/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.protocols;

import java.io.InputStream;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.appserver.AppserverPlugin;
import org.eclipse.help.internal.protocols.HelpURL;
import org.eclipse.help.internal.util.ResourceLocator;
import org.eclipse.help.internal.util.URLCoder;

public class PluginURL
extends HelpURL {
    protected IPluginDescriptor plugin;
    protected String file;
    private static boolean cachingEnabled = true;

    static {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if ("-dev".equals(args[i])) {
                cachingEnabled = false;
                break;
            }
            ++i;
        }
    }

    public PluginURL(String url, String query) {
        super(url, query);
    }

    private String getFile() {
        if (this.file == null) {
            int start = this.url.indexOf("/") + 1;
            int end = this.url.indexOf("?");
            if (end == -1) {
                end = this.url.indexOf("#");
            }
            if (end == -1) {
                end = this.url.length();
            }
            this.file = this.url.substring(start, end);
            this.file = URLCoder.decode(this.file);
        }
        return this.file;
    }

    private IPluginDescriptor getPlugin() {
        if (this.plugin == null) {
            int i = this.url.indexOf(47);
            String pluginId = i == -1 ? "" : this.url.substring(0, i);
            pluginId = URLCoder.decode(pluginId);
            this.plugin = Platform.getPluginRegistry().getPluginDescriptor(pluginId);
        }
        return this.plugin;
    }

    public boolean isCacheable() {
        if (this.getValue("resultof") != null) {
            return false;
        }
        return cachingEnabled;
    }

    public InputStream openStream() {
        IPluginDescriptor plugin = this.getPlugin();
        if (plugin == null) {
            return null;
        }
        if (plugin.equals(AppserverPlugin.getDefault().getContributingServerPlugin())) {
            return null;
        }
        if (this.getFile() == null || "".equals(this.getFile())) {
            return null;
        }
        InputStream inputStream = null;
        inputStream = ResourceLocator.openFromZip(plugin, "doc.zip", this.getFile(), this.getLocale());
        if (inputStream == null) {
            inputStream = ResourceLocator.openFromPlugin(plugin, this.getFile(), this.getLocale());
        }
        return inputStream;
    }
}

