/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.ParsedDocument;
import org.eclipse.help.internal.search.QueryBuilder;
import org.eclipse.help.internal.util.HelpProperties;
import org.eclipse.help.internal.util.PluginVersionInfo;
import org.eclipse.help.internal.util.ResourceLocator;
import org.eclipse.help.internal.util.Resources;

public class SearchIndex {
    private IndexReader ir;
    private IndexWriter iw;
    private File indexDir;
    private String locale;
    private AnalyzerDescriptor analyzerDescriptor;
    private PluginVersionInfo docPlugins;
    private String indexedDocsFile;
    private HelpProperties indexedDocs;
    private static final String INDEXED_CONTRIBUTION_INFO_FILE = "indexed_contributions";
    public static final String INDEXED_DOCS_FILE = "indexed_docs";
    private static final String ANALYZER_VERSION_FILENAME = "indexed_analyzer";
    private File analyzerVersionFile;
    private File inconsistencyFile;
    private HTMLDocParser parser;
    private IndexSearcher searcher;

    public SearchIndex(String locale, AnalyzerDescriptor analyzerDesc) {
        this(locale, analyzerDesc, new File(String.valueOf(HelpPlugin.getDefault().getStateLocation().toOSString()) + File.separator + "nl" + File.separator + locale));
    }

    public SearchIndex(String locale, AnalyzerDescriptor analyzerDesc, File indexDir) {
        this.locale = locale;
        this.indexDir = indexDir;
        this.analyzerDescriptor = analyzerDesc;
        this.inconsistencyFile = new File(indexDir.getParentFile(), String.valueOf(locale) + ".inconsistent");
        this.analyzerVersionFile = new File(indexDir, ANALYZER_VERSION_FILENAME);
        this.indexedDocsFile = "nl" + File.separator + locale + File.separator + INDEXED_DOCS_FILE;
        this.parser = new HTMLDocParser();
        if (!this.exists()) {
            this.unzipProductIndex();
        }
    }

    public boolean addDocument(String name, URL url) {
        if (HelpPlugin.DEBUG_SEARCH) {
            System.out.println("SearchIndex.addDocument(" + name + ", " + url + ")");
        }
        try {
            Document doc = new Document();
            doc.add(Field.Keyword((String)"name", (String)name));
            try {
                try {
                    this.parser.openDocument(url);
                }
                catch (IOException iOException) {
                    HelpPlugin.logError(Resources.getString("ES25", name), null);
                    Object var6_5 = null;
                    this.parser.closeDocument();
                    return false;
                }
                ParsedDocument parsed = new ParsedDocument(this.parser.getContentReader());
                doc.add(Field.Text((String)"contents", (Reader)parsed.newContentReader()));
                doc.add(Field.Text((String)"exact_contents", (Reader)parsed.newContentReader()));
                String title = this.parser.getTitle();
                doc.add(Field.UnStored((String)"title", (String)title));
                doc.add(Field.UnStored((String)"exact_title", (String)title));
                doc.add(Field.UnIndexed((String)"raw_title", (String)title));
                this.iw.addDocument(doc);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.parser.closeDocument();
                throw throwable;
            }
            Object var6_7 = null;
            this.parser.closeDocument();
            ((Hashtable)this.indexedDocs).put(name, "0");
            return true;
        }
        catch (IOException e) {
            HelpPlugin.logError(Resources.getString("ES16", name, this.indexDir.getAbsolutePath()), e);
            return false;
        }
    }

    public boolean beginAddBatch() {
        try {
            if (this.iw != null) {
                this.iw.close();
            }
            boolean create = false;
            if (!this.exists()) {
                create = true;
                this.indexDir.mkdirs();
                if (!this.indexDir.exists()) {
                    return false;
                }
            }
            this.indexedDocs = new HelpProperties(this.indexedDocsFile, HelpPlugin.getDefault());
            this.indexedDocs.restore();
            this.setInconsistent(true);
            this.iw = new IndexWriter(this.indexDir, this.analyzerDescriptor.getAnalyzer(), create);
            this.iw.mergeFactor = 20;
            this.iw.maxFieldLength = 1000000;
            return true;
        }
        catch (IOException e) {
            HelpPlugin.logError(Resources.getString("ES17"), e);
            return false;
        }
    }

    public boolean beginDeleteBatch() {
        try {
            if (this.ir != null) {
                this.ir.close();
            }
            this.indexedDocs = new HelpProperties(this.indexedDocsFile, HelpPlugin.getDefault());
            this.indexedDocs.restore();
            this.setInconsistent(true);
            this.ir = IndexReader.open((File)this.indexDir);
            return true;
        }
        catch (IOException e) {
            HelpPlugin.logError(Resources.getString("ES18"), e);
            return false;
        }
    }

    public boolean removeDocument(String name) {
        if (HelpPlugin.DEBUG_SEARCH) {
            System.out.println("SearchIndex.removeDocument(" + name + ")");
        }
        Term term = new Term("name", name);
        try {
            this.ir.delete(term);
            ((Hashtable)this.indexedDocs).remove(name);
        }
        catch (IOException e) {
            HelpPlugin.logError(Resources.getString("ES22", name, this.indexDir.getAbsolutePath()), e);
            return false;
        }
        return true;
    }

    public boolean endAddBatch() {
        try {
            if (this.iw == null) {
                return false;
            }
            this.iw.optimize();
            this.iw.close();
            this.indexedDocs.save();
            this.indexedDocs = null;
            this.getDocPlugins().save();
            this.saveAnalyzerId();
            this.setInconsistent(false);
            return true;
        }
        catch (IOException e) {
            HelpPlugin.logError(Resources.getString("ES19"), e);
            return false;
        }
    }

    public boolean endDeleteBatch() {
        try {
            if (this.ir == null) {
                return false;
            }
            this.ir.close();
            this.indexedDocs.save();
            this.indexedDocs = null;
            this.getDocPlugins().save();
            this.saveAnalyzerId();
            this.setInconsistent(false);
            return true;
        }
        catch (IOException e) {
            HelpPlugin.logError(Resources.getString("ES20"), e);
            return false;
        }
    }

    public boolean exists() {
        return this.indexDir.exists() && !this.isInconsistent();
    }

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector) {
        try {
            QueryBuilder queryBuilder = new QueryBuilder(searchQuery.getSearchWord(), this.analyzerDescriptor);
            Query luceneQuery = queryBuilder.getLuceneQuery(searchQuery.getFieldNames(), searchQuery.isFieldSearch());
            String highlightTerms = queryBuilder.gethighlightTerms();
            if (luceneQuery != null) {
                if (this.searcher == null) {
                    this.openSearcher();
                }
                Hits hits = this.searcher.search(luceneQuery);
                collector.addHits(hits, highlightTerms);
            }
        }
        catch (Exception e) {
            HelpPlugin.logError(Resources.getString("ES21", searchQuery.getSearchWord()), e);
        }
    }

    public String getLocale() {
        return this.locale;
    }

    public PluginVersionInfo getDocPlugins() {
        if (this.docPlugins == null) {
            Iterator docPluginsIterator = HelpSystem.getTocManager().getContributingPlugins().iterator();
            this.docPlugins = new PluginVersionInfo("nl" + File.separator + this.locale + File.separator + INDEXED_CONTRIBUTION_INFO_FILE, docPluginsIterator, HelpPlugin.getDefault(), !this.exists());
        }
        return this.docPlugins;
    }

    public HelpProperties getIndexedDocs() {
        HelpProperties indexedDocs = new HelpProperties(this.indexedDocsFile, HelpPlugin.getDefault());
        if (this.exists()) {
            indexedDocs.restore();
        }
        return indexedDocs;
    }

    private String readAnalyzerId() {
        if (!this.analyzerVersionFile.exists()) {
            return "";
        }
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(this.analyzerVersionFile));
            String id = dis.readUTF();
            dis.close();
            return id;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private void saveAnalyzerId() {
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(this.analyzerVersionFile));
            dos.writeUTF(this.analyzerDescriptor.getId());
            dos.flush();
            dos.close();
        }
        catch (IOException iOException) {}
    }

    public boolean isInconsistent() {
        if (this.inconsistencyFile.exists()) {
            return true;
        }
        return !this.analyzerDescriptor.isCompatible(this.readAnalyzerId());
    }

    public void setInconsistent(boolean inconsistent) {
        if (inconsistent) {
            try {
                FileOutputStream fos = new FileOutputStream(this.inconsistencyFile);
                fos.close();
            }
            catch (IOException iOException) {}
        } else {
            this.inconsistencyFile.delete();
        }
    }

    public synchronized void openSearcher() throws IOException {
        if (this.searcher == null) {
            this.searcher = new IndexSearcher(this.indexDir.getAbsolutePath());
        }
    }

    public void close() {
        if (this.searcher != null) {
            try {
                this.searcher.close();
            }
            catch (IOException iOException) {}
        }
    }

    public File getIndexDir() {
        return this.indexDir;
    }

    private void unzipProductIndex() {
        ZipInputStream zis;
        InputStream zipIn;
        block18: {
            String indexPluginId = HelpPlugin.getDefault().getPluginPreferences().getString("productIndex");
            if (indexPluginId == null || indexPluginId.length() <= 0) {
                return;
            }
            zipIn = ResourceLocator.openFromPlugin(indexPluginId, "doc_index.zip", this.getLocale());
            if (zipIn == null) {
                return;
            }
            byte[] buf = new byte[8192];
            File destDir = this.getIndexDir();
            zis = new ZipInputStream(zipIn);
            FileOutputStream fos = null;
            try {
                try {
                    ZipEntry zEntry;
                    while ((zEntry = zis.getNextEntry()) != null) {
                        if (zEntry.isDirectory()) {
                            new File(destDir, zEntry.getName()).mkdirs();
                            continue;
                        }
                        String filePath = zEntry.getName();
                        int lastSeparator = filePath.lastIndexOf("/");
                        String fileDir = "";
                        if (lastSeparator >= 0) {
                            fileDir = filePath.substring(0, lastSeparator);
                        }
                        new File(destDir, fileDir).mkdirs();
                        File outFile = new File(destDir, filePath);
                        fos = new FileOutputStream(outFile);
                        int n = 0;
                        while ((n = zis.read(buf)) >= 0) {
                            fos.write(buf, 0, n);
                        }
                        fos.close();
                    }
                    if (HelpPlugin.DEBUG_SEARCH) {
                        System.out.println("SearchIndex: Prebuilt index restored to " + destDir + ".");
                    }
                }
                catch (IOException iOException) {
                    if (fos == null) break block18;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    zipIn.close();
                    if (zis != null) {
                        zis.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        Object var13_15 = null;
        try {
            zipIn.close();
            if (zis != null) {
                zis.close();
            }
        }
        catch (IOException iOException) {}
    }
}

