/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.IndexingOperation;
import org.eclipse.help.internal.search.ProgressDistributor;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.util.PluginVersionInfo;
import org.eclipse.help.internal.util.Resources;

public class SearchManager {
    private Map indexes = new HashMap();
    private Map analyzerDescriptors = new HashMap();
    private Map progressDistibutors = new HashMap();

    public SearchIndex getIndex(String locale) {
        Map map = this.indexes;
        synchronized (map) {
            Object index = this.indexes.get(locale);
            if (index == null) {
                index = new SearchIndex(locale, this.getAnalyzer(locale));
                this.indexes.put(locale, index);
            }
            return (SearchIndex)index;
        }
    }

    private ProgressDistributor getProgressDistributor(SearchIndex index) {
        Map map = this.progressDistibutors;
        synchronized (map) {
            Object distributor = this.progressDistibutors.get(index);
            if (distributor == null) {
                distributor = new ProgressDistributor();
                this.progressDistibutors.put(index, distributor);
            }
            return (ProgressDistributor)distributor;
        }
    }

    private AnalyzerDescriptor getAnalyzer(String locale) {
        AnalyzerDescriptor analyzerDesc = (AnalyzerDescriptor)this.analyzerDescriptors.get(locale);
        if (analyzerDesc != null) {
            return analyzerDesc;
        }
        analyzerDesc = new AnalyzerDescriptor(locale);
        this.analyzerDescriptors.put(locale, analyzerDesc);
        String lang = analyzerDesc.getLang();
        if (locale != null && !locale.equals(lang)) {
            this.analyzerDescriptors.put(lang, analyzerDesc);
        }
        return analyzerDesc;
    }

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) {
        SearchIndex index;
        block3: {
            index = this.getIndex(searchQuery.getLocale());
            try {
                this.updateIndex(pm, index);
                if (!index.exists()) {
                    return;
                }
            }
            catch (IndexingOperation.IndexingException indexingException) {
                if (!HelpPlugin.DEBUG_SEARCH) break block3;
                System.out.println(String.valueOf(this.getClass().getName()) + " IndexUpdateException occured.");
            }
        }
        index.search(searchQuery, collector);
    }

    private boolean isIndexingNeeded(SearchIndex index) {
        if (!index.exists()) {
            return true;
        }
        return index.getDocPlugins().detectChange();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateIndex(IProgressMonitor pm, SearchIndex index) throws OperationCanceledException, IndexingOperation.IndexingException {
        ProgressDistributor progressDistrib;
        block10: {
            progressDistrib = this.getProgressDistributor(index);
            progressDistrib.addMonitor(pm);
            try {
                SearchManager searchManager = this;
                synchronized (searchManager) {
                    if (!this.isIndexingNeeded(index)) {
                        pm.beginTask("", 1);
                        pm.worked(1);
                        pm.done();
                        progressDistrib.removeMonitor(pm);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 8] lbl12 : MonitorExitStatement: MONITOREXIT : var4_4
                        Object var7_5 = null;
                        progressDistrib.removeMonitor(pm);
                        return;
                    }
                    if (HelpPlugin.DEBUG_SEARCH) {
                        System.out.println("SearchManager indexing " + index.getLocale());
                    }
                    try {
                        PluginVersionInfo versions = index.getDocPlugins();
                        if (versions == null) {
                            pm.beginTask("", 1);
                            pm.worked(1);
                            pm.done();
                            progressDistrib.removeMonitor(pm);
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 9] lbl26 : MonitorExitStatement: MONITOREXIT : var4_4
                            break block10;
                        }
                        IndexingOperation indexer = new IndexingOperation(index);
                        indexer.execute(progressDistrib);
                    }
                    catch (OperationCanceledException oce) {
                        progressDistrib.operationCanceled();
                        HelpPlugin.logWarning(Resources.getString("Search_cancelled"));
                        throw oce;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                progressDistrib.removeMonitor(pm);
                throw throwable;
            }
        }
        Object var7_6 = null;
        progressDistrib.removeMonitor(pm);
        return;
        Object var7_8 = null;
        progressDistrib.removeMonitor(pm);
    }

    public void close() {
        Iterator it = this.indexes.values().iterator();
        while (it.hasNext()) {
            ((SearchIndex)it.next()).close();
        }
    }
}

