/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import org.eclipse.help.internal.toc.HrefUtil;
import org.eclipse.help.internal.toc.ITocNode;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocNode;
import org.xml.sax.Attributes;

class Anchor
extends TocNode {
    protected Toc parentToc;
    protected String id;
    protected TocFile tocFile;

    protected Anchor(TocFile tocFile, Attributes attrs) {
        this.tocFile = tocFile;
        if (attrs == null) {
            return;
        }
        this.id = attrs.getValue("id");
        this.id = HrefUtil.normalizeHref(tocFile.getPluginID(), String.valueOf(tocFile.getHref()) + "#" + this.id);
        this.parentToc = tocFile.getToc();
    }

    public void build(TocBuilder builder) {
        builder.buildAnchor(this);
    }

    protected String getID() {
        return this.id;
    }

    public TocFile getTocFile() {
        return this.tocFile;
    }

    public void addChild(ITocNode child) {
        super.addChild(child);
        if (child instanceof Toc && this.parentToc != null) {
            this.parentToc.getChildrenTocs().add(child);
        }
    }
}

