/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.toc.HrefUtil;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.util.Resources;

public class DirectoryToc {
    private String dir;
    private ITopic[] extraTopics;
    private String locale;

    protected DirectoryToc(TocFile tocFile) {
        this(tocFile.getPluginID(), tocFile.getLocale(), tocFile.getExtraDir());
    }

    private DirectoryToc(String pluginID, String locale, String directory) {
        this.locale = locale;
        this.dir = HrefUtil.normalizeDirectoryHref(pluginID, directory);
    }

    public ITopic[] getExtraTopics() {
        if (this.extraTopics == null) {
            Collection col = this.createExtraTopics();
            this.extraTopics = col.toArray(new ITopic[col.size()]);
            this.dir = null;
        }
        return this.extraTopics;
    }

    private Collection createExtraTopics() {
        HashSet ret = new HashSet();
        String pluginID = HrefUtil.getPluginIDFromHref(this.dir);
        if (pluginID == null) {
            return ret;
        }
        IPluginDescriptor pluginDesc = Platform.getPluginRegistry().getPluginDescriptor(pluginID);
        if (pluginDesc == null) {
            return ret;
        }
        String directory = HrefUtil.getResourcePathFromHref(this.dir);
        if (directory == null) {
            directory = "";
        }
        Path iPath = new Path("$nl$/doc.zip");
        HashMap<String, String> override = new HashMap<String, String>(1);
        override.put("$nl$", this.locale);
        URL url = null;
        try {
            url = pluginDesc.getPlugin().find((IPath)iPath, override);
            if (url == null) {
                url = pluginDesc.getPlugin().find((IPath)new Path("doc.zip"));
            }
        }
        catch (CoreException ce) {
            HelpPlugin.logError(Resources.getString("E034", "/" + pluginID + "/doc.zip"), ce);
        }
        if (url != null) {
            ret.addAll(this.createExtraTopicsFromZip(pluginID, directory, url));
        }
        iPath = new Path("$nl$/" + directory);
        url = null;
        try {
            url = pluginDesc.getPlugin().find((IPath)iPath, override);
            if (url == null) {
                url = directory.length() == 0 ? pluginDesc.getInstallURL() : pluginDesc.getPlugin().find((IPath)new Path(directory));
            }
        }
        catch (CoreException ce) {
            HelpPlugin.logError(Resources.getString("E035", "/" + pluginID + "/" + directory), ce);
        }
        if (url != null) {
            ret.addAll(this.createExtraTopicsFromDirectory(pluginID, directory, url));
        }
        return ret;
    }

    private Collection createExtraTopicsFromZip(String pluginID, String directory, URL url) {
        URL realZipURL;
        Collection ret = new ArrayList(0);
        try {
            realZipURL = Platform.resolve((URL)url);
        }
        catch (IOException ioe) {
            HelpPlugin.logError(Resources.getString("E036", url.toString()), ioe);
            return new ArrayList(0);
        }
        try {
            ZipFile zipFile = new ZipFile(realZipURL.getFile());
            ret = this.createExtraTopicsFromZipFile(pluginID, zipFile, directory);
            zipFile.close();
        }
        catch (IOException ioe) {
            HelpPlugin.logError(Resources.getString("E037", realZipURL.getFile()), ioe);
            return new ArrayList(0);
        }
        return ret;
    }

    private Collection createExtraTopicsFromZipFile(String pluginID, ZipFile zipFile, String directory) {
        String constantHrefSegment = "/" + pluginID + "/";
        ArrayList<ExtraTopic> ret = new ArrayList<ExtraTopic>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zEntry = enumeration.nextElement();
            if (zEntry.isDirectory()) continue;
            String docName = zEntry.getName();
            int l = directory.length();
            if (l != 0 && (docName.length() <= l || docName.charAt(l) != '/' || !directory.equals(docName.substring(0, l)))) continue;
            ret.add(new ExtraTopic(String.valueOf(constantHrefSegment) + docName));
        }
        return ret;
    }

    private Collection createExtraTopicsFromDirectory(String pluginID, String directory, URL url) {
        URL realURL;
        ArrayList col = new ArrayList();
        try {
            realURL = Platform.resolve((URL)url);
        }
        catch (IOException ioe) {
            HelpPlugin.logError(Resources.getString("E038", url.toString()), ioe);
            return col;
        }
        File dirFile = new File(realURL.getFile());
        if (dirFile.exists() && dirFile.isDirectory()) {
            String prefix = directory.length() > 0 ? "/" + pluginID + "/" + directory : "/" + pluginID;
            this.createExtraTopicsFromDirectoryFile(prefix, dirFile, col);
        }
        return col;
    }

    private Collection createExtraTopicsFromDirectoryFile(String prefix, File dir, Collection col) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            String href = String.valueOf(prefix) + "/" + files[i].getName();
            if (files[i].isDirectory()) {
                this.createExtraTopicsFromDirectoryFile(href, files[i], col);
            } else {
                col.add(new ExtraTopic(href));
            }
            ++i;
        }
        return col;
    }

    class ExtraTopic
    implements ITopic {
        private String topicHref;

        public ExtraTopic(String href) {
            this.topicHref = href;
        }

        public String getHref() {
            return this.topicHref;
        }

        public String getLabel() {
            return this.topicHref;
        }

        public ITopic[] getSubtopics() {
            return new ITopic[0];
        }
    }
}

