/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.toc.DirectoryToc;
import org.eclipse.help.internal.toc.HrefUtil;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocNode;
import org.eclipse.help.internal.toc.Topic;
import org.eclipse.help.internal.util.FastStack;
import org.xml.sax.Attributes;

public class Toc
extends TocNode
implements IToc {
    private String link_to;
    private String href;
    private String label;
    private TocFile tocFile;
    private ITopic[] topicArray;
    private Topic descriptionTopic;
    private Collection childrenTocs;
    private DirectoryToc directoryToc;
    private Map topicMap;

    protected Toc(TocFile tocFile, Attributes attrs) {
        if (attrs == null) {
            return;
        }
        this.tocFile = tocFile;
        this.label = attrs.getValue("label");
        this.link_to = attrs.getValue("link_to");
        this.link_to = HrefUtil.normalizeHref(tocFile.getPluginID(), this.link_to);
        this.href = HrefUtil.normalizeHref(tocFile.getPluginID(), tocFile.getHref());
        try {
            this.descriptionTopic = new Topic(tocFile, null);
            this.descriptionTopic.setLabel(this.label);
            String topic = attrs.getValue("topic");
            if (topic != null && topic.trim().length() > 0) {
                this.descriptionTopic.setHref(HrefUtil.normalizeHref(tocFile.getPluginID(), topic));
            } else {
                this.descriptionTopic.setHref("");
            }
        }
        catch (Exception exception) {}
        this.childrenTocs = new ArrayList();
        this.directoryToc = new DirectoryToc(tocFile);
    }

    public void build(TocBuilder builder) {
        builder.buildToc(this);
    }

    public TocFile getTocFile() {
        return this.tocFile;
    }

    protected String getLink_to() {
        return this.link_to;
    }

    public String getHref() {
        return this.href;
    }

    public String getLabel() {
        return this.label;
    }

    public ITopic getTopic(String href) {
        if (href == null) {
            return this.descriptionTopic;
        }
        if (this.topicMap == null) {
            this.topicMap = new HashMap();
            FastStack stack = new FastStack();
            ITopic[] topics = this.getTopics();
            int i = 0;
            while (i < topics.length) {
                stack.push(topics[i]);
                ++i;
            }
            while (!stack.isEmpty()) {
                ITopic topic = (ITopic)stack.pop();
                if (topic == null) continue;
                String topicHref = topic.getHref();
                if (topicHref != null) {
                    this.topicMap.put(topicHref, topic);
                }
                ITopic[] subtopics = topic.getSubtopics();
                int i2 = 0;
                while (i2 < subtopics.length) {
                    stack.push(subtopics[i2]);
                    ++i2;
                }
            }
        }
        return (ITopic)this.topicMap.get(href);
    }

    public ITopic[] getTopics() {
        if (this.topicArray == null) {
            List topics = this.getChildTopics();
            this.topicArray = new ITopic[topics.size()];
            topics.toArray(this.topicArray);
            this.children = null;
            this.parents = null;
            this.tocFile = null;
        }
        return this.topicArray;
    }

    public ITopic[] getExtraTopics() {
        ITopic[] dirTopics = this.directoryToc.getExtraTopics();
        Iterator it = this.childrenTocs.iterator();
        while (it.hasNext()) {
            ITopic[] moreDirTopics;
            IToc toc = (IToc)it.next();
            if (!(toc instanceof Toc) || (moreDirTopics = ((Toc)toc).getExtraTopics()).length <= 0) continue;
            ITopic[] newDirTopics = new ITopic[dirTopics.length + moreDirTopics.length];
            System.arraycopy(dirTopics, 0, newDirTopics, 0, dirTopics.length);
            System.arraycopy(moreDirTopics, 0, newDirTopics, dirTopics.length, moreDirTopics.length);
            dirTopics = newDirTopics;
        }
        return dirTopics;
    }

    public String toString() {
        return this.href != null ? this.href : super.toString();
    }

    public Collection getChildrenTocs() {
        return this.childrenTocs;
    }
}

