/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class ResourceLocator {
    private static final Hashtable zipCache = new Hashtable();
    private static final Object zipNotFound = new Object();

    public static InputStream openFromZip(String pluginId, String zip, String file, String locale) {
        IPluginDescriptor pluginDesc = Platform.getPluginRegistry().getPluginDescriptor(pluginId);
        return ResourceLocator.openFromZip(pluginDesc, zip, file, locale);
    }

    public static InputStream openFromPlugin(String pluginId, String file, String locale) {
        IPluginDescriptor pluginDesc = Platform.getPluginRegistry().getPluginDescriptor(pluginId);
        return ResourceLocator.openFromPlugin(pluginDesc, file, locale);
    }

    public static InputStream openFromZip(IPluginDescriptor pluginDesc, String zip, String file, String locale) {
        InputStream is = ResourceLocator.doOpenFromZip(pluginDesc, "$nl$/" + zip, file, locale);
        if (is == null) {
            is = ResourceLocator.doOpenFromZip(pluginDesc, zip, file, locale);
        }
        return is;
    }

    public static InputStream openFromPlugin(IPluginDescriptor pluginDesc, String file, String locale) {
        InputStream is = ResourceLocator.doOpenFromPlugin(pluginDesc, "$nl$/" + file, locale);
        if (is == null) {
            is = ResourceLocator.doOpenFromPlugin(pluginDesc, file, locale);
        }
        return is;
    }

    private static InputStream doOpenFromZip(IPluginDescriptor pluginDesc, String zip, String file, String locale) {
        String realZipURL = ResourceLocator.findZip(pluginDesc, zip, locale);
        if (realZipURL == null) {
            return null;
        }
        try {
            URL jurl = new URL("jar", "", String.valueOf(realZipURL) + "!/" + file);
            URLConnection jconnection = jurl.openConnection();
            jconnection.setDefaultUseCaches(false);
            jconnection.setUseCaches(false);
            return jconnection.getInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static InputStream doOpenFromPlugin(IPluginDescriptor pluginDesc, String file, String locale) {
        Path flatFilePath = new Path(file);
        HashMap<String, String> override = new HashMap<String, String>(1);
        override.put("$nl$", locale);
        try {
            URL flatFileURL = pluginDesc.getPlugin().find((IPath)flatFilePath, override);
            if (flatFileURL != null) {
                try {
                    return flatFileURL.openStream();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    private static String findZip(IPluginDescriptor pluginDesc, String zip, String locale) {
        String pluginID = pluginDesc.getUniqueIdentifier();
        Object cached = zipCache.get(String.valueOf(pluginID) + '/' + zip + '/' + locale);
        if (cached == null) {
            Path zipFilePath = new Path(zip);
            HashMap<String, String> override = new HashMap<String, String>(1);
            override.put("$nl$", locale);
            try {
                URL zipFileURL = pluginDesc.getPlugin().find((IPath)zipFilePath, override);
                if (zipFileURL != null) {
                    URL realZipURL = Platform.resolve((URL)zipFileURL);
                    cached = realZipURL.toExternalForm();
                } else {
                    cached = zipNotFound;
                }
            }
            catch (CoreException coreException) {
                cached = zipNotFound;
            }
            catch (IOException iOException) {
                cached = zipNotFound;
            }
            zipCache.put(String.valueOf(pluginID) + '/' + zip + '/' + locale, cached);
        }
        if (cached == zipNotFound) {
            return null;
        }
        return (String)cached;
    }
}

