/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.Formatter;
import com.ibm.logging.ILogRecord;
import com.ibm.logging.LogUtil;
import com.ibm.logging.MessageCatalog;
import java.util.MissingResourceException;

public class EnhancedFormatter
extends Formatter {
    private static final String S = "(C) Copyright IBM Corp. 1998, 1999.";
    static final long serialVersionUID = 7727572344374372213L;
    protected static final String SPACE = "  ";
    protected transient String date = null;
    protected transient String time = null;
    protected transient String className = null;
    protected transient String methodName = null;
    protected transient String org = null;
    protected transient String product = null;
    protected transient String comp = null;
    protected transient String client = null;
    protected transient String server = null;
    protected transient String threadID = null;

    public EnhancedFormatter() {
    }

    public EnhancedFormatter(String string) {
        super(string);
    }

    public EnhancedFormatter(String string, String string2) {
        super(string, string2);
    }

    public String format(ILogRecord iLogRecord) {
        StringBuffer stringBuffer = new StringBuffer(256);
        this.initTitles();
        long l = iLogRecord.getTimeStamp();
        stringBuffer.append(String.valueOf(this.date) + SPACE + this.getDate(l) + SPACE + this.getTime(l) + this.lineSep);
        Object object = iLogRecord.getAttribute("loggingClass");
        if (object != null) {
            stringBuffer.append(String.valueOf(this.className) + SPACE + object + this.lineSep);
        }
        if ((object = iLogRecord.getAttribute("loggingMethod")) != null) {
            stringBuffer.append(String.valueOf(this.methodName) + SPACE + object + this.lineSep);
        }
        if ((object = iLogRecord.getAttribute("organization")) != null && !object.equals("")) {
            stringBuffer.append(String.valueOf(this.org) + SPACE + object + this.lineSep);
        }
        if ((object = iLogRecord.getAttribute("product")) != null && !object.equals("")) {
            stringBuffer.append(String.valueOf(this.product) + SPACE + object + this.lineSep);
        }
        if ((object = iLogRecord.getAttribute("component")) != null && !object.equals("")) {
            stringBuffer.append(String.valueOf(this.comp) + SPACE + object + this.lineSep);
        }
        if ((object = iLogRecord.getAttribute("server")) != null && !object.equals("")) {
            stringBuffer.append(String.valueOf(this.server) + SPACE + object + this.lineSep);
        }
        if ((object = iLogRecord.getAttribute("client")) != null && !object.equals("")) {
            stringBuffer.append(String.valueOf(this.client) + SPACE + object + this.lineSep);
        }
        stringBuffer.append(SPACE + this.getText(iLogRecord));
        return stringBuffer.toString();
    }

    protected void initTitles() {
        if (this.date == null) {
            try {
                MessageCatalog messageCatalog = new MessageCatalog("com.ibm.logging.Msgs", this.getLocale());
                this.date = messageCatalog.getMessage("DATE");
                this.time = messageCatalog.getMessage("TIME");
                this.className = messageCatalog.getMessage("CLASS_NAME");
                this.methodName = messageCatalog.getMessage("METHOD_NAME");
                this.org = messageCatalog.getMessage("ORGANIZATION");
                this.product = messageCatalog.getMessage("PRODUCT");
                this.comp = messageCatalog.getMessage("COMPONENT");
                this.client = messageCatalog.getMessage("CLIENT");
                this.server = messageCatalog.getMessage("SERVER");
                this.threadID = messageCatalog.getMessage("THREAD_ID");
            }
            catch (MissingResourceException missingResourceException) {
                this.date = "Date:";
                this.time = "Time:";
                this.className = "Class:";
                this.methodName = "Method:";
                this.org = "Organization:";
                this.product = "Product:";
                this.comp = "Component:";
                this.client = "Client:";
                this.server = "Server:";
                this.threadID = "Thread ID:";
            }
            int n = this.date.length();
            if (this.time.length() > n) {
                n = this.time.length();
            }
            if (this.className.length() > n) {
                n = this.className.length();
            }
            if (this.methodName.length() > n) {
                n = this.methodName.length();
            }
            if (this.org.length() > n) {
                n = this.org.length();
            }
            if (this.product.length() > n) {
                n = this.product.length();
            }
            if (this.comp.length() > n) {
                n = this.comp.length();
            }
            if (this.client.length() > n) {
                n = this.client.length();
            }
            if (this.server.length() > n) {
                n = this.server.length();
            }
            if (this.threadID.length() > n) {
                n = this.threadID.length();
            }
            this.date = LogUtil.left(this.date, n);
            this.time = LogUtil.left(this.time, n);
            this.className = LogUtil.left(this.className, n);
            this.methodName = LogUtil.left(this.methodName, n);
            this.org = LogUtil.left(this.org, n);
            this.product = LogUtil.left(this.product, n);
            this.comp = LogUtil.left(this.comp, n);
            this.client = LogUtil.left(this.client, n);
            this.server = LogUtil.left(this.server, n);
            this.threadID = LogUtil.left(this.threadID, n);
        }
    }
}

