/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.Formatter;
import com.ibm.logging.Gate;
import com.ibm.logging.IConstants;
import com.ibm.logging.IFormatter;
import com.ibm.logging.IHandler;
import com.ibm.logging.ILogRecord;
import com.ibm.logging.LogUtil;
import com.ibm.logging.NestedException;
import com.ibm.logging.utilities.BackupFile;
import com.ibm.logging.utilities.CircularRecordQueue;
import com.ibm.logging.utilities.IRecordQueue;
import com.ibm.logging.utilities.RecordQueue;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class Handler
extends Gate
implements IConstants,
IHandler,
Runnable {
    private static final String S = "(C) Copyright IBM Corp. 1998, 2000.";
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    public static final int DEFAULT_RETRY_COUNT = 5;
    public static final int DEFAULT_RETRY_INTERVAL = 5000;
    private transient BackupFile backupFile;
    private transient boolean backupEnabled;
    public transient boolean deviceOpen;
    private transient boolean finished;
    private transient boolean stopRequested;
    protected Hashtable formatters;
    private int backupFileCapacity;
    protected transient int deviceFailures;
    private transient int discardedRecordCount;
    private int maxRetries;
    private int retryInterval;
    protected transient Object deviceLock;
    protected transient Object queueEmptyLock;
    protected transient Object queueFullLock;
    protected transient Object retryTimer;
    protected transient PrintWriter pWriter = null;
    private transient IRecordQueue inQueue;
    private transient IRecordQueue outQueue;
    private String formatterNames;
    protected transient Thread myThread;

    public Handler() {
        this(null, null);
    }

    public Handler(String string) {
        this(string, null);
    }

    public Handler(String string, String string2) {
        super(string, string2);
        this.start();
    }

    public void addFormatter(IFormatter iFormatter) {
        if (iFormatter != null) {
            Enumeration enumeration = iFormatter.getRecordClasses();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.formatters.put(string, iFormatter);
            }
        }
    }

    private void backupRecord(ILogRecord iLogRecord) {
        if (this.deviceFailures == 1) {
            LogUtil.errorMsg(LogUtil.msgs.getMessage("BACKUP_ATTEMPT", this.getName()));
        }
        if (!this.backupFile.isFull()) {
            try {
                this.backupFile.writeRecord(iLogRecord);
            }
            catch (IOException iOException) {
                if (this.discardedRecordCount == 0) {
                    LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_WRITE_BACKUP", this.getName()));
                }
                iOException.printStackTrace();
                ++this.discardedRecordCount;
            }
        } else {
            if (this.discardedRecordCount == 0) {
                LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_BACKUP_FULL", this.getName()));
            }
            ++this.discardedRecordCount;
        }
    }

    private boolean clearBackupFile() throws NestedException {
        boolean bl;
        block12: {
            ILogRecord iLogRecord = null;
            bl = true;
            boolean bl2 = false;
            while (this.backupFile.getRecordCount() > 0 && !bl2) {
                try {
                    iLogRecord = this.backupFile.readRecord();
                }
                catch (Exception exception) {
                    LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_READ_BACKUP", this.backupFile.getName(), this.getName()));
                    exception.printStackTrace();
                    bl2 = true;
                    this.backupFile.close();
                    try {
                        this.backupFile.open();
                    }
                    catch (IOException iOException) {
                        LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_NO_BACKUP"));
                        iOException.printStackTrace();
                        this.setBackupEnabled(false);
                    }
                }
                try {
                    this.writeRecord(iLogRecord);
                }
                catch (NestedException nestedException) {
                    bl2 = true;
                    ++this.deviceFailures;
                    BackupFile backupFile = new BackupFile(this.getBackupCapacity());
                    try {
                        backupFile.open();
                        backupFile.writeRecord(iLogRecord);
                        while (this.backupFile.getRecordCount() > 0) {
                            iLogRecord = this.backupFile.readRecord();
                            backupFile.writeRecord(iLogRecord);
                        }
                        this.backupFile.delete();
                        this.backupFile = backupFile;
                        bl = false;
                    }
                    catch (Exception exception) {
                        LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_NO_BACKUP"));
                        exception.printStackTrace();
                        this.setBackupEnabled(false);
                    }
                }
            }
            if (bl2) break block12;
            this.backupFile.delete();
            try {
                this.backupFile.open();
            }
            catch (IOException iOException) {
                LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_NO_BACKUP"));
                iOException.printStackTrace();
                this.setBackupEnabled(false);
            }
        }
        return bl;
    }

    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.pWriter != null) {
                this.pWriter.flush();
                this.pWriter.close();
            }
            this.pWriter = null;
            this.deviceOpen = false;
        }
    }

    public void dumpQueue() {
        if (this.isCircular()) {
            boolean bl = false;
            Object object = this.queueEmptyLock;
            synchronized (object) {
                Object object2 = this.queueFullLock;
                synchronized (object2) {
                    while (!bl) {
                        ILogRecord iLogRecord = this.inQueue.dequeue();
                        if (iLogRecord == null) {
                            bl = true;
                            continue;
                        }
                        this.outQueue.enqueue(iLogRecord);
                    }
                    this.queueFullLock.notifyAll();
                }
                this.queueEmptyLock.notifyAll();
            }
        }
    }

    protected IFormatter findFormatter(ILogRecord iLogRecord) {
        boolean bl = false;
        Class<?> clazz = iLogRecord.getClass();
        IFormatter iFormatter = null;
        while (!bl && clazz != null) {
            String string = clazz.getName();
            if (this.formatters.containsKey(string)) {
                bl = true;
                iFormatter = (IFormatter)this.formatters.get(string);
                continue;
            }
            clazz = clazz.getSuperclass();
        }
        return iFormatter;
    }

    public int getBackupCapacity() {
        return this.backupFileCapacity;
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        ((Hashtable)properties).put("queueCapacity", new Integer(this.getQueueCapacity()).toString());
        ((Hashtable)properties).put("isBackupEnabled", new Boolean(this.isBackupEnabled()).toString());
        ((Hashtable)properties).put("backupCapacity", new Integer(this.getBackupCapacity()).toString());
        ((Hashtable)properties).put("isCircular", new Boolean(this.isCircular()).toString());
        ((Hashtable)properties).put("maxRetries", new Integer(this.getMaxRetries()).toString());
        ((Hashtable)properties).put("retryInterval", new Integer(this.getRetryInterval()).toString());
        ((Hashtable)properties).put("formatterNames", this.formatterNames);
        return properties;
    }

    public Enumeration getFormatters() {
        return this.formatters.elements();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getQueueCapacity() {
        return this.inQueue.getCapacity();
    }

    public int getQueueCount() {
        int n = this.isCircular() ? this.inQueue.getQueueCount() + this.outQueue.getQueueCount() : this.inQueue.getQueueCount();
        return n;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public Thread getThread() {
        return this.myThread;
    }

    public void init() {
        super.init();
        if (this.deviceLock == null) {
            this.deviceLock = new Object();
        }
        if (this.queueEmptyLock == null) {
            this.queueEmptyLock = new Object();
        }
        if (this.queueFullLock == null) {
            this.queueFullLock = new Object();
        }
        if (this.retryTimer == null) {
            this.retryTimer = new Object();
        }
        this.myThread = null;
        this.deviceFailures = 0;
        this.discardedRecordCount = 0;
        this.deviceOpen = false;
        this.finished = false;
        this.stopRequested = false;
        this.setBackupEnabled(false);
        this.setBackupCapacity(50000);
        this.setMaxRetries(5);
        this.setRetryInterval(5000);
        if (this.formatters == null) {
            this.formatters = new Hashtable();
        } else {
            this.formatters.clear();
        }
        this.addFormatter(new Formatter());
        this.formatterNames = "";
        this.pWriter = null;
        this.outQueue = this.inQueue = new RecordQueue(10000);
    }

    public boolean isBackupEnabled() {
        return this.backupEnabled;
    }

    public boolean isCircular() {
        return this.inQueue.isCircular();
    }

    public void logRecord(ILogRecord iLogRecord, boolean bl) {
        if (iLogRecord != null && !this.stopRequested) {
            if (bl) {
                this.writeRecordSafely(iLogRecord);
            } else {
                boolean bl2 = false;
                while (!bl2) {
                    Object object;
                    if (this.inQueue.enqueue(iLogRecord)) {
                        bl2 = true;
                        if (this.inQueue.isCircular()) continue;
                        object = this.queueEmptyLock;
                        synchronized (object) {
                            this.queueEmptyLock.notify();
                            continue;
                        }
                    }
                    if (!Thread.currentThread().equals(this.myThread)) {
                        object = this.queueFullLock;
                        synchronized (object) {
                            Object object2 = this.retryTimer;
                            synchronized (object2) {
                                this.retryTimer.notify();
                            }
                            try {
                                this.queueFullLock.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                    }
                    if (this.discardedRecordCount == 0) {
                        LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_QUEUE_FULL", this.getName()));
                    }
                    ++this.discardedRecordCount;
                    bl2 = true;
                }
            }
        }
    }

    protected void newQueue(int n, boolean bl) {
        if (bl) {
            this.inQueue = new CircularRecordQueue(n);
            this.outQueue = new RecordQueue(0);
        } else {
            this.outQueue = this.inQueue = new RecordQueue(n);
        }
    }

    public abstract void openDevice() throws NestedException;

    public void removeFormatter(IFormatter iFormatter) {
        if (iFormatter != null) {
            Enumeration enumeration = iFormatter.getRecordClasses();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.formatters.remove(string);
            }
        }
    }

    private void retryRecord(ILogRecord iLogRecord) {
        boolean bl = false;
        int n = 0;
        int n2 = this.getMaxRetries();
        if (this.deviceFailures == 1 && n2 > 0) {
            LogUtil.errorMsg(LogUtil.msgs.getMessage("RETRY_ATTEMPT", this.getName()));
        }
        while (!bl && n < n2 && !this.stopRequested) {
            block10: {
                try {
                    int n3 = this.getRetryInterval();
                    if (n3 == 0) break block10;
                    Object object = this.retryTimer;
                    synchronized (object) {
                        this.retryTimer.wait(n3);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.writeRecord(iLogRecord);
                bl = true;
                this.deviceFailures = 0;
            }
            catch (NestedException nestedException) {
                ++n;
            }
        }
        if (!bl) {
            ++this.discardedRecordCount;
        }
    }

    public void run() {
        Object object;
        while (!this.finished) {
            ILogRecord iLogRecord;
            object = this.queueEmptyLock;
            synchronized (object) {
                iLogRecord = this.outQueue.dequeue();
                if (iLogRecord == null) {
                    if (this.stopRequested) {
                        this.finished = true;
                    } else {
                        try {
                            this.queueEmptyLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            if (iLogRecord == null) continue;
            object = this.queueFullLock;
            synchronized (object) {
                this.queueFullLock.notifyAll();
            }
            this.writeRecordSafely(iLogRecord);
        }
        this.closeDevice();
        if (this.backupFile != null) {
            this.backupFile.delete();
        }
        object = this.queueEmptyLock;
        synchronized (object) {
            this.queueEmptyLock.notify();
            this.myThread = null;
        }
    }

    public void setBackupCapacity(int n) {
        if (n >= 0) {
            this.backupFileCapacity = n;
        }
    }

    public void setBackupEnabled(boolean bl) {
        if (bl) {
            if (this.backupFile == null) {
                this.backupFile = new BackupFile(this.getBackupCapacity());
            } else {
                this.backupFile.delete();
            }
            try {
                this.backupFile.open();
                this.backupEnabled = true;
            }
            catch (IOException iOException) {
                LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_NO_BACKUP"));
                iOException.printStackTrace();
            }
        } else {
            if (this.backupFile != null) {
                this.backupFile.delete();
            }
            this.backupFile = null;
            this.backupEnabled = false;
        }
    }

    public void setCircular(boolean bl) throws IllegalStateException {
        Object object = this.queueEmptyLock;
        synchronized (object) {
            Object object2 = this.queueFullLock;
            synchronized (object2) {
                if (this.inQueue.isCircular() != bl) {
                    if (this.inQueue.getQueueCount() != 0 || this.outQueue.getQueueCount() != 0) {
                        throw new IllegalStateException(LogUtil.msgs.getMessage("ERR_QUEUE_STATE"));
                    }
                    this.newQueue(this.getQueueCapacity(), bl);
                }
            }
        }
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("queueCapacity");
        if (string != null) {
            this.setQueueCapacity(new Integer(string));
        }
        if ((string = properties.getProperty("isBackupEnabled")) != null) {
            this.setBackupEnabled(new Boolean(string));
        }
        if ((string = properties.getProperty("backupCapacity")) != null) {
            this.setBackupCapacity(new Integer(string));
        }
        if ((string = properties.getProperty("maxRetries")) != null) {
            this.setMaxRetries(new Integer(string));
        }
        if ((string = properties.getProperty("retryInterval")) != null) {
            this.setRetryInterval(new Integer(string));
        }
        if ((string = properties.getProperty("isCircular")) != null) {
            this.setCircular(new Boolean(string));
        }
        if ((string = properties.getProperty("formatterNames")) != null) {
            this.formatterNames = string;
        }
    }

    public void setMaxRetries(int n) {
        if (n >= 0) {
            this.maxRetries = n;
        }
    }

    public void setQueueCapacity(int n) throws IllegalStateException {
        if (n >= 0) {
            Object object = this.queueEmptyLock;
            synchronized (object) {
                Object object2 = this.queueFullLock;
                synchronized (object2) {
                    if (n != this.getQueueCapacity()) {
                        if (this.inQueue.getQueueCount() != 0 || this.outQueue.getQueueCount() != 0) {
                            throw new IllegalStateException(LogUtil.msgs.getMessage("ERR_QUEUE_STATE"));
                        }
                        this.newQueue(n, this.inQueue.isCircular());
                    }
                }
            }
        }
    }

    public void setRetryInterval(int n) {
        if (n >= 0) {
            this.retryInterval = n;
        }
    }

    public void start() {
        if (this.myThread == null) {
            this.finished = false;
            this.stopRequested = false;
            String string = String.valueOf(this.getClass().getName()) + ":" + this.getName();
            this.myThread = new Thread((Runnable)this, string);
            this.myThread.setDaemon(true);
            this.myThread.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        this.dumpQueue();
        Object object = this.queueEmptyLock;
        synchronized (object) {
            this.stopRequested = true;
            this.queueEmptyLock.notify();
        }
        object = this.queueEmptyLock;
        synchronized (object) {
            while (true) {
                if (this.finished) {
                    return;
                }
                try {
                    this.queueEmptyLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", deviceOpen=" + this.deviceOpen;
    }

    protected void writeRecord(ILogRecord iLogRecord) throws NestedException {
        Object object = this.deviceLock;
        synchronized (object) {
            IFormatter iFormatter;
            if (!this.deviceOpen) {
                this.openDevice();
            }
            if (this.deviceOpen && (iFormatter = this.findFormatter(iLogRecord)) != null) {
                String string = iFormatter.format(iLogRecord);
                this.pWriter.println(string);
                if (this.pWriter.checkError()) {
                    this.closeDevice();
                    throw new NestedException(LogUtil.msgs.getMessage("ERR_WRITE_MSG", this.getName()));
                }
            }
        }
    }

    private void writeRecordSafely(ILogRecord iLogRecord) {
        boolean bl = true;
        try {
            if (this.isBackupEnabled() && this.backupFile.getRecordCount() != 0) {
                bl = this.clearBackupFile();
            }
            if (bl) {
                this.writeRecord(iLogRecord);
                this.deviceFailures = 0;
                ++this.loggedRecordCount;
                if (this.discardedRecordCount != 0) {
                    if (this.discardedRecordCount == 1) {
                        LogUtil.errorMsg(LogUtil.msgs.getMessage("HANDLER_OK_1", this.getName()));
                    } else {
                        LogUtil.errorMsg(LogUtil.msgs.getMessage("HANDLER_OK_2", this.getName(), new Integer(this.discardedRecordCount)));
                    }
                    this.discardedRecordCount = 0;
                }
            } else {
                this.backupRecord(iLogRecord);
            }
        }
        catch (NestedException nestedException) {
            if (this.deviceFailures == 0) {
                LogUtil.errorMsg(nestedException.getMessage());
                if (nestedException.getNestedException() != null) {
                    nestedException.getNestedException().printStackTrace();
                }
            }
            ++this.deviceFailures;
            if (this.isBackupEnabled()) {
                this.backupRecord(iLogRecord);
            }
            this.retryRecord(iLogRecord);
        }
    }
}

