/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.IConstants;
import com.ibm.logging.ILogRecord;
import com.ibm.logging.ILoggable;
import com.ibm.logging.IRecordType;
import com.ibm.logging.LogUtil;
import com.ibm.logging.NestedException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class LogRecord
extends Hashtable
implements IConstants,
IRecordType,
ILogRecord {
    private static final String S = "(C) Copyright IBM Corp. 1998, 1999.";
    static final long serialVersionUID = 8087853956136976291L;
    private long type = 0L;
    private long timeStamp;
    private ILogRecord nextRecord = null;
    private String msgFile = null;
    private String msgText = "";
    private String[] msgParms = null;

    public LogRecord() {
        this.setTimeStamp(System.currentTimeMillis());
        this.setAttribute("threadID", Thread.currentThread().getName());
    }

    public LogRecord(long l, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this();
        this.setType(l);
        if (string != null) {
            this.setAttribute("loggingClass", string);
        }
        if (string2 != null) {
            this.setAttribute("loggingMethod", string2);
        }
        if (string3 != null) {
            this.setAttribute("organization", string3);
        }
        if (string4 != null) {
            this.setAttribute("product", string4);
        }
        if (string5 != null) {
            this.setAttribute("component", string5);
        }
        if (string6 != null) {
            this.setAttribute("client", string6);
        }
        if (string7 != null) {
            this.setAttribute("server", string7);
        }
    }

    public LogRecord(long l, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, Object[] objectArray) {
        this(l, string, string2, string3, string4, string5, string6, string7);
        this.setText(string8);
        this.setMessageFile(string9);
        this.setParameters(LogRecord.objectsToStrings(objectArray));
    }

    public LogRecord(long l, String string, String string2, String string3, String string4, String string5, String string6, String string7, Throwable object) {
        this(l, string, string2, string3, string4, string5, string6, string7);
        if (object != null) {
            Object object2;
            if (object instanceof NestedException && (object2 = ((NestedException)object).getNestedException()) != null) {
                this.setText(((Throwable)object).getMessage());
                object = object2;
            }
            this.setAttribute("throwable", object);
            object2 = new StringWriter();
            ((Throwable)object).printStackTrace(new PrintWriter((Writer)object2));
            this.setAttribute("throwableTrace", ((StringWriter)object2).toString());
        }
    }

    public LogRecord(long l, String string, String string2, String string3, String string4, String string5, String string6, String string7, byte[] byArray) {
        this(l, string, string2, string3, string4, string5, string6, string7);
        if (byArray != null) {
            this.setAttribute("hexData", byArray);
        }
    }

    public Object getAttribute(String string) {
        Object var2_2 = null;
        if (string != null) {
            var2_2 = this.get(string);
        }
        return var2_2;
    }

    public String getMessageFile() {
        return this.msgFile;
    }

    public ILogRecord getNext() {
        return this.nextRecord;
    }

    public String[] getParameters() {
        return this.msgParms;
    }

    public Hashtable getSupportedTypes() {
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
        hashtable.put(LogUtil.msgs.getMessage("TYPE_INFO"), new Long(1L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_WARN"), new Long(2L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_ERR"), new Long(4L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_FATAL"), new Long(8L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_API"), new Long(16L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_CALLBACK"), new Long(32L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_ENTRY"), new Long(128L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_EXIT"), new Long(256L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_ERROR_EXC"), new Long(512L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_MISC_DATA"), new Long(1024L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_OBJ_CREATE"), new Long(2048L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_OBJ_DELETE"), new Long(4096L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_PRIVATE"), new Long(8192L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_PUBLIC"), new Long(16384L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_STATIC"), new Long(32768L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_SVC"), new Long(65536L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_LEVEL1"), new Long(262144L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_LEVEL2"), new Long(524288L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_LEVEL3"), new Long(0x100000L));
        hashtable.put(LogUtil.msgs.getMessage("TYPE_PERF"), new Long(131072L));
        return hashtable;
    }

    public String getText() {
        return this.msgText;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getType() {
        return this.type;
    }

    public long maskLongValue(String string) {
        long l = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("TYPE_INFO") || string2.equals("TYPE_INFORMATION")) {
                l |= 1L;
                continue;
            }
            if (string2.equals("TYPE_WARN") || string2.equals("TYPE_WARNING")) {
                l |= 2L;
                continue;
            }
            if (string2.equals("TYPE_ERR") || string2.equals("TYPE_ERROR")) {
                l |= 4L;
                continue;
            }
            if (string2.equals("TYPE_FATAL")) {
                l |= 8L;
                continue;
            }
            if (string2.equals("TYPE_DEFAULT_MESSAGE")) {
                l |= 0xFL;
                continue;
            }
            if (string2.equals("TYPE_API")) {
                l |= 0x10L;
                continue;
            }
            if (string2.equals("TYPE_CALLBACK")) {
                l |= 0x20L;
                continue;
            }
            if (string2.equals("TYPE_ENTRY")) {
                l |= 0x80L;
                continue;
            }
            if (string2.equals("TYPE_EXIT")) {
                l |= 0x100L;
                continue;
            }
            if (string2.equals("TYPE_ERROR_EXC")) {
                l |= 0x200L;
                continue;
            }
            if (string2.equals("TYPE_MISC_DATA")) {
                l |= 0x400L;
                continue;
            }
            if (string2.equals("TYPE_OBJ_CREATE")) {
                l |= 0x800L;
                continue;
            }
            if (string2.equals("TYPE_OBJ_DELETE")) {
                l |= 0x1000L;
                continue;
            }
            if (string2.equals("TYPE_PRIVATE")) {
                l |= 0x2000L;
                continue;
            }
            if (string2.equals("TYPE_PUBLIC")) {
                l |= 0x4000L;
                continue;
            }
            if (string2.equals("TYPE_STATIC")) {
                l |= 0x8000L;
                continue;
            }
            if (string2.equals("TYPE_SVC")) {
                l |= 0x10000L;
                continue;
            }
            if (string2.equals("TYPE_LEVEL1")) {
                l |= 0x40000L;
                continue;
            }
            if (string2.equals("TYPE_LEVEL2")) {
                l |= 0x80000L;
                continue;
            }
            if (string2.equals("TYPE_LEVEL3")) {
                l |= 0x100000L;
                continue;
            }
            if (string2.equals("TYPE_PERF")) {
                l |= 0x20000L;
                continue;
            }
            if (string2.equals("TYPE_DEFAULT_TRACE")) {
                l |= 0x1FFB0L;
                continue;
            }
            if (!string2.equals("TYPE_ALL")) continue;
            l |= 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    public String maskToString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (l == -1L) {
            stringBuffer.append("TYPE_ALL");
        } else if (l == 0L) {
            stringBuffer.append("TYPE_NONE");
        } else {
            if ((l & 1L) != 0L) {
                stringBuffer.append("TYPE_INFO ");
            }
            if ((l & 2L) != 0L) {
                stringBuffer.append("TYPE_WARN ");
            }
            if ((l & 4L) != 0L) {
                stringBuffer.append("TYPE_ERR ");
            }
            if ((l & 8L) != 0L) {
                stringBuffer.append("TYPE_FATAL ");
            }
            if ((l & 0x10L) != 0L) {
                stringBuffer.append("TYPE_API ");
            }
            if ((l & 0x20L) != 0L) {
                stringBuffer.append("TYPE_CALLBACK ");
            }
            if ((l & 0x80L) != 0L) {
                stringBuffer.append("TYPE_ENTRY ");
            }
            if ((l & 0x100L) != 0L) {
                stringBuffer.append("TYPE_EXIT ");
            }
            if ((l & 0x200L) != 0L) {
                stringBuffer.append("TYPE_ERROR_EXC ");
            }
            if ((l & 0x400L) != 0L) {
                stringBuffer.append("TYPE_MISC_DATA ");
            }
            if ((l & 0x800L) != 0L) {
                stringBuffer.append("TYPE_OBJ_CREATE ");
            }
            if ((l & 0x1000L) != 0L) {
                stringBuffer.append("TYPE_OBJ_DELETE ");
            }
            if ((l & 0x2000L) != 0L) {
                stringBuffer.append("TYPE_PRIVATE ");
            }
            if ((l & 0x4000L) != 0L) {
                stringBuffer.append("TYPE_PUBLIC ");
            }
            if ((l & 0x8000L) != 0L) {
                stringBuffer.append("TYPE_STATIC ");
            }
            if ((l & 0x10000L) != 0L) {
                stringBuffer.append("TYPE_SVC ");
            }
            if ((l & 0x40000L) != 0L) {
                stringBuffer.append("TYPE_LEVEL1 ");
            }
            if ((l & 0x80000L) != 0L) {
                stringBuffer.append("TYPE_LEVEL2 ");
            }
            if ((l & 0x100000L) != 0L) {
                stringBuffer.append("TYPE_LEVEL3 ");
            }
            if ((l & 0x20000L) != 0L) {
                stringBuffer.append("TYPE_PERF ");
            }
        }
        return stringBuffer.toString().trim();
    }

    protected static String[] objectsToStrings(Object[] objectArray) {
        String string = null;
        String[] stringArray = null;
        if (objectArray != null) {
            stringArray = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == null) {
                    if (string == null) {
                        string = LogUtil.msgs.getMessage("NULL_OBJECT");
                    }
                    stringArray[n] = string;
                } else {
                    stringArray[n] = objectArray[n] instanceof ILoggable ? ((ILoggable)objectArray[n]).toLogString() : objectArray[n].toString();
                }
                ++n;
            }
        }
        return stringArray;
    }

    public void setAttribute(String string, Object object) {
        if (string != null && object != null) {
            this.put(string, object);
        }
    }

    public void setMessageFile(String string) {
        this.msgFile = string;
    }

    public void setNext(ILogRecord iLogRecord) {
        this.nextRecord = iLogRecord;
    }

    public void setParameters(String[] stringArray) {
        this.msgParms = stringArray;
    }

    public void setText(String string) {
        if (string != null) {
            this.msgText = string;
        }
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public void setType(long l) {
        this.type = l;
    }

    public String toString() {
        String string;
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("timeStamp:  ");
        stringBuffer.append(this.getTimeStamp());
        stringBuffer.append(string2);
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement();
            stringBuffer.append((Object)string);
            stringBuffer.append(":  ");
            stringBuffer.append(this.get(string));
            stringBuffer.append(string2);
        }
        string = this.getMessageFile();
        if (string != null) {
            stringBuffer.append("messageFile:  ");
            stringBuffer.append(string);
            stringBuffer.append(string2);
        }
        stringBuffer.append("text:  ");
        stringBuffer.append(this.getText());
        stringBuffer.append(string2);
        String[] stringArray = this.getParameters();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("textParameter");
                stringBuffer.append(n + 1);
                stringBuffer.append(":  ");
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(string2);
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

