/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.MessageCatalog;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogUtil {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    public static final String LOG_MSG_CAT = "com.ibm.logging.Msgs";
    private static final String MISSING_MSG_CAT = "The Logging Toolkit message file, com.ibm.logging.Msgs, was not found.  No toolkit messages can be displayed.";
    public static MessageCatalog msgs = null;
    private static Hashtable localeToCodePage;
    private static PrintWriter errWriter;
    static /* synthetic */ Class class$com$ibm$logging$LogUtil;

    static {
        try {
            msgs = new MessageCatalog(LOG_MSG_CAT);
        }
        catch (MissingResourceException missingResourceException) {
            LogUtil.errorMsg(MISSING_MSG_CAT);
            missingResourceException.printStackTrace();
        }
        localeToCodePage = new Hashtable();
        errWriter = null;
        localeToCodePage.put("cs", "Cp852");
        localeToCodePage.put("da", "Cp850");
        localeToCodePage.put("en", "Cp850");
        localeToCodePage.put("de", "Cp850");
        localeToCodePage.put("es", "Cp850");
        localeToCodePage.put("fi", "Cp850");
        localeToCodePage.put("fr", "Cp850");
        localeToCodePage.put("hu", "Cp852");
        localeToCodePage.put("it", "Cp850");
        localeToCodePage.put("nl", "Cp949");
        localeToCodePage.put("no", "Cp850");
        localeToCodePage.put("pl", "Cp852");
        localeToCodePage.put("pt", "Cp850");
        localeToCodePage.put("ru", "Cp866");
        localeToCodePage.put("sl", "Cp852");
        localeToCodePage.put("sv", "Cp850");
        localeToCodePage.put("tr", "Cp857");
        try {
            String string = LogUtil.getConsoleCodePage();
            LogUtil logUtil = new LogUtil();
            OutputStreamWriter outputStreamWriter = string != null && logUtil.getClass().getClassLoader() == null ? new OutputStreamWriter((OutputStream)System.err, string) : new OutputStreamWriter(System.err);
            errWriter = new PrintWriter((Writer)outputStreamWriter, true);
        }
        catch (Exception exception) {}
    }

    public static Vector arrayToVector(Object[] objectArray) {
        Vector<String> vector = null;
        if (objectArray != null) {
            vector = new Vector<String>();
            int n = 0;
            while (n < objectArray.length) {
                vector.addElement(objectArray[n].toString());
                ++n;
            }
        }
        return vector;
    }

    public static Object[] checkNullObjects(Object[] objectArray) {
        String string = null;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == null) {
                    if (string == null) {
                        string = msgs.getMessage("NULL_OBJECT");
                    }
                    objectArray[n] = string;
                }
                ++n;
            }
        }
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Object createObject(String string) {
        Object var2_2;
        block2: {
            Class<?> clazz = null;
            var2_2 = null;
            if (string == null) break block2;
            ClassLoader classLoader = (class$com$ibm$logging$LogUtil != null ? class$com$ibm$logging$LogUtil : (class$com$ibm$logging$LogUtil = LogUtil.class$("com.ibm.logging.LogUtil"))).getClassLoader();
            try {
                clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                var2_2 = clazz.newInstance();
            }
            catch (Exception exception) {
                LogUtil.errorMsg(msgs.getMessage("ERR_OBJ_CREATE", string));
                exception.printStackTrace();
            }
        }
        return var2_2;
    }

    public static void errorMsg(String string) {
        if (errWriter == null) {
            System.err.println(string);
        } else {
            errWriter.println(string);
        }
    }

    public static String getConsoleCodePage() {
        String string = null;
        try {
            String string2 = System.getProperty("os.name");
            if (string2 != null && string2.startsWith("Windows")) {
                Locale locale = Locale.getDefault();
                String string3 = locale.getLanguage();
                String string4 = locale.getCountry();
                string = (String)localeToCodePage.get(String.valueOf(string3) + "_" + string4);
                if (string == null) {
                    string = (String)localeToCodePage.get(string3);
                }
            }
        }
        catch (Exception exception) {}
        return string;
    }

    public static String left(String string, int n) {
        return LogUtil.left(string, n, " ");
    }

    public static String left(String string, int n, String string2) {
        String string3 = string;
        if (string != null) {
            if (string.length() < n) {
                while (string3.length() < n) {
                    string3 = String.valueOf(string3) + string2;
                }
            } else if (string.length() > n) {
                string3 = string.substring(0, n);
            }
        }
        return string3;
    }

    public static boolean makePath(String string) throws SecurityException {
        boolean bl;
        if (string == null) {
            bl = false;
        } else {
            File file;
            bl = true;
            File file2 = new File(string = string.replace('/', File.separatorChar));
            String string2 = file2.getParent();
            if (string2 != null && !(file = new File(string2)).exists()) {
                bl = file.mkdirs();
            }
        }
        return bl;
    }

    public static Vector stringToVector(String string) {
        Vector<String> vector = null;
        if (string != null) {
            vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken().trim());
            }
        }
        return vector;
    }

    public static String vectorToString(Vector vector) {
        String string = null;
        StringBuffer stringBuffer = null;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            stringBuffer = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(enumeration.nextElement());
                stringBuffer.append(" ");
            }
            string = stringBuffer.toString().trim();
        }
        return string;
    }
}

