/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.Gate;
import com.ibm.logging.IHandler;
import com.ibm.logging.ILoggerCfg;
import com.ibm.logging.LogUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class LoggerCfg
extends Gate
implements ILoggerCfg {
    private static final String S = "(C) Copyright IBM Corp. 1998, 1999.";
    private boolean sync;
    private String client;
    private String component;
    private String handlerNames;
    private String messageFile;
    private String organization;
    private String product;
    private String server;
    private Vector handlers;
    private Vector suppressedKeys;

    public LoggerCfg() {
    }

    public LoggerCfg(String string) {
        super(string);
    }

    public LoggerCfg(String string, String string2) {
        super(string, string2);
    }

    public void addHandler(IHandler iHandler) {
        if (iHandler != null && !this.handlers.contains(iHandler)) {
            this.handlers.addElement(iHandler);
        }
    }

    public void addSuppressedKey(String string) {
        if (string != null && !this.suppressedKeys.contains(string)) {
            this.suppressedKeys.addElement(string);
        }
    }

    public String getClient() {
        return this.client;
    }

    public String getComponent() {
        return this.component;
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        ((Hashtable)properties).put("isSync", new Boolean(this.isSynchronous()).toString());
        ((Hashtable)properties).put("organization", this.getOrganization());
        ((Hashtable)properties).put("product", this.getProduct());
        ((Hashtable)properties).put("component", this.getComponent());
        ((Hashtable)properties).put("client", this.getClient());
        ((Hashtable)properties).put("server", this.getServer());
        ((Hashtable)properties).put("handlerNames", this.handlerNames);
        String string = this.getMessageFile();
        if (string != null) {
            ((Hashtable)properties).put("messageFile", string);
        }
        ((Hashtable)properties).put("suppressedKeys", LogUtil.vectorToString(this.suppressedKeys));
        return properties;
    }

    public Enumeration getHandlers() {
        return this.handlers.elements();
    }

    public String getMessageFile() {
        return this.messageFile;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getProduct() {
        return this.product;
    }

    public String getServer() {
        return this.server;
    }

    public Vector getSuppressedKeys() {
        return this.suppressedKeys;
    }

    public void init() {
        super.init();
        this.setSynchronous(false);
        this.setOrganization("");
        this.setProduct("");
        this.setComponent("");
        this.setClient("");
        this.setServer("");
        this.handlerNames = "";
        this.messageFile = null;
        if (this.handlers == null) {
            this.handlers = new Vector();
        } else {
            this.handlers.removeAllElements();
        }
        if (this.suppressedKeys == null) {
            this.suppressedKeys = new Vector();
        } else {
            this.suppressedKeys.removeAllElements();
        }
    }

    public boolean isSynchronous() {
        return this.sync;
    }

    public void removeHandler(IHandler iHandler) {
        if (iHandler != null && this.handlers.contains(iHandler)) {
            this.handlers.removeElement(iHandler);
        }
    }

    public void removeSuppressedKey(String string) {
        if (string != null && this.suppressedKeys.contains(string)) {
            this.suppressedKeys.removeElement(string);
        }
    }

    public void setClient(String string) {
        if (string != null) {
            this.client = string;
        }
    }

    public void setComponent(String string) {
        if (string != null) {
            this.component = string;
        }
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("isSync");
        if (string != null) {
            this.setSynchronous(new Boolean(string));
        }
        if ((string = properties.getProperty("organization")) != null) {
            this.setOrganization(string);
        }
        if ((string = properties.getProperty("product")) != null) {
            this.setProduct(string);
        }
        if ((string = properties.getProperty("component")) != null) {
            this.setComponent(string);
        }
        if ((string = properties.getProperty("client")) != null) {
            this.setClient(string);
        }
        if ((string = properties.getProperty("server")) != null) {
            this.setServer(string);
        }
        if ((string = properties.getProperty("handlerNames")) != null) {
            this.handlerNames = string;
        }
        if ((string = properties.getProperty("messageFile")) != null) {
            this.messageFile = string;
        }
        if ((string = properties.getProperty("suppressedKeys")) != null) {
            this.suppressedKeys = LogUtil.stringToVector(string);
        }
    }

    public void setMessageFile(String string) {
        if (string != null) {
            this.messageFile = string;
        }
    }

    public void setOrganization(String string) {
        if (string != null) {
            this.organization = string;
        }
    }

    public void setProduct(String string) {
        if (string != null) {
            this.product = string;
        }
    }

    public void setServer(String string) {
        if (string != null) {
            this.server = string;
        }
    }

    public void setSynchronous(boolean bl) {
        this.sync = bl;
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", isSync=" + this.isSynchronous();
    }
}

