/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.LogUtil;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageCatalog {
    private static final String S = "(C) Copyright IBM Corp. 1998, 1999.";
    private static boolean debugMode;
    private static ClassLoader classLoader;
    private int hitCount = 0;
    private Locale locale;
    private MessageFormat msgFormatter = new MessageFormat("");
    private Object formatLock = new Object();
    private ResourceBundle msgBundle;
    private String baseName;
    static /* synthetic */ Class class$com$ibm$logging$MessageCatalog;

    static {
        classLoader = null;
        debugMode = false;
    }

    public MessageCatalog(String string) {
        this(string, Locale.getDefault());
    }

    public MessageCatalog(String string, Locale locale) {
        this.baseName = string;
        this.msgBundle = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setLocale(locale);
    }

    public MessageCatalog(ResourceBundle resourceBundle) {
        this(resourceBundle, Locale.getDefault());
    }

    public MessageCatalog(ResourceBundle resourceBundle, Locale locale) {
        this.msgBundle = resourceBundle;
        this.baseName = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setLocale(locale);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public String formatMessage(String var1_1, Object[] var2_2) {
        var3_3 = null;
        if (var2_2 != null) {
            block24: {
                var4_4 = false;
                var5_5 = new StringBuffer();
                var2_2 = LogUtil.checkNullObjects(var2_2);
                try {
                    var6_6 = this.formatLock;
                    synchronized (var6_6) {
                        this.msgFormatter.applyPattern(var1_1);
                    }
                }
                catch (IllegalArgumentException v1) {
                    var4_4 = true;
                }
                if (!var4_4) {
                    try {
                        var6_6 = this.formatLock;
                        synchronized (var6_6) {
                            var5_5 = this.msgFormatter.format(var2_2, var5_5, (FieldPosition)null);
                            break block24;
                        }
                    }
                    catch (IllegalArgumentException v3) {
                        var6_7 = 0;
                        ** while (var6_7 < var2_2.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (!(var2_2[var6_7] instanceof Number) && !(var2_2[var6_7] instanceof Date)) {
                            var2_2[var6_7] = var2_2[var6_7].toString();
                        }
                        ++var6_7;
                        continue;
                    }
lbl33:
                    // 1 sources

                    var5_5.setLength(0);
                    try {
                        var7_9 = this.formatLock;
                        synchronized (var7_9) {
                            var5_5 = this.msgFormatter.format(var2_2, var5_5, (FieldPosition)null);
                        }
                    }
                    catch (IllegalArgumentException v5) {
                        var4_4 = true;
                    }
                }
            }
            if (var4_4) {
                var5_5.setLength(0);
                var5_5.append(var1_1);
                var6_8 = 0;
                while (var6_8 < var2_2.length) {
                    var5_5.append(", p" + (var6_8 + 1) + "=" + var2_2[var6_8].toString());
                    ++var6_8;
                }
            }
            var3_3 = var5_5.toString();
        } else {
            var3_3 = var1_1;
        }
        if (MessageCatalog.isDebugMode()) {
            var3_3 = "[" + var3_3 + "]";
        }
        ++this.hitCount;
        return var3_3;
    }

    public char getChar(String string) {
        String string2 = this.getMessage(string);
        char c = MessageCatalog.isDebugMode() ? string2.charAt(1) : string2.charAt(0);
        return c;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public Enumeration getKeys() {
        return this.msgBundle.getKeys();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getMessage(String string) {
        return this.getMessage(string, null);
    }

    public String getMessage(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return this.getMessage(string, objectArray);
    }

    public String getMessage(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return this.getMessage(string, objectArray);
    }

    public String getMessage(String string, Object[] objectArray) {
        String string2 = null;
        if (this.msgBundle != null) {
            try {
                string2 = this.formatMessage(this.msgBundle.getString(string), objectArray);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (string2 == null) {
            StringBuffer stringBuffer = new StringBuffer(256);
            if (MessageCatalog.isDebugMode()) {
                stringBuffer.append("[");
            }
            if (this.msgBundle == null) {
                if (this.baseName == null) {
                    stringBuffer.append(LogUtil.msgs.getMessage("ERR_MISSING_BUNDLE_NO_FILE", string));
                } else {
                    stringBuffer.append(LogUtil.msgs.getMessage("ERR_MISSING_BUNDLE", this.baseName, string));
                }
            } else if (this.baseName == null) {
                stringBuffer.append(LogUtil.msgs.getMessage("ERR_MISSING_KEY_NO_FILE", string));
            } else {
                stringBuffer.append(LogUtil.msgs.getMessage("ERR_MISSING_KEY", string, this.baseName));
            }
            if (objectArray == null) {
                stringBuffer.append(".");
            } else {
                objectArray = LogUtil.checkNullObjects(objectArray);
                int n = 0;
                while (n < objectArray.length) {
                    stringBuffer.append(", p" + (n + 1) + "=" + objectArray[n].toString());
                    ++n;
                }
            }
            if (MessageCatalog.isDebugMode()) {
                stringBuffer.append("]");
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public String getMsg(String string, Object[] objectArray) {
        return this.getMessage(string, objectArray);
    }

    public boolean isDebug() {
        return MessageCatalog.isDebugMode();
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            MessageCatalog.classLoader = classLoader;
        }
    }

    public void setDebug(boolean bl) {
        MessageCatalog.setDebugMode(bl);
    }

    public static void setDebugMode(boolean bl) {
        debugMode = bl;
    }

    public void setLocale(Locale locale) {
        block6: {
            if (locale == null) break block6;
            this.locale = locale;
            this.msgFormatter.setLocale(locale);
            if (this.baseName != null) {
                try {
                    Class clazz = class$com$ibm$logging$MessageCatalog != null ? class$com$ibm$logging$MessageCatalog : (class$com$ibm$logging$MessageCatalog = MessageCatalog.class$("com.ibm.logging.MessageCatalog"));
                    synchronized (clazz) {
                        this.msgBundle = classLoader == null ? ResourceBundle.getBundle(this.baseName, this.getLocale()) : ResourceBundle.getBundle(this.baseName, this.getLocale(), classLoader);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    this.msgBundle = null;
                }
            }
        }
    }

    public String toString() {
        String string = this.baseName != null ? this.baseName : this.msgBundle.toString();
        return "bundle=" + string + ", locale=" + this.getLocale().toString() + ", isDebug=" + this.isDebug();
    }
}

