/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.ILogRecord;
import com.ibm.logging.LogUtil;
import com.ibm.logging.MultiFileHandler;
import com.ibm.logging.NestedException;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Vector;

public class SerialFileHandler
extends MultiFileHandler {
    private static final String S = "(C) Copyright IBM Corp. 1999.";
    static final long serialVersionUID = -3739196948239217286L;
    private transient File outputFile = null;
    private transient ObjectOutput objectOutput = null;

    public SerialFileHandler() {
    }

    public SerialFileHandler(String string) {
        super(string);
    }

    public SerialFileHandler(String string, String string2) {
        super(string, string2);
    }

    public SerialFileHandler(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            super.closeDevice();
            try {
                if (this.objectOutput != null) {
                    this.objectOutput.close();
                }
            }
            catch (Exception exception) {}
            this.outputFile = null;
            this.objectOutput = null;
        }
    }

    public void openDevice() throws NestedException {
        long l = -1L;
        String string = this.getFileName();
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.outputFile != null) {
                l = this.outputFile.length();
            }
            long l2 = this.getMaxFileSize() * 1024;
            if (!this.deviceOpen || l >= l2) {
                this.closeDevice();
                Vector vector = this.getDirList(this.fileDir);
                vector = this.deleteExtraFiles(vector, this.fileDir);
                this.renameFiles(vector, this.fileDir);
                try {
                    LogUtil.makePath(string);
                    this.objectOutput = new ObjectOutputStream(new FileOutputStream(string, true));
                    this.outputFile = new File(string);
                    this.deviceOpen = true;
                }
                catch (Exception exception) {
                    String string2 = LogUtil.msgs.getMessage("ERR_OPEN_FILE", string);
                    throw new NestedException(string2, exception);
                }
            }
        }
    }

    public Vector readSerializedRecords() throws ClassNotFoundException, FileNotFoundException, IOException, StreamCorruptedException {
        ObjectInput objectInput = null;
        String string = null;
        Vector<ILogRecord> vector = new Vector<ILogRecord>();
        Object object = this.deviceLock;
        synchronized (object) {
            this.closeDevice();
            Vector vector2 = this.getDirList(this.fileDir);
            try {
                int n = 0;
                while (n < vector2.size()) {
                    string = String.valueOf(this.fileDir) + vector2.elementAt(n);
                    objectInput = new ObjectInputStream(new FileInputStream(string));
                    boolean bl = false;
                    while (!bl) {
                        try {
                            vector.addElement((ILogRecord)objectInput.readObject());
                        }
                        catch (EOFException eOFException) {
                            bl = true;
                        }
                    }
                    objectInput.close();
                    ++n;
                }
                objectInput = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (objectInput != null) {
                    try {
                        objectInput.close();
                    }
                    catch (Exception exception) {
                        LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_CLOSE_STREAM", this.getName(), string));
                        exception.printStackTrace();
                    }
                }
                throw throwable;
            }
            Object var8_10 = null;
            if (objectInput != null) {
                try {
                    objectInput.close();
                }
                catch (Exception exception) {
                    LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_CLOSE_STREAM", this.getName(), string));
                    exception.printStackTrace();
                }
            }
        }
        return vector;
    }

    protected void writeRecord(ILogRecord iLogRecord) throws NestedException {
        this.openDevice();
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.deviceOpen) {
                try {
                    this.objectOutput.writeObject(iLogRecord);
                    this.objectOutput.flush();
                }
                catch (Exception exception) {
                    this.closeDevice();
                    String string = LogUtil.msgs.getMessage("ERR_WRITE_MSG", this.getName());
                    throw new NestedException(string, exception);
                }
            }
        }
    }
}

