/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.Handler;
import com.ibm.logging.LogUtil;
import com.ibm.logging.NestedException;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;

public class SocketHandler
extends Handler {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 8384099130353912333L;
    private static final int DEFAULT_PORT = 9991;
    private static final String DEFAULT_SERVER = "localhost";
    private int port;
    private String server;
    private transient Socket socket;
    private DataOutputStream dos;
    private OutputStreamWriter osw;
    private BufferedWriter bw;

    public SocketHandler() {
    }

    public SocketHandler(String string) {
        super(string);
    }

    public SocketHandler(String string, String string2) {
        super(string, string2);
    }

    public SocketHandler(String string, String string2, String string3, int n) {
        super(string, string2);
        this.setServer(string3);
        this.setPort(n);
    }

    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            super.closeDevice();
            try {
                if (this.socket != null) {
                    this.bw.flush();
                    this.osw.flush();
                    this.dos.flush();
                    this.bw.close();
                    this.osw.close();
                    this.dos.close();
                    this.socket.close();
                }
            }
            catch (IOException iOException) {}
            this.socket = null;
        }
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        ((Hashtable)properties).put("socketPort", new Integer(this.getPort()).toString());
        ((Hashtable)properties).put("socketServer", this.getServer());
        return properties;
    }

    public int getPort() {
        return this.port;
    }

    public String getServer() {
        return this.server;
    }

    public void init() {
        super.init();
        this.port = 9991;
        this.server = DEFAULT_SERVER;
        this.socket = null;
    }

    public void openDevice() throws NestedException {
        this.closeDevice();
        Object object = this.deviceLock;
        synchronized (object) {
            try {
                this.socket = new Socket(this.getServer(), this.getPort());
                this.dos = new DataOutputStream(this.socket.getOutputStream());
                this.osw = new OutputStreamWriter(this.dos);
                this.bw = new BufferedWriter(this.osw);
                this.pWriter = new PrintWriter((Writer)this.bw, true);
                this.deviceOpen = true;
            }
            catch (Exception exception) {
                String string = LogUtil.msgs.getMessage("ERR_OPEN_SOCKET", this.getServer(), new Integer(this.getPort()));
                throw new NestedException(string, exception);
            }
        }
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("socketPort");
        if (string != null) {
            this.setPort(new Integer(string.trim()));
        }
        if ((string = properties.getProperty("socketServer")) != null) {
            this.setServer(string);
        }
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setServer(String string) {
        if (string != null) {
            this.server = string;
        }
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", server=" + this.getServer() + ", port=" + this.getPort();
    }
}

