/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.Handler;
import com.ibm.logging.IFormatter;
import com.ibm.logging.ILogRecord;
import java.awt.Font;
import java.awt.TextArea;

public class TextAreaHandler
extends Handler {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 8089111989501470480L;
    private transient TextArea textArea;

    public TextAreaHandler() {
    }

    public TextAreaHandler(String string) {
        super(string);
    }

    public TextAreaHandler(String string, String string2) {
        super(string, string2);
    }

    public TextAreaHandler(String string, String string2, TextArea textArea) {
        super(string, string2);
        this.setTextArea(textArea);
    }

    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.deviceOpen = false;
        }
    }

    public TextArea getTextArea() {
        return this.textArea;
    }

    public void init() {
        super.init();
        this.textArea = new TextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
    }

    public void openDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.deviceOpen = true;
        }
    }

    public void setTextArea(TextArea textArea) {
        if (textArea != null) {
            this.textArea = textArea;
        }
    }

    protected void writeRecord(ILogRecord iLogRecord) {
        Object object = this.deviceLock;
        synchronized (object) {
            IFormatter iFormatter;
            if (!this.deviceOpen) {
                this.openDevice();
            }
            if (this.deviceOpen && (iFormatter = this.findFormatter(iLogRecord)) != null) {
                String string = iFormatter.format(iLogRecord);
                this.textArea.append(String.valueOf(string) + "\n");
            }
        }
    }
}

