/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.mgr;

import com.ibm.logging.LogUtil;
import com.ibm.logging.mgr.Group;
import com.ibm.logging.mgr.LogManager;
import java.util.Enumeration;
import java.util.Hashtable;

public class BaseGroup
extends Group
implements Cloneable {
    private static final String S = "(C) Copyright IBM Corp. 1998, 1999.";
    static final long serialVersionUID = -116623750397005860L;
    private Hashtable groups = new Hashtable();
    private String defaultMessageLogger = null;
    private String defaultTraceLogger = null;

    public BaseGroup() {
        super(LogUtil.msgs.getMessage("BASE_GROUP_NAME"));
    }

    public void addGroup(Group group) {
        if (group != null) {
            this.groups.put(group.getName(), group);
        }
    }

    public synchronized Object clone() {
        BaseGroup baseGroup = (BaseGroup)super.clone();
        baseGroup.groups = (Hashtable)this.groups.clone();
        return baseGroup;
    }

    public String getDefaultMessageLogger() {
        return this.defaultMessageLogger;
    }

    public String getDefaultTraceLogger() {
        return this.defaultTraceLogger;
    }

    public Group getGroup(String string) {
        Group group = null;
        if (string != null) {
            group = (Group)this.groups.get(string);
        }
        return group;
    }

    public Enumeration getGroups() {
        return this.groups.elements();
    }

    public void removeGroup(Group group) {
        if (group != null) {
            this.removeGroup(group.getName());
        }
    }

    public void removeGroup(String string) {
        if (string != null) {
            this.groups.remove(string);
        }
    }

    public void setDefaultMessageLogger(String string) {
        this.defaultMessageLogger = string;
    }

    public void setDefaultTraceLogger(String string) {
        this.defaultTraceLogger = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\r\n");
        stringBuffer.append(super.toString());
        if (!this.groups.isEmpty()) {
            Enumeration enumeration = this.groups.elements();
            while (enumeration.hasMoreElements()) {
                Group group = (Group)enumeration.nextElement();
                stringBuffer.append(group.toString());
            }
        }
        return stringBuffer.toString();
    }

    public void update(BaseGroup baseGroup, LogManager logManager) {
        if (baseGroup != null) {
            super.update(baseGroup, logManager);
            Enumeration enumeration = baseGroup.getGroups();
            while (enumeration.hasMoreElements()) {
                Group group = (Group)enumeration.nextElement();
                String string = group.getName();
                Group group2 = this.getGroup(string);
                if (group2 == null) {
                    this.addGroup(group);
                    continue;
                }
                group2.update(group, logManager);
            }
        }
    }
}

