/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.mgr;

import com.ibm.logging.IConstants;
import com.ibm.logging.IFilter;
import com.ibm.logging.IFormatter;
import com.ibm.logging.IGate;
import com.ibm.logging.IHandler;
import com.ibm.logging.ILogger;
import com.ibm.logging.LogException;
import com.ibm.logging.LogUtil;
import com.ibm.logging.mgr.BaseGroup;
import com.ibm.logging.mgr.Config;
import com.ibm.logging.mgr.Group;
import com.ibm.logging.mgr.IDataStore;
import com.ibm.logging.mgr.ILogManager;
import com.ibm.logging.mgr.IManageable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogManager
implements IConstants,
ILogManager {
    private static final String S = "(C) Copyright IBM Corp. 1998, 2000.";
    protected static final Object dsLock = new Object();
    protected static final Object getMgrLock = new Object();
    protected static final Object getObjLock = new Object();
    private IDataStore dataStore = null;
    private BaseGroup baseGroup = new BaseGroup();
    private static LogManager mgr = null;

    protected LogManager(IDataStore iDataStore) {
        this.addDataStore(iDataStore);
        try {
            this.restoreConfig();
        }
        catch (LogException logException) {
            logException.printStackTrace();
        }
    }

    public void addDataStore(IDataStore iDataStore) {
        Object object = dsLock;
        synchronized (object) {
            if (iDataStore != null) {
                this.dataStore = iDataStore;
                this.dataStore.addConfigChangeListener(this);
            }
        }
    }

    protected void addFilters(IGate iGate, Config config, Group group) {
        if (iGate != null) {
            IFilter iFilter;
            String string = config.getProperty("filterNames");
            Vector vector = new Vector();
            Enumeration enumeration = iGate.getFilters();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    iFilter = (IFilter)this.getObject(string2, group);
                    if (iFilter == null) {
                        iFilter = (IFilter)this.getObject(string2, this.baseGroup);
                    }
                    if (iFilter == null) continue;
                    if (vector.contains(iFilter)) {
                        this.returnObject(iFilter);
                        vector.removeElement(iFilter);
                        continue;
                    }
                    iGate.addFilter(iFilter);
                }
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                iFilter = (IFilter)enumeration.nextElement();
                iGate.removeFilter(iFilter);
                this.returnObject(iFilter);
            }
        }
    }

    protected void addFormatters(IHandler iHandler, Config config, Group group) {
        String string;
        if (iHandler != null && (string = config.getProperty("formatterNames")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                IFormatter iFormatter = (IFormatter)this.getObject(string2, group);
                if (iFormatter == null) {
                    iFormatter = (IFormatter)this.getObject(string2, this.baseGroup);
                }
                if (iFormatter == null) continue;
                iHandler.addFormatter(iFormatter);
            }
        }
    }

    protected void addHandlers(ILogger iLogger, Config config, Group group) {
        if (iLogger != null) {
            IHandler iHandler;
            String string = config.getProperty("handlerNames");
            Vector vector = new Vector();
            Enumeration enumeration = iLogger.getHandlers();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    iHandler = (IHandler)this.getObject(string2, group);
                    if (iHandler == null) {
                        iHandler = (IHandler)this.getObject(string2, this.baseGroup);
                    }
                    if (iHandler == null) continue;
                    if (vector.contains(iHandler)) {
                        this.returnObject(iHandler);
                        vector.removeElement(iHandler);
                        continue;
                    }
                    iLogger.addHandler(iHandler);
                }
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                iHandler = (IHandler)enumeration.nextElement();
                iLogger.removeHandler(iHandler);
                this.returnObject(iHandler);
            }
        }
    }

    public static void deleteManager() {
        Object object = getMgrLock;
        synchronized (object) {
            mgr = null;
        }
    }

    protected void finalize() throws Throwable {
        Enumeration enumeration = this.baseGroup.getConfigs();
        this.stopObjects(enumeration);
        enumeration = this.baseGroup.getGroups();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            Enumeration enumeration2 = group.getConfigs();
            this.stopObjects(enumeration2);
        }
        super.finalize();
    }

    public BaseGroup getBaseGroup() {
        return this.baseGroup;
    }

    public Enumeration getDataStores() {
        Vector<IDataStore> vector = new Vector<IDataStore>(1);
        Object object = dsLock;
        synchronized (object) {
            if (this.dataStore != null) {
                vector.addElement(this.dataStore);
            }
        }
        return vector.elements();
    }

    protected ILogger getDefaultLogger(String string, String string2, Group group) {
        ILogger iLogger = null;
        if (string2 != null) {
            Object object = getObjLock;
            synchronized (object) {
                Config config = this.baseGroup.getConfig(string2);
                if (config != null) {
                    Config config2 = new Config(config);
                    String string3 = group.getName();
                    if (!group.equals(this.baseGroup) && this.baseGroup.getGroup(string3) == null) {
                        this.baseGroup.addGroup(group);
                    }
                    ((Hashtable)config2).put("name", string);
                    group.addConfig(config2);
                    iLogger = (ILogger)this.getObject(string, group);
                }
            }
            if (iLogger == null) {
                LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_MISSING_LOGGER", string));
            }
        } else {
            LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_MISSING_LOGGER_NO_DEF", string));
        }
        return iLogger;
    }

    public static LogManager getManager() {
        LogManager.getManager(null);
        return mgr;
    }

    public static LogManager getManager(IDataStore iDataStore) {
        Object object = getMgrLock;
        synchronized (object) {
            if (mgr == null) {
                mgr = new LogManager(iDataStore);
            }
        }
        return mgr;
    }

    public ILogger getMessageLogger(String string) throws IllegalArgumentException {
        ILogger iLogger = (ILogger)this.getObject(string);
        if (iLogger == null) {
            iLogger = this.getDefaultLogger(string, this.baseGroup.getDefaultMessageLogger(), this.baseGroup);
        }
        return iLogger;
    }

    public ILogger getMessageLogger(String string, Group group) throws IllegalArgumentException {
        ILogger iLogger = (ILogger)this.getObject(string, group);
        if (iLogger == null) {
            iLogger = this.getDefaultLogger(string, this.baseGroup.getDefaultMessageLogger(), group);
        }
        return iLogger;
    }

    public ILogger getMessageLogger(String string, String string2) throws IllegalArgumentException {
        ILogger iLogger = (ILogger)this.getObject(string, string2);
        if (iLogger == null) {
            Group group = this.baseGroup.getGroup(string2);
            if (group == null) {
                group = new Group(string2);
            }
            iLogger = this.getDefaultLogger(string, this.baseGroup.getDefaultMessageLogger(), group);
        }
        return iLogger;
    }

    public IManageable getObject(String string) throws IllegalArgumentException {
        return this.getObject(string, this.baseGroup);
    }

    public IManageable getObject(String string, Group group) throws IllegalArgumentException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException(LogUtil.msgs.getMessage("ERR_OBJECT_NAME"));
        }
        if (group == null) {
            throw new IllegalArgumentException(LogUtil.msgs.getMessage("ERR_MISSING_GROUP", string));
        }
        IManageable iManageable = null;
        Object object = getObjLock;
        synchronized (object) {
            Config config = group.getConfig(string);
            if (config != null) {
                iManageable = config.getObject();
                if (iManageable == null) {
                    String string2 = config.getProperty("className");
                    if (string2 != null) {
                        iManageable = (IManageable)LogUtil.createObject(string2);
                        if (iManageable != null) {
                            iManageable.init();
                            iManageable.setConfig(config);
                            iManageable.setManaged(true);
                            config.setObject(iManageable);
                            if (iManageable instanceof ILogger) {
                                this.addHandlers((ILogger)iManageable, config, group);
                                this.addFilters((IGate)iManageable, config, group);
                            } else if (iManageable instanceof IHandler) {
                                this.addFormatters((IHandler)iManageable, config, group);
                                this.addFilters((IGate)iManageable, config, group);
                            }
                        }
                    } else {
                        LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_MISSING_CLASS_NAME", string));
                    }
                }
                if (iManageable != null) {
                    config.incrementInUseCount();
                }
            }
        }
        return iManageable;
    }

    public IManageable getObject(String string, String string2) throws IllegalArgumentException {
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException(LogUtil.msgs.getMessage("ERR_GROUP_NAME"));
        }
        IManageable iManageable = null;
        Object object = getObjLock;
        synchronized (object) {
            Group group = this.baseGroup.getGroup(string2);
            if (group != null) {
                iManageable = this.getObject(string, group);
            }
        }
        return iManageable;
    }

    public ILogger getTraceLogger(String string) throws IllegalArgumentException {
        ILogger iLogger = (ILogger)this.getObject(string);
        if (iLogger == null) {
            iLogger = this.getDefaultLogger(string, this.baseGroup.getDefaultTraceLogger(), this.baseGroup);
        }
        return iLogger;
    }

    public ILogger getTraceLogger(String string, Group group) throws IllegalArgumentException {
        ILogger iLogger = (ILogger)this.getObject(string, group);
        if (iLogger == null) {
            iLogger = this.getDefaultLogger(string, this.baseGroup.getDefaultTraceLogger(), group);
        }
        return iLogger;
    }

    public ILogger getTraceLogger(String string, String string2) throws IllegalArgumentException {
        ILogger iLogger = (ILogger)this.getObject(string, string2);
        if (iLogger == null) {
            Group group = this.baseGroup.getGroup(string2);
            if (group == null) {
                group = new Group(string2);
            }
            iLogger = this.getDefaultLogger(string, this.baseGroup.getDefaultTraceLogger(), group);
        }
        return iLogger;
    }

    public void removeConfig(Config config) {
        if (config != null) {
            Object object = dsLock;
            synchronized (object) {
                String string = config.getProperty("group");
                Group group = string == null || string.equals("") ? this.baseGroup : this.baseGroup.getGroup(string);
                if (group != null) {
                    String string2 = config.getProperty("name");
                    group.removeConfig(string2);
                }
            }
        }
    }

    public void removeDataStore(IDataStore iDataStore) {
        Object object = dsLock;
        synchronized (object) {
            if (iDataStore != null && this.dataStore.equals(iDataStore)) {
                this.dataStore.removeConfigChangeListener(this);
                this.dataStore = null;
            }
        }
    }

    protected void removeFilters(IGate iGate) {
        Enumeration enumeration = iGate.getFilters();
        while (enumeration.hasMoreElements()) {
            this.returnObject((IManageable)enumeration.nextElement());
        }
    }

    protected void removeFormatters(IHandler iHandler) {
        Enumeration enumeration = iHandler.getFormatters();
        while (enumeration.hasMoreElements()) {
            this.returnObject((IManageable)enumeration.nextElement());
        }
    }

    protected void removeHandlers(ILogger iLogger) {
        Enumeration enumeration = iLogger.getHandlers();
        while (enumeration.hasMoreElements()) {
            this.returnObject((IManageable)enumeration.nextElement());
        }
    }

    public void restoreConfig() throws LogException {
        BaseGroup baseGroup = null;
        Object object = dsLock;
        synchronized (object) {
            if (this.dataStore != null) {
                baseGroup = this.dataStore.restoreConfig();
            }
        }
        object = getObjLock;
        synchronized (object) {
            if (baseGroup != null) {
                BaseGroup baseGroup2 = this.baseGroup;
                this.baseGroup = baseGroup;
                this.baseGroup.update(baseGroup2, this);
            }
        }
    }

    public void returnObject(IManageable iManageable) {
        String string = iManageable.getGroup();
        if (string.equals("")) {
            this.returnObject(iManageable, this.baseGroup);
        } else {
            this.returnObject(iManageable, string);
        }
    }

    public void returnObject(IManageable iManageable, Group group) {
        if (iManageable != null && group != null && iManageable.isManaged()) {
            Object object = getObjLock;
            synchronized (object) {
                Config config = group.getConfig(iManageable.getName());
                if (config != null && config.decrementInUseCount() == 0) {
                    if (iManageable instanceof ILogger) {
                        this.removeHandlers((ILogger)iManageable);
                        this.removeFilters((IGate)iManageable);
                    } else if (iManageable instanceof IHandler) {
                        ((IHandler)iManageable).stop();
                        this.removeFormatters((IHandler)iManageable);
                        this.removeFilters((IGate)iManageable);
                    }
                    config.setObject(null);
                    iManageable = null;
                }
            }
        }
    }

    public void returnObject(IManageable iManageable, String string) {
        if (string != null) {
            Object object = getObjLock;
            synchronized (object) {
                Group group = this.baseGroup.getGroup(string);
                if (group != null) {
                    this.returnObject(iManageable, group);
                }
            }
        }
    }

    public void saveConfig() throws LogException {
        Object object = dsLock;
        synchronized (object) {
            if (this.dataStore != null) {
                this.dataStore.saveConfig(this.baseGroup);
            }
        }
    }

    public void setBaseGroup(BaseGroup baseGroup) {
        Object object = dsLock;
        synchronized (object) {
            if (baseGroup != null) {
                BaseGroup baseGroup2 = this.baseGroup;
                this.baseGroup = baseGroup;
                this.baseGroup.update(baseGroup2, this);
            }
        }
    }

    private void stopObjects(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Config config = (Config)enumeration.nextElement();
            IManageable iManageable = config.getObject();
            if (iManageable == null) continue;
            this.returnObject(iManageable);
        }
    }

    public void updateConfig(Config config) {
        if (config != null) {
            String string = config.getProperty("name");
            Object object = dsLock;
            synchronized (object) {
                Group group;
                String string2 = config.getProperty("group");
                if (string2 == null || string2.equals("")) {
                    group = this.baseGroup;
                } else {
                    group = this.baseGroup.getGroup(string2);
                    if (group == null) {
                        group = new Group(string2);
                        this.baseGroup.addGroup(group);
                    }
                }
                Config config2 = group.getConfig(string);
                group.addConfig(config);
                if (config2 == null) {
                    config.update();
                } else {
                    config.update(config2);
                }
            }
        }
    }
}

