/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.mgr;

import com.ibm.logging.IConstants;
import com.ibm.logging.LogIOException;
import com.ibm.logging.LogUtil;
import com.ibm.logging.mgr.BaseGroup;
import com.ibm.logging.mgr.Config;
import com.ibm.logging.mgr.DataStore;
import com.ibm.logging.mgr.Group;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyDataStore
extends DataStore
implements IConstants {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private Properties props;

    public PropertyDataStore(String string) throws LogIOException {
        this(new Properties());
        try {
            this.setPropertyDataStore(this.loadProperties(string));
        }
        catch (Exception exception) {
            throw new LogIOException(LogUtil.msgs.getMessage("ERR_PROP_IO", string));
        }
    }

    public PropertyDataStore(Properties properties) {
        this.setPropertyDataStore(properties);
    }

    private void addObjects(String string, BaseGroup baseGroup) throws LogIOException {
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null) continue;
                string3 = "/" + string3.replace('.', '/') + ".properties";
                try {
                    Group group;
                    Config config = new Config(this.loadProperties(string3));
                    String string4 = config.getProperty("group");
                    if (string4 == null || string4.equals("")) {
                        group = baseGroup;
                    } else {
                        group = baseGroup.getGroup(string4);
                        if (group == null) {
                            group = new Group(string4);
                            baseGroup.addGroup(group);
                        }
                    }
                    group.addConfig(config);
                }
                catch (IOException iOException) {
                    throw new LogIOException(LogUtil.msgs.getMessage("ERR_PROP_IO", string3));
                }
                catch (NullPointerException nullPointerException) {
                    throw new LogIOException(LogUtil.msgs.getMessage("ERR_PROP_NOT_FOUND", string3));
                }
            }
        }
    }

    public Properties getPropertyDataStore() {
        return this.props;
    }

    public Properties loadProperties(String string) throws IOException {
        Properties properties = new Properties();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getClass().getResourceAsStream(string));
        properties.load(bufferedInputStream);
        bufferedInputStream.close();
        return properties;
    }

    public BaseGroup restoreConfig() throws LogIOException {
        BaseGroup baseGroup = new BaseGroup();
        this.addObjects("loggers", baseGroup);
        this.addObjects("handlers", baseGroup);
        this.addObjects("formatters", baseGroup);
        this.addObjects("filters", baseGroup);
        this.updateGroups(baseGroup);
        String string = this.props.getProperty("defaultMessageLogger");
        if (string != null) {
            baseGroup.setDefaultMessageLogger(string);
        }
        if ((string = this.props.getProperty("defaultTraceLogger")) != null) {
            baseGroup.setDefaultTraceLogger(string);
        }
        return baseGroup;
    }

    public void saveConfig(BaseGroup baseGroup) throws LogIOException {
    }

    public void setPropertyDataStore(Properties properties) {
        this.props = properties;
    }

    protected void updateGroups(BaseGroup baseGroup) {
        this.updateParents(baseGroup, baseGroup);
        Enumeration enumeration = baseGroup.getGroups();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            this.updateParents(group, baseGroup);
        }
    }

    private void updateParents(Group group, BaseGroup baseGroup) {
        Enumeration enumeration = group.getConfigs();
        while (enumeration.hasMoreElements()) {
            Config config = (Config)enumeration.nextElement();
            String string = (String)((Hashtable)config).get("parent");
            if (string == null) continue;
            Config config2 = group.getConfig(string);
            if (config2 == null) {
                config2 = baseGroup.getConfig(string);
            }
            if (config2 != null) {
                config.setParent(config2);
                continue;
            }
            LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_MISSING_PARENT", (String)((Hashtable)config).get("name"), string));
        }
    }
}

