/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.server;

import com.ibm.logging.LogUtil;
import com.ibm.logging.MessageCatalog;
import com.ibm.logging.server.ConnectionHandler;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;

public class LogServer
implements Runnable {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final int DEFAULT_PORT = 9991;
    private boolean toFile = false;
    private int port = 9991;
    private PrintWriter pWriter = null;
    private MessageCatalog cat = new MessageCatalog("com.ibm.logging.Msgs");
    private String filename = null;

    public LogServer(int n, String string) {
        this.port = n;
        this.filename = string;
        Thread thread = new Thread(this);
        thread.start();
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = 0;
        String string = null;
        switch (stringArray.length) {
            case 0: {
                n = 9991;
                break;
            }
            case 1: {
                n = Integer.valueOf(stringArray[0]);
                break;
            }
            case 2: {
                n = Integer.valueOf(stringArray[0]);
                string = stringArray[1];
                break;
            }
            default: {
                object = new MessageCatalog("com.ibm.logging.Msgs");
                LogUtil.errorMsg(((MessageCatalog)object).getMessage("LS_USAGE"));
                System.exit(1);
            }
        }
        object = new LogServer(n, string);
    }

    public void run() {
        Closeable closeable;
        Closeable closeable2;
        if (this.filename != null) {
            this.toFile = true;
            try {
                closeable2 = new FileOutputStream(this.filename, true);
                closeable = new OutputStreamWriter((OutputStream)closeable2);
                this.pWriter = new PrintWriter((Writer)new BufferedWriter((Writer)closeable), true);
            }
            catch (IOException iOException) {
                LogUtil.errorMsg(this.cat.getMessage("ERR_LS_OPEN_FILE", this.filename));
                iOException.printStackTrace();
            }
        } else {
            this.toFile = false;
        }
        try {
            this.write(this.cat.getMessage("START_SERVER"));
            this.write(this.cat.getMessage("CREATE_SOCKET", new Integer(this.port).toString()));
            if (this.toFile) {
                this.write(this.cat.getMessage("OUTPUT_TO_FILE", this.filename));
            } else {
                this.write(this.cat.getMessage("OUTPUT_TO_CONSOLE"));
            }
            closeable2 = new ServerSocket(this.port);
            while (true) {
                closeable = ((ServerSocket)closeable2).accept();
                ConnectionHandler connectionHandler = new ConnectionHandler((Socket)closeable, this.toFile, this.pWriter);
                Thread thread = new Thread(connectionHandler);
                thread.start();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void write(String string) {
        if (this.toFile) {
            this.pWriter.println(string);
        }
        System.out.println(string);
    }
}

