/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.utilities;

import com.ibm.logging.ConsoleHandler;
import com.ibm.logging.FileHandler;
import com.ibm.logging.Handler;
import com.ibm.logging.ILogRecord;
import com.ibm.logging.LogUtil;
import com.ibm.logging.SerialFileHandler;
import java.util.Vector;

public class SerialViewer {
    private static final String s = "(C) Copyright IBM Corp. 1998, 2000.";
    SerialFileHandler inHandler = new SerialFileHandler();
    Handler outHandler = null;

    public SerialViewer(String string) {
        this.inHandler.setFileName(string);
        this.outHandler = new ConsoleHandler();
    }

    public SerialViewer(String string, String string2) {
        this.inHandler.setName("SerialViewer");
        this.inHandler.setFileName(string);
        FileHandler fileHandler = new FileHandler();
        fileHandler.setFileName(string2);
        this.outHandler = fileHandler;
    }

    private void deserialize() {
        try {
            Vector vector = this.inHandler.readSerializedRecords();
            int n = 0;
            while (n < vector.size()) {
                ILogRecord iLogRecord = (ILogRecord)vector.elementAt(n);
                this.outHandler.logRecord(iLogRecord, true);
                ++n;
            }
        }
        catch (Exception exception) {
            LogUtil.errorMsg(LogUtil.msgs.getMessage("ERR_READ_RECORDS", this.inHandler.getName(), this.inHandler.getFileName()));
            exception.printStackTrace();
        }
        this.inHandler.stop();
        this.outHandler.stop();
    }

    public static void main(String[] stringArray) {
        int n = 0;
        SerialViewer serialViewer = null;
        int n2 = stringArray.length;
        if (n2 == 1) {
            serialViewer = new SerialViewer(stringArray[0]);
        } else if (n2 == 2) {
            serialViewer = new SerialViewer(stringArray[0], stringArray[1]);
        } else {
            LogUtil.errorMsg(LogUtil.msgs.getMessage("SV_USAGE"));
            n = 1;
        }
        if (serialViewer != null) {
            serialViewer.deserialize();
        }
        System.exit(n);
    }
}

