/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;

public class DvClassObjects
implements ActionListener,
MouseListener,
MouseMotionListener {
    String classname;
    int totalObjects;
    int currentObjectStart = 0;
    static final int number_of_columns = 4;
    static final int number_of_rows = 10;
    static final int batch_size = 40;
    static final String sixteenZeros = "0000000000000000";
    JTextArea jText;
    JLabel label1;
    JLabel label2;
    long[] objectList;
    long ongoing_memory = 0L;
    JTable table = null;
    JButton backButton;
    JButton forwardButton;
    long[] theObjectAddresses;
    ClassObjectsTableModel dataModel;
    Vector vPrev = new Vector();

    public DvClassObjects(String string) {
        this.classname = string;
        this.constructWindow();
    }

    private void constructWindow() {
        DvUtils.writetoTrace(" DvClassObjects: constructWindow() entry");
        this.totalObjects = DvObjectsCommands.namesIndexFile.getInstanceCountForClass(this.classname);
        this.vPrev.add(new Long(0L));
        this.theObjectAddresses = new long[40];
        this.ongoing_memory = DvObjectsCommands.namesIndexFile.getInstancesForClass(this.classname, this.currentObjectStart, this.ongoing_memory, this.theObjectAddresses);
        this.vPrev.add(new Long(this.ongoing_memory));
        String[] stringArray = new String[]{"Objects", "Objects", "Objects", "Objects"};
        this.dataModel = new ClassObjectsTableModel(stringArray, this.theObjectAddresses);
        this.table = new JTable(this.dataModel);
        this.table.setAutoResizeMode(0);
        this.table.setSelectionMode(0);
        this.table.setCellSelectionEnabled(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JInternalFrame jInternalFrame = Dumpviewer.theIFM.createNewFrame(this.classname, Dumpviewer.theIFM.getDefaultProperties(), 0);
        Dumpviewer.addIFrameToDesktop(jInternalFrame, 270, 320, 350, 200);
        Dumpviewer.theIFM.addContentToFrame(jInternalFrame, this.table, jPanel);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        this.backButton = new JButton("Prev40");
        this.backButton.setToolTipText("Press this to see previous 40 objects.");
        this.forwardButton = new JButton("Next40");
        this.forwardButton.setToolTipText("Press this to see next 40 objects.");
        this.label2 = new JLabel(this.currentObjectStart + 1 + " thru " + (this.currentObjectStart + 40) + " of " + this.totalObjects);
        jPanel4.add(this.backButton);
        jPanel4.add(this.forwardButton);
        jPanel3.add(this.label2);
        jPanel.add((Component)jPanel5, "Center");
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        jPanel.add((Component)jPanel4, "South");
        this.table.addMouseListener(this);
        this.backButton.addActionListener(this);
        this.forwardButton.addActionListener(this);
        DvUtils.writetoTrace(" DvClassObjects: constructWindow() exit");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.forwardButton) {
            DvUtils.writetoTrace("Next40 pressed in DvClassObjects");
            if (this.currentObjectStart + 40 <= this.totalObjects) {
                this.currentObjectStart += 40;
                if (this.vPrev.size() == this.currentObjectStart / 40 + 1) {
                    this.ongoing_memory = DvObjectsCommands.namesIndexFile.getInstancesForClass(this.classname, this.currentObjectStart, this.ongoing_memory, this.dataModel.tabledAddresses);
                    this.vPrev.add(new Long(this.ongoing_memory));
                } else {
                    Long l = (Long)this.vPrev.get(this.currentObjectStart / 40);
                    DvObjectsCommands.namesIndexFile.getInstancesForClass(this.classname, this.currentObjectStart, l, this.dataModel.tabledAddresses);
                }
                this.label2.setText(this.currentObjectStart + 1 + " thru " + (this.currentObjectStart + 40) + " of " + this.totalObjects);
                this.table.revalidate();
                this.table.repaint();
            }
        } else if (actionEvent.getSource() == this.backButton) {
            DvUtils.writetoTrace("Prev40 pressed in DvClassObjects");
            if (0 < this.currentObjectStart) {
                int n = this.currentObjectStart / 40 - 1;
                Long l = (Long)this.vPrev.get(this.currentObjectStart / 40 - 1);
                DvObjectsCommands.namesIndexFile.getInstancesForClass(this.classname, this.currentObjectStart, l, this.dataModel.tabledAddresses);
                this.currentObjectStart -= 40;
                this.label2.setText(this.currentObjectStart + 1 + " thru " + (this.currentObjectStart + 40) + " of " + this.totalObjects);
                this.table.revalidate();
                this.table.repaint();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        int n = mouseEvent.getClickCount();
        if (n > 2) {
            n = 2;
        }
        if (2 == n && !((mouseEvent.getModifiers() & 4) == 4) && (object = mouseEvent.getSource()) instanceof JTable) {
            DvUtils.writetoTrace("Double click detected in object table ...");
            int n2 = this.table.getSelectedRow();
            int n3 = this.table.getSelectedColumn();
            long l = this.dataModel.getArrayValue(n2, n3);
            if (0L != l) {
                String string = DvObjectsCommands.getObjectDetailsAsString(l);
                JInternalFrame jInternalFrame = Dumpviewer.theIFM.createNewFrame(this.classname + "@ 0x" + Long.toHexString(l), Dumpviewer.theIFM.getDefaultProperties(), 0);
                Dumpviewer.addIFrameToDesktop(jInternalFrame, 230, 350, 5, Dumpviewer.selfRef.getHeight() - 330);
                JTextArea jTextArea = new JTextArea(string, 8, 25);
                jTextArea.setEditable(false);
                Dumpviewer.theIFM.addContentToFrame(jInternalFrame, jTextArea);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    static class ClassObjectsTableModel
    extends AbstractTableModel {
        boolean valsgiven = false;
        String[] columnNames = new String[]{"C1", "C2", "C3", "C4", "C5", "C6"};
        int nRows;
        int nColumns;
        int addressSize = 8;
        public long[] tabledAddresses;

        public int getColumnCount() {
            return this.nColumns;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this.nRows;
        }

        public long getArrayValue(int n, int n2) {
            return this.tabledAddresses[n * this.nColumns + n2];
        }

        public Object getValueAt(int n, int n2) {
            if (0L == this.tabledAddresses[n * this.nColumns + n2]) {
                return " ";
            }
            String string = Long.toHexString(this.tabledAddresses[n * this.nColumns + n2]);
            if (string.length() < this.addressSize) {
                string = DvClassObjects.sixteenZeros.substring(0, this.addressSize - string.length()) + string;
            }
            return new String("0x" + string);
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public ClassObjectsTableModel(String[] stringArray, long[] lArray) {
            if (DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture())) {
                this.addressSize = 16;
            }
            this.nRows = 10;
            this.nColumns = 4;
            this.tabledAddresses = new long[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                this.tabledAddresses[i] = lArray[i];
            }
            try {
                this.columnNames[0] = stringArray[0];
                this.columnNames[1] = stringArray[1];
                this.columnNames[2] = stringArray[2];
                this.columnNames[3] = stringArray[3];
                this.columnNames[4] = stringArray[4];
                this.columnNames[5] = stringArray[5];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

