/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.DvObject;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.CommandPluginResponse;
import java.lang.reflect.Method;
import java.util.Vector;

public class DvHeap {
    Vector subHeaps = new Vector();
    CommandPluginResponse cpr;
    public Vector theOutput = new Vector();
    public Object gui;
    Vector godV = null;
    Vector heapScanV = null;
    long totalObjectCount = 0L;
    static DvHeap selfref;

    public DvHeap() {
        selfref = this;
        DvHeap.reset();
    }

    public static void reset() {
        DvHeap.selfref.subHeaps.clear();
        DvHeap.selfref.totalObjectCount = 0L;
    }

    public boolean doScan(CommandPluginResponse commandPluginResponse) {
        boolean bl = true;
        this.cpr = commandPluginResponse;
        if (null == this.heapScanV) {
            this.heapScanV = DvUtils.findMethodForCurrentSuffix("heapScan", new Class[]{DvHeap.class});
        }
        if (null != this.heapScanV) {
            try {
                Method method = (Method)this.heapScanV.get(1);
                CommandPlugin commandPlugin = (CommandPlugin)this.heapScanV.get(0);
                Boolean bl2 = (Boolean)method.invoke((Object)commandPlugin, this);
                bl = bl2;
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to find heapScan method supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
                bl = false;
            }
        } else {
            DvUtils.trace("*** Unable to find a heapScan method supporting " + DvUtils.getSuffix(), 0, true);
            bl = false;
        }
        return bl;
    }

    public void createSubHeap(long l, long l2, String string, DvThread dvThread, long l3, boolean bl) {
        DvSubHeap dvSubHeap = new DvSubHeap(l, l2, string, dvThread, l3, bl);
        this.subHeaps.add(dvSubHeap);
        this.totalObjectCount += l3;
    }

    public Vector getSubHeapsIndexesForJvm(long l) {
        Vector vector;
        if (-1L == l) {
            vector = this.subHeaps;
        } else {
            int n = this.subHeaps.size();
            vector = new Vector();
            for (int i = 0; i < n; ++i) {
                DvSubHeap dvSubHeap = (DvSubHeap)this.subHeaps.get(i);
            }
        }
        return vector;
    }

    public String toString() {
        return this.toString(this.subHeaps);
    }

    public String toString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n=================================");
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append("\n======= heap component: " + i + "=======");
            stringBuffer.append(((DvSubHeap)vector.get(i)).toString());
        }
        stringBuffer.append("\n=================================");
        return stringBuffer.toString();
    }

    public void doOutput(String string, boolean bl) {
        this.theOutput.add(string);
        if (bl && null == this.gui) {
            this.cpr.output(this.theOutput);
            this.theOutput.clear();
        }
    }

    public String establishHeapName(long l) {
        for (int i = 0; i < this.subHeaps.size(); ++i) {
            DvSubHeap dvSubHeap = (DvSubHeap)this.subHeaps.get(i);
            if (l < dvSubHeap.subHeapStart || l > dvSubHeap.subHeapEnd) continue;
            String string = dvSubHeap.subHeapName;
            if (null != dvSubHeap.thread) {
                string = string + " (thread= " + dvSubHeap.thread.id();
            }
            return string;
        }
        return null;
    }

    public DvObject getObjectDetails(long l) {
        DvObject dvObject = new DvObject();
        dvObject.address = l;
        if (null == this.godV) {
            this.godV = DvUtils.findMethodForCurrentSuffix("getObjectDetails", new Class[]{DvObject.class, DvHeap.class});
        }
        if (null != this.godV) {
            try {
                Method method = (Method)this.godV.get(1);
                CommandPlugin commandPlugin = (CommandPlugin)this.godV.get(0);
                method.invoke((Object)commandPlugin, dvObject, this);
                dvObject.heapName = this.establishHeapName(l);
                if (null == dvObject.heapName) {
                    dvObject.heapName = "??????";
                }
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to find getObjectDetails supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Unable to find a getObjectDetails method supporting " + DvUtils.getSuffix(), 0, true);
        }
        return dvObject;
    }

    public String getObjectSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append("\n\n Objects Summary\n ===============\n");
        for (int i = 0; i < this.subHeaps.size(); ++i) {
            stringBuffer.append(this.subHeaps.get(i).toString());
        }
        stringBuffer.append("\n Total number of objects found via all Heaps     = " + this.totalObjectCount);
        return stringBuffer.toString();
    }

    private class DvSubHeap {
        private String subHeapName;
        private long subHeapStart;
        private long subHeapEnd;
        private DvThread thread;
        private long objCount;
        private boolean subHeapNormalTraversal;

        public DvSubHeap(long l, long l2, String string, DvThread dvThread, long l3, boolean bl) {
            this.subHeapName = string;
            this.subHeapStart = l;
            this.subHeapEnd = l2;
            this.thread = dvThread;
            this.objCount = l3;
            bl = this.subHeapNormalTraversal;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n" + this.subHeapName);
            if (null != this.thread) {
                stringBuffer.append(this.thread.getThreadName(null));
            }
            stringBuffer.append("\n\tstart address: 0x" + Long.toHexString(this.subHeapStart));
            if (this.subHeapEnd != -1L) {
                stringBuffer.append("\n\tend   address: 0x" + Long.toHexString(this.subHeapEnd));
                stringBuffer.append("\n\theap  size   : 0x" + Long.toHexString(this.subHeapEnd - this.subHeapStart) + "  " + (this.subHeapEnd - this.subHeapStart));
            } else {
                stringBuffer.append("\n\tend   address: un-measured (non meaningful)");
            }
            stringBuffer.append("\n\tObjects found : " + this.objCount);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

