/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.DvTraceFmtPlugin;
import com.ibm.jvm.dump.plugins.SovTraceObject;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DvTraceFmtSov
extends DvTraceFmtPlugin {
    private static DvTraceFmtSov selfRef;
    private static int ptrLength;
    private static String[] commandsSupported;
    private static String[] mySuffixes;

    public DvTraceFmtSov() {
        selfRef = this;
        ptrLength = DvUtils.pointerLength();
    }

    public String[] getSuffixes() {
        return mySuffixes;
    }

    public String pluginName() {
        return "General plugin supporting trace format commands (for sov)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public static StringTokenizer getValidTraceEntries() {
        return new StringTokenizer("dg,st,lk,xe,xm,ci,cl,dc,hpi,xhpi,java,awt,awt_dnd_datatransfer,Audio,jit,jdwp,mt,fontmanager,net,awt_java2d,awt_print,dbgmalloc", ",");
    }

    public static Boolean isTraceEnabled() {
        DvDump dvDump = DvConsole.getCurrentDump();
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        return new Boolean(new SovTraceObject(as).isEnabled());
    }

    public static void doCreateTraceFile() {
        Object object;
        traceRecords = new Hashtable();
        DvTraceFmtSov.outputAndFlush("Processing Trace File Header\n----------------------------");
        try {
            String string = DvUtils.getValue("TRACE_VERBOSE");
            verbose = string.toUpperCase().equals("TRUE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DvDump dvDump = DvConsole.getCurrentDump();
        DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
        int n = 0;
        String string = DvUtils.getValue("WorkDir");
        snapTraceFileName = null == string ? "extracted.trc" : string + "extracted.trc";
        try {
            object = new File(snapTraceFileName);
            ((File)object).createNewFile();
        }
        catch (Exception exception) {
            DvTraceFmtSov.outputAndFlush(" Unable to create \"" + snapTraceFileName + "\"");
            return;
        }
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        object = new CTypeObject("execenv", dvThread.eeAddress(), as);
        CTypeObject cTypeObject = ((CTypeObject)object).getField("jvmP").deReference();
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        SovTraceObject sovTraceObject = new SovTraceObject(as);
        CTypeObject cTypeObject2 = sovTraceObject.traceFileHeader;
        CTypeObject cTypeObject3 = cTypeObject2.getField("bufferSize");
        CTypeObject cTypeObject4 = cTypeObject2.getField("header");
        CTypeObject cTypeObject5 = cTypeObject4.getField("length");
        long l = cTypeObject2.getAddr();
        DvTraceFmtSov.outputAndFlush("address of TraceFileHeader = 0x" + Long.toHexString(l));
        int n2 = DvTraceFmtSov.readAnInt(cTypeObject3);
        DvTraceFmtSov.outputAndFlush("TraceBuffer Size           = " + n2 + " (hex 0x" + Long.toHexString(n2) + ")");
        int n3 = DvTraceFmtSov.readAnInt(cTypeObject5);
        DvTraceFmtSov.outputAndFlush("TraceFileHeader length     = " + n3 + " (hex 0x" + Long.toHexString(n3) + ")");
        DvTraceFmtSov.outputAndFlush("\nwriting TraceFileHeader");
        DvTraceFmtSov.writeDataToFile(l, n3, "NEW");
        DvTraceFmtSov.outputAndFlush("\nProcessing Trace Buffers\n------------------------");
        CTypeObject cTypeObject6 = sovTraceObject.traceData.getField("traceGlobal");
        long l2 = DvTraceFmtSov.readPtrAsLong(cTypeObject6);
        if (l2 != 0L) {
            Object[] objectArray;
            DvTraceFmtSov.outputAndFlush("traceGlobal ptr = 0x" + Long.toHexString(l2));
            while (l2 != 0L) {
                ++n;
                cTypeObject6 = cTypeObject6.deReference(sovTraceObject.traceBufferName);
                if (verbose) {
                    DvTraceFmtSov.outputAndFlush("************ Buffer (" + n + ") ************");
                    DvTraceFmtSov.outputAndFlush(cTypeObject6.toString());
                }
                CTypeObject cTypeObject7 = cTypeObject6.getField("record");
                objectArray = cTypeObject7.getField("sequence");
                long l3 = DvTraceFmtSov.readLongAsLong((CTypeObject)objectArray);
                traceRecords.put(new Long(l3), new Long(cTypeObject7.getAddr()));
                cTypeObject6 = cTypeObject6.getField("globalNext");
                l2 = DvTraceFmtSov.readPtrAsLong(cTypeObject6);
            }
            int n4 = 0;
            objectArray = traceRecords.keys();
            while (objectArray.hasMoreElements()) {
                ++n4;
                objectArray.nextElement();
            }
            DvTraceFmtSov.outputAndFlush("There are " + n4 + " buffers");
            objectArray = new Long[n4];
            n4 = 0;
            Enumeration enumeration = traceRecords.keys();
            while (enumeration.hasMoreElements()) {
                objectArray[n4] = (Long)enumeration.nextElement();
                ++n4;
            }
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                DvTraceFmtSov.outputAndFlush(" ");
                DvTraceFmtSov.outputAndFlush("sequence: 0x" + Long.toHexString((Long)objectArray[i]));
                long l4 = (Long)traceRecords.get(objectArray[i]);
                DvTraceFmtSov.writeDataToFile(l4, n2, "APPEND");
            }
        } else {
            DvTraceFmtSov.outputAndFlush("There are no trace buffers on the global chain (traceGlobal==NULL).");
        }
    }

    static {
        ptrLength = 4;
        commandsSupported = new String[0];
        mySuffixes = new String[]{"sov"};
    }
}

