/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j;

import java.util.StringTokenizer;
import org.uddi4j.UDDIElement;
import org.uddi4j.response.DispositionReport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UDDIException
extends Exception {
    static final String UDDI_TAG = "Fault";
    String faultCode = null;
    String faultString = null;
    String faultActor = null;
    String detail = null;
    Element detailElement = null;
    DispositionReport dispositionReport = null;

    public UDDIException() {
    }

    public UDDIException(Element element, boolean bl) {
        if (UDDIException.isValidElement(element)) {
            Element element2;
            NodeList nodeList = element.getElementsByTagName("faultcode");
            if (nodeList.getLength() == 0) {
                nodeList = element.getElementsByTagNameNS(UDDIElement.SOAPNS, "faultcode");
            }
            if (nodeList != null && nodeList.getLength() > 0) {
                element2 = (Element)nodeList.item(0);
                this.faultCode = this.getText(element2);
            }
            if ((nodeList = element.getElementsByTagName("faultstring")).getLength() == 0) {
                nodeList = element.getElementsByTagNameNS(UDDIElement.SOAPNS, "faultstring");
            }
            if (nodeList != null && nodeList.getLength() > 0) {
                element2 = (Element)nodeList.item(0);
                this.faultString = this.getText(element2);
            }
            if ((nodeList = element.getElementsByTagName("faultactor")).getLength() == 0) {
                nodeList = element.getElementsByTagNameNS(UDDIElement.SOAPNS, "faultactor");
            }
            if (nodeList != null && nodeList.getLength() > 0) {
                element2 = (Element)nodeList.item(0);
                this.faultActor = this.getText(element2);
            }
            if ((nodeList = element.getElementsByTagName("detail")).getLength() == 0) {
                nodeList = element.getElementsByTagNameNS(UDDIElement.SOAPNS, "detail");
            }
            if (nodeList != null && nodeList.getLength() > 0) {
                this.detailElement = element2 = (Element)nodeList.item(0);
                if (bl) {
                    try {
                        nodeList = element.getElementsByTagName(DispositionReport.UDDI_TAG);
                        if (nodeList != null && nodeList.getLength() > 0) {
                            element2 = (Element)nodeList.item(0);
                            this.dispositionReport = new DispositionReport(element2);
                        }
                    }
                    catch (UDDIException uDDIException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static boolean isValidElement(Element element) {
        String string = element.getNodeName();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return UDDI_TAG.equals(string2);
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public String getDetail() {
        return this.detail;
    }

    public Element getDetailElement() {
        return this.detailElement;
    }

    public DispositionReport getDispositionReport() {
        return this.dispositionReport;
    }

    protected String getText(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = "";
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 3) {
                string = string + nodeList.item(n).getNodeValue();
            }
            ++n;
        }
        return string.trim();
    }

    public String toString() {
        if (this.dispositionReport != null) {
            return this.dispositionReport.getErrInfoText();
        }
        return this.getFaultString();
    }
}

