/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.datatype.business;

import java.util.Vector;
import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.business.Address;
import org.uddi4j.datatype.business.Email;
import org.uddi4j.datatype.business.PersonName;
import org.uddi4j.datatype.business.Phone;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Contact
extends UDDIElement {
    public static final String UDDI_TAG = "contact";
    protected Element base = null;
    String useType = null;
    PersonName personName = null;
    Vector description = new Vector();
    Vector phone = new Vector();
    Vector email = new Vector();
    Vector address = new Vector();

    public Contact() {
    }

    public Contact(String string) {
        this.personName = new PersonName(string);
    }

    public Contact(Element element) throws UDDIException {
        super(element);
        this.useType = this.getAttr(element, "useType");
        NodeList nodeList = null;
        nodeList = this.getChildElementsByTagName(element, "personName");
        if (nodeList.getLength() > 0) {
            this.personName = new PersonName((Element)nodeList.item(0));
        }
        nodeList = this.getChildElementsByTagName(element, "description");
        int n = 0;
        while (n < nodeList.getLength()) {
            this.description.addElement(new Description((Element)nodeList.item(n)));
            ++n;
        }
        nodeList = this.getChildElementsByTagName(element, "phone");
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            this.phone.addElement(new Phone((Element)nodeList.item(n2)));
            ++n2;
        }
        nodeList = this.getChildElementsByTagName(element, "email");
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            this.email.addElement(new Email((Element)nodeList.item(n3)));
            ++n3;
        }
        nodeList = this.getChildElementsByTagName(element, "address");
        int n4 = 0;
        while (n4 < nodeList.getLength()) {
            this.address.addElement(new Address((Element)nodeList.item(n4)));
            ++n4;
        }
    }

    private String getAttr(Element element, String string) {
        if (element.getAttributeNode(string) != null && element.getAttributeNode(string).getSpecified()) {
            return element.getAttribute(string);
        }
        return null;
    }

    public void setUseType(String string) {
        this.useType = string;
    }

    public void setPersonName(PersonName personName) {
        this.personName = personName;
    }

    public void setPersonName(String string) {
        this.personName = new PersonName();
        this.personName.setText(string);
    }

    public void setDescriptionVector(Vector vector) {
        this.description = vector;
    }

    public void setDefaultDescriptionString(String string) {
        if (this.description.size() > 0) {
            this.description.setElementAt(new Description(string), 0);
        } else {
            this.description.addElement(new Description(string));
        }
    }

    public void setPhoneVector(Vector vector) {
        this.phone = vector;
    }

    public void setEmailVector(Vector vector) {
        this.email = vector;
    }

    public void setAddressVector(Vector vector) {
        this.address = vector;
    }

    public String getUseType() {
        return this.useType;
    }

    public PersonName getPersonName() {
        return this.personName;
    }

    public String getPersonNameString() {
        return this.personName.getText();
    }

    public Vector getDescriptionVector() {
        return this.description;
    }

    public String getDefaultDescriptionString() {
        if (this.description.size() > 0) {
            Description description = (Description)this.description.elementAt(0);
            return description.getText();
        }
        return null;
    }

    public Vector getPhoneVector() {
        return this.phone;
    }

    public Vector getEmailVector() {
        return this.email;
    }

    public Vector getAddressVector() {
        return this.address;
    }

    public void saveToXML(Element element) {
        int n;
        this.base = element.getOwnerDocument().createElement(UDDI_TAG);
        if (this.useType != null) {
            this.base.setAttribute("useType", this.useType);
        }
        if (this.description != null) {
            n = 0;
            while (n < this.description.size()) {
                ((Description)this.description.elementAt(n)).saveToXML(this.base);
                ++n;
            }
        }
        if (this.personName != null) {
            this.personName.saveToXML(this.base);
        }
        if (this.phone != null) {
            n = 0;
            while (n < this.phone.size()) {
                ((Phone)this.phone.elementAt(n)).saveToXML(this.base);
                ++n;
            }
        }
        if (this.email != null) {
            n = 0;
            while (n < this.email.size()) {
                ((Email)this.email.elementAt(n)).saveToXML(this.base);
                ++n;
            }
        }
        if (this.address != null) {
            n = 0;
            while (n < this.address.size()) {
                ((Address)this.address.elementAt(n)).saveToXML(this.base);
                ++n;
            }
        }
        element.appendChild(this.base);
    }
}

