/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.response;

import java.util.Vector;
import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.Name;
import org.uddi4j.response.ServiceInfos;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BusinessInfo
extends UDDIElement {
    public static final String UDDI_TAG = "businessInfo";
    protected Element base = null;
    String businessKey = null;
    Name name = null;
    ServiceInfos serviceInfos = null;
    Vector description = new Vector();

    public BusinessInfo() {
    }

    public BusinessInfo(String string, String string2, ServiceInfos serviceInfos) {
        this.businessKey = string;
        this.name = new Name(string2);
        this.serviceInfos = serviceInfos;
    }

    public BusinessInfo(Element element) throws UDDIException {
        super(element);
        this.businessKey = element.getAttribute("businessKey");
        NodeList nodeList = null;
        nodeList = this.getChildElementsByTagName(element, "name");
        if (nodeList.getLength() > 0) {
            this.name = new Name((Element)nodeList.item(0));
        }
        if ((nodeList = this.getChildElementsByTagName(element, "serviceInfos")).getLength() > 0) {
            this.serviceInfos = new ServiceInfos((Element)nodeList.item(0));
        }
        nodeList = this.getChildElementsByTagName(element, "description");
        int n = 0;
        while (n < nodeList.getLength()) {
            this.description.addElement(new Description((Element)nodeList.item(n)));
            ++n;
        }
    }

    public void setBusinessKey(String string) {
        this.businessKey = string;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public void setName(String string) {
        this.name = new Name();
        this.name.setText(string);
    }

    public void setServiceInfos(ServiceInfos serviceInfos) {
        this.serviceInfos = serviceInfos;
    }

    public void setDescriptionVector(Vector vector) {
        this.description = vector;
    }

    public void setDefaultDescriptionString(String string) {
        if (this.description.size() > 0) {
            this.description.setElementAt(new Description(string), 0);
        } else {
            this.description.addElement(new Description(string));
        }
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public Name getName() {
        return this.name;
    }

    public String getNameString() {
        return this.name.getText();
    }

    public ServiceInfos getServiceInfos() {
        return this.serviceInfos;
    }

    public Vector getDescriptionVector() {
        return this.description;
    }

    public String getDefaultDescriptionString() {
        if (this.description.size() > 0) {
            Description description = (Description)this.description.elementAt(0);
            return description.getText();
        }
        return null;
    }

    public void saveToXML(Element element) {
        this.base = element.getOwnerDocument().createElement(UDDI_TAG);
        if (this.businessKey != null) {
            this.base.setAttribute("businessKey", this.businessKey);
        }
        if (this.name != null) {
            this.name.saveToXML(this.base);
        }
        if (this.description != null) {
            int n = 0;
            while (n < this.description.size()) {
                ((Description)this.description.elementAt(n)).saveToXML(this.base);
                ++n;
            }
        }
        if (this.serviceInfos != null) {
            this.serviceInfos.saveToXML(this.base);
        }
        element.appendChild(this.base);
    }
}

