/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogRecord;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.nio.BufferUnderflowException;

public class DataItem {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$recoverylog$spi$DataItem == null ? (class$com$ibm$ws$recoverylog$spi$DataItem = DataItem.class$("com.ibm.ws.recoverylog.spi.DataItem")) : class$com$ibm$ws$recoverylog$spi$DataItem), (String)"Transaction", null);
    protected static final int HEADER_SIZE = 4;
    protected static final int UNWRITTEN = -1;
    protected int _storageMode = 1;
    protected byte[] _data = null;
    protected int _filePosition = -1;
    protected LogRecord _logRecord = null;
    protected int _dataSize = 0;
    protected RecoverableUnitSectionImpl _rus = null;
    protected boolean _written = false;
    static /* synthetic */ Class class$com$ibm$ws$recoverylog$spi$DataItem;

    public DataItem(int n, byte[] byArray, RecoverableUnitSectionImpl recoverableUnitSectionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DataItem", (Object)new Object[]{new Integer(n), new Integer(byArray.length), RLSUtils.toHexString(byArray, 32), recoverableUnitSectionImpl});
        }
        this._rus = recoverableUnitSectionImpl;
        this._data = byArray;
        this._storageMode = n;
        this._dataSize = byArray.length;
        this._rus.payloadAdded(this._dataSize + 4);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DataItem", (Object)this);
        }
    }

    public DataItem(int n, ReadableLogRecord readableLogRecord, RecoverableUnitSectionImpl recoverableUnitSectionImpl) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DataItem", (Object)new Object[]{new Integer(n), readableLogRecord, recoverableUnitSectionImpl});
        }
        this._rus = recoverableUnitSectionImpl;
        this._storageMode = n;
        this._logRecord = readableLogRecord;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Reading data size field @ position " + readableLogRecord.position()));
            }
            this._dataSize = readableLogRecord.getInt();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("This data item contains " + this._dataSize + " bytes of data"));
            }
            this._rus.payloadAdded(this._dataSize + 4);
            this._rus.payloadWritten(this._dataSize + 4);
            if (n == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Reading " + this._dataSize + "bytes of data @ position " + readableLogRecord.position()));
                }
                this._data = new byte[this._dataSize];
                this._logRecord.get(this._data);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Tracking " + this._dataSize + "bytes of data @ position " + readableLogRecord.position()));
                }
                this._filePosition = readableLogRecord.position();
                this._data = null;
                this._logRecord.advancePosition(this._dataSize);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            FFDCFilter.processException((Throwable)bufferUnderflowException, (String)"com.ibm.ws.recoverylog.spi.DataItem.DataItem", (String)"174", (Object)this);
            throw new InternalLogException();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.DataItem.DataItem", (String)"179", (Object)this);
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DataItem", (Object)this);
        }
    }

    protected void write(WriteableLogRecord writeableLogRecord) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object)new Object[]{this, writeableLogRecord});
        }
        byte[] byArray = this.getData();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Writing '" + byArray.length + "' bytes " + RLSUtils.toHexString(byArray, 32)));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Writing length field");
        }
        writeableLogRecord.putInt(byArray.length);
        if (this._storageMode == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Updaing data location references");
            }
            this._filePosition = writeableLogRecord.position();
            this._logRecord = writeableLogRecord;
            this._data = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Writing data field");
        }
        writeableLogRecord.put(byArray);
        if (!this._written) {
            this._rus.payloadWritten(this._dataSize + 4);
        }
        this._written = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    protected byte[] getData() {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getData", (Object)this);
        }
        if ((byArray = this._data) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cached data located");
            }
        } else if (this._storageMode == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No cached data located. Attempting data retreival");
            }
            if (this._filePosition != -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Retrieving " + this._dataSize + " bytes of data @ position " + this._filePosition));
                }
                this._logRecord.position(this._filePosition);
                byArray = new byte[this._dataSize];
                this._logRecord.get(byArray);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to retrieve data as file position is not set");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No cached data located");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getData", (Object)new Object[]{new Integer(byArray.length), RLSUtils.toHexString(byArray, 32)});
        }
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

