/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.EndOfLogException;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogFileHeader;
import com.ibm.ws.recoverylog.spi.LogHeaderInvalidException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.WriteOperationFailedException;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class LogFileHandle {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$recoverylog$spi$LogFileHandle == null ? (class$com$ibm$ws$recoverylog$spi$LogFileHandle = LogFileHandle.class$("com.ibm.ws.recoverylog.spi.LogFileHandle")) : class$com$ibm$ws$recoverylog$spi$LogFileHandle), (String)"Transaction", null);
    static final int STATUS_FIELD_FILE_OFFSET = 4 + LogFileHeader.MAGIC_NUMBER.length + 4;
    private MappedByteBuffer _fileBuffer = null;
    private RandomAccessFile _file = null;
    private FileChannel _fileChannel = null;
    private LogFileHeader _logFileHeader = null;
    private String _logDirectory = null;
    private String _fileName = null;
    private String _serverName = null;
    private String _serviceName = null;
    private String _logName = null;
    private int _fileSize = 0;
    static /* synthetic */ Class class$com$ibm$ws$recoverylog$spi$LogFileHandle;

    protected LogFileHandle(String string, String string2, String string3, String string4, String string5, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LogFileHandle", (Object)new Object[]{this, string, string2, string3, string4, string5, new Integer(n)});
        }
        this._logDirectory = string;
        this._fileName = string2;
        this._serverName = string3;
        this._serviceName = string4;
        this._logName = string5;
        this._fileSize = n;
        this._logFileHeader = new LogFileHeader(this._serverName, this._serviceName, this._logName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LogFileHandle");
        }
    }

    protected ReadableLogRecord getReadableLogRecord(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getReadableLogRecord", (Object)new Object[]{this, new Long(l)});
        }
        ReadableLogRecord readableLogRecord = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating readable log record to read from file " + this._fileName));
            }
            readableLogRecord = new ReadableLogRecord(this._fileBuffer, l);
        }
        catch (EndOfLogException endOfLogException) {
            readableLogRecord = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getReadableLogRecord", (Object)readableLogRecord);
        }
        return readableLogRecord;
    }

    protected void fileOpen() throws LogHeaderInvalidException, InternalLogException, LogAllocationException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fileOpen", (Object)new Object[]{this, this._serviceName, this._logName});
        }
        boolean bl = false;
        try {
            try {
                final File file = new File(this._logDirectory, this._fileName);
                bl = !file.exists();
                this._fileBuffer = (MappedByteBuffer)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        LogFileHandle.this._file = new RandomAccessFile(file, "rw");
                        LogFileHandle.this._fileChannel = LogFileHandle.this._file.getChannel();
                        int n = (int)LogFileHandle.this._file.length();
                        int n2 = LogFileHandle.this._fileSize * 1024;
                        int n3 = n > n2 ? n : n2;
                        return LogFileHandle.this._fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n3);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"338", (Object)this);
                throw new LogAllocationException();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"343", (Object)this);
                throw new InternalLogException();
            }
        }
        catch (LogAllocationException logAllocationException) {
            FFDCFilter.processException((Throwable)logAllocationException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"351", (Object)this);
            this._fileBuffer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fileOpen");
            }
            throw logAllocationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"359", (Object)this);
            this._fileBuffer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fileOpen");
            }
            throw new InternalLogException();
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Log File " + this._fileName + " is cold starting"));
            }
            try {
                this.writeFileHeader(false);
            }
            catch (LogHeaderInvalidException logHeaderInvalidException) {
                FFDCFilter.processException((Throwable)logHeaderInvalidException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"380", (Object)this);
                this._file = null;
                this._fileChannel = null;
                this._fileBuffer = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"fileOpen");
                }
                throw new InternalLogException();
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"388", (Object)this);
                this._file = null;
                this._fileChannel = null;
                this._fileBuffer = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"fileOpen");
                }
                throw internalLogException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"396", (Object)this);
                this._file = null;
                this._fileChannel = null;
                this._fileBuffer = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"fileOpen");
                }
                throw new InternalLogException();
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Log File " + this._fileName + " is warm starting"));
            }
            this.readFileHeader();
        }
        if (!this._logFileHeader.valid()) {
            try {
                this._fileChannel.close();
                this._file.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"423", (Object)this);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", (String)"429", (Object)this);
            }
            this._fileBuffer = null;
            this._file = null;
            this._fileChannel = null;
            this._logFileHeader = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fileOpen");
            }
            throw new LogHeaderInvalidException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fileOpen");
        }
    }

    protected boolean fileExists() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fileExists", (Object)new Object[]{this, this._serviceName, this._logName});
        }
        boolean bl = true;
        File file = new File(this._logDirectory, this._fileName);
        bl = file.exists();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fileExists", (Object)new Boolean(bl));
        }
        return bl;
    }

    void fileClose() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fileClose", (Object)new Object[]{this, this._serviceName, this._logName});
        }
        if (this._fileChannel != null) {
            try {
                this._fileChannel.close();
                this._file.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileClose", (String)"541", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"fileClose");
                }
                throw new InternalLogException();
            }
            this._fileBuffer = null;
            this._file = null;
            this._fileChannel = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fileClose");
        }
    }

    public WriteableLogRecord getWriteableLogRecord(int n, long l) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)new Object[]{this, this._serviceName, this._logName, new Integer(n), new Long(l)});
        }
        WriteableLogRecord writeableLogRecord = new WriteableLogRecord(this._fileBuffer.duplicate(), l, n);
        this._fileBuffer.position(this._fileBuffer.position() + n + WriteableLogRecord.HEADER_SIZE);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)writeableLogRecord);
        }
        return writeableLogRecord;
    }

    private void writeFileHeader(boolean bl) throws LogHeaderInvalidException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeFileHeader", (Object)new Object[]{this, new Boolean(bl)});
        }
        try {
            this._logFileHeader.write(this._fileBuffer, bl);
        }
        catch (LogHeaderInvalidException logHeaderInvalidException) {
            FFDCFilter.processException((Throwable)logHeaderInvalidException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.writeFileHeader", (String)"700", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeFileHeader");
            }
            throw logHeaderInvalidException;
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.writeFileHeader", (String)"706", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeFileHeader");
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.writeFileHeader", (String)"712", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeFileHeader");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeFileHeader");
        }
    }

    private void writeFileStatus(boolean bl) throws LogHeaderInvalidException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeFileStatus", (Object)new Object[]{this, new Boolean(bl)});
        }
        if (!this._logFileHeader.valid()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeFileStatus");
            }
            throw new LogHeaderInvalidException();
        }
        try {
            int n = 0;
            if (bl) {
                n = this._fileBuffer.position();
            }
            this._fileBuffer.position(STATUS_FIELD_FILE_OFFSET);
            this._fileBuffer.putInt(this._logFileHeader.status());
            this._fileBuffer.force();
            if (bl) {
                this._fileBuffer.position(n);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.writeFileStatus", (String)"797", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeFileStatus");
            }
            throw new WriteOperationFailedException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeFileStatus");
        }
    }

    private void readFileHeader() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"readFileHeader", (Object)new Object[]{this, this._serviceName, this._logName});
            }
            this._logFileHeader.reset();
            try {
                if (this._fileBuffer.capacity() >= 4) {
                    this._logFileHeader.read(this._fileBuffer);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.readFileHeader", (String)"863", (Object)this);
                if (!tc.isEventEnabled()) break block5;
                Tr.event((TraceComponent)tc, (String)"The log header could not be read from the disk due to an unexpected exception");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readFileHeader");
        }
    }

    protected LogFileHeader logFileHeader() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logFileHeader", (Object)new Object[]{this, this._serviceName, this._logName});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logFileHeader", (Object)this._logFileHeader);
        }
        return this._logFileHeader;
    }

    public byte[] getServiceData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServiceData", (Object)new Object[]{this, this._serviceName, this._logName});
        }
        byte[] byArray = null;
        if (this._logFileHeader != null) {
            byArray = this._logFileHeader.getServiceData();
        }
        if (tc.isEntryEnabled()) {
            if (byArray != null) {
                Tr.exit((TraceComponent)tc, (String)"getServiceData", (Object)RLSUtils.toHexString(byArray, 32));
            } else {
                Tr.exit((TraceComponent)tc, (String)"getServiceData", (Object)"null");
            }
        }
        return byArray;
    }

    public int freeBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"freeBytes", (Object)new Object[]{this, this._serviceName, this._logName});
        }
        int n = 0;
        try {
            int n2 = this._fileBuffer.position();
            int n3 = this._fileBuffer.capacity();
            n = n3 - n2;
            if (n < 0) {
                n = 0;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.freeBytes", (String)"956", (Object)this);
            n = 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"freeBytes", (Object)new Integer(n));
        }
        return n;
    }

    public void setServiceData(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            if (byArray != null) {
                Tr.entry((TraceComponent)tc, (String)"setServiceData", (Object)new Object[]{this, this._serviceName, this._logName, RLSUtils.toHexString(byArray, 32)});
            } else {
                Tr.entry((TraceComponent)tc, (String)"setServiceData", (Object)new Object[]{this, this._serviceName, this._logName, "null"});
            }
        }
        this._logFileHeader.setServiceData(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServiceData");
        }
    }

    public String fileName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fileName", (Object)new Object[]{this, this._serviceName, this._logName});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fileName", (Object)this._fileName);
        }
        return this._fileName;
    }

    void keypointStarting(long l) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointStarting", (Object)new Object[]{this, this._serviceName, this._logName, new Long(l)});
        }
        this._logFileHeader.keypointStarting(l);
        try {
            this.writeFileHeader(false);
        }
        catch (LogHeaderInvalidException logHeaderInvalidException) {
            FFDCFilter.processException((Throwable)logHeaderInvalidException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.keypointStarting", (String)"1067", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointStarting");
            }
            throw new InternalLogException();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.keypointStarting", (String)"1073", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointStarting");
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.keypointStarting", (String)"1079", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointStarting");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointStarting");
        }
    }

    void keypointComplete() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointComplete", (Object)new Object[]{this, this._serviceName, this._logName});
        }
        this._logFileHeader.keypointComplete();
        try {
            this.writeFileStatus(true);
        }
        catch (LogHeaderInvalidException logHeaderInvalidException) {
            FFDCFilter.processException((Throwable)logHeaderInvalidException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.keypointComplete", (String)"1111", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointComplete");
            }
            throw new InternalLogException();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.keypointComplete", (String)"1117", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointComplete");
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.keypointComplete", (String)"1123", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointComplete");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointComplete");
        }
    }

    void becomeInactive() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"becomeInactive", (Object)new Object[]{this, this._serviceName, this._logName});
        }
        this._logFileHeader.changeStatus(2);
        try {
            this.writeFileStatus(false);
        }
        catch (LogHeaderInvalidException logHeaderInvalidException) {
            FFDCFilter.processException((Throwable)logHeaderInvalidException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.becomeInactive", (String)"1155", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"becomeInactive");
            }
            throw new InternalLogException();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.becomeInactive", (String)"1161", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"becomeInactive");
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.becomeInactive", (String)"1167", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"becomeInactive");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointComplete");
        }
    }

    void becomeActive() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"becomeActive", (Object)new Object[]{this, this._serviceName, this._logName});
        }
        this._logFileHeader.changeStatus(4);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"becomeActive");
        }
    }

    public void fileExtend(int n) throws LogAllocationException {
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fileExtend", (Object)new Object[]{this, this._serviceName, this._logName, new Integer(n)});
        }
        if ((n2 = this._fileBuffer.capacity()) < n) {
            try {
                int n3 = this._fileBuffer.position();
                Tr.uncondEvent((TraceComponent)tc, (String)("Expanding log file to size of " + n + " bytes."));
                this._fileBuffer = this._fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n);
                this._fileBuffer.position(n3);
                this._fileSize = n;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.LogFileHandle.fileExtend", (String)"1266", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unable to extend file " + this._fileName + " to " + n + " bytes"));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"fileExtend");
                }
                throw new LogAllocationException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fileExtend");
        }
    }

    protected void force() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"force");
        }
        this._fileBuffer.force();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"force");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

