/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogHeaderInvalidException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.MappedByteBuffer;
import java.util.Date;
import java.util.GregorianCalendar;

public class LogFileHeader {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$recoverylog$spi$LogFileHeader == null ? (class$com$ibm$ws$recoverylog$spi$LogFileHeader = LogFileHeader.class$("com.ibm.ws.recoverylog.spi.LogFileHeader")) : class$com$ibm$ws$recoverylog$spi$LogFileHeader), (String)"Transaction", null);
    static final byte[] MAGIC_NUMBER = new byte[]{87, 65, 83, 76, 79, 71};
    static final int RLS_VERSION = 2;
    public static final int STATUS_INACTIVE = 2;
    public static final int STATUS_ACTIVE = 4;
    public static final int STATUS_KEYPOINTING = 8;
    private int _status = 2;
    private long _date = 0L;
    private long _firstRecordSequenceNumber = 0L;
    private String _serverName = null;
    private String _serviceName = null;
    private String _logName = null;
    private byte[] _serviceData = null;
    private boolean _valid = false;
    private static final int HEADER_SIZE = 62;
    static /* synthetic */ Class class$com$ibm$ws$recoverylog$spi$LogFileHeader;

    public LogFileHeader(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LogFileHeader", (Object)new Object[]{this, string, string2, string3});
        }
        this._status = 2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = gregorianCalendar.getTime();
        this._date = date.getTime();
        this._firstRecordSequenceNumber = 0L;
        this._serverName = new String(string);
        this._serviceName = new String(string2);
        this._logName = new String(string3);
        this._serviceData = null;
        this._valid = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LogFileHeader");
        }
    }

    public void writeStatus(DataOutputStream dataOutputStream) throws LogHeaderInvalidException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeStatus", (Object)this);
        }
        if (!this._valid) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeStatus");
            }
            throw new LogHeaderInvalidException();
        }
        try {
            dataOutputStream.write(MAGIC_NUMBER, 0, MAGIC_NUMBER.length);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeInt(this._status);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.writeStatus", (String)"260", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeStatus");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeStatus");
        }
    }

    public void write(MappedByteBuffer mappedByteBuffer, boolean bl) throws LogHeaderInvalidException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object)new Object[]{this, mappedByteBuffer, new Boolean(bl)});
        }
        if (!this._valid) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)"LogHeaderInvalidException");
            }
            throw new LogHeaderInvalidException();
        }
        try {
            int n = 0;
            if (bl) {
                n = mappedByteBuffer.position();
            }
            byte[] byArray = this._serverName.getBytes();
            byte[] byArray2 = this._serviceName.getBytes();
            byte[] byArray3 = this._logName.getBytes();
            mappedByteBuffer.position(0);
            mappedByteBuffer.putInt(62 + byArray.length + byArray2.length + byArray3.length);
            mappedByteBuffer.put(MAGIC_NUMBER);
            mappedByteBuffer.putInt(2);
            mappedByteBuffer.putInt(this._status);
            mappedByteBuffer.putLong(this._date);
            mappedByteBuffer.putLong(this._firstRecordSequenceNumber);
            mappedByteBuffer.putInt(byArray.length);
            mappedByteBuffer.put(byArray);
            mappedByteBuffer.putInt(byArray2.length);
            mappedByteBuffer.put(byArray2);
            mappedByteBuffer.putInt(byArray3.length);
            mappedByteBuffer.put(byArray3);
            if (this._serviceData != null) {
                mappedByteBuffer.putInt(this._serviceData.length);
                mappedByteBuffer.put(this._serviceData);
            } else {
                mappedByteBuffer.putInt(0);
            }
            mappedByteBuffer.putLong(this._date);
            mappedByteBuffer.putLong(this._firstRecordSequenceNumber);
            mappedByteBuffer.force();
            if (bl) {
                mappedByteBuffer.position(n);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            FFDCFilter.processException((Throwable)bufferUnderflowException, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.write", (String)"338", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write");
            }
            throw new InternalLogException();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.write", (String)"344", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    public boolean read(MappedByteBuffer mappedByteBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read", (Object)this);
        }
        long l = -1L;
        long l2 = -1L;
        int n = -1;
        this._valid = false;
        try {
            int n2 = mappedByteBuffer.getInt();
            if (n2 > 0 && n2 <= mappedByteBuffer.capacity() - mappedByteBuffer.position()) {
                byte[] byArray = new byte[MAGIC_NUMBER.length];
                mappedByteBuffer.get(byArray);
                if (this.validMagicNumber(byArray)) {
                    int n3 = mappedByteBuffer.getInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log creator version is " + n3));
                    }
                    this._status = mappedByteBuffer.getInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log file state is " + LogFileHeader.statusToString(this._status)));
                    }
                    this._date = mappedByteBuffer.getLong();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log file date (long) is " + this._date));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log file date (date) is " + new Date(this._date).toString()));
                    }
                    this._firstRecordSequenceNumber = mappedByteBuffer.getLong();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log file first record sequence number is " + this._firstRecordSequenceNumber));
                    }
                    int n4 = mappedByteBuffer.getInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Reading String of length " + n4));
                    }
                    byte[] byArray2 = new byte[n4];
                    mappedByteBuffer.get(byArray2);
                    this._serverName = new String(byArray2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log file created on server " + this._serverName));
                    }
                    n4 = mappedByteBuffer.getInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Reading String of length " + n4));
                    }
                    byte[] byArray3 = new byte[n4];
                    mappedByteBuffer.get(byArray3);
                    this._serviceName = new String(byArray3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log file created by service " + this._serviceName));
                    }
                    n4 = mappedByteBuffer.getInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Reading String of length " + n4));
                    }
                    byte[] byArray4 = new byte[n4];
                    mappedByteBuffer.get(byArray4);
                    this._logName = new String(byArray4);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log name was " + this._logName));
                    }
                    n = mappedByteBuffer.getInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log file contains " + n + " bytes of service specific information"));
                    }
                    if (n > 0) {
                        this._serviceData = new byte[n];
                        mappedByteBuffer.get(this._serviceData);
                    } else {
                        this._serviceData = null;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Service Specific Information is [" + RLSUtils.toHexString(this._serviceData, 32) + "]"));
                    }
                    l = mappedByteBuffer.getLong();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log file check date (long) is " + l));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log file check date (date) is " + new Date(l).toString()));
                    }
                    l2 = mappedByteBuffer.getLong();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovery log file check first record sequence number is " + l2));
                    }
                    if (this._date == l && this._firstRecordSequenceNumber == l2 && this._date > 0L) {
                        this._valid = true;
                    } else {
                        this.reset();
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Error processing recovery log file header - integrity check failed");
                        }
                    }
                }
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            FFDCFilter.processException((Throwable)bufferUnderflowException, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.read", (String)"454", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Error processing recovery log file header", (Object)bufferUnderflowException.toString());
            }
            this.reset();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogFileHeader.read", (String)"460", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Error processing recovery log file header", (Object)throwable.toString());
            }
            this.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)new Boolean(this._valid));
        }
        return this._valid;
    }

    private boolean validMagicNumber(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validMagicNumber", (Object)new Object[]{this, RLSUtils.toHexString(byArray, 32)});
        }
        boolean bl = false;
        for (int i = 0; !bl && i < MAGIC_NUMBER.length; ++i) {
            if (byArray[i] == MAGIC_NUMBER[i]) continue;
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validMagicNumber", (Object)new Boolean(!bl));
        }
        return !bl;
    }

    public long date() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"date", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"date", (Object)new Long(this._date));
        }
        return this._date;
    }

    public long firstRecordSequenceNumber() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"firstRecordSequenceNumber", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"firstRecordSequenceNumber", (Object)new Long(this._firstRecordSequenceNumber));
        }
        return this._firstRecordSequenceNumber;
    }

    public String serverName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serverName", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serverName", (Object)this._serverName);
        }
        return this._serverName;
    }

    public String serviceName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serviceName", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serviceName", (Object)this._serviceName);
        }
        return this._serviceName;
    }

    public String logName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logName", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logName", (Object)this._logName);
        }
        return this._logName;
    }

    public byte[] getServiceData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServiceData", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            if (this._serviceData != null) {
                Tr.exit((TraceComponent)tc, (String)"getServiceData", (Object)RLSUtils.toHexString(this._serviceData, 32));
            } else {
                Tr.exit((TraceComponent)tc, (String)"getServiceData", (Object)"null");
            }
        }
        return this._serviceData;
    }

    public void setServiceData(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            if (byArray != null) {
                Tr.entry((TraceComponent)tc, (String)"setServiceData", (Object)new Object[]{this, RLSUtils.toHexString(byArray, 32)});
            } else {
                Tr.entry((TraceComponent)tc, (String)"setServiceData", (Object)new Object[]{this, "null"});
            }
        }
        this._serviceData = byArray;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServiceData", (Object)byArray);
        }
    }

    public boolean valid() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"valid", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"valid", (Object)new Boolean(this._valid));
        }
        return this._valid;
    }

    public int status() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"status", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"status", (Object)new Integer(this._status));
        }
        return this._status;
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset", (Object)this);
        }
        this._status = 4;
        this._date = 0L;
        this._firstRecordSequenceNumber = 0L;
        this._serverName = null;
        this._serviceName = null;
        this._logName = null;
        this._serviceData = null;
        this._valid = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    public void changeStatus(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"changeStatus", (Object)new Object[]{this, new Integer(n)});
        }
        this._status = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"changeStatus");
        }
    }

    public void keypointStarting(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointStarting", (Object)new Object[]{this, new Long(l)});
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = gregorianCalendar.getTime();
        this._date = date.getTime();
        this._firstRecordSequenceNumber = l;
        this._valid = true;
        this._status = 8;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointStarting");
        }
    }

    public void keypointComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointComplete", (Object)this);
        }
        this._status = 4;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointComplete");
        }
    }

    static String statusToString(int n) {
        String string = null;
        string = n == 2 ? "INACTIVE" : (n == 4 ? "ACTIVE" : (n == 8 ? "KEYPOINTING" : "UNKNOWN"));
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

