/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogFileHandle;
import com.ibm.ws.recoverylog.spi.LogFileHeader;
import com.ibm.ws.recoverylog.spi.LogFullException;
import com.ibm.ws.recoverylog.spi.LogHeaderInvalidException;
import com.ibm.ws.recoverylog.spi.LogOpenException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoveryLogImpl;
import com.ibm.ws.recoverylog.spi.WriteOperationFailedException;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.io.File;
import java.util.ArrayList;

class LogHandle {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$recoverylog$spi$LogHandle == null ? (class$com$ibm$ws$recoverylog$spi$LogHandle = LogHandle.class$("com.ibm.ws.recoverylog.spi.LogHandle")) : class$com$ibm$ws$recoverylog$spi$LogHandle), (String)"Transaction", null);
    private static String RECOVERY_FILE_1_NAME = "log1";
    private static String RECOVERY_FILE_2_NAME = "log2";
    private RecoveryLogImpl _recoveryLog = null;
    private String _serviceName = null;
    private String _serverName = null;
    private String _logName = null;
    private String _logDirectory = null;
    private int _logFileSize = 0;
    private int _maxLogFileSize = 0;
    private LogFileHandle _file1 = null;
    private LogFileHandle _file2 = null;
    private LogFileHandle _activeFile = null;
    private LogFileHandle _inactiveFile = null;
    private long _recordSequenceNumber = 0L;
    private ArrayList _recoveredRecords = null;
    public int _physicalFreeBytes = 0;
    private byte[] _serviceData = null;
    private static Object _directoryCreationLock = new Object();
    static /* synthetic */ Class class$com$ibm$ws$recoverylog$spi$LogHandle;

    LogHandle(RecoveryLogImpl recoveryLogImpl, String string, String string2, String string3, String string4, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LogHandle", (Object)new Object[]{this, recoveryLogImpl, string, string2, string3, string4, new Integer(n), new Integer(n2)});
        }
        this._recoveryLog = recoveryLogImpl;
        this._serviceName = string;
        this._serverName = string2;
        this._logName = string3;
        this._logDirectory = string4;
        this._maxLogFileSize = n2;
        this._logFileSize = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LogHandle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void openLog() throws LogOpenException, LogCorruptedException, LogAllocationException, InternalLogException {
        block76: {
            block79: {
                long l;
                long l2;
                block82: {
                    block81: {
                        long l3;
                        long l4;
                        block80: {
                            int n;
                            int n2;
                            block78: {
                                block77: {
                                    boolean bl;
                                    if (tc.isEntryEnabled()) {
                                        Tr.entry((TraceComponent)tc, (String)"openLog", (Object)this);
                                    }
                                    if (this._activeFile != null) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog");
                                        }
                                        throw new LogOpenException();
                                    }
                                    Object object = _directoryCreationLock;
                                    synchronized (object) {
                                        File file = new File(this._logDirectory);
                                        if (!file.exists()) {
                                            boolean bl2;
                                            if (tc.isEventEnabled()) {
                                                Tr.event((TraceComponent)tc, (String)"Creating recovery log directory ", (Object)this._logDirectory);
                                            }
                                            if (!(bl2 = file.mkdirs())) {
                                                if (tc.isEventEnabled()) {
                                                    Tr.event((TraceComponent)tc, (String)"Unable to create the log directory");
                                                }
                                                if (tc.isEntryEnabled()) {
                                                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogAllocationException");
                                                }
                                                throw new LogAllocationException();
                                            }
                                        }
                                    }
                                    object = System.getProperty("os.name");
                                    if (((String)object).equalsIgnoreCase("HPUX") || ((String)object).equalsIgnoreCase("HP-UX")) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Running on HP-UX, open logs with initial size of maximum log size");
                                        }
                                        this._file1 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_1_NAME, this._serverName, this._serviceName, this._logName, this._maxLogFileSize);
                                        this._file2 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_2_NAME, this._serverName, this._serviceName, this._logName, this._maxLogFileSize);
                                    } else {
                                        this._file1 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_1_NAME, this._serverName, this._serviceName, this._logName, this._logFileSize);
                                        this._file2 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_2_NAME, this._serverName, this._serviceName, this._logName, this._logFileSize);
                                    }
                                    this._activeFile = null;
                                    this._inactiveFile = null;
                                    if (this._file1.fileExists() != this._file2.fileExists()) {
                                        if (tc.isEventEnabled()) {
                                            Tr.event((TraceComponent)tc, (String)"One of the recovery log files has been deleted. Recovery can't complete");
                                        }
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
                                        }
                                        throw new LogCorruptedException();
                                    }
                                    boolean bl3 = bl = !this._file1.fileExists();
                                    if (bl) {
                                        this._file1.becomeActive();
                                    }
                                    try {
                                        this._file1.fileOpen();
                                    }
                                    catch (LogHeaderInvalidException logHeaderInvalidException) {
                                        FFDCFilter.processException((Throwable)logHeaderInvalidException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"370", (Object)this);
                                        if (tc.isEventEnabled()) {
                                            Tr.event((TraceComponent)tc, (String)("The log header in file '" + this._file1.fileName() + "' is invalid"));
                                        }
                                        this._file1 = null;
                                    }
                                    catch (LogAllocationException logAllocationException) {
                                        FFDCFilter.processException((Throwable)logAllocationException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"376", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog");
                                        }
                                        throw logAllocationException;
                                    }
                                    catch (InternalLogException internalLogException) {
                                        FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"384", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog");
                                        }
                                        throw internalLogException;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"392", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog");
                                        }
                                        throw new InternalLogException();
                                    }
                                    try {
                                        this._file2.fileOpen();
                                    }
                                    catch (LogHeaderInvalidException logHeaderInvalidException) {
                                        FFDCFilter.processException((Throwable)logHeaderInvalidException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"408", (Object)this);
                                        if (tc.isEventEnabled()) {
                                            Tr.event((TraceComponent)tc, (String)("The log header in file '" + this._file2.fileName() + "' is invalid"));
                                        }
                                        this._file2 = null;
                                    }
                                    catch (LogAllocationException logAllocationException) {
                                        FFDCFilter.processException((Throwable)logAllocationException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"414", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog");
                                        }
                                        throw logAllocationException;
                                    }
                                    catch (InternalLogException internalLogException) {
                                        FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"422", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog");
                                        }
                                        throw internalLogException;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"430", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog");
                                        }
                                        throw new InternalLogException();
                                    }
                                    if (this._file1 == null && this._file2 == null) {
                                        if (tc.isEventEnabled()) {
                                            Tr.event((TraceComponent)tc, (String)"Neither of the recovery log files are valid. Recovery can't complete");
                                        }
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
                                        }
                                        throw new LogCorruptedException();
                                    }
                                    if (this._file1 != null && this._file2 == null) {
                                        if (this._file1.logFileHeader().status() == 4) {
                                            if (tc.isEventEnabled()) {
                                                Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file1.fileName() + "' as its ACTIVE and '" + this._file2.fileName() + "' is not valid"));
                                            }
                                            this._activeFile = this._file1;
                                            break block76;
                                        } else {
                                            this._file1 = null;
                                            this._file2 = null;
                                            if (tc.isEventEnabled()) {
                                                Tr.event((TraceComponent)tc, (String)("The only valid recovery log file '" + this._file1.fileName() + "' is not in ACTIVE state"));
                                            }
                                            if (tc.isEntryEnabled()) {
                                                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
                                            }
                                            throw new LogCorruptedException();
                                        }
                                    }
                                    if (this._file1 == null && this._file2 != null) {
                                        if (this._file2.logFileHeader().status() == 4) {
                                            if (tc.isEventEnabled()) {
                                                Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file2.fileName() + "' as its ACTIVE and '" + this._file1.fileName() + "' is not valid"));
                                            }
                                            this._activeFile = this._file2;
                                            break block76;
                                        } else {
                                            this._file1 = null;
                                            this._file2 = null;
                                            if (tc.isEventEnabled()) {
                                                Tr.event((TraceComponent)tc, (String)("The only valid recovery log file '" + this._file2.fileName() + "' is not in ACTIVE state"));
                                            }
                                            if (tc.isEntryEnabled()) {
                                                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
                                            }
                                            throw new LogCorruptedException();
                                        }
                                    }
                                    n2 = this._file1.logFileHeader().status();
                                    n = this._file2.logFileHeader().status();
                                    l2 = this._file1.logFileHeader().firstRecordSequenceNumber();
                                    l = this._file2.logFileHeader().firstRecordSequenceNumber();
                                    l4 = this._file1.logFileHeader().date();
                                    l3 = this._file2.logFileHeader().date();
                                    if (n2 != 4 || n == 4) break block77;
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file1.fileName() + "' as its ACTIVE and '" + this._file2.fileName() + "' is not ACTIVE"));
                                    }
                                    this._activeFile = this._file1;
                                    this._inactiveFile = this._file2;
                                    break block76;
                                }
                                if (n2 == 4 || n != 4) break block78;
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file2.fileName() + "' as its ACTIVE and '" + this._file1.fileName() + "' is not ACTIVE"));
                                }
                                this._activeFile = this._file2;
                                this._inactiveFile = this._file1;
                                break block76;
                            }
                            if (n2 != 4 || n != 4) break block79;
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Both recovery files are in ACTIVE state. Determine target file by examining timestamp");
                            }
                            if (l4 <= l3) break block80;
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file1.fileName() + "' as it was created after '" + this._file2.fileName() + "'"));
                            }
                            this._activeFile = this._file1;
                            this._inactiveFile = this._file2;
                            break block76;
                        }
                        if (l4 >= l3) break block81;
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file2.fileName() + "' as it was created after '" + this._file1.fileName() + "'"));
                        }
                        this._activeFile = this._file2;
                        this._inactiveFile = this._file1;
                        break block76;
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Both recovery files have the same timestamp. Determine target file by examining first record sequence numbers");
                    }
                    if (l2 != 0L || l != 0L) break block82;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file1.fileName() + "' as both files are empty"));
                    }
                    this._activeFile = this._file1;
                    this._inactiveFile = this._file2;
                    break block76;
                }
                if (l2 > l) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file1.fileName() + "' as it has as the highest record sequence number"));
                    }
                    this._activeFile = this._file1;
                    this._inactiveFile = this._file2;
                    break block76;
                } else if (l2 < l) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file2.fileName() + "' as it has as the highest record sequence number"));
                    }
                    this._activeFile = this._file2;
                    this._inactiveFile = this._file1;
                    break block76;
                } else {
                    this._file1 = null;
                    this._file2 = null;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Neither of the recovery log files are valid as they have the same record sequence number. Recovery can't complete");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
                    }
                    throw new LogCorruptedException();
                }
            }
            this._file1 = null;
            this._file2 = null;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The recovery lof files are in an undefined state");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
            }
            throw new LogCorruptedException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Selected log file '" + this._activeFile.fileName() + "' for recovery"));
        }
        this._serviceData = this._activeFile.getServiceData();
        if (this._activeFile == this._file1) {
            this._file2.setServiceData(this._serviceData);
        } else {
            this._file1.setServiceData(this._serviceData);
        }
        try {
            this._recoveredRecords = this.readRecords();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"593", (Object)this);
            this._file1 = null;
            this._file2 = null;
            this._activeFile = null;
            this._inactiveFile = null;
            this._recoveredRecords = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)((Object)internalLogException));
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"603", (Object)this);
            this._file1 = null;
            this._file2 = null;
            this._activeFile = null;
            this._inactiveFile = null;
            this._recoveredRecords = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
            }
            throw new InternalLogException();
        }
        this._physicalFreeBytes = this._activeFile.freeBytes();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"openLog");
        }
    }

    private ArrayList readRecords() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readRecords", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readRecords");
            }
            throw new InternalLogException();
        }
        ArrayList<ReadableLogRecord> arrayList = null;
        this._recordSequenceNumber = this._activeFile.logFileHeader().firstRecordSequenceNumber();
        ReadableLogRecord readableLogRecord = this._activeFile.getReadableLogRecord(this._recordSequenceNumber);
        if (readableLogRecord != null) {
            arrayList = new ArrayList<ReadableLogRecord>();
        }
        while (readableLogRecord != null) {
            arrayList.add(readableLogRecord);
            ++this._recordSequenceNumber;
            readableLogRecord = this._activeFile.getReadableLogRecord(this._recordSequenceNumber);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Next record sequence number is " + this._recordSequenceNumber));
        }
        if (tc.isEntryEnabled()) {
            if (arrayList != null) {
                Tr.exit((TraceComponent)tc, (String)"readRecords", (Object)new Integer(arrayList.size()));
            } else {
                Tr.exit((TraceComponent)tc, (String)"readRecords", (Object)new Integer(0));
            }
        }
        return arrayList;
    }

    void keypointStarting() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointStarting", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointStarting");
            }
            throw new InternalLogException();
        }
        if (this._activeFile == this._file1) {
            this._activeFile = this._file2;
            this._inactiveFile = this._file1;
        } else {
            this._activeFile = this._file1;
            this._inactiveFile = this._file2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Keypoint processing is switching to log file " + this._activeFile.fileName()));
        }
        try {
            this._activeFile.keypointStarting(this._recordSequenceNumber);
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.keypointStarting", (String)"859", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointStarting");
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogHandle.keypointStarting", (String)"865", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointStarting");
            }
            throw new InternalLogException();
        }
        this._physicalFreeBytes = this._activeFile.freeBytes();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointStarting");
        }
    }

    void closeLog() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLog", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"closeLog");
            }
            throw new InternalLogException();
        }
        try {
            this._file1.fileClose();
            this._file2.fileClose();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.closeLog", (String)"1051", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"closeLog");
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogHandle.closeLog", (String)"1057", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"closeLog");
            }
            throw new InternalLogException();
        }
        this._file1 = null;
        this._file2 = null;
        this._activeFile = null;
        this._recoveredRecords = null;
        this._physicalFreeBytes = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    byte[] getServiceData() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServiceData", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServiceData");
            }
            throw new InternalLogException();
        }
        byte[] byArray = this._activeFile.getServiceData();
        if (tc.isEntryEnabled()) {
            if (byArray != null) {
                Tr.exit((TraceComponent)tc, (String)"getServiceData", (Object)RLSUtils.toHexString(byArray, 32));
            } else {
                Tr.exit((TraceComponent)tc, (String)"getServiceData", (Object)"null");
            }
        }
        return byArray;
    }

    void force() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"force", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"force");
            }
            throw new InternalLogException();
        }
        this._activeFile.force();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"force");
        }
    }

    LogFileHeader logFileHeader() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logFileHeader", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"logFileHeader");
            }
            throw new InternalLogException();
        }
        LogFileHeader logFileHeader = this._activeFile.logFileHeader();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logFileHeader", (Object)logFileHeader);
        }
        return logFileHeader;
    }

    ArrayList recoveredRecords() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveredRecords", (Object)this);
            if (this._recoveredRecords != null) {
                Tr.exit((TraceComponent)tc, (String)"recoveredRecords", (Object)new Integer(this._recoveredRecords.size()));
            } else {
                Tr.exit((TraceComponent)tc, (String)"recoveredRecords", (Object)new Integer(0));
            }
        }
        return this._recoveredRecords;
    }

    void setServiceData(byte[] byArray) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            if (byArray != null) {
                Tr.entry((TraceComponent)tc, (String)"setServiceData", (Object)new Object[]{this, RLSUtils.toHexString(byArray, 32)});
            } else {
                Tr.entry((TraceComponent)tc, (String)"setServiceData", (Object)new Object[]{this, "null"});
            }
        }
        if (this._file1 == null || this._file2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setServiceData");
            }
            throw new InternalLogException();
        }
        this._serviceData = byArray;
        this._file1.setServiceData(byArray);
        this._file2.setServiceData(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServiceData");
        }
    }

    public void keypoint() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypoint", (Object)this);
        }
        try {
            this.force();
            this._activeFile.keypointComplete();
            if (this._activeFile == this._file1) {
                this._file2.becomeInactive();
            } else {
                this._file1.becomeInactive();
            }
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.keypoint", (String)"1346", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint");
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogHandle.keypoint", (String)"1352", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypoint");
        }
    }

    void resizeLog(int n) throws InternalLogException, LogFullException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resizeLog", (Object)new Object[]{this, new Integer(n)});
        }
        if (this._activeFile == null || this._inactiveFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resizeLog", (Object)"InternalLogException");
            }
            throw new InternalLogException();
        }
        try {
            this._file1.fileExtend(n);
            this._file2.fileExtend(n);
        }
        catch (LogAllocationException logAllocationException) {
            FFDCFilter.processException((Throwable)logAllocationException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.resizeLog", (String)"1612", (Object)this);
            this._activeFile = this._activeFile == this._file1 ? this._file2 : this._file1;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resizeLog");
            }
            throw new WriteOperationFailedException();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.LogHandle.resizeLog", (String)"1555", (Object)this);
            this._activeFile = this._activeFile == this._file1 ? this._file2 : this._file1;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resizeLog");
            }
            throw new InternalLogException();
        }
        this._physicalFreeBytes = this._activeFile.freeBytes();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Log file " + this._activeFile.fileName() + " now has " + this._physicalFreeBytes + " bytes of storage available"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resizeLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WriteableLogRecord getWriteableLogRecord(int n) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)new Object[]{this, new Integer(n)});
        }
        WriteableLogRecord writeableLogRecord = null;
        boolean bl = false;
        LogHandle logHandle = this;
        synchronized (logHandle) {
            if (this._activeFile.freeBytes() < n + WriteableLogRecord.HEADER_SIZE) {
                bl = true;
            } else {
                try {
                    writeableLogRecord = this._activeFile.getWriteableLogRecord(n, this._recordSequenceNumber++);
                }
                catch (InternalLogException internalLogException) {
                    FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.getWriteableLogRecord", (String)"1112", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)((Object)internalLogException));
                    }
                    throw internalLogException;
                }
            }
        }
        if (bl) {
            try {
                this._recoveryLog.keypoint();
            }
            catch (LogClosedException logClosedException) {
                FFDCFilter.processException((Throwable)logClosedException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.getWriteableLogRecord", (String)"1129", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)"InternalLogException");
                }
                throw new InternalLogException();
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle.getWriteableLogRecord", (String)"1135", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)((Object)internalLogException));
                }
                throw internalLogException;
            }
            writeableLogRecord = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)writeableLogRecord);
        }
        return writeableLogRecord;
    }

    protected int getFreeSpace() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFreeSpace", (Object)this);
        }
        int n = this._activeFile.freeBytes();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFreeSpace", (Object)new Integer(n));
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

