/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitSectionException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogHandle;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionExistsException;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl;
import com.ibm.ws.recoverylog.spi.RecoveryLogImpl;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public class RecoverableUnitImpl
implements RecoverableUnit {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$recoverylog$spi$RecoverableUnitImpl == null ? (class$com$ibm$ws$recoverylog$spi$RecoverableUnitImpl = RecoverableUnitImpl.class$("com.ibm.ws.recoverylog.spi.RecoverableUnitImpl")) : class$com$ibm$ws$recoverylog$spi$RecoverableUnitImpl), (String)"Transaction", null);
    protected static short RECORDTYPENORMAL = 1;
    protected static short RECORDTYPEDELETED = (short)2;
    private static int END_OF_SECTIONS = -1;
    private static final int RECORD_HEADER_SIZE = 18;
    private static final int REMOVAL_HEADER_SIZE = 14;
    private static final int TOTAL_HEADER_SIZE = 42;
    private long _identity = 0L;
    private HashMap _recoverableUnitSections = null;
    private boolean _storedOnDisk = false;
    private LogHandle _logHandle = null;
    private Lock _controlLock = null;
    private int _storageMode = 1;
    private int _unwrittenDataSize = 0;
    private int _totalDataSize = 0;
    private RecoveryLogImpl _recLog = null;
    static /* synthetic */ Class class$com$ibm$ws$recoverylog$spi$RecoverableUnitImpl;

    RecoverableUnitImpl(RecoveryLogImpl recoveryLogImpl, long l, LogHandle logHandle, int n, Lock lock) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoverableUnitImpl", (Object)new Object[]{this, recoveryLogImpl, new Long(l), logHandle, new Integer(n), lock});
        }
        this._identity = l;
        this._logHandle = logHandle;
        this._controlLock = lock;
        this._recLog = recoveryLogImpl;
        this._storageMode = n;
        this._recoverableUnitSections = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoverableUnitImpl");
        }
    }

    public RecoverableUnitSection createSection(int n, boolean bl) throws RecoverableUnitSectionExistsException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSection", (Object)new Object[]{this, new Integer(n), new Boolean(bl)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSection", (Object)this);
            }
            throw new InternalLogException();
        }
        Integer n2 = new Integer(n);
        RecoverableUnitSectionImpl recoverableUnitSectionImpl = null;
        this._controlLock.getSharedLock();
        if (!this._recoverableUnitSections.containsKey(n2)) {
            recoverableUnitSectionImpl = new RecoverableUnitSectionImpl(this._recLog, this, this._identity, n, this._controlLock, this._logHandle, this._storageMode, bl);
            this._recoverableUnitSections.put(n2, recoverableUnitSectionImpl);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("RecoverableUnitImpl '" + this._identity + "' created a new RecoverableUnitSection with identity '" + n + "'"));
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("RecoverableUnitImpl '" + this._identity + "' was unable to create a RecoverableUnitSection with id '" + n + "' as it already exists"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSection");
            }
            try {
                this._controlLock.releaseSharedLock();
            }
            catch (NoSharedLockException noSharedLockException) {
                FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.createSection", (String)"212", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createSection");
                }
                throw new InternalLogException();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.createSection", (String)"218", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createSection");
                }
                throw new InternalLogException();
            }
            throw new RecoverableUnitSectionExistsException();
        }
        try {
            this._controlLock.releaseSharedLock();
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.createSection", (String)"232", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSection");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSection", (Object)recoverableUnitSectionImpl);
        }
        return recoverableUnitSectionImpl;
    }

    public void removeSection(int n) throws InvalidRecoverableUnitSectionException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeSection", (Object)new Object[]{this, new Integer(n)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeSection");
        }
        throw new UnsupportedOperationException();
    }

    public RecoverableUnitSection lookupSection(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupSection", (Object)new Object[]{this, new Integer(n)});
        }
        RecoverableUnitSectionImpl recoverableUnitSectionImpl = (RecoverableUnitSectionImpl)this._recoverableUnitSections.get(new Integer(n));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupSection", (Object)recoverableUnitSectionImpl);
        }
        return recoverableUnitSectionImpl;
    }

    public void writeSections() throws InternalLogException {
        this.writeSections(false);
    }

    /*
     * Unable to fully structure code
     */
    void writeSections(boolean var1_1) throws InternalLogException {
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections", (Object)new Object[]{this, new Boolean(var1_1)});
        }
        if (this._recLog.failed()) {
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections", (Object)this);
            }
            throw new InternalLogException();
        }
        if (this._logHandle == null) {
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections");
            }
            throw new InternalLogException();
        }
        this._controlLock.getSharedLock();
        if (this._unwrittenDataSize > 0 || var1_1 && this._totalDataSize > 0) {
            try {
                if (RecoverableUnitImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)RecoverableUnitImpl.tc, (String)("Writing recoverable unit '" + this._identity + "'"));
                }
                if (RecoverableUnitImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)RecoverableUnitImpl.tc, (String)("Unwritten data size = " + this._unwrittenDataSize + " total data size = " + this._totalDataSize));
                }
                if ((var2_2 = this._logHandle.getWriteableLogRecord(18 + (var1_1 != false ? this._totalDataSize : this._unwrittenDataSize))) == null) ** GOTO lbl78
                var2_2.putInt(0);
                var2_2.putLong(this._identity);
                var2_2.putShort(RecoverableUnitImpl.RECORDTYPENORMAL);
                var3_7 = this._recoverableUnitSections.values().iterator();
                while (var3_7.hasNext()) {
                    var4_11 = (RecoverableUnitSectionImpl)var3_7.next();
                    var4_11.format(var1_1, var2_2);
                }
                var2_2.putInt(RecoverableUnitImpl.END_OF_SECTIONS);
                var2_2.close();
                this._storedOnDisk = true;
            }
            catch (IOException var2_3) {
                FFDCFilter.processException((Throwable)var2_3, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"383", (Object)this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)RecoverableUnitImpl.tc, (String)"An unexpected error IO occurred whilst formatting the recovery log buffer");
                }
                this._recLog.markFailed();
                try {
                    this._controlLock.releaseSharedLock();
                }
                catch (Throwable var3_8) {
                    FFDCFilter.processException((Throwable)var3_8, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"392", (Object)this);
                    if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections");
                    }
                    throw new InternalLogException();
                }
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections");
                }
                throw new InternalLogException();
            }
            catch (InternalLogException var2_4) {
                FFDCFilter.processException((Throwable)var2_4, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"587", (Object)this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)RecoverableUnitImpl.tc, (String)"An InternalLogException exception occured whilst formatting the recovery log buffer");
                }
                this._recLog.markFailed();
                try {
                    this._controlLock.releaseSharedLock();
                }
                catch (Throwable var3_9) {
                    FFDCFilter.processException((Throwable)var3_9, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"392", (Object)this);
                }
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections");
                }
                throw var2_4;
            }
            catch (Throwable var2_5) {
                FFDCFilter.processException((Throwable)var2_5, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"402", (Object)this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)RecoverableUnitImpl.tc, (String)"An unexpected error occurred whilst formatting the recovery log buffer");
                }
                this._recLog.markFailed();
                try {
                    this._controlLock.releaseSharedLock();
                }
                catch (Throwable var3_10) {
                    FFDCFilter.processException((Throwable)var3_10, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"411", (Object)this);
                    if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections");
                    }
                    throw new InternalLogException();
                }
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections");
                }
                throw new InternalLogException();
            }
        } else if (RecoverableUnitImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)RecoverableUnitImpl.tc, (String)"RecoverableUnitImpl has no RecoverableUnitSections that need to be added to the disk record");
        }
lbl78:
        // 5 sources

        try {
            this._controlLock.releaseSharedLock();
        }
        catch (NoSharedLockException var2_6) {
            FFDCFilter.processException((Throwable)var2_6, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"474", (Object)this);
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections");
            }
            throw new InternalLogException();
        }
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections");
        }
    }

    void writeSection(RecoverableUnitSectionImpl recoverableUnitSectionImpl, int n) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeSection", (Object)new Object[]{this, recoverableUnitSectionImpl, new Integer(n)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSection", (Object)this);
            }
            throw new InternalLogException();
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSection");
            }
            throw new InternalLogException();
        }
        this._controlLock.getSharedLock();
        try {
            WriteableLogRecord writeableLogRecord;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing recoverable unit '" + recoverableUnitSectionImpl.identity() + "'"));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unwritten data size = " + n));
            }
            if ((writeableLogRecord = this._logHandle.getWriteableLogRecord(18 + n)) != null) {
                writeableLogRecord.putInt(0);
                writeableLogRecord.putLong(this._identity);
                writeableLogRecord.putShort(RECORDTYPENORMAL);
                recoverableUnitSectionImpl.format(false, writeableLogRecord);
                writeableLogRecord.putInt(END_OF_SECTIONS);
                writeableLogRecord.close();
                this._storedOnDisk = true;
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"383", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error IO occurred whilst formatting the recovery log buffer");
            }
            this._recLog.markFailed();
            try {
                this._controlLock.releaseSharedLock();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"392", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeSections");
                }
                throw new InternalLogException();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSections");
            }
            throw new InternalLogException();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"402", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occurred whilst formatting the recovery log buffer");
            }
            this._recLog.markFailed();
            try {
                this._controlLock.releaseSharedLock();
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"411", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeSections");
                }
                throw new InternalLogException();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSections");
            }
            throw new InternalLogException();
        }
        try {
            this._controlLock.releaseSharedLock();
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"474", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSections");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeSections");
        }
    }

    public void forceSections() throws InternalLogException {
        this.forceSections(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void forceSections(boolean bl) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forceSections", (Object)new Object[]{this, new Boolean(bl)});
        }
        if (this._recLog.failed()) {
            if (!tc.isEntryEnabled()) throw new InternalLogException();
            Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)this);
            throw new InternalLogException();
        }
        try {
            this.writeSections(bl);
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"531", (Object)this);
            if (!tc.isEntryEnabled()) throw internalLogException;
            Tr.exit((TraceComponent)tc, (String)"forceSections");
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"537", (Object)this);
            if (!tc.isEntryEnabled()) throw new InternalLogException();
            Tr.exit((TraceComponent)tc, (String)"forceSections");
            throw new InternalLogException();
        }
        this._controlLock.getSharedLock();
        try {
            try {
                this._logHandle.force();
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"550", (Object)this);
                this._recLog.markFailed();
                if (!tc.isEntryEnabled()) throw internalLogException;
                Tr.exit((TraceComponent)tc, (String)"forceSections");
                throw internalLogException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"556", (Object)this);
                this._recLog.markFailed();
                if (!tc.isEntryEnabled()) throw new InternalLogException();
                Tr.exit((TraceComponent)tc, (String)"forceSections");
                throw new InternalLogException();
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                this._controlLock.releaseSharedLock();
                throw throwable;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"568", (Object)this);
                throw new InternalLogException();
            }
        }
        try {}
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"568", (Object)this);
            throw new InternalLogException();
        }
        this._controlLock.releaseSharedLock();
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"forceSections");
    }

    public LogCursor sections() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sections", (Object)this);
        }
        Collection collection = this._recoverableUnitSections.values();
        LogCursorImpl logCursorImpl = new LogCursorImpl(null, collection, false, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sections", (Object)logCursorImpl);
        }
        return logCursorImpl;
    }

    public long identity() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"identity", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"identity", (Object)new Long(this._identity));
        }
        return this._identity;
    }

    void recover(ReadableLogRecord readableLogRecord) throws LogCorruptedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object)new Object[]{this, readableLogRecord});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)this);
            }
            throw new InternalLogException();
        }
        try {
            int n = readableLogRecord.getInt();
            while (n != END_OF_SECTIONS) {
                RecoverableUnitSectionImpl recoverableUnitSectionImpl;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Recovering RecoverableUnitSection '" + n + "'"));
                }
                readableLogRecord.getShort();
                boolean bl = readableLogRecord.getBoolean();
                if (tc.isDebugEnabled()) {
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)"RecoverableUnitSection can hold only a single data item");
                    } else {
                        Tr.debug((TraceComponent)tc, (String)"RecoverableUnitSection can hold multiple data items");
                    }
                }
                if ((recoverableUnitSectionImpl = (RecoverableUnitSectionImpl)this._recoverableUnitSections.get(new Integer(n))) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("RecoverableUnitSection " + n + " has not been encountered before. Creating."));
                    }
                    try {
                        recoverableUnitSectionImpl = (RecoverableUnitSectionImpl)this.createSection(n, bl);
                    }
                    catch (RecoverableUnitSectionExistsException recoverableUnitSectionExistsException) {
                        FFDCFilter.processException((Throwable)recoverableUnitSectionExistsException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"713", (Object)this);
                    }
                    catch (InternalLogException internalLogException) {
                        FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"717", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"An unexpected exception occured when attempting to create a new RecoverableUnitSection");
                        }
                        throw internalLogException;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("RecoverableUnitSection " + n + " has been encountered before."));
                }
                recoverableUnitSectionImpl.recover(readableLogRecord);
                this._storedOnDisk = true;
                n = readableLogRecord.getInt();
            }
        }
        catch (LogCorruptedException logCorruptedException) {
            FFDCFilter.processException((Throwable)logCorruptedException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"740", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"A LogCorruptedException exception occured reconstructng a RecoverableUnitImpl");
            }
            this._recLog.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover");
            }
            throw logCorruptedException;
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"747", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An InternalLogException exception occured reconstructng a RecoverableUnitImpl");
            }
            this._recLog.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover");
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"753", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An exception occured reconstructng a RecoverableUnitImpl");
            }
            this._recLog.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover");
        }
    }

    /*
     * Unable to fully structure code
     */
    void remove() throws InternalLogException {
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)RecoverableUnitImpl.tc, (String)"remove", (Object)this);
        }
        if (this._recLog.failed()) {
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"remove", (Object)this);
            }
            throw new InternalLogException();
        }
        if (this._storedOnDisk) {
            try {
                if (RecoverableUnitImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)RecoverableUnitImpl.tc, (String)("Creating deletion record for recoverable unit '" + this._identity + "'"));
                }
                if ((var1_1 = this._logHandle.getWriteableLogRecord(14)) == null) ** GOTO lbl27
                var1_1.putInt(0);
                var1_1.putLong(this._identity);
                var1_1.putShort(RecoverableUnitImpl.RECORDTYPEDELETED);
                var1_1.close();
            }
            catch (Throwable var1_2) {
                FFDCFilter.processException((Throwable)var1_2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.remove", (String)"801", (Object)this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)RecoverableUnitImpl.tc, (String)"An unexpected error occurred whilst formatting the recovery log buffer");
                }
                this._recLog.markFailed();
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"remove");
                }
                throw new InternalLogException();
            }
        } else if (RecoverableUnitImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)RecoverableUnitImpl.tc, (String)("Not writing deletion record because RecoverableUnit '" + this._identity + "' is not on disk"));
        }
lbl27:
        // 5 sources

        if (this._unwrittenDataSize > 0) {
            this._recLog.payloadDeleted(this._totalDataSize + 42, this._unwrittenDataSize + 42);
        } else {
            this._recLog.payloadDeleted(this._totalDataSize + 42, this._unwrittenDataSize);
        }
        if (RecoverableUnitImpl.tc.isEventEnabled()) {
            Tr.event((TraceComponent)RecoverableUnitImpl.tc, (String)("Remove completed for recoverable unit " + this._identity + ". Clear internal state"));
        }
        this._recoverableUnitSections.clear();
        this._totalDataSize = 0;
        this._unwrittenDataSize = 0;
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"remove");
        }
    }

    protected void payloadAdded(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadAdded", (Object)new Object[]{this, new Integer(n), new Integer(n2)});
        }
        int n3 = n;
        int n4 = n2;
        if (this._unwrittenDataSize == 0) {
            n3 += 42;
        }
        if (this._totalDataSize == 0) {
            n4 += 42;
        }
        this._unwrittenDataSize += n;
        this._totalDataSize += n2;
        this._recLog.payloadAdded(n3, n4);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadAdded");
        }
    }

    protected void payloadWritten(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadWritten", (Object)new Object[]{this, new Integer(n)});
        }
        this._unwrittenDataSize -= n;
        if (this._unwrittenDataSize == 0) {
            this._recLog.payloadWritten(n + 42);
        } else {
            this._recLog.payloadWritten(n);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadWritten");
        }
    }

    protected void payloadDeleted(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadDeleted", (Object)new Object[]{this, new Integer(n), new Integer(n2)});
        }
        this._totalDataSize -= n;
        this._unwrittenDataSize -= n2;
        if (this._unwrittenDataSize == 0 && n2 != 0) {
            n2 += 42;
        }
        if (this._totalDataSize == 0) {
            n += 42;
        }
        this._recLog.payloadDeleted(n, n2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadDeleted");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

