/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.DataItem;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogHandle;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnitImpl;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryLogImpl;
import com.ibm.ws.recoverylog.spi.SingleDataItem;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.io.IOException;
import java.util.ArrayList;

public class RecoverableUnitSectionImpl
implements RecoverableUnitSection {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$recoverylog$spi$RecoverableUnitSectionImpl == null ? (class$com$ibm$ws$recoverylog$spi$RecoverableUnitSectionImpl = RecoverableUnitSectionImpl.class$("com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl")) : class$com$ibm$ws$recoverylog$spi$RecoverableUnitSectionImpl), (String)"Transaction", null);
    private static final int INITIAL_DATA_CAPACITY = 10;
    protected static short RECORDTYPENORMAL = 1;
    protected static short RECORDTYPEDELETED = (short)2;
    private static final int HEADER_SIZE = 11;
    private int _identity = 0;
    private ArrayList _unwrittenData = null;
    private ArrayList _writtenData = null;
    private boolean _singleData = false;
    private DataItem _lastDataItem = null;
    private Lock _controlLock = null;
    private LogHandle _logHandle = null;
    private long _recoverableUnitIdentity = 0L;
    private int _unwrittenDataSize = 0;
    private int _totalDataSize = 0;
    private RecoveryLogImpl _recLog = null;
    private RecoverableUnitImpl _recUnit = null;
    private int _storageMode = 1;
    static /* synthetic */ Class class$com$ibm$ws$recoverylog$spi$RecoverableUnitSectionImpl;

    RecoverableUnitSectionImpl(RecoveryLogImpl recoveryLogImpl, RecoverableUnitImpl recoverableUnitImpl, long l, int n, Lock lock, LogHandle logHandle, int n2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoverableUnitSectionImpl", (Object)new Object[]{this, recoveryLogImpl, recoverableUnitImpl, new Long(l), new Integer(n), lock, logHandle, new Integer(n2), new Boolean(bl)});
        }
        this._recLog = recoveryLogImpl;
        this._recoverableUnitIdentity = l;
        this._identity = n;
        this._controlLock = lock;
        this._logHandle = logHandle;
        this._singleData = bl;
        this._recUnit = recoverableUnitImpl;
        this._storageMode = n2;
        this._unwrittenData = new ArrayList(10);
        this._writtenData = new ArrayList(10);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoverableUnitSectionImpl");
        }
    }

    public void addData(byte[] byArray) throws InternalLogException {
        DataItem dataItem;
        if (tc.isEntryEnabled()) {
            if (byArray != null) {
                Tr.entry((TraceComponent)tc, (String)"addData", (Object)new Object[]{this, new Integer(this._identity), new Integer(byArray.length), RLSUtils.toHexString(byArray, 32)});
            } else {
                Tr.entry((TraceComponent)tc, (String)"addData", (Object)new Object[]{this, new Integer(this._identity), new Integer(0), "null"});
            }
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addData", (Object)this);
            }
            throw new InternalLogException();
        }
        this._controlLock.getSharedLock();
        if (this._singleData) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Section can hold only a single data item.");
            }
            if (this._writtenData.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is existing WRITTEN data. Updating data wrapper.");
                }
                dataItem = (SingleDataItem)this._writtenData.get(0);
                ((SingleDataItem)dataItem).setData(byArray);
                this._writtenData.clear();
                this._unwrittenData.add(0, dataItem);
                this._lastDataItem = dataItem;
            } else if (this._unwrittenData.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is existing UNWRITTEN data. Updating data wrapper.");
                }
                dataItem = (SingleDataItem)this._unwrittenData.get(0);
                ((SingleDataItem)dataItem).setData(byArray);
                this._lastDataItem = dataItem;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is no existing data. Creating data wrapper");
                }
                dataItem = new SingleDataItem(this._storageMode, byArray, this);
                this._unwrittenData.add(0, dataItem);
                this._lastDataItem = dataItem;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Section holds multiple data items");
            }
            dataItem = new DataItem(this._storageMode, byArray, this);
            this._unwrittenData.add(dataItem);
            this._lastDataItem = dataItem;
        }
        try {
            this._controlLock.releaseSharedLock();
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.addData", (String)"248", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addData");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addData");
        }
    }

    public void write() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object)new Object[]{this, new Integer(this._identity)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)this);
            }
            throw new InternalLogException();
        }
        this._controlLock.getSharedLock();
        if (this._unwrittenDataSize > 0) {
            try {
                this._recUnit.writeSection(this, this._unwrittenDataSize + 11);
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.write", (String)"473", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"write");
                }
                throw internalLogException;
            }
        }
        try {
            this._controlLock.releaseSharedLock();
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.write", (String)"344", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void force() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"force", (Object)new Object[]{this, new Integer(this._identity)});
        }
        if (this._recLog.failed()) {
            if (!tc.isEntryEnabled()) throw new InternalLogException();
            Tr.exit((TraceComponent)tc, (String)"force", (Object)this);
            throw new InternalLogException();
        }
        try {
            this.write();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.force", (String)"374", (Object)this);
            if (!tc.isEntryEnabled()) throw internalLogException;
            Tr.exit((TraceComponent)tc, (String)"force");
            throw internalLogException;
        }
        this._controlLock.getSharedLock();
        try {
            try {
                this._logHandle.force();
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.force", (String)"393", (Object)this);
                this._recLog.markFailed();
                if (!tc.isEntryEnabled()) throw internalLogException;
                Tr.exit((TraceComponent)tc, (String)"force");
                throw internalLogException;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                this._controlLock.releaseSharedLock();
                throw throwable;
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.force", (String)"405", (Object)this);
                throw new InternalLogException();
            }
        }
        try {}
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.force", (String)"405", (Object)this);
            throw new InternalLogException();
        }
        this._controlLock.releaseSharedLock();
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"force");
    }

    void format(boolean bl, WriteableLogRecord writeableLogRecord) throws IOException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"format", (Object)new Object[]{this, new Integer(this._identity), new Boolean(bl), writeableLogRecord});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"format", (Object)this);
            }
            throw new InternalLogException();
        }
        this._controlLock.getSharedLock();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this._writtenData != null) {
            n2 = this._writtenData.size();
        }
        if (this._unwrittenData != null) {
            n3 = this._unwrittenData.size();
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Section has '" + n3 + "' unwritten data items and '" + n2 + "' written data items to write"));
            }
            n = n3 + n2;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Section has '" + n3 + "' unwritten data items and '0' written data items to write"));
            }
            n = n3;
        }
        if (n > 0) {
            int n4;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing section identity '" + this._identity + "'"));
            }
            writeableLogRecord.putInt(this._identity);
            writeableLogRecord.putShort(RECORDTYPENORMAL);
            writeableLogRecord.putBoolean(this._singleData);
            writeableLogRecord.putInt(n);
            if (bl) {
                for (n4 = 0; n4 < n2; ++n4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Writing written data item '" + n4 + "'"));
                    }
                    ((DataItem)this._writtenData.get(n4)).write(writeableLogRecord);
                }
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Writing unwritten data item '" + n4 + "'"));
                }
                DataItem dataItem = (DataItem)this._unwrittenData.get(n4);
                dataItem.write(writeableLogRecord);
                this._writtenData.add(dataItem);
            }
            if (n3 > 0) {
                this._unwrittenData.clear();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RecoverableUnitSectionImpl '" + this._identity + "' has no data to format"));
        }
        try {
            this._controlLock.releaseSharedLock();
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.format", (String)"555", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"format - exception");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"format");
        }
    }

    public LogCursor data() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"data", (Object)new Object[]{this, new Integer(this._identity)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"data", (Object)this);
            }
            throw new InternalLogException();
        }
        this._controlLock.getSharedLock();
        if (tc.isEventEnabled()) {
            int n = 0;
            int n2 = 0;
            if (this._writtenData != null) {
                n = this._writtenData.size();
            }
            if (this._unwrittenData != null) {
                n2 = this._unwrittenData.size();
            }
            Tr.event((TraceComponent)tc, (String)("#writtenDataBlocks = " + n + " #unwrittenDataBlocks = " + n2));
        }
        LogCursorImpl logCursorImpl = null;
        logCursorImpl = this._singleData ? (this._writtenData.size() > 0 ? new LogCursorImpl(null, ((DataItem)this._writtenData.get(0)).getData()) : new LogCursorImpl(null, ((DataItem)this._unwrittenData.get(0)).getData())) : new LogCursorImpl(null, this._writtenData, this._unwrittenData, false, null);
        try {
            this._controlLock.releaseSharedLock();
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.data", (String)"636", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"data");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"data", (Object)new Integer(logCursorImpl.initialSize()));
        }
        return logCursorImpl;
    }

    public int identity() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"identity", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"identity", (Object)new Integer(this._identity));
        }
        return this._identity;
    }

    void recover(ReadableLogRecord readableLogRecord) throws LogCorruptedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object)this);
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)this);
            }
            throw new InternalLogException();
        }
        try {
            int n = readableLogRecord.getInt();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Recovering '" + n + "' data items"));
            }
            for (int i = 0; i < n; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Recovering data item '" + i + "'"));
                }
                DataItem dataItem = null;
                if (this._singleData) {
                    dataItem = new SingleDataItem(this._storageMode, readableLogRecord, this);
                    this._writtenData.add(0, dataItem);
                } else {
                    dataItem = new DataItem(this._storageMode, readableLogRecord, this);
                    this._writtenData.add(dataItem);
                }
                this._lastDataItem = dataItem;
            }
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.recover", (String)"732", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An InternalLogException occured reconstructng a RecoverableUnitSectionImpl");
            }
            this._recLog.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover");
            }
            throw new LogCorruptedException();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.recover", (String)"739", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An exception occured reconstructng a RecoverableUnitSectionImpl");
            }
            this._recLog.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover");
        }
    }

    public byte[] lastData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lastData", (Object)this);
        }
        byte[] byArray = null;
        if (this._lastDataItem != null) {
            byArray = this._lastDataItem.getData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lastData", (Object)RLSUtils.toHexString(byArray, 32));
        }
        return byArray;
    }

    protected void payloadAdded(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadAdded", (Object)new Object[]{this, new Integer(n)});
        }
        int n2 = n;
        int n3 = n;
        if (this._unwrittenDataSize == 0) {
            n2 += 11;
        }
        if (this._totalDataSize == 0) {
            n3 += 11;
        }
        this._unwrittenDataSize += n;
        this._totalDataSize += n;
        this._recUnit.payloadAdded(n2, n3);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadAdded");
        }
    }

    protected void payloadWritten(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadWritten", (Object)new Object[]{this, new Integer(n)});
        }
        this._unwrittenDataSize -= n;
        if (this._unwrittenDataSize == 0) {
            this._recUnit.payloadWritten(n + 11);
        } else {
            this._recUnit.payloadWritten(n);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadWritten");
        }
    }

    protected void payloadDeleted(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadDeleted", (Object)new Object[]{this, new Integer(n), new Integer(n2)});
        }
        this._totalDataSize -= n;
        this._unwrittenDataSize -= n2;
        if (this._unwrittenDataSize == 0 && n2 != 0) {
            n2 += 11;
        }
        if (this._totalDataSize == 0) {
            n += 11;
        }
        this._recUnit.payloadDeleted(n, n2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadDeleted");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

