/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.ConflictingCredentialsException;
import com.ibm.ws.recoverylog.spi.DistributedFailureScope;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InvalidFailureScopeException;
import com.ibm.ws.recoverylog.spi.InvalidStateException;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.RecoveryLogManagerImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

public class RecoveryDirectorImpl
implements RecoveryDirector {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$recoverylog$spi$RecoveryDirectorImpl == null ? (class$com$ibm$ws$recoverylog$spi$RecoveryDirectorImpl = RecoveryDirectorImpl.class$("com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl")) : class$com$ibm$ws$recoverylog$spi$RecoveryDirectorImpl), (String)"Transaction", null);
    private static RecoveryDirectorImpl _instance = null;
    private TreeMap _registeredRecoveryAgents = null;
    private HashMap _outstandingRecoveryRecords = null;
    private boolean _registrationAllowed = true;
    private FailureScope _currentFailureScope = null;
    private boolean _localRecoveryComplete = false;
    static /* synthetic */ Class class$com$ibm$ws$recoverylog$spi$RecoveryDirectorImpl;

    private RecoveryDirectorImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoveryDirectorImpl");
        }
        this._registeredRecoveryAgents = new TreeMap();
        this._outstandingRecoveryRecords = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoveryDirectorImpl");
        }
    }

    public static synchronized RecoveryDirector instance() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"instance");
        }
        if (_instance == null) {
            _instance = new RecoveryDirectorImpl();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"instance", (Object)_instance);
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryLogManager registerService(RecoveryAgent recoveryAgent, int n) throws ConflictingCredentialsException, InvalidStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerService", (Object)new Object[]{recoveryAgent, new Integer(n)});
        }
        RecoveryLogManagerImpl recoveryLogManagerImpl = null;
        TreeMap treeMap = this._registeredRecoveryAgents;
        synchronized (treeMap) {
            ArrayList arrayList;
            Serializable serializable;
            if (!this._registrationAllowed) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Client service registration attempted after recovery processing has been driven");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"registerService");
                }
                throw new InvalidStateException();
            }
            int n2 = recoveryAgent.clientIdentifier();
            String string = recoveryAgent.clientName();
            Collection collection = this._registeredRecoveryAgents.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                serializable = (ArrayList)iterator.next();
                arrayList = serializable.iterator();
                while (arrayList.hasNext()) {
                    RecoveryAgent recoveryAgent2 = (RecoveryAgent)arrayList.next();
                    if (recoveryAgent2.clientIdentifier() != n2 && !recoveryAgent2.clientName().equals(string)) continue;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Client service registration attempted with non-unique identity or name");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"registerService");
                    }
                    throw new ConflictingCredentialsException();
                }
            }
            serializable = new Integer(n);
            arrayList = (ArrayList)this._registeredRecoveryAgents.get(serializable);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this._registeredRecoveryAgents.put(serializable, arrayList);
            }
            arrayList.add(recoveryAgent);
            recoveryLogManagerImpl = new RecoveryLogManagerImpl(recoveryAgent);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("New service '" + string + "' (" + n2 + ") registered with RecoveryDirectorImpl"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerService", (Object)recoveryLogManagerImpl);
        }
        return recoveryLogManagerImpl;
    }

    public void recoveryComplete(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object)new Object[]{recoveryAgent.clientName(), failureScope});
        }
        if (!(bl = this.removeRecoveryRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The supplied FailureScope was not recognized as outstaning work for this RecoveryAgent");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
            }
            throw new InvalidFailureScopeException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FailureScope currentFailureScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"currentFailureScope");
        }
        RecoveryDirectorImpl recoveryDirectorImpl = this;
        synchronized (recoveryDirectorImpl) {
            if (this._currentFailureScope == null) {
                this._currentFailureScope = new DistributedFailureScope();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"currentFailureScope", (Object)this._currentFailureScope);
        }
        return this._currentFailureScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void directRecovery(FailureScope failureScope) throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"directRecovery", (Object)failureScope);
        }
        Object object = this._registeredRecoveryAgents;
        synchronized (object) {
            this._registrationAllowed = false;
        }
        object = this._registeredRecoveryAgents.values();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList = (ArrayList)iterator.next();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                RecoveryAgent recoveryAgent = (RecoveryAgent)iterator2.next();
                this.addRecoveryRecord(recoveryAgent, failureScope);
                try {
                    recoveryAgent.initiateRecovery(failureScope);
                }
                catch (RecoveryFailedException recoveryFailedException) {
                    FFDCFilter.processException((Throwable)recoveryFailedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directRecovery", (String)"405", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"directRecovery");
                    }
                    throw recoveryFailedException;
                }
                HashMap hashMap = this._outstandingRecoveryRecords;
                synchronized (hashMap) {
                    while (this.recoveryOutstanding(recoveryAgent, failureScope)) {
                        try {
                            this._outstandingRecoveryRecords.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directRecovery", (String)"429", (Object)this);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"directRecovery");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecoveryRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addRecoveryRecord", (Object)new Object[]{recoveryAgent.clientName(), failureScope});
        }
        HashMap hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> hashSet = (HashSet<FailureScope>)this._outstandingRecoveryRecords.get(recoveryAgent);
            if (hashSet == null) {
                hashSet = new HashSet<FailureScope>();
                this._outstandingRecoveryRecords.put(recoveryAgent, hashSet);
            }
            hashSet.add(failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addRecoveryRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeRecoveryRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoveryRecord", (Object)new Object[]{recoveryAgent.clientName(), failureScope});
        }
        boolean bl = false;
        HashMap hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet hashSet = (HashSet)this._outstandingRecoveryRecords.get(recoveryAgent);
            if (hashSet != null) {
                bl = hashSet.remove(failureScope);
            }
            this._outstandingRecoveryRecords.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoveryRecord", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recoveryOutstanding(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryOutstanding", (Object)new Object[]{recoveryAgent.clientName(), failureScope});
        }
        boolean bl = false;
        HashMap hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet hashSet = (HashSet)this._outstandingRecoveryRecords.get(recoveryAgent);
            if (hashSet != null) {
                bl = hashSet.contains(failureScope);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryOutstanding", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void driveLocalRecovery() throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"driveLocalRecovery");
        }
        RecoveryDirectorImpl recoveryDirectorImpl = this;
        synchronized (recoveryDirectorImpl) {
            if (this._currentFailureScope == null) {
                this._currentFailureScope = new DistributedFailureScope();
            }
        }
        if (!this._localRecoveryComplete) {
            try {
                this.directRecovery(this._currentFailureScope);
            }
            catch (RecoveryFailedException recoveryFailedException) {
                FFDCFilter.processException((Throwable)recoveryFailedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.driveLocalRecovery", (String)"605", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"driveLocalRecovery");
                }
                throw recoveryFailedException;
            }
            this._localRecoveryComplete = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"driveLocalRecovery");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

