/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.DistributedFailureScope;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.HoldingExclusiveLockException;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorCallback;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogFullException;
import com.ibm.ws.recoverylog.spi.LogHandle;
import com.ibm.ws.recoverylog.spi.LogOpenException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.NoExclusiveLockException;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitExistsException;
import com.ibm.ws.recoverylog.spi.RecoverableUnitImpl;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.utils.RecoverableUnitIdTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class RecoveryLogImpl
implements DistributedRecoveryLog,
LogCursorCallback {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$recoverylog$spi$RecoveryLogImpl == null ? (class$com$ibm$ws$recoverylog$spi$RecoveryLogImpl = RecoveryLogImpl.class$("com.ibm.ws.recoverylog.spi.RecoveryLogImpl")) : class$com$ibm$ws$recoverylog$spi$RecoveryLogImpl), (String)"Transaction", null);
    private static int DEFAULT_LOGFILE_SIZE = 1024;
    private static final int MIN_LOGFILE_SIZE = 8;
    protected static final int MEMORY_BACKED = 1;
    protected static final int FILE_BACKED = 2;
    protected static final int IN_MEMORY_MAXIMUM = 5120;
    private static float TOTAL_DATA_RESIZE_TRIGGER = 0.95f;
    private static float TOTAL_DATA_RESIZE_MULTIPLIER = 1.25f;
    private RecoveryAgent _recoveryAgent = null;
    private DistributedFailureScope _failureScope = null;
    private String _clientName = null;
    private String _logName = null;
    private int _logIdentifier = 0;
    private String _serverName = null;
    private String _logDirectory = null;
    private int _logFileSize = 0;
    private int _maxLogFileSize = 0;
    private HashMap _recoverableUnits = null;
    private LogHandle _logHandle = null;
    private Lock _controlLock = null;
    private int _closesRequired = 0;
    private static String _fileSeparator = null;
    private FileLogProperties _fileLogProperties = null;
    private int _unwrittenDataSize = 0;
    private int _totalDataSize = 0;
    private int _storageMode = 1;
    private boolean _failed = false;
    private RecoverableUnitIdTable _recUnitIdTable = new RecoverableUnitIdTable();
    static /* synthetic */ Class class$com$ibm$ws$recoverylog$spi$RecoveryLogImpl;

    RecoveryLogImpl(FailureScope failureScope, FileLogProperties fileLogProperties, RecoveryAgent recoveryAgent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoveryLogImpl", (Object)new Object[]{this, failureScope, fileLogProperties, recoveryAgent});
        }
        this._failureScope = (DistributedFailureScope)failureScope;
        this._fileLogProperties = fileLogProperties;
        this._recoveryAgent = recoveryAgent;
        this._logName = this._fileLogProperties.logName();
        this._logIdentifier = this._fileLogProperties.logIdentifier();
        this._logDirectory = this._fileLogProperties.logDirectory();
        this._logFileSize = this._fileLogProperties.logFileSize();
        this._maxLogFileSize = this._fileLogProperties.maxLogFileSize();
        this._clientName = recoveryAgent.clientName();
        this._serverName = this._failureScope.serverName();
        if (_fileSeparator == null) {
            _fileSeparator = System.getProperty("file.separator");
        }
        if (this._logDirectory == null) {
            this._logDirectory = Configuration.WASInstallDirectory() + _fileSeparator + "recoveryLogs" + _fileSeparator + Configuration.serverName() + _fileSeparator + this._clientName + _fileSeparator + this._logName;
        }
        if (this._logFileSize == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using default values for log file size and maximum size");
            }
            this._logFileSize = DEFAULT_LOGFILE_SIZE;
            this._maxLogFileSize = DEFAULT_LOGFILE_SIZE;
        }
        if (this._logFileSize < 8) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Log file size is too small. Enforcing minimum size");
            }
            this._logFileSize = 8;
        }
        if (this._maxLogFileSize < 8) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Log file maximum size is too small. Enforcing minimum size");
            }
            this._maxLogFileSize = 8;
        }
        if (this._logFileSize > this._maxLogFileSize) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Log file size is greater than maximum. Constraining log file size");
            }
            this._logFileSize = this._maxLogFileSize;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Log file size is " + this._logFileSize + " kbytes. Log maximum size is " + this._maxLogFileSize + " kbytes"));
        }
        this._controlLock = new Lock();
        if (this._maxLogFileSize >= 5120) {
            this._storageMode = 2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using a 'retain only on disk' model for forced log data");
            }
        } else {
            this._storageMode = 1;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using a 'retain in memory' model for forced log data");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoveryLogImpl");
        }
    }

    public synchronized void openLog() throws LogCorruptedException, LogAllocationException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"openLog", (Object)this);
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)this);
            }
            throw new InternalLogException();
        }
        if (this._logHandle == null) {
            this._logHandle = new LogHandle(this, this._clientName, this._serverName, this._logName, this._logDirectory, this._logFileSize, this._maxLogFileSize);
            this._recoverableUnits = new HashMap();
            try {
                this._logHandle.openLog();
            }
            catch (LogOpenException logOpenException) {
                FFDCFilter.processException((Throwable)logOpenException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.openLog", (String)"257", (Object)this);
                this.markFailed();
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog");
                }
                throw new InternalLogException();
            }
            catch (LogCorruptedException logCorruptedException) {
                FFDCFilter.processException((Throwable)logCorruptedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.openLog", (String)"265", (Object)this);
                this.markFailed();
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog");
                }
                throw logCorruptedException;
            }
            catch (LogAllocationException logAllocationException) {
                FFDCFilter.processException((Throwable)logAllocationException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.openLog", (String)"273", (Object)this);
                this.markFailed();
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog");
                }
                throw logAllocationException;
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.openLog", (String)"281", (Object)this);
                this.markFailed();
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog");
                }
                throw internalLogException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.openLog", (String)"289", (Object)this);
                this.markFailed();
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog");
                }
                throw new InternalLogException();
            }
            ArrayList arrayList = this._logHandle.recoveredRecords();
            if (arrayList != null && arrayList.size() > 0) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("RecoveryLogImpl " + this._logName + " contains " + arrayList.size() + " records to recover"));
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        RecoverableUnitImpl recoverableUnitImpl;
                        short s;
                        ReadableLogRecord readableLogRecord = (ReadableLogRecord)arrayList.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovering record " + i));
                        }
                        readableLogRecord.getInt();
                        long l = readableLogRecord.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Record relates to RecoverableUnit '" + l + "'"));
                        }
                        if ((s = readableLogRecord.getShort()) == RecoverableUnitImpl.RECORDTYPEDELETED) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"This is a DELETION record. Deleting RecoverableUnit from map");
                            }
                            this._recoverableUnits.remove(new Long(l));
                            this._recUnitIdTable.removeId(l);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This is a NORMAL record. Decoding contents");
                        }
                        if ((recoverableUnitImpl = (RecoverableUnitImpl)this._recoverableUnits.get(new Long(l))) == null) {
                            recoverableUnitImpl = new RecoverableUnitImpl(this, l, this._logHandle, this._storageMode, this._controlLock);
                            this._recoverableUnits.put(new Long(l), recoverableUnitImpl);
                            this._recUnitIdTable.reserveId(l, (Object)recoverableUnitImpl);
                        }
                        recoverableUnitImpl.recover(readableLogRecord);
                    }
                }
                catch (LogCorruptedException logCorruptedException) {
                    FFDCFilter.processException((Throwable)logCorruptedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.openLog", (String)"369", (Object)this);
                    this.markFailed();
                    this._logHandle = null;
                    this._recoverableUnits = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"A LogCorruptedException exception occured when reconstructng a RecoverableUnit");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"openLog");
                    }
                    throw logCorruptedException;
                }
                catch (InternalLogException internalLogException) {
                    FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.openLog", (String)"378", (Object)this);
                    this.markFailed();
                    this._logHandle = null;
                    this._recoverableUnits = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"An InternalLogException exception occured when reconstructng a RecoverableUnit");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"openLog");
                    }
                    throw internalLogException;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.openLog", (String)"387", (Object)this);
                    this.markFailed();
                    this._logHandle = null;
                    this._recoverableUnits = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"An exception occured reconstructng a RecoverableUnit");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"openLog");
                    }
                    throw new InternalLogException();
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("RecoveryLogImpl " + this._logName + " is empty"));
            }
        }
        ++this._closesRequired;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)new Integer(this._closesRequired));
        }
    }

    public byte[] serviceData() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serviceData", (Object)this);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serviceData");
            }
            throw new LogClosedException();
        }
        byte[] byArray = null;
        try {
            byArray = this._logHandle.getServiceData();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.serviceData", (String)"445", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serviceData");
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.serviceData", (String)"451", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serviceData");
            }
            throw new InternalLogException();
        }
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        if (tc.isEntryEnabled()) {
            if (byArray2 != null) {
                Tr.exit((TraceComponent)tc, (String)"serviceData", (Object)RLSUtils.toHexString(byArray2, 32));
            } else {
                Tr.exit((TraceComponent)tc, (String)"serviceData", (Object)"null");
            }
        }
        return byArray2;
    }

    public void recoveryComplete() throws LogClosedException, InternalLogException {
        Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object)this);
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)this);
            }
            throw new InternalLogException();
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
            }
            throw new LogClosedException();
        }
        try {
            this.keypoint();
        }
        catch (LogClosedException logClosedException) {
            FFDCFilter.processException((Throwable)logClosedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.recoveryComplete", (String)"618", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
            }
            throw logClosedException;
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.recoveryComplete", (String)"624", (Object)this);
            this.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.recoveryComplete", (String)"630", (Object)this);
            this.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    public void recoveryComplete(byte[] byArray) throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            if (byArray != null) {
                Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object)new Object[]{this, RLSUtils.toHexString(byArray, 32)});
            } else {
                Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object)new Object[]{this, "null"});
            }
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)this);
            }
            throw new InternalLogException();
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
            }
            throw new LogClosedException();
        }
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        try {
            this._logHandle.setServiceData(byArray2);
            this.keypoint();
        }
        catch (LogClosedException logClosedException) {
            FFDCFilter.processException((Throwable)logClosedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.recoveryComplete", (String)"551", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
            }
            throw logClosedException;
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.recoveryComplete", (String)"530", (Object)this);
            this.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.recoveryComplete", (String)"567", (Object)this);
            this.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    public void closeLog(byte[] byArray) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            if (byArray != null) {
                Tr.entry((TraceComponent)tc, (String)"closeLog", (Object)new Object[]{this, RLSUtils.toHexString(byArray, 32)});
            } else {
                Tr.entry((TraceComponent)tc, (String)"closeLog", (Object)new Object[]{this, "null"});
            }
        }
        if (this._logHandle != null) {
            try {
                this._logHandle.setServiceData(byArray);
                this.closeLog();
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.closeLog", (String)"682", (Object)this);
                this.markFailed();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"closeLog");
                }
                throw internalLogException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.closeLog", (String)"688", (Object)this);
                this.markFailed();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"closeLog");
                }
                throw new InternalLogException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLog() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLog", (Object)this);
        }
        if (this._logHandle != null) {
            if (!this.failed()) {
                try {
                    this.keypoint();
                }
                catch (LogClosedException logClosedException) {
                    FFDCFilter.processException((Throwable)logClosedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.closeLog", (String)"731", (Object)this);
                }
                catch (InternalLogException internalLogException) {
                    FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.closeLog", (String)"735", (Object)this);
                    this.markFailed();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"closeLog");
                    }
                    throw internalLogException;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.closeLog", (String)"741", (Object)this);
                    this.markFailed();
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"closeLog");
                    }
                    throw new InternalLogException();
                }
            }
            RecoveryLogImpl recoveryLogImpl = this;
            synchronized (recoveryLogImpl) {
                --this._closesRequired;
                if (this._closesRequired <= 0) {
                    try {
                        this._logHandle.closeLog();
                    }
                    catch (InternalLogException internalLogException) {
                        FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.closeLog", (String)"753", (Object)this);
                        this.markFailed();
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"closeLog");
                        }
                        throw internalLogException;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.closeLog", (String)"759", (Object)this);
                        this.markFailed();
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"closeLog");
                        }
                        throw new InternalLogException();
                    }
                    this._logHandle = null;
                    this._recoverableUnits = null;
                    this._closesRequired = 0;
                    this._unwrittenDataSize = 0;
                    this._totalDataSize = 0;
                    this._failed = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)new Integer(this._closesRequired));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoverableUnit createRecoverableUnit() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoverableUnit");
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)this);
            }
            throw new InternalLogException();
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit");
            }
            throw new LogClosedException();
        }
        RecoverableUnitImpl recoverableUnitImpl = null;
        this._controlLock.getSharedLock();
        RecoveryLogImpl recoveryLogImpl = this;
        synchronized (recoveryLogImpl) {
            long l = this._recUnitIdTable.nextId((Object)this);
            recoverableUnitImpl = new RecoverableUnitImpl(this, l, this._logHandle, this._storageMode, this._controlLock);
            this._recoverableUnits.put(new Long(l), recoverableUnitImpl);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("RecoveryLogImpl '" + this._logName + "' created a new RecoverableUnit with id '" + l + "'"));
            }
        }
        try {
            this._controlLock.releaseSharedLock();
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.createRecoverableUnit", (String)"833", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit");
            }
            throw new InternalLogException();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.createRecoverableUnit", (String)"839", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)recoverableUnitImpl);
        }
        return recoverableUnitImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoverableUnit createRecoverableUnit(long l) throws LogClosedException, RecoverableUnitExistsException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoverableUnit", (Object)new Object[]{this, new Long(l)});
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)this);
            }
            throw new InternalLogException();
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit");
            }
            throw new LogClosedException();
        }
        Long l2 = new Long(l);
        RecoverableUnitImpl recoverableUnitImpl = null;
        this._controlLock.getSharedLock();
        RecoveryLogImpl recoveryLogImpl = this;
        synchronized (recoveryLogImpl) {
            if (!this._recoverableUnits.containsKey(l2)) {
                recoverableUnitImpl = new RecoverableUnitImpl(this, l, this._logHandle, this._storageMode, this._controlLock);
                this._recoverableUnits.put(l2, recoverableUnitImpl);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("RecoveryLogImpl '" + this._logName + "' created a new RecoverableUnit with id '" + l + "'"));
                }
            } else if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("RecoveryLogImpl '" + this._logName + "' was unable to create a RecoverableUnit with id '" + l + "' as it already exists"));
            }
        }
        try {
            this._controlLock.releaseSharedLock();
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.createRecoverableUnit", (String)"833", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit");
            }
            throw new InternalLogException();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.createRecoverableUnit", (String)"839", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit");
            }
            throw new InternalLogException();
        }
        if (recoverableUnitImpl == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit");
            }
            throw new RecoverableUnitExistsException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)recoverableUnitImpl);
        }
        return recoverableUnitImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecoverableUnit(long l) throws LogClosedException, InvalidRecoverableUnitException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)new Object[]{this, new Long(l)});
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)this);
            }
            throw new InternalLogException();
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit");
            }
            throw new LogClosedException();
        }
        this._controlLock.getSharedLock();
        RecoverableUnitImpl recoverableUnitImpl = null;
        RecoveryLogImpl recoveryLogImpl = this;
        synchronized (recoveryLogImpl) {
            recoverableUnitImpl = (RecoverableUnitImpl)this._recoverableUnits.remove(new Long(l));
        }
        if (recoverableUnitImpl == null) {
            try {
                this._controlLock.releaseSharedLock();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.removeRecoverableUnit", (String)"1054", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit");
            }
            throw new InvalidRecoverableUnitException();
        }
        this._recUnitIdTable.removeId(recoverableUnitImpl.identity());
        try {
            recoverableUnitImpl.remove();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.removeRecoverableUnit", (String)"944", (Object)this);
            this.markFailed();
            try {
                this._controlLock.releaseSharedLock();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.removeRecoverableUnit", (String)"954", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit");
            }
            throw internalLogException;
        }
        try {
            this._controlLock.releaseSharedLock();
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.removeRecoverableUnit", (String)"971", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit");
            }
            throw new InternalLogException();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.removeRecoverableUnit", (String)"977", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoverableUnit lookupRecoverableUnit(long l) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object)new Object[]{this, new Long(l)});
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"lookupRecoverableUnit");
            }
            throw new LogClosedException();
        }
        RecoverableUnit recoverableUnit = null;
        RecoveryLogImpl recoveryLogImpl = this;
        synchronized (recoveryLogImpl) {
            recoverableUnit = (RecoverableUnit)this._recoverableUnits.get(new Long(l));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object)recoverableUnit);
        }
        return recoverableUnit;
    }

    public LogCursor recoverableUnits() throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverableUnits", (Object)this);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoverableUnits");
            }
            throw new LogClosedException();
        }
        Collection collection = this._recoverableUnits.values();
        LogCursorImpl logCursorImpl = new LogCursorImpl(this._controlLock, collection, true, this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)logCursorImpl);
        }
        return logCursorImpl;
    }

    public LogProperties logProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logProperties", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logProperties", (Object)this._fileLogProperties);
        }
        return this._fileLogProperties;
    }

    protected void keypoint() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypoint", (Object)this);
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)this);
            }
            throw new InternalLogException();
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint");
            }
            throw new LogClosedException();
        }
        boolean bl = false;
        try {
            bl = this._controlLock.attemptExclusiveLock();
        }
        catch (HoldingExclusiveLockException holdingExclusiveLockException) {
            FFDCFilter.processException((Throwable)holdingExclusiveLockException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1099", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The keypoint operation has triggered a keypoint operation.");
            }
            this.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint");
            }
            throw new InternalLogException();
        }
        if (bl) {
            int n;
            try {
                this._logHandle.keypointStarting();
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1118", (Object)this);
                this.markFailed();
                try {
                    this._controlLock.releaseExclusiveLock();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1153", (Object)this);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"keypoint");
                }
                throw internalLogException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1124", (Object)this);
                this.markFailed();
                try {
                    this._controlLock.releaseExclusiveLock();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1153", (Object)this);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"keypoint");
                }
                throw new InternalLogException();
            }
            if (tc.isDebugEnabled()) {
                n = this._logHandle.getFreeSpace();
                Tr.debug((TraceComponent)tc, (String)("Recovery log contains " + this._totalDataSize + " payload bytes"));
                Tr.debug((TraceComponent)tc, (String)("Target keypoint file has " + n + " available free bytes"));
                Tr.debug((TraceComponent)tc, (String)("Resize trigger constant is " + TOTAL_DATA_RESIZE_TRIGGER));
                Tr.debug((TraceComponent)tc, (String)("Resize trigger value is " + (float)n * TOTAL_DATA_RESIZE_TRIGGER + " bytes"));
            }
            if ((float)this._totalDataSize > (float)this._logHandle.getFreeSpace() * TOTAL_DATA_RESIZE_TRIGGER) {
                n = Math.min((int)((float)this._totalDataSize * TOTAL_DATA_RESIZE_MULTIPLIER), this._maxLogFileSize * 1024);
                if (n < this._totalDataSize) {
                    this.markFailed();
                    try {
                        this._controlLock.releaseExclusiveLock();
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1153", (Object)this);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)"LogFullException");
                    }
                    throw new LogFullException();
                }
                this._logHandle.resizeLog(n);
            }
            Collection collection = this._recoverableUnits.values();
            Iterator iterator = collection.iterator();
            try {
                while (iterator.hasNext()) {
                    RecoverableUnitImpl recoverableUnitImpl = (RecoverableUnitImpl)iterator.next();
                    recoverableUnitImpl.writeSections(true);
                }
                this._logHandle.keypoint();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1145", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception caught performing keypoint", (Object)throwable);
                }
                this.markFailed();
                try {
                    this._controlLock.releaseExclusiveLock();
                }
                catch (Throwable throwable3) {
                    FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1153", (Object)this);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"keypoint");
                }
                throw new InternalLogException();
            }
            try {
                this._controlLock.releaseExclusiveLock();
            }
            catch (NoExclusiveLockException noExclusiveLockException) {
                FFDCFilter.processException((Throwable)noExclusiveLockException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1168", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"keypoint");
                }
                throw new InternalLogException();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1174", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"keypoint");
                }
                throw new InternalLogException();
            }
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)this);
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypoint");
        }
    }

    public void removing(Object object) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removing", (Object)object);
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)this);
            }
            throw new InternalLogException();
        }
        try {
            ((RecoverableUnitImpl)object).remove();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.removing", (String)"1434", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst removing a RecoverableUnit");
            }
            this.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing");
            }
            throw internalLogException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.removing", (String)"1321", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst removing a RecoverableUnit");
            }
            this.markFailed();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing");
            }
            throw new InternalLogException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removing");
        }
    }

    protected void payloadAdded(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadAdded", (Object)new Object[]{this, new Integer(n), new Integer(n2)});
        }
        this._unwrittenDataSize += n;
        this._totalDataSize += n2;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadAdded");
        }
    }

    protected void payloadWritten(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadWritten", (Object)new Object[]{this, new Integer(n)});
        }
        this._unwrittenDataSize -= n;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadWritten");
        }
    }

    protected void payloadDeleted(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadDeleted", (Object)new Object[]{this, new Integer(n), new Integer(n2)});
        }
        this._totalDataSize -= n;
        this._unwrittenDataSize -= n2;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadDeleted");
        }
    }

    protected boolean failed() {
        if (tc.isDebugEnabled() && this._failed) {
            Tr.debug((TraceComponent)tc, (String)("RecoeryLog has been marked as failed. [" + this + " " + this._logIdentifier + " " + this._clientName + "]"));
        }
        return this._failed;
    }

    protected synchronized void markFailed() {
        if (tc.isDebugEnabled() && !this._failed) {
            Tr.debug((TraceComponent)tc, (String)("Recovery log is being marked as failed. [" + this + " " + this._logIdentifier + " " + this._clientName + "]"));
        }
        this._failed = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

