/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product;

import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.formatters.HTMLPrintFormatter;
import com.ibm.websphere.product.formatters.PrintFormatter;
import com.ibm.websphere.product.formatters.TextPrintFormatter;
import com.ibm.websphere.product.history.WASHistory;
import com.ibm.websphere.product.history.xml.aparInfo;
import com.ibm.websphere.product.history.xml.componentApplied;
import com.ibm.websphere.product.history.xml.componentUpdate;
import com.ibm.websphere.product.history.xml.componentVersion;
import com.ibm.websphere.product.history.xml.customProperty;
import com.ibm.websphere.product.history.xml.efixApplied;
import com.ibm.websphere.product.history.xml.efixDriver;
import com.ibm.websphere.product.history.xml.efixPrereq;
import com.ibm.websphere.product.history.xml.enumUpdateType;
import com.ibm.websphere.product.history.xml.includedEFix;
import com.ibm.websphere.product.history.xml.platformPrereq;
import com.ibm.websphere.product.history.xml.productPrereq;
import com.ibm.websphere.product.history.xml.ptfApplied;
import com.ibm.websphere.product.history.xml.ptfDriver;
import com.ibm.websphere.product.xml.CalendarUtil;
import com.ibm.websphere.product.xml.component.component;
import com.ibm.websphere.product.xml.efix.efix;
import com.ibm.websphere.product.xml.efix.ptf;
import com.ibm.websphere.product.xml.extension.extension;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.websphere.product.xml.websphere.websphere;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Vector;
import org.xml.sax.SAXParseException;

public class VersionInfo {
    public static final String pgmVersion = "1.15.2.1";
    public static final String pgmUpdate = "4/28/04";
    public static final String TEXT_MODE = "text";
    public static final String HTML_MODE = "html";
    public static final String DEFAULT_REPORT_MODE = "text";
    protected boolean printStack;
    protected WASProduct wasProduct;
    protected WASHistory wasHistory;
    protected PrintFormatter formatter;
    protected boolean displayEFixes;
    protected boolean displayEFixDetail;
    protected boolean displayPTFs;
    protected boolean displayPTFDetail;
    protected boolean displayComponents;
    protected boolean displayComponentDetail;
    protected boolean isText;

    protected static String getDefaultedString(String string, String string2) {
        if (WASProduct.msgs == null) {
            return string2;
        }
        try {
            return WASProduct.msgs.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    protected static String getDefaultedString(String string, String string2, Object[] objectArray) {
        String string3 = VersionInfo.getDefaultedString(string, string2);
        return MessageFormat.format(string3, objectArray);
    }

    protected static String getString(String string) {
        return WASProduct.getString(string);
    }

    protected static String getString(String string, Object object) {
        return WASProduct.getString(string, object);
    }

    protected static String getString(String string, Object object, Object object2) {
        return WASProduct.getString(string, object, object2);
    }

    protected static String getString(String string, Object[] objectArray) {
        return WASProduct.getString(string, objectArray);
    }

    protected static void handleRecoverableErrors(Iterator iterator, PrintStream printStream, boolean bl) {
        while (iterator.hasNext()) {
            SAXParseException sAXParseException = (SAXParseException)iterator.next();
            String string = VersionInfo.getString("WVER0022E", new Object[]{sAXParseException.getSystemId(), sAXParseException.getPublicId(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException.toString()});
            printStream.println(string);
            if (!bl) continue;
            sAXParseException.printStackTrace(printStream);
        }
    }

    protected static void handleWarnings(Iterator iterator, PrintStream printStream, boolean bl) {
        while (iterator.hasNext()) {
            SAXParseException sAXParseException = (SAXParseException)iterator.next();
            String string = VersionInfo.getString("WVER0024E", new Object[]{sAXParseException.getSystemId(), sAXParseException.getPublicId(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException.toString()});
            printStream.println(string);
            if (!bl) continue;
            sAXParseException.printStackTrace(printStream);
        }
    }

    protected static int handleFatalExceptions(int n, Iterator iterator, PrintStream printStream, boolean bl) {
        while (iterator.hasNext()) {
            Exception exception = (Exception)iterator.next();
            String string = VersionInfo.getString("listing.nested.error", Integer.toString(++n), exception.toString());
            printStream.println(string);
            if (!bl) continue;
            exception.printStackTrace(printStream);
        }
        return n;
    }

    public static boolean handleErrors(WASProduct wASProduct, WASHistory wASHistory, PrintStream printStream, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = wASProduct.numRecoverableErrors();
        int n5 = wASHistory.numRecoverableErrors();
        if (n4 > 0 || n5 > 0) {
            printStream.println(VersionInfo.getString("WVER0021E"));
            VersionInfo.handleRecoverableErrors(wASProduct.getRecoverableErrors(), printStream, bl);
            VersionInfo.handleRecoverableErrors(wASHistory.getRecoverableErrors(), printStream, bl);
        }
        int n6 = wASProduct.numWarnings();
        int n7 = wASHistory.numWarnings();
        if (n6 > 0 || n7 > 0) {
            printStream.println(VersionInfo.getString("WVER0023E"));
            VersionInfo.handleWarnings(wASProduct.getWarnings(), printStream, bl);
            VersionInfo.handleWarnings(wASHistory.getWarnings(), printStream, bl);
        }
        if ((n3 = (n2 = wASProduct.numExceptions()) + (n = wASHistory.numExceptions())) == 0) {
            return true;
        }
        String string = VersionInfo.getString(n3 == 1 ? "WVER0015E" : "WVER0016E");
        printStream.println(string);
        int n8 = 0;
        n8 = VersionInfo.handleFatalExceptions(n8, wASProduct.getExceptions(), printStream, bl);
        n8 = VersionInfo.handleFatalExceptions(n8, wASHistory.getExceptions(), printStream, bl);
        return false;
    }

    public static void printCopyright() {
        System.out.println(VersionInfo.getDefaultedString("WVER0010I", "WVER0010I: Copyright (c) IBM Corporation 2002; All rights reserved."));
        System.out.println(VersionInfo.getDefaultedString("WVER0011I", "WVER0011I: WebSphere Application Server Release 5.1"));
        System.out.println(VersionInfo.getDefaultedString("WVER0012I", "WVER0012I: VersionInfo Reporter Version {0}, Dated {1}", new Object[]{pgmVersion, pgmUpdate}));
        System.out.println();
    }

    public static void main(String[] stringArray) {
        VersionInfo.main(stringArray, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int main(String[] stringArray, boolean bl) {
        Object object;
        VersionInfo.printCopyright();
        boolean bl2 = false;
        Object object2 = null;
        String string = null;
        boolean bl3 = false;
        boolean bl4 = false;
        Object object3 = null;
        String string2 = null;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        for (int i = 0; !bl2 && i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).equalsIgnoreCase("-format")) {
                if (++i < stringArray.length) {
                    object = stringArray[i];
                    if (((String)object).equalsIgnoreCase("text") || ((String)object).equalsIgnoreCase(HTML_MODE)) {
                        object3 = object;
                        continue;
                    }
                    bl2 = true;
                    object2 = object;
                    string = "WVER0006E";
                    continue;
                }
                bl2 = true;
                object2 = object;
                string = "WVER0005E";
                continue;
            }
            if (((String)object).equalsIgnoreCase("-file")) {
                if (++i < stringArray.length) {
                    string2 = stringArray[i];
                    continue;
                }
                bl2 = true;
                object2 = object;
                string = "WVER0005E";
                continue;
            }
            if (((String)object).equalsIgnoreCase("-fixes")) {
                bl5 = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-fixDetail")) {
                bl5 = true;
                bl6 = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-ptfs")) {
                bl7 = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-ptfDetail")) {
                bl7 = true;
                bl8 = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-components")) {
                bl9 = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-componentDetail")) {
                bl9 = true;
                bl10 = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-long")) {
                bl5 = true;
                bl6 = true;
                bl7 = true;
                bl8 = true;
                bl9 = true;
                bl10 = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-help") || ((String)object).equalsIgnoreCase("-?") || ((String)object).equalsIgnoreCase("/?") || ((String)object).equalsIgnoreCase("/help")) {
                bl2 = true;
                bl3 = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-usage")) {
                bl2 = true;
                bl4 = true;
                continue;
            }
            if (((String)object).equalsIgnoreCase("-printStack")) {
                bl11 = true;
                continue;
            }
            bl2 = true;
            object2 = object;
            string = "WVER0007E";
        }
        if (bl3) {
            System.out.println(VersionInfo.getString("WVER0008I"));
            if (!bl) return 0;
            System.exit(0);
            return -1;
        }
        if (bl4) {
            System.out.println(VersionInfo.getString("WVER0003I"));
            if (!bl) return 0;
            System.exit(0);
            return -1;
        }
        if (object2 != null) {
            System.err.println(VersionInfo.getString(string, object2));
            if (!bl) return -1;
            System.exit(-1);
            return -1;
        }
        Throwable throwable = null;
        try {
            object = new VersionInfo();
            ((VersionInfo)object).setPrintStack(bl11);
            ((VersionInfo)object).runReport((String)object3, string2, bl5, bl6, bl7, bl8, bl9, bl10);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throwable = fileNotFoundException;
        }
        catch (IOException iOException) {
            throwable = iOException;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (throwable != null) {
            String string3;
            object = string2 == null ? VersionInfo.getString("label.standard.output") : string2;
            try {
                String string4 = throwable.toString();
                string3 = VersionInfo.getString("WVER0004E", object, string4);
            }
            catch (Throwable throwable3) {
                string3 = VersionInfo.getString("WVER0009E", new Object[]{object, throwable.getClass().getName(), throwable3.getClass().getName()});
            }
            System.err.println(string3);
            if (bl11) {
                throwable.printStackTrace();
            }
            if (!bl) return -1;
            System.exit(-1);
            return -1;
        }
        if (!bl) return 0;
        System.exit(0);
        return -1;
    }

    public VersionInfo() {
        this.setPrintStack(false);
        this.clearProduct();
        this.clearPrintMode();
        this.clearFormatter();
    }

    protected void setPrintStack(boolean bl) {
        this.printStack = bl;
    }

    protected boolean getPrintStack() {
        return this.printStack;
    }

    protected boolean setProduct() {
        this.wasProduct = new WASProduct();
        this.wasHistory = new WASHistory();
        return VersionInfo.handleErrors(this.wasProduct, this.wasHistory, System.err, this.getPrintStack());
    }

    protected WASProduct getProduct() {
        return this.wasProduct;
    }

    protected WASHistory getHistory() {
        return this.wasHistory;
    }

    protected void clearProduct() {
        this.wasProduct = null;
        this.wasHistory = null;
    }

    protected boolean isText() {
        return this.isText;
    }

    protected void setFormatter(String string, PrintWriter printWriter) {
        if (string == null || !string.equalsIgnoreCase("text") && !string.equalsIgnoreCase(HTML_MODE)) {
            string = "text";
        }
        if (string.equalsIgnoreCase(HTML_MODE)) {
            this.isText = false;
            this.formatter = new HTMLPrintFormatter();
        } else {
            this.isText = true;
            this.formatter = new TextPrintFormatter();
        }
        this.formatter.setPrintWriter(printWriter);
    }

    protected PrintFormatter getFormatter() {
        return this.formatter;
    }

    protected void clearFormatter() {
        this.formatter = null;
    }

    protected void setPrintMode(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.displayEFixes = bl;
        this.displayEFixDetail = bl2;
        this.displayPTFs = bl3;
        this.displayPTFDetail = bl4;
        this.displayComponents = bl5;
        this.displayComponentDetail = bl6;
    }

    protected boolean displayEFixes() {
        return this.displayEFixes;
    }

    protected boolean displayEFixDetail() {
        return this.displayEFixDetail;
    }

    protected boolean displayPTFs() {
        return this.displayPTFs;
    }

    protected boolean displayPTFDetail() {
        return this.displayPTFDetail;
    }

    protected boolean displayComponents() {
        return this.displayComponents;
    }

    protected boolean displayComponentDetail() {
        return this.displayComponentDetail;
    }

    protected void clearPrintMode() {
        this.displayEFixes = false;
        this.displayEFixDetail = false;
        this.displayPTFs = false;
        this.displayPTFDetail = false;
        this.displayComponents = false;
        this.displayComponentDetail = false;
    }

    public void runReport(String string, String string2) throws FileNotFoundException, IOException {
        this.runReport(string, string2, false, false, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws FileNotFoundException, IOException {
        if (string2 == null) {
            this.runReport(string, System.out, bl, bl2, bl3, bl4, bl5, bl6);
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            try {
                this.runReport(string, fileOutputStream, bl, bl2, bl3, bl4, bl5, bl6);
            }
            finally {
                fileOutputStream.close();
            }
        }
    }

    public void runReport(String string, OutputStream outputStream) {
        this.runReport(string, outputStream, false, false, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String string, OutputStream outputStream, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        try {
            this.runReport(string, printWriter, bl, bl2, bl3, bl4, bl5, bl6);
        }
        finally {
            printWriter.flush();
        }
    }

    public void runReport(String string, PrintWriter printWriter) {
        this.runReport(string, printWriter, false, false, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String string, PrintWriter printWriter, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        block6: {
            this.setFormatter(string, printWriter);
            this.setPrintMode(bl, bl2, bl3, bl4, bl5, bl6);
            try {
                if (!this.setProduct()) break block6;
                try {
                    this.printReport();
                    VersionInfo.handleErrors(this.getProduct(), this.getHistory(), System.err, this.getPrintStack());
                }
                finally {
                    this.clearProduct();
                }
            }
            finally {
                this.clearPrintMode();
                this.clearFormatter();
            }
        }
    }

    protected String getTimeStamp() {
        return CalendarUtil.getTimeStampAsString();
    }

    protected void printReport() {
        Iterator iterator;
        WASProduct wASProduct = this.getProduct();
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.printHeader(VersionInfo.getString("report.header"));
        this.printTimeStamp();
        this.printSource();
        this.printPlatform(wASProduct.getPlatform());
        this.printChecklist();
        Iterator iterator2 = this.getCorrectedProducts(wASProduct);
        while (iterator2.hasNext()) {
            this.printProduct((product)iterator2.next());
        }
        Iterator iterator3 = wASProduct.getExtensions();
        while (iterator3.hasNext()) {
            this.printExtension((extension)iterator3.next());
        }
        if (this.displayComponents()) {
            iterator = wASProduct.getComponents();
            while (iterator.hasNext()) {
                this.printComponent((component)iterator.next());
            }
        }
        if (this.displayEFixes()) {
            iterator = wASProduct.getEFixes();
            while (iterator.hasNext()) {
                this.printEFix((efix)iterator.next());
            }
        }
        if (this.displayPTFs()) {
            iterator = wASProduct.getPTFs();
            while (iterator.hasNext()) {
                this.printPTF((ptf)iterator.next());
            }
        }
        printFormatter.blankLine();
        printFormatter.printFooter(VersionInfo.getString("report.footer"));
    }

    protected Iterator getCorrectedProducts(WASProduct wASProduct) {
        Object object;
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = wASProduct.getProducts();
        while (iterator.hasNext()) {
            object2 = (product)iterator.next();
            object = ((product)object2).getId();
            if (object == null) continue;
            if (((String)object).equalsIgnoreCase("BASE")) {
                bl = true;
                continue;
            }
            if (!((String)object).equalsIgnoreCase("ND")) continue;
            bl2 = true;
        }
        object2 = new Vector();
        iterator = wASProduct.getProducts();
        while (iterator.hasNext()) {
            object = (product)iterator.next();
            String string = ((product)object).getId();
            boolean bl3 = !bl || string == null || !string.equalsIgnoreCase("ND");
            if (!bl3) continue;
            ((Vector)object2).addElement(object);
        }
        return ((Vector)object2).iterator();
    }

    protected void separator(int n) {
        if (this.isText()) {
            this.getFormatter().separator(n);
        }
    }

    protected void separator() {
        if (this.isText()) {
            this.getFormatter().separator();
        }
    }

    protected void printTimeStamp() {
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("info.report.on", this.getTimeStamp()));
    }

    protected String unsub(String string, String string2, String string3) {
        int n = string2.indexOf(string);
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n) + string3 + string2.substring(n + string.length());
    }

    protected void printSource() {
        WASProduct wASProduct = this.getProduct();
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("info.source"), true);
        this.separator();
        String string = VersionInfo.getString("product.substitution");
        String string2 = VersionInfo.getString("version.substitution");
        String string3 = wASProduct.getProductDirName();
        String string4 = wASProduct.getVersionDirName();
        String string5 = this.unsub(string4, wASProduct.getDTDDirName(), string2);
        String string6 = this.unsub(string4, wASProduct.getLogDirName(), string2);
        String string7 = this.unsub(string4, wASProduct.getBackupDirName(), string2);
        String string8 = this.unsub(string4, wASProduct.getTmpDirName(), string2);
        string4 = this.unsub(string3, string4, string);
        Vector<String[]> vector = new Vector<String[]>();
        vector.add(new String[]{VersionInfo.getString("label.product.dir"), string3});
        vector.add(new String[]{VersionInfo.getString("label.version.dir"), string4});
        vector.add(new String[]{VersionInfo.getString("label.version.dtd.dir"), string5});
        vector.add(new String[]{VersionInfo.getString("label.version.log.dir"), string6});
        vector.add(new String[]{VersionInfo.getString("label.version.backup.dir"), string7});
        vector.add(new String[]{VersionInfo.getString("label.version.tmp.dir"), string8});
        int[] nArray = new int[]{20, 80};
        printFormatter.printTable(nArray, vector, 0);
    }

    protected void printPlatform(websphere websphere2) {
        if (websphere2 == null) {
            return;
        }
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("info.platform"), true);
        this.separator();
        Vector<String[]> vector = new Vector<String[]>();
        vector.add(new String[]{VersionInfo.getString("label.name"), websphere2.getName()});
        vector.add(new String[]{VersionInfo.getString("label.version"), websphere2.getVersion()});
        printFormatter.printTable(vector);
    }

    protected void printChecklist() {
        WASProduct wASProduct = this.getProduct();
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("info.technology"), true);
        this.separator();
        boolean bl = wASProduct.productPresent("BASE");
        Vector<String[]> vector = new Vector<String[]>();
        String string = VersionInfo.getString("label.installed");
        for (int i = 0; i < WASProduct.PRODUCT_IDS.length; ++i) {
            String string2 = WASProduct.PRODUCT_IDS[i];
            if (bl && string2 != null && string2.equalsIgnoreCase("ND") || !wASProduct.productPresent(string2)) continue;
            vector.add(new String[]{string2, string});
        }
        printFormatter.printTable(vector);
    }

    protected void printProduct(product product2) {
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("info.product"), true);
        this.separator();
        Vector<String[]> vector = new Vector<String[]>();
        vector.add(new String[]{VersionInfo.getString("label.name"), product2.getName()});
        vector.add(new String[]{VersionInfo.getString("label.version"), product2.getVersion()});
        vector.add(new String[]{VersionInfo.getString("label.id"), product2.getId()});
        vector.add(new String[]{VersionInfo.getString("label.build.level"), product2.getBuildInfo().getLevel()});
        vector.add(new String[]{VersionInfo.getString("label.build.date"), product2.getBuildInfo().getDate()});
        printFormatter.printTable(vector);
    }

    protected void printComponent(component component2) {
        String string = component2.getName();
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("info.component"), true);
        this.separator();
        Vector<String[]> vector = new Vector<String[]>();
        vector.add(new String[]{VersionInfo.getString("label.component.name"), string});
        vector.add(new String[]{VersionInfo.getString("label.spec.version"), component2.getSpecVersion()});
        vector.add(new String[]{VersionInfo.getString("label.build.version"), component2.getBuildVersion()});
        vector.add(new String[]{VersionInfo.getString("label.build.date"), component2.getBuildDate()});
        printFormatter.printTable(vector);
        if (this.displayComponentDetail()) {
            this.printComponentDetail(component2);
        }
    }

    protected void printComponentDetail(component component2) {
        String string = component2.getName();
        Vector vector = this.selectApplications(string);
        int n = vector.size();
        if (n == 0) {
            return;
        }
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("info.update.on.component"), 1, true);
        this.separator(1);
        Vector vector2 = new Vector();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])vector.elementAt(i);
            this.printApplication(objectArray);
        }
    }

    protected Vector selectApplications(String string) {
        int n;
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Iterator iterator = this.getHistory().getEFixApplieds();
        while (iterator.hasNext()) {
            object = (efixApplied)iterator.next();
            int n2 = ((efixApplied)object).getComponentAppliedCount();
            for (n = 0; n < n2; ++n) {
                componentApplied componentApplied2 = ((efixApplied)object).getComponentApplied(n);
                if (!componentApplied2.getComponentName().equals(string)) continue;
                vector.add(new Object[]{object, componentApplied2});
            }
        }
        object = this.getHistory().getPTFApplieds();
        while (object.hasNext()) {
            ptfApplied ptfApplied2 = (ptfApplied)object.next();
            n = ptfApplied2.getComponentAppliedCount();
            for (int i = 0; i < n; ++i) {
                componentApplied componentApplied3 = ptfApplied2.getComponentApplied(i);
                if (!componentApplied3.getComponentName().equals(string)) continue;
                vector.add(new Object[]{ptfApplied2, componentApplied3});
            }
        }
        return vector;
    }

    protected void printApplication(Object[] objectArray) {
        componentVersion componentVersion2;
        Object object;
        componentApplied componentApplied2 = (componentApplied)objectArray[1];
        Vector<String[]> vector = new Vector<String[]>();
        vector.add(new String[]{VersionInfo.getString("label.component.name"), componentApplied2.getComponentName()});
        if (objectArray[0] instanceof efixApplied) {
            object = (efixApplied)objectArray[0];
            vector.add(new String[]{VersionInfo.getString("label.update.type"), VersionInfo.getString("label.update.type.efix")});
            vector.add(new String[]{VersionInfo.getString("label.efix.id"), ((efixApplied)object).getEFixId()});
        } else {
            object = (ptfApplied)objectArray[0];
            vector.add(new String[]{VersionInfo.getString("label.update.type"), VersionInfo.getString("label.update.type.ptf")});
            vector.add(new String[]{VersionInfo.getString("label.ptf.id"), ((ptfApplied)object).getPTFId()});
        }
        object = componentApplied2.getUpdateTypeAsEnum();
        String string = this.updateEffectText((enumUpdateType)object);
        vector.add(new String[]{VersionInfo.getString("label.update.effect"), string});
        boolean bl = componentApplied2.getIsRequiredAsBoolean();
        String string2 = this.booleanText(bl);
        vector.add(new String[]{VersionInfo.getString("label.is.required"), string2});
        boolean bl2 = componentApplied2.getIsOptionalAsBoolean();
        String string3 = this.booleanText(bl2);
        vector.add(new String[]{VersionInfo.getString("label.is.optional"), string3});
        boolean bl3 = componentApplied2.getIsExternalAsBoolean();
        String string4 = this.booleanText(bl3);
        vector.add(new String[]{VersionInfo.getString("label.is.external"), string4});
        if (bl3) {
            vector.add(new String[]{VersionInfo.getString("label.root.property.file"), componentApplied2.getRootPropertyFile()});
            vector.add(new String[]{VersionInfo.getString("label.root.property.name"), componentApplied2.getRootPropertyName()});
            vector.add(new String[]{VersionInfo.getString("label.root.property.value"), componentApplied2.getRootPropertyValue()});
        }
        boolean bl4 = componentApplied2.getIsCustomAsBoolean();
        String string5 = this.booleanText(bl4);
        vector.add(new String[]{VersionInfo.getString("label.is.custom"), string5});
        vector.add(new String[]{VersionInfo.getString("label.log.file.name"), componentApplied2.getLogName()});
        vector.add(new String[]{VersionInfo.getString("label.backup.file.name"), componentApplied2.getBackupName()});
        vector.add(new String[]{VersionInfo.getString("label.install.date"), componentApplied2.getTimeStamp()});
        componentVersion componentVersion3 = componentApplied2.getInitialVersion();
        if (componentVersion3 != null) {
            vector.add(new String[]{VersionInfo.getString("label.initial.spec.version"), componentVersion3.getSpecVersion()});
            vector.add(new String[]{VersionInfo.getString("label.initial.build.version"), componentVersion3.getBuildVersion()});
            vector.add(new String[]{VersionInfo.getString("label.initial.build.date"), componentVersion3.getBuildDate()});
        }
        if ((componentVersion2 = componentApplied2.getFinalVersion()) != null) {
            vector.add(new String[]{VersionInfo.getString("label.final.spec.version"), componentVersion2.getSpecVersion()});
            vector.add(new String[]{VersionInfo.getString("label.final.build.version"), componentVersion2.getBuildVersion()});
            vector.add(new String[]{VersionInfo.getString("label.final.build.date"), componentVersion2.getBuildDate()});
        }
        this.getFormatter().printTable(vector, 1);
    }

    protected void printExtension(extension extension2) {
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("info.extension"), true);
        this.separator();
        Vector<String[]> vector = new Vector<String[]>();
        vector.add(new String[]{VersionInfo.getString("label.name"), extension2.getName()});
        vector.add(new String[]{VersionInfo.getString("label.id"), extension2.getId()});
        printFormatter.printTable(vector);
    }

    protected void printEFix(efix efix2) {
        efixDriver efixDriver2 = this.printEFixHeader(efix2);
        if (efixDriver2 == null) {
            return;
        }
        this.printEFixApars(efixDriver2);
        this.printEFixPlatformPrereqs(efixDriver2);
        this.printEFixProductPrereqs(efixDriver2);
        this.printEFixPrereqs(efixDriver2);
        this.printEFixComponents(efixDriver2);
        this.printEFixCustomProperties(efixDriver2);
    }

    protected efixDriver printEFixHeader(efix efix2) {
        efixDriver efixDriver2;
        PrintFormatter printFormatter = this.getFormatter();
        WASProduct wASProduct = this.getProduct();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("info.efix"), true);
        this.separator();
        Vector<String[]> vector = new Vector<String[]>();
        vector.add(new String[]{VersionInfo.getString("label.id"), efix2.getId()});
        vector.add(new String[]{VersionInfo.getString("label.short.description"), efix2.getShortDescription()});
        vector.add(new String[]{VersionInfo.getString("label.build.date"), efix2.getBuildDate()});
        vector.add(new String[]{VersionInfo.getString("label.build.version"), efix2.getBuildVersion()});
        if (this.displayEFixDetail()) {
            efixDriver2 = this.getHistory().getEFixDriverById(efix2.getId());
            boolean bl = efixDriver2.getIsTrialAsBoolean();
            String string = this.booleanText(bl);
            vector.add(new String[]{VersionInfo.getString("label.is.trial"), string});
            vector.add(new String[]{VersionInfo.getString("label.expiration.date"), efixDriver2.getExpirationDate()});
            vector.add(new String[]{VersionInfo.getString("label.long.description"), efixDriver2.getLongDescription()});
        } else {
            efixDriver2 = null;
        }
        printFormatter.printTable(vector);
        return efixDriver2;
    }

    protected void printEFixApars(efixDriver efixDriver2) {
        int n = efixDriver2.getAparInfoCount();
        if (n == 0) {
            return;
        }
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("label.apar"), 1, true);
        this.separator(1);
        Vector<String[]> vector = new Vector<String[]>();
        for (int i = 0; i < n; ++i) {
            aparInfo aparInfo2 = efixDriver2.getAparInfo(i);
            vector.add(new String[]{VersionInfo.getString("label.apar.number"), aparInfo2.getNumber()});
            vector.add(new String[]{VersionInfo.getString("label.apar.date"), aparInfo2.getDate()});
            vector.add(new String[]{VersionInfo.getString("label.apar.short.description"), aparInfo2.getShortDescription()});
            vector.add(new String[]{VersionInfo.getString("label.apar.long.description"), aparInfo2.getLongDescription()});
        }
        printFormatter.printTable(vector, 1);
    }

    protected void printEFixPlatformPrereqs(efixDriver efixDriver2) {
        int n = efixDriver2.getPlatformPrereqCount();
        if (n == 0) {
            return;
        }
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("label.supported.platforms"), 1, true);
        this.separator(1);
        Vector<Object[]> vector = new Vector<Object[]>();
        for (int i = 0; i < n; ++i) {
            platformPrereq platformPrereq2 = efixDriver2.getPlatformPrereq(i);
            Object[] objectArray = new Object[]{platformPrereq2.getArchitecture(), platformPrereq2.getOSPlatform(), platformPrereq2.getOSVersion()};
            vector.add(objectArray);
        }
        int[] nArray = new int[]{15, 15, 70};
        printFormatter.printTable(nArray, vector, 1);
    }

    protected void printEFixProductPrereqs(efixDriver efixDriver2) {
        int n = efixDriver2.getProductPrereqCount();
        if (n == 0) {
            return;
        }
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("label.supported.products"), 1, true);
        this.separator(1);
        Vector<Object[]> vector = new Vector<Object[]>();
        for (int i = 0; i < n; ++i) {
            productPrereq productPrereq2 = efixDriver2.getProductPrereq(i);
            Object[] objectArray = new Object[]{productPrereq2.getProductId(), productPrereq2.getBuildVersion(), productPrereq2.getBuildDate(), productPrereq2.getBuildLevel()};
            vector.add(objectArray);
        }
        int[] nArray = new int[]{15, 15, 15, 15, 40};
        printFormatter.printTable(nArray, vector, 1);
    }

    protected void printEFixPrereqs(efixDriver efixDriver2) {
        int n = efixDriver2.getEFixPrereqCount();
        if (n == 0) {
            return;
        }
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.println(VersionInfo.getString("label.efix.efix.prereqs"), 1, true);
        this.separator(1);
        Vector<Object[]> vector = new Vector<Object[]>();
        for (int i = 0; i < n; ++i) {
            efixPrereq efixPrereq2 = efixDriver2.getEFixPrereq(i);
            boolean bl = efixPrereq2.getIsNegativeAsBoolean();
            String string = this.isNegativeText(bl);
            String string2 = efixPrereq2.getInstallIndex();
            if (string2 == null) {
                string2 = "";
            }
            Object[] objectArray = new Object[]{efixPrereq2.getEFixId(), string, string2};
            vector.add(objectArray);
        }
        int[] nArray = new int[]{15, 15, 15, 55};
        printFormatter.printTable(nArray, vector, 1);
    }

    protected void printEFixComponents(efixDriver efixDriver2) {
        int n = efixDriver2.getComponentUpdateCount();
        if (n == 0) {
            return;
        }
        WASHistory wASHistory = this.getHistory();
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("label.component.updates"), 1, true);
        this.separator(1);
        int[] nArray = new int[]{15, 15, 15, 55};
        int[] nArray2 = new int[]{5, 15, 15, 65};
        int[] nArray3 = new int[]{5, 95, 0, 0};
        Vector<int[]> vector = new Vector<int[]>();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray;
            String string;
            Object[] objectArray2;
            componentUpdate componentUpdate2 = efixDriver2.getComponentUpdate(i);
            enumUpdateType enumUpdateType2 = componentUpdate2.getUpdateTypeAsEnum();
            String string2 = this.updateEffectText(enumUpdateType2);
            String string3 = this.isRequiredText(componentUpdate2.getIsRequiredAsBoolean(), componentUpdate2.getIsOptionalAsBoolean(), componentUpdate2.getIsRecommendedAsBoolean());
            Object[] objectArray3 = new Object[]{componentUpdate2.getComponentName(), string2, string3};
            vector.add(nArray);
            vector2.add(objectArray3);
            boolean bl = componentUpdate2.getIsCustomAsBoolean();
            String string4 = this.isCustomText(bl);
            vector.add(nArray2);
            Object[] objectArray4 = new Object[]{"", string4, componentUpdate2.getPrimaryContent()};
            vector2.add(objectArray4);
            componentApplied componentApplied2 = wASHistory.getEFixComponentAppliedById(efixDriver2.getId(), componentUpdate2.getComponentName());
            String string5 = this.isInstalledText(componentApplied2);
            Object[] objectArray5 = new Object[]{"", string5, "", ""};
            vector.add(nArray3);
            vector2.add(objectArray5);
            int n2 = componentUpdate2.getComponentPrereqCount();
            for (int j = 0; j < n2; ++j) {
                objectArray2 = componentUpdate2.getComponentPrereq(j);
                string = VersionInfo.getString("label.component.requires", objectArray2.getComponentName(), objectArray2.getSpecVersion());
                objectArray = new Object[]{"", string, "", ""};
                vector.add(nArray3);
                vector2.add(objectArray);
            }
            componentVersion componentVersion2 = componentUpdate2.getFinalVersion();
            if (componentVersion2 != null) {
                objectArray2 = new Object[]{componentVersion2.getSpecVersion(), componentVersion2.getBuildVersion(), componentVersion2.getBuildDate()};
                string = VersionInfo.getString("label.becomes", objectArray2);
                objectArray = new Object[]{"", string, "", ""};
                vector.add(nArray3);
                vector2.add(objectArray);
            }
            printFormatter.printTable(vector, vector2, 1);
        }
    }

    protected void printEFixCustomProperties(efixDriver efixDriver2) {
        int n = efixDriver2.getCustomPropertyCount();
        if (n == 0) {
            return;
        }
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("label.custom.properties"), 1, true);
        this.separator(1);
        Vector<Object[]> vector = new Vector<Object[]>();
        for (int i = 0; i < n; ++i) {
            customProperty customProperty2 = efixDriver2.getCustomProperty(i);
            Object[] objectArray = new Object[]{customProperty2.getPropertyName(), customProperty2.getPropertyType(), customProperty2.getPropertyValue()};
            vector.addElement(objectArray);
        }
        int[] nArray = new int[]{20, 20, 60};
        this.getFormatter().printTable(nArray, vector, 1);
    }

    protected void printPTF(ptf ptf2) {
        ptfDriver ptfDriver2 = this.printPTFHeader(ptf2);
        if (ptfDriver2 == null) {
            return;
        }
        this.printPTFPlatformPrereqs(ptfDriver2);
        this.printPTFProductPrereqs(ptfDriver2);
        this.printPTFIncludedEFixes(ptfDriver2);
        this.printPTFComponents(ptfDriver2);
        this.printPTFCustomProperties(ptfDriver2);
    }

    protected ptfDriver printPTFHeader(ptf ptf2) {
        ptfDriver ptfDriver2;
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("info.ptf"), true);
        this.separator();
        Vector<String[]> vector = new Vector<String[]>();
        vector.add(new String[]{VersionInfo.getString("label.id"), ptf2.getId()});
        vector.add(new String[]{VersionInfo.getString("label.short.description"), ptf2.getShortDescription()});
        vector.add(new String[]{VersionInfo.getString("label.build.date"), ptf2.getBuildDate()});
        vector.add(new String[]{VersionInfo.getString("label.build.version"), ptf2.getBuildVersion()});
        if (this.displayPTFDetail()) {
            ptfDriver2 = this.getHistory().getPTFDriverById(ptf2.getId());
            vector.add(new String[]{VersionInfo.getString("label.long.description"), ptfDriver2.getLongDescription()});
        } else {
            ptfDriver2 = null;
        }
        printFormatter.printTable(vector);
        return ptfDriver2;
    }

    protected void printPTFPlatformPrereqs(ptfDriver ptfDriver2) {
        int n = ptfDriver2.getPlatformPrereqCount();
        if (n == 0) {
            return;
        }
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("label.supported.platforms"), 1, true);
        this.separator(1);
        Vector<Object[]> vector = new Vector<Object[]>();
        for (int i = 0; i < n; ++i) {
            platformPrereq platformPrereq2 = ptfDriver2.getPlatformPrereq(i);
            Object[] objectArray = new Object[]{platformPrereq2.getArchitecture(), platformPrereq2.getOSPlatform(), platformPrereq2.getOSVersion()};
            vector.add(objectArray);
        }
        int[] nArray = new int[]{15, 15, 70};
        printFormatter.printTable(nArray, vector, 1);
    }

    protected void printPTFProductPrereqs(ptfDriver ptfDriver2) {
        int n = ptfDriver2.getProductPrereqCount();
        if (n == 0) {
            return;
        }
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("label.supported.products"), 1, true);
        this.separator(1);
        Vector<Object[]> vector = new Vector<Object[]>();
        for (int i = 0; i < n; ++i) {
            productPrereq productPrereq2 = ptfDriver2.getProductPrereq(i);
            Object[] objectArray = new Object[]{productPrereq2.getProductId(), productPrereq2.getBuildVersion(), productPrereq2.getBuildDate(), productPrereq2.getBuildLevel()};
            vector.add(objectArray);
        }
        int[] nArray = new int[]{15, 15, 15, 15, 40};
        printFormatter.printTable(nArray, vector, 1);
    }

    protected void printPTFIncludedEFixes(ptfDriver ptfDriver2) {
        int n = ptfDriver2.getIncludedEFixCount();
        if (n == 0) {
            return;
        }
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.println(VersionInfo.getString("label.included.efixes"), 1, true);
        this.separator(1);
        Vector<Object[]> vector = new Vector<Object[]>();
        for (int i = 0; i < n; ++i) {
            includedEFix includedEFix2 = ptfDriver2.getIncludedEFix(i);
            Object[] objectArray = new Object[]{includedEFix2.getEFixId()};
            vector.add(objectArray);
        }
        int[] nArray = new int[]{100};
        printFormatter.printTable(nArray, vector, 1);
    }

    protected void printPTFComponents(ptfDriver ptfDriver2) {
        int n = ptfDriver2.getComponentUpdateCount();
        if (n == 0) {
            return;
        }
        WASHistory wASHistory = this.getHistory();
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("label.component.updates"), 1, true);
        this.separator(1);
        int[] nArray = new int[]{15, 15, 15, 55};
        int[] nArray2 = new int[]{5, 15, 15, 65};
        int[] nArray3 = new int[]{5, 95, 0, 0};
        Vector<int[]> vector = new Vector<int[]>();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray;
            String string;
            Object[] objectArray2;
            componentUpdate componentUpdate2 = ptfDriver2.getComponentUpdate(i);
            String string2 = componentUpdate2.getComponentName();
            enumUpdateType enumUpdateType2 = componentUpdate2.getUpdateTypeAsEnum();
            String string3 = this.updateEffectText(enumUpdateType2);
            String string4 = this.isRequiredText(componentUpdate2.getIsRequiredAsBoolean(), componentUpdate2.getIsOptionalAsBoolean(), componentUpdate2.getIsRecommendedAsBoolean());
            Object[] objectArray3 = new Object[]{string2, string3, string4};
            vector.add(nArray);
            vector2.add(objectArray3);
            boolean bl = componentUpdate2.getIsCustomAsBoolean();
            String string5 = this.isCustomText(bl);
            String string6 = componentUpdate2.getPrimaryContent();
            vector.add(nArray2);
            Object[] objectArray4 = new Object[]{"", string5, string6};
            componentApplied componentApplied2 = wASHistory.getPTFComponentAppliedById(ptfDriver2.getId(), string2);
            String string7 = this.isInstalledText(componentApplied2);
            Object[] objectArray5 = new Object[]{"", string7, "", ""};
            vector.add(nArray3);
            vector2.add(objectArray5);
            int n2 = componentUpdate2.getComponentPrereqCount();
            for (int j = 0; j < n2; ++j) {
                objectArray2 = componentUpdate2.getComponentPrereq(j);
                string = objectArray2.getComponentName();
                objectArray = objectArray2.getSpecVersion();
                String string8 = VersionInfo.getString("label.component.requires", string, objectArray);
                Object[] objectArray6 = new Object[]{"", string8, "", ""};
                vector.add(nArray3);
                vector2.add(objectArray6);
            }
            componentVersion componentVersion2 = componentUpdate2.getFinalVersion();
            if (componentVersion2 != null) {
                objectArray2 = new Object[]{componentVersion2.getSpecVersion(), componentVersion2.getBuildVersion(), componentVersion2.getBuildDate()};
                string = VersionInfo.getString("label.becomes", objectArray2);
                objectArray = new Object[]{"", string, "", ""};
                vector.add(nArray3);
                vector2.add(objectArray);
            }
            printFormatter.printTable(vector, vector2, 1);
        }
    }

    protected void printPTFCustomProperties(ptfDriver ptfDriver2) {
        int n = ptfDriver2.getCustomPropertyCount();
        if (n == 0) {
            return;
        }
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(VersionInfo.getString("label.custom.properties"), 1, true);
        this.separator(1);
        Vector<Object[]> vector = new Vector<Object[]>();
        for (int i = 0; i < n; ++i) {
            customProperty customProperty2 = ptfDriver2.getCustomProperty(i);
            Object[] objectArray = new Object[]{customProperty2.getPropertyName(), customProperty2.getPropertyType(), customProperty2.getPropertyValue()};
            vector.addElement(objectArray);
        }
        int[] nArray = new int[]{20, 20, 60};
        printFormatter.printTable(nArray, vector, 1);
    }

    protected String booleanText(boolean bl) {
        return VersionInfo.getString(bl ? "label.true" : "label.false");
    }

    protected String isInstalledText(componentApplied componentApplied2) {
        if (componentApplied2 == null) {
            return VersionInfo.getString("label.is.absent");
        }
        String string = componentApplied2.getTimeStamp();
        return VersionInfo.getString("label.is.installed", string);
    }

    protected String updateEffectText(enumUpdateType enumUpdateType2) {
        String string = enumUpdateType2 == enumUpdateType.ADD_UPDATE_TYPE ? "label.update.effect.add" : (enumUpdateType2 == enumUpdateType.REPLACE_UPDATE_TYPE ? "label.update.effect.replace" : (enumUpdateType2 == enumUpdateType.REMOVE_UPDATE_TYPE ? "label.update.effect.remove" : (enumUpdateType2 == enumUpdateType.PATCH_UPDATE_TYPE ? "label.update.effect.patch" : "label.update.effect.unknown")));
        return VersionInfo.getString(string);
    }

    protected String isNegativeText(boolean bl) {
        return VersionInfo.getString(bl ? "label.is.negative" : "label.is.positive");
    }

    protected String isRequiredText(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            return VersionInfo.getString("label.is.required.tag");
        }
        if (!bl2) {
            return VersionInfo.getString("label.if.possible.tag");
        }
        if (!bl3) {
            return VersionInfo.getString("label.is.optional.tag");
        }
        return VersionInfo.getString("label.is.recommended.tag");
    }

    protected String isCustomText(boolean bl) {
        return VersionInfo.getString(bl ? "label.is.custom.tag" : "label.is.standard.tag");
    }
}

