/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.formatters;

import com.ibm.websphere.product.formatters.PrintFormatter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;

public class TextPrintFormatter
implements PrintFormatter {
    public static final String pgmVersion = "1.4";
    public static final String pgmUpdate = "9/3/02";
    protected PrintWriter out = new PrintWriter(System.out);
    public static final String PAD_TEXT = "                                                                                ";
    public static final int MAX_PAD_WIDTH = "                                                                                ".length();
    public static final String SEPARATOR_LINE = "--------------------------------------------------------------------------------";
    public static final int REPORT_WIDTH = "--------------------------------------------------------------------------------".length();
    public static final int INDENT_GAP = 3;

    public void setPrintWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public String paddingFor(String string, int n) {
        int n2 = string.length();
        int n3 = n2 > n ? 0 : n - n2;
        if (n3 > MAX_PAD_WIDTH) {
            n3 = MAX_PAD_WIDTH;
        }
        return PAD_TEXT.substring(0, n3);
    }

    public String embolden(String string) {
        return string;
    }

    public void println(String string, boolean bl) {
        this.println(string, 0, bl);
    }

    public void println(String string, int n, boolean bl) {
        this.println(bl ? this.embolden(string) : string, n);
    }

    public void println(String string) {
        this.println(string, 0);
    }

    public void println(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if ((n *= 3) > REPORT_WIDTH) {
            n = REPORT_WIDTH;
        }
        this.out.print(PAD_TEXT.substring(0, n));
        this.out.println(string);
    }

    public void blankLine() {
        this.out.println("");
    }

    public void separator() {
        this.separator(0, false);
    }

    public void separator(boolean bl) {
        this.separator(0, bl);
    }

    public void separator(int n) {
        this.separator(n, false);
    }

    public void separator(int n, boolean bl) {
        int n2;
        if (n < 0) {
            n = 0;
        }
        String string = (n2 = REPORT_WIDTH - n * 3) > 0 ? SEPARATOR_LINE.substring(0, n2) : "";
        this.println(string, n, bl);
    }

    public void printHeader(String string) {
        this.separator(true);
        this.println(string, true);
        this.separator(true);
    }

    public void printFooter(String string) {
        this.separator(true);
        this.println(string, true);
        this.separator(true);
    }

    public void printList(Iterator iterator, int n) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = e == null ? "" : e.toString();
            this.println(string, n);
        }
    }

    public void printTable(Vector vector) {
        this.printTable(vector, 0);
    }

    public void printTable(Vector vector, int n) {
        this.printTable(PrintFormatter.STANDARD_WIDTHS, vector, n);
    }

    public void printTable(int[] nArray, Vector vector, int n) {
        Vector<int[]> vector2 = new Vector<int[]>();
        vector2.add(nArray);
        this.printTable(vector2, vector, n);
    }

    public void printTable(Vector vector, Vector vector2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = vector.iterator();
        Iterator iterator2 = vector2.iterator();
        int[] nArray = null;
        while (iterator2.hasNext()) {
            if (iterator.hasNext()) {
                nArray = (int[])iterator.next();
            }
            Object[] objectArray = (Object[])iterator2.next();
            int n2 = objectArray.length;
            int n3 = n2 - 1;
            for (int i = 0; i < n2; ++i) {
                int n4 = nArray[i];
                Object object = objectArray[i];
                String string = object == null ? "" : object.toString();
                stringBuffer.append(string);
                if (i == n3) continue;
                String string2 = this.paddingFor(string, n4);
                if (string2.length() == 0) {
                    string2 = " ";
                }
                stringBuffer.append(string2);
            }
            this.println(stringBuffer.toString(), n);
            stringBuffer.setLength(0);
        }
    }
}

