/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.xml;

import com.ibm.websphere.product.xml.BaseEntityResolver;
import com.ibm.websphere.product.xml.BaseErrorHandler;
import com.ibm.websphere.product.xml.BaseHandler;
import com.ibm.websphere.product.xml.BaseHandlerException;
import com.ibm.websphere.product.xml.BaseWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class BaseFactory {
    public static final String pgmVersion = "1.3";
    public static final String pgmUpdate = "10/7/02";
    protected BaseHandler handler;
    protected BaseWriter writer;
    public static final String NAMESPACES_FEATURE_NAME = "http://xml.org/sax/features/namespaces";
    public static final String VALIDATE_FEATURE_NAME = "http://xml.org/sax/features/validation";
    public static final String LOAD_EXTERNAL_DTD_FEATURE_NAME = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String VALIDATING_PROPERTY_NAME = "was.version.validate";
    public static final String VALIDATING_PROPERTY_TRUE_VALUE = "true";
    public static final String VALIDATING_PROPERTY_FALSE_VALUE = "false";
    protected BaseHandlerException boundException;
    protected Vector recoverableErrors;
    protected Vector warnings;

    public BaseFactory(BaseHandler baseHandler, BaseWriter baseWriter) {
        this.handler = baseHandler;
        this.writer = baseWriter;
        this.boundException = null;
        this.recoverableErrors = new Vector();
        this.warnings = new Vector();
    }

    public BaseHandler getHandler() {
        return this.handler;
    }

    public BaseWriter getWriter() {
        return this.writer;
    }

    public static BaseHandlerException saveSingleton(Object object, BaseWriter baseWriter, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        BaseFactory baseFactory = new BaseFactory(null, baseWriter);
        if (!baseFactory.save(string, arrayList)) {
            return baseFactory.getException();
        }
        return null;
    }

    public boolean save(String string, List list) {
        this.getWriter().emit(list, string);
        Exception exception = this.writer.getBoundException();
        if (exception != null) {
            this.setException("WVER0107E", new Object[]{string}, exception);
            return false;
        }
        return true;
    }

    public static Object loadSingleton(BaseHandler baseHandler, String string, String string2, String string3) throws BaseHandlerException {
        BaseFactory baseFactory = new BaseFactory(baseHandler, null);
        List list = baseFactory.load(string, string2, string3);
        BaseHandlerException baseHandlerException = baseFactory.getException();
        if (baseHandlerException != null) {
            throw baseHandlerException;
        }
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static Object loadSingleton(BaseHandler baseHandler, String string, InputSource inputSource, String string2) throws BaseHandlerException {
        BaseFactory baseFactory = new BaseFactory(baseHandler, null);
        List list = baseFactory.load(string, inputSource, string2);
        BaseHandlerException baseHandlerException = baseFactory.getException();
        if (baseHandlerException != null) {
            throw baseHandlerException;
        }
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public List load(String string, String string2, String string3) {
        InputSource inputSource = this.openSource(string2, string3);
        return this.load(string, inputSource, string3);
    }

    public List load(String string, InputSource inputSource, String string2) {
        XMLReader xMLReader;
        try {
            xMLReader = this.createReader(string);
        }
        catch (SAXException sAXException) {
            this.setException("WVER0101E", new Object[]{string, string2}, sAXException);
            return null;
        }
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.out);
            this.setException("WVER0102E", new Object[]{string, string2, sAXParseException.getSystemId(), sAXParseException.getPublicId(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber())}, sAXParseException);
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            this.setException("WVER0101E", new Object[]{string, string2});
            return null;
        }
        return (List)this.getHandler().getObject();
    }

    protected XMLReader createReader(String string) throws SAXException, SAXNotRecognizedException {
        boolean bl = this.isValidating();
        XMLReader xMLReader = null;
        try {
            xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        xMLReader.setFeature(NAMESPACES_FEATURE_NAME, true);
        xMLReader.setFeature(VALIDATE_FEATURE_NAME, bl);
        xMLReader.setEntityResolver(this.createEntityResolver(string));
        xMLReader.setContentHandler(this.getHandler());
        xMLReader.setErrorHandler(this.createErrorHandler());
        return xMLReader;
    }

    protected EntityResolver createEntityResolver(String string) {
        return new BaseEntityResolver(this, string);
    }

    protected ErrorHandler createErrorHandler() {
        return new BaseErrorHandler(this);
    }

    protected InputSource openSource(String string, String string2) {
        File file = new File(string, string2);
        String string3 = file.getAbsolutePath();
        return new InputSource(string3);
    }

    protected boolean isValidating() {
        String string = System.getProperty(VALIDATING_PROPERTY_NAME);
        return string == null || !string.equalsIgnoreCase(VALIDATING_PROPERTY_FALSE_VALUE);
    }

    protected void setException(BaseHandlerException baseHandlerException) {
        this.boundException = baseHandlerException;
    }

    public BaseHandlerException getException() {
        return this.boundException;
    }

    protected void clearException() {
        this.boundException = null;
    }

    protected void setException(String string) {
        this.setException(this.createException(string, null, null));
    }

    protected void setException(String string, Exception exception) {
        this.setException(this.createException(string, null, exception));
    }

    protected void setException(String string, Object[] objectArray) {
        this.setException(this.createException(string, objectArray, null));
    }

    protected void setException(String string, Object[] objectArray, Exception exception) {
        this.setException(this.createException(string, objectArray, exception));
    }

    protected BaseHandlerException createException(String string, Object[] objectArray, Exception exception) {
        return new BaseHandlerException(string, objectArray, exception);
    }

    public Iterator getRecoverableErrors() {
        return this.recoverableErrors.iterator();
    }

    protected void addRecoverableError(SAXException sAXException) {
        this.recoverableErrors.add(sAXException);
    }

    public void clearRecoverableErrors() {
        this.recoverableErrors = new Vector();
    }

    public Iterator getWarnings() {
        return this.warnings.iterator();
    }

    protected void addWarning(SAXException sAXException) {
        this.warnings.add(sAXException);
    }

    public void clearWarnings() {
        this.warnings = new Vector();
    }
}

