/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.xml;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;

public abstract class BaseWriter {
    public static final String pgmVersion = "1.3";
    public static final String pgmUpdate = "5/14/04";
    protected Exception boundException;
    public static final String DEFAULT_ENCODING = "UTF8";
    protected String encoding;
    protected String encodingTag;
    protected String docTypeString;
    protected String outputFileName;
    protected FileOutputStream outputStream;
    protected PrintWriter outputWriter;
    protected static final int INDENT_WIDTH = 80;
    protected static final String indentLine = "                                                                                ";
    public static final int INDENT_GAP = 2;
    protected int indent;
    public static final boolean IS_COMPLETE = true;
    public static final boolean IS_INCOMPLETE = false;
    public static final int MAX_TEXT_WITH_ELEMENT = 40;
    protected static final boolean CLOSE_WHOLLY = true;
    protected static final boolean CLOSE_PARTIALLY = false;

    public Exception getBoundException() {
        return this.boundException;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void print(String string) {
        this.outputWriter.print(string);
    }

    public void println() {
        this.outputWriter.println();
    }

    public void println(String string) {
        this.outputWriter.println(string);
    }

    public void flush() {
        this.outputWriter.flush();
    }

    public void openWriter(String string, String string2, String string3, String string4) throws FileNotFoundException, UnsupportedEncodingException {
        this.encoding = string;
        this.encodingTag = string2;
        this.docTypeString = string3;
        this.outputFileName = string4;
        this.outputStream = new FileOutputStream(string4);
        String string5 = string == null ? DEFAULT_ENCODING : string;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.outputStream, string5);
        this.outputWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        this.indent = 0;
    }

    public void closeWriter() throws IOException {
        this.outputWriter.flush();
        this.outputWriter = null;
        FileOutputStream fileOutputStream = this.outputStream;
        this.outputStream = null;
        ((OutputStream)fileOutputStream).close();
    }

    public void indentIn() {
        this.indent += 2;
    }

    public void indentOut() {
        this.indent -= 2;
    }

    public void printIndent() {
        int n;
        for (n = this.indent; n >= 80; n -= 80) {
            this.print(indentLine);
        }
        if (n > 0) {
            this.print(indentLine.substring(0, n));
        }
    }

    public void beginDocument() {
        if (this.encodingTag != null && !this.encodingTag.equals("")) {
            this.println("<?xml version=\"1.0\" encoding=\"" + this.encodingTag + "\"?>");
        }
        if (this.docTypeString != null && !this.docTypeString.equals("")) {
            this.println(this.docTypeString);
        }
    }

    public void emitElement(String string, Iterator iterator, boolean bl) {
        this.printIndent();
        this.beginElementOpening(string);
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (string3 == null) continue;
            this.print(" ");
            this.emitAttribute(string2, string3);
        }
        this.endElementOpening(bl);
        this.println();
    }

    public void emitElement(String string, Iterator iterator, String string2) {
        this.printIndent();
        this.beginElementOpening(string);
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            if (string4 == null) continue;
            this.print(" ");
            this.emitAttribute(string3, string4);
        }
        this.endElementOpening(false);
        this.println();
        this.indentIn();
        this.println(string2);
        this.indentOut();
        this.printIndent();
        this.emitElementClosure(string2);
        this.println();
    }

    public void emitAttributeOnLine(String string, String string2) {
        if (string2 != null) {
            this.printIndent();
            this.emitAttribute(string, string2);
            this.println();
        }
    }

    public void emitElement(String string, String string2) {
        this.printIndent();
        this.beginElementOpening(string);
        this.endElementOpening(false);
        string2 = this.normalize(string2);
        if (string2.length() > 40) {
            this.println();
            this.indentIn();
            this.printIndent();
            this.println(string2);
            this.indentOut();
            this.printIndent();
        } else {
            this.print(string2);
        }
        this.emitElementClosure(string);
        this.println();
    }

    public void beginElementOpening(String string) {
        this.print("<" + string);
    }

    public void endElementOpening(boolean bl) {
        if (bl) {
            this.print("/>");
        } else {
            this.print(">");
        }
    }

    public void emitElementClosure(String string) {
        this.print("</" + string + ">");
    }

    public void emitAttribute(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        string2 = BaseWriter.formatToXMLCompatibleData(string2);
        this.print(string + "=\"" + string2 + "\"");
    }

    private static String formatToXMLCompatibleData(String string) {
        if (string == null || string.trim().equalsIgnoreCase("")) {
            return new String("");
        }
        String string2 = BaseWriter.replaceAll(string, "&", "&amp;");
        String string3 = BaseWriter.replaceAll(string2, "<", "&lt;");
        String string4 = BaseWriter.replaceAll(string3, ">", "&gt;");
        String string5 = BaseWriter.replaceAll(string4, "'", "&apos;");
        String string6 = BaseWriter.replaceAll(string5, "\"", "&quot;");
        return string6;
    }

    private static final String replaceAll(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        int n = string.indexOf(string2);
        while (n != -1) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
            n = string.indexOf(string2, n + string3.length());
        }
        return string;
    }

    public String normalize(String string) {
        if (string == null) {
            return "";
        }
        string = string.trim();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\r' || c == '\n') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String getDefaultDocTypeString(List list) {
        return null;
    }

    public void emit(List list, String string) {
        this.emit(list, null, null, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emit(List list, String string, String string2, String string3, String string4) {
        if (string3 == null) {
            string3 = this.getDefaultDocTypeString(list);
        }
        this.boundException = null;
        try {
            this.openWriter(string, string2, string3, string4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.boundException = fileNotFoundException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.boundException = unsupportedEncodingException;
        }
        if (this.boundException != null) {
            return;
        }
        try {
            this.baseEmit(list);
        }
        finally {
            try {
                this.closeWriter();
            }
            catch (IOException iOException) {
                this.boundException = iOException;
            }
        }
    }

    public abstract void baseEmit(List var1);
}

