/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.websphere.ce.j2c.ConnectionWaitTimeoutException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.transaction.Transaction;

public class AdapterUtil {
    public static final String NLS_FILE = "IBMDataStoreAdapterNLS";
    public static final String TRACE_GROUP = "RRA";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$rsadapter$AdapterUtil == null ? (class$com$ibm$ws$rsadapter$AdapterUtil = AdapterUtil.class$("com.ibm.ws.rsadapter.AdapterUtil")) : class$com$ibm$ws$rsadapter$AdapterUtil), (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final TraceNLS NLS = TraceNLS.getTraceNLS((String)"IBMDataStoreAdapterNLS");
    public static final String WS_SQL_STATE = "WS000";
    public static final int APPLICATION_J2EE_VERSION_UNKNOWN = 0;
    public static final int APPLICATION_J2EE_VERSION_1_2 = 12;
    public static final int APPLICATION_J2EE_VERSION_1_3 = 13;
    public static final int EJB_MODULE_J2EE_VERSION_UNKNOWN = 0;
    public static final int EJB_MODULE_J2EE_VERSION_1_1 = 11;
    public static final int EJB_MODULE_J2EE_VERSION_2_0 = 20;
    public static final int EJB_CMP_VERSION_UNKNOWN = 0;
    public static final int EJB_CMP_VERSION_1_1 = 11;
    public static final int EJB_CMP_VERSION_2_0 = 20;
    private static final String prepend = "eis/";
    private static final String postpend = "_CMP";
    private static final UOWCurrent uow = TransactionManagerFactory.getUOWCurrent();
    static /* synthetic */ Class class$com$ibm$ws$rsadapter$AdapterUtil;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static String checkName(String string, int n, int n2, int n3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkName " + string + ", App Ver: " + n + ", EJB Mod Ver: " + n2 + ",EJB CMP Ver: " + n3));
        }
        String string2 = string;
        if (n2 == 20) {
            if (n3 == 20) {
                if (!string.startsWith(prepend) || !string.endsWith(postpend)) {
                    string2 = prepend + string + postpend;
                }
            } else if (n3 == 11 && string.startsWith(prepend) && string.endsWith(postpend)) {
                string2 = string.substring(prepend.length(), string.lastIndexOf(postpend));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkName result: " + string2));
        }
        return string2;
    }

    public static String restoreJndiName(String string) {
        String string2 = string;
        if (string != null) {
            int n = string.indexOf(prepend);
            int n2 = string.indexOf(postpend);
            if (n != -1 && n2 != -1) {
                string2 = string.substring(n += prepend.length(), n2);
            }
        }
        return string2;
    }

    public static final DataStoreAdapterException createDataStoreAdapterException(String string, Object object, Throwable throwable, Class clazz) {
        Object[] objectArray;
        if (object == null) {
            objectArray = null;
        } else if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        return new DataStoreAdapterException(string, objectArray, throwable, object == null ? AdapterUtil.getNLSMessage(string) : (object instanceof Object[] ? AdapterUtil.getNLSMessage(string, (Object[])object) : AdapterUtil.getNLSMessage(string, object)), clazz);
    }

    public static Throwable getChainedException(Throwable throwable) {
        Method[] methodArray = throwable.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!(class$java$lang$Throwable == null ? AdapterUtil.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(methodArray[i].getReturnType()) || methodArray[i].getName().equals("fillInStackTrace") || methodArray[i].getParameterTypes().length != 0) continue;
            try {
                return (Throwable)methodArray[i].invoke((Object)throwable, null);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getConcurrencyModeString(int n) {
        switch (n) {
            case 1007: {
                return "CONCUR READ ONLY";
            }
            case 1008: {
                return "CONCUR UPDATABLE";
            }
        }
        return "UNKNOWN RESULT SET CONCURRENCY: " + n;
    }

    public static String getConnectionEventString(int n) {
        switch (n) {
            case 1: {
                return "CONNECTION CLOSED";
            }
            case 2: {
                return "LOCAL TRANSACTION STARTED";
            }
            case 3: {
                return "LOCAL TRANSACTION COMMITTED";
            }
            case 4: {
                return "LOCAL TRANSACTION ROLLEDBACK";
            }
            case 5: {
                return "CONNECTION ERROR OCCURRED";
            }
            case 900: {
                return "INTERACTION PENDING";
            }
        }
        return "UNKNOWN CONNECTION EVENT: " + n;
    }

    public static String getFetchDirectionString(int n) {
        switch (n) {
            case 1000: {
                return "FETCH FORWARD";
            }
            case 1001: {
                return "FETCH REVERSE";
            }
            case 1002: {
                return "FETCH UNKNOWN";
            }
        }
        return "UNKNOWN FETCH DIRECTION: " + n;
    }

    public static final int getGlobalTranStatus() {
        UOWCoordinator uOWCoordinator = uow.getUOWCoord();
        int n = 5;
        if (uOWCoordinator != null && uOWCoordinator.isGlobal()) {
            try {
                n = ((Transaction)uOWCoordinator).getStatus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static final String getGlobalTranStatusAsString() {
        return AdapterUtil.getGlobalTranStatusString(AdapterUtil.getGlobalTranStatus());
    }

    public static String getGlobalTranStatusString(int n) {
        switch (n) {
            case 0: {
                return "STATUS ACTIVE";
            }
            case 3: {
                return "STATUS COMMITTED";
            }
            case 8: {
                return "STATUS COMMITTING";
            }
            case 1: {
                return "STATUS MARKED ROLLBACK";
            }
            case 6: {
                return "STATUS NO TRANSACTION";
            }
            case 2: {
                return "STATUS PREPARED";
            }
            case 7: {
                return "STATUS PREPARING";
            }
            case 4: {
                return "STATUS ROLLEDBACK";
            }
            case 9: {
                return "STATUS ROLLING BACK";
            }
            case 5: {
                return "STATUS UNKNOWN";
            }
        }
        return "UNKNOWN GLOBAL TRANSACTION STATUS: " + n;
    }

    public static String getIsolationLevelString(int n) {
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 2: {
                return "READ COMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        return "UNKNOWN ISOLATION LEVEL: " + n;
    }

    public static final String getNLSMessage(String string) {
        return NLS.getString(string, string);
    }

    public static final String getNLSMessage(String string, Locale locale) {
        return locale == null ? AdapterUtil.getNLSMessage(string) : TraceNLS.getFormattedMessage((String)NLS_FILE, (String)string, (Locale)locale, null, (String)string);
    }

    public static final String getNLSMessage(String string, Locale locale, Object object) {
        String string2;
        if (locale == null) {
            string2 = AdapterUtil.getNLSMessage(string, object);
        } else {
            Object[] objectArray;
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object;
            }
            string2 = TraceNLS.getFormattedMessage((String)NLS_FILE, (String)string, (Locale)locale, (Object[])objectArray, (String)string);
        }
        return string2;
    }

    public static final String getNLSMessage(String string, Object object) {
        Object[] objectArray;
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        return NLS.getFormattedMessage(string, objectArray, string);
    }

    public static String getResultSetTypeString(int n) {
        switch (n) {
            case 1003: {
                return "TYPE FORWARD ONLY";
            }
            case 1004: {
                return "TYPE SCROLL INSENSITIVE";
            }
            case 1005: {
                return "TYPE SCROLL SENSITIVE";
            }
        }
        return "UNKNOWN RESULT SET TYPE: " + n;
    }

    public static String getSQLTypeString(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN SQL TYPE: " + n;
    }

    public static String getXAExceptionCodeString(int n) {
        switch (n) {
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "UNKNOWN XA EXCEPTION CODE: " + n;
    }

    public static String getXAResourceEndFlagString(int n) {
        switch (n) {
            case 0x20000000: {
                return "TMFAIL";
            }
            case 0x4000000: {
                return "TMSUCCESS";
            }
            case 0x2000000: {
                return "TMSUSPEND";
            }
        }
        return "UNKNOWN XA RESOURCE END FLAG: " + n;
    }

    public static String getXAResourceRecoverFlagString(int n) {
        switch (n) {
            case 0x800000: {
                return "TMENDRSCAN";
            }
            case 0: {
                return "TMNOFLAGS";
            }
            case 0x1000000: {
                return "TMSTARTRSCAN";
            }
        }
        return "UNKNOWN XA RESOURCE RECOVER FLAG: " + n;
    }

    public static String getXAResourceStartFlagString(int n) {
        switch (n) {
            case 0x200000: {
                return "TMJOIN";
            }
            case 0: {
                return "TMNOFLAGS";
            }
            case 0x8000000: {
                return "TMRESUME";
            }
        }
        return "UNKNOWN XA RESOURCE START FLAG: " + n;
    }

    public static String getXAResourceVoteString(int n) {
        switch (n) {
            case 0: {
                return "XA_OK";
            }
            case 3: {
                return "XA_RDONLY";
            }
        }
        return "UNKNOWN XA RESOURCE VOTE: " + n;
    }

    public static Properties hidePassword(Properties properties) {
        Properties properties2 = properties;
        if (properties2 != null && (properties2 = (Properties)properties2.clone()).containsKey("password")) {
            properties2.setProperty("password", "******");
        }
        return properties2;
    }

    public static final boolean inGlobalTransaction() {
        UOWCoordinator uOWCoordinator = uow.getUOWCoord();
        return uOWCoordinator != null && uOWCoordinator.isGlobal();
    }

    public static final boolean match(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static Object[] populateArrayForTrace(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n + 2);
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object == null) {
                arrayList.add(null);
                continue;
            }
            if (object.getClass().isArray()) {
                int n2;
                int n3;
                Object[] objectArray2;
                arrayList.add("{");
                if (object.getClass().getComponentType().isPrimitive()) {
                    if (object.getClass().getComponentType() == Integer.TYPE) {
                        objectArray2 = (int[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Integer((int)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Float.TYPE) {
                        objectArray2 = (float[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Float((float)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Double.TYPE) {
                        objectArray2 = (double[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Double((double)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Byte.TYPE) {
                        objectArray2 = (byte[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Byte((byte)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Short.TYPE) {
                        objectArray2 = (short[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Short((short)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Long.TYPE) {
                        objectArray2 = (long[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Long((long)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Boolean.TYPE) {
                        objectArray2 = (boolean[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Boolean((boolean)objectArray2[n2]));
                        }
                    } else if (object.getClass().getComponentType() == Character.TYPE) {
                        objectArray2 = (char[])object;
                        n3 = objectArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            arrayList.add(new Character((char)objectArray2[n2]));
                        }
                    }
                } else {
                    objectArray2 = (Object[])object;
                    n3 = objectArray2.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        arrayList.add(objectArray2[n2]);
                    }
                }
                arrayList.add("}");
                continue;
            }
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public static String sqlWarningToString(SQLWarning sQLWarning) {
        if (sQLWarning == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        sQLWarning.printStackTrace(new PrintWriter(stringWriter));
        StringBuffer stringBuffer = new StringBuffer(stringWriter.toString());
        SQLWarning sQLWarning2 = sQLWarning.getNextWarning();
        if (sQLWarning2 != null && sQLWarning2 != sQLWarning) {
            stringBuffer.append("-------- linked warning -------\n").append(AdapterUtil.sqlWarningToString(sQLWarning2));
        }
        return stringBuffer.toString();
    }

    public static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        StringBuffer stringBuffer = new StringBuffer(stringWriter.toString());
        Throwable throwable2 = AdapterUtil.getChainedException(throwable);
        if (throwable2 != null && throwable2 != throwable) {
            stringBuffer.append("-------- chained exception -------\n").append(AdapterUtil.stackTraceToString(throwable2));
        }
        return stringBuffer.toString();
    }

    public static DataStoreAdapterException translateSQLException(SQLException sQLException, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl, Class clazz) {
        DataStoreAdapterException dataStoreAdapterException = new DataStoreAdapterException("DSA_ERROR", sQLException, clazz);
        dataStoreAdapterException = wSRdbManagedConnectionImpl.getManagedConnectionFactory().getInternalDataStoreHelper().mapException(dataStoreAdapterException);
        if (dataStoreAdapterException.getLinkedException() instanceof StaleStatementException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"remapping StaleStatementException to StaleConnectionException");
            }
            dataStoreAdapterException.setLinkedException((Exception)new StaleConnectionException(((SQLException)dataStoreAdapterException.getLinkedException()).getNextException()));
        } else if (bl && dataStoreAdapterException.isConnectionError() && wSRdbManagedConnectionImpl != null) {
            wSRdbManagedConnectionImpl.processConnectionErrorOccurredEvent(null, (Exception)((Object)dataStoreAdapterException));
        }
        return dataStoreAdapterException;
    }

    public static String toErrorMessage(Throwable throwable) {
        String string = throwable.getMessage();
        StringBuffer stringBuffer = new StringBuffer(string == null ? "" : string);
        Throwable throwable2 = AdapterUtil.getChainedException(throwable);
        if (throwable2 != null && throwable2 != throwable) {
            stringBuffer.append(" Chained ").append(throwable2.getClass().getName()).append(": ").append(AdapterUtil.toErrorMessage(throwable2));
        }
        return stringBuffer.toString();
    }

    public static Properties toProperties(String string) throws IOException {
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(string.replace(';', '\n').getBytes()));
        return properties;
    }

    public static SQLException toSQLException(ResourceException resourceException) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toSQLException", (Object)resourceException);
        }
        if (resourceException instanceof ConnectionWaitTimeoutException) {
            object = new com.ibm.websphere.ce.cm.ConnectionWaitTimeoutException(resourceException.getMessage());
        } else {
            Throwable throwable = AdapterUtil.getChainedException((Throwable)resourceException);
            while (throwable != null && !(throwable instanceof SQLException)) {
                throwable = AdapterUtil.getChainedException(throwable);
            }
            if (throwable instanceof SQLException) {
                object = (SQLException)throwable;
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Converting ResourceException to a SQLException");
                }
                object = new SQLException(AdapterUtil.getNLSMessage("RESX_TO_SQLX", new Object[]{resourceException.getErrorCode(), AdapterUtil.stackTraceToString((Throwable)resourceException)}));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"toSQLException", (Object)new Object[]{AdapterUtil.getStackTraceWithState((SQLException)object)});
            }
        }
        return object;
    }

    public static SQLException toSQLException(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        return new SQLException(AdapterUtil.getNLSMessage("CONVERT_TO_SQLX", new Object[]{throwable.getClass().getName(), throwable.getMessage(), AdapterUtil.stackTraceToString(throwable)}));
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName() + '@' + Integer.toHexString(object.hashCode());
    }

    public static String getLockTypeAsString(int n) {
        switch (n) {
            case 1: {
                return "LOCKTYPE_SELECT";
            }
            case 2: {
                return "LOCKTYPE_SELECT_FOR_UPDATE";
            }
            case 3: {
                return "LOCKTYPE_SELECT_FOR_UPDATE_WITH_RS";
            }
            case 4: {
                return "LOCKTYPE_SELECT_FOR_UPDATE_WITH_RR";
            }
        }
        return "UNKNOWN LOCK TYPE: " + n;
    }

    public static String getHelperTypeAsString(int n) {
        switch (n) {
            case -1: {
                return "CUSTOM_HELPER";
            }
            case 0: {
                return "CLOUDSCAPE_HELPER";
            }
            case 1: {
                return "DB2_HELPER";
            }
            case 2: {
                return "DB2_400_HELPER";
            }
            case 3: {
                return "DB2_390_HELPER";
            }
            case 4: {
                return "DB2_UNIVERSAL_HELPER";
            }
            case 5: {
                return "GENERIC_HELPER";
            }
            case 6: {
                return "DATADIRECT_HELPER";
            }
            case 7: {
                return "CONNECTJDBC_HELPER";
            }
            case 8: {
                return "WSCONNECTJDBC_HELPER";
            }
            case 9: {
                return "SEQUELINK_HELPER";
            }
            case 10: {
                return "MSSQL_HELPER";
            }
            case 11: {
                return "SYBASE_HELPER";
            }
            case 12: {
                return "SYBASE11_HELPER";
            }
            case 13: {
                return "ORACLE_HELPER";
            }
            case 14: {
                return "INFORMIX_HELPER";
            }
            case 15: {
                return "DB2_390_LOCAL_HELPER";
            }
            case 16: {
                return "CLOUDSCAPE_NETWORK_SERVER_HELPER";
            }
        }
        return "UNKNOWN helper TYPE: " + n;
    }

    public static StringBuffer getStackTraceWithState(SQLException sQLException) {
        SQLException sQLException2 = sQLException;
        boolean bl = false;
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string);
        do {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            sQLException2.printStackTrace(printWriter);
            if (bl) {
                stringBuffer.append("---- Begin backtrace for Nested Throwables").append(string);
            }
            stringBuffer.append("SQL STATE:  " + sQLException2.getSQLState()).append(string);
            stringBuffer.append("ERROR CODE: " + sQLException2.getErrorCode()).append(string);
            stringBuffer.append(stringWriter.toString());
            bl = true;
        } while ((sQLException2 = sQLException2.getNextException()) != null);
        return stringBuffer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

