/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.correlation.CorrelationService;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.DataStoreHelperKeeper;
import com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.CSCacheKey;
import com.ibm.ws.rsadapter.spi.PSCacheKey;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;

public class WSJdbcConnection
extends WSJdbcObject
implements Connection,
Reassociateable,
DataStoreHelperKeeper {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection), (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    Connection connImpl;
    DataStoreHelper helper;
    WSRdbManagedConnectionImpl managedConn;
    WSManagedConnectionFactoryImpl mcf;
    ConnectionManager cm;
    CMConfigData cmConfigData;
    boolean isReserved;
    boolean isShareable;
    Object managedConnKey;
    Subject subject;
    ConnectionRequestInfo connRequestInfo;
    boolean autoCommit;
    boolean detectMultithreadedAccess;
    Object threadID;
    int currentTransactionIsolation = 2;
    boolean supportIsolvlSwitching = false;
    static /* synthetic */ Class class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection;
    static /* synthetic */ Class class$java$sql$Connection;

    WSJdbcConnection() {
    }

    public WSJdbcConnection(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, Connection connection, Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{wSRdbManagedConnectionImpl, AdapterUtil.toString(connection)});
        }
        this.managedConn = wSRdbManagedConnectionImpl;
        this.connImpl = connection;
        this.managedConnKey = object;
        this.threadID = object2;
        this.detectMultithreadedAccess = this.threadID != null;
        this.mcf = this.managedConn.getManagedConnectionFactory();
        this.helper = this.mcf.getDataStoreHelper();
        this.supportIsolvlSwitching = this.mcf.getInternalDataStoreHelper().isIsolationLevelSwitchingSupport();
        this.pmi = this.mcf.getPMI();
        this.autoCommit = this.managedConn.getDefaultAutoCommit();
        this.childWrappers = new ArrayList(8);
        this.currentTransactionIsolation = this.managedConn.getTransactionIsolation();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    final Connection initialize(ConnectionManager connectionManager) throws SQLException {
        this.cm = connectionManager;
        this.cmConfigData = this.cm instanceof com.ibm.ws.j2c.ConnectionManager ? ((com.ibm.ws.j2c.ConnectionManager)this.cm).getCMConfigData() : null;
        this.isShareable = this.cmConfigData != null && this.cmConfigData.isShareable();
        this.connImpl.clearWarnings();
        return this;
    }

    void beginTransactionIfNecessary() throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.managedConn.isMCStale()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale", (Object)this.managedConn);
            }
            throw new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION"));
        }
        if (this.detectMultithreadedAccess) {
            this.detectMultithreadedAccess();
        }
        switch (this.managedConn.getTransactionState()) {
            case 2: 
            case 7: {
                bl = true;
            }
            case 1: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"Transaction is active.");
                break;
            }
            case 0: {
                if (AdapterUtil.inGlobalTransaction()) {
                    try {
                        this.managedConn.processInteractionPendingEvent(this);
                        bl = this.managedConn.getTransactionState() == 2;
                        break;
                    }
                    catch (ResourceException resourceException) {
                        SystemException systemException;
                        FFDCFilter.processException((Throwable)resourceException, (String)((class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection).getName() + ".beginTransactionIfNecessary"), (String)"324", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Error signalling the interaction pending event.", (Object)((Object)resourceException));
                        }
                        if (resourceException.getLinkedException() instanceof SystemException && (systemException = (SystemException)resourceException.getLinkedException()).getCause() != null && systemException.getCause() instanceof XAException) {
                            XAException xAException = (XAException)systemException.getCause();
                            if (xAException.errorCode == -7) {
                                this.fireConnectionErrorEvent((Exception)((Object)resourceException));
                                StaleConnectionException staleConnectionException = new StaleConnectionException(resourceException.getMessage());
                                throw staleConnectionException;
                            }
                        }
                        throw AdapterUtil.toSQLException(resourceException);
                    }
                }
                if (this.cmConfigData != null && this.cmConfigData.getResolutionControl() == 1) {
                    String string = "Transaction was never started for RESOLVER = CONTAINER AT BOUNDARY.";
                    SQLException sQLException = new SQLException(AdapterUtil.getNLSMessage("WS_INTERNAL_ERROR", string));
                    FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".beginTransactionIfNecessary"), (String)"382", (Object)this, (Object[])new Object[]{string + " Possible components: Connection Manager"});
                    throw sQLException;
                }
                bl2 = true;
                if (this.autoCommit) break;
                try {
                    this.managedConn.processLocalTransactionStartedEvent(this);
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, (String)((class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection).getName() + ".beginTransactionIfNecessary"), (String)"300", (Object)this);
                    throw AdapterUtil.toSQLException(resourceException);
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("Local transaction started for " + this));
                break;
            }
            default: {
                throw new SQLException(AdapterUtil.getNLSMessage("INVALID_TRAN_STATE", this.managedConn.getTransactionStateAsString()));
            }
        }
        if (bl2) {
            this.managedConn.enforceAutoCommit(this.autoCommit);
        }
        if (this.supportIsolvlSwitching) {
            this.managedConn.setTransactionIsolation(this.currentTransactionIsolation);
        }
    }

    public final void clearWarnings() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            this.connImpl.clearWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.clearWarnings", (String)"395", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    SQLException closeWrapper() {
        SQLException sQLException;
        block6: {
            sQLException = null;
            if (this.managedConn != null) {
                try {
                    this.managedConn.processConnectionClosedEvent(this);
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.close", (String)"495", (Object)this);
                    if (sQLException == null) {
                        sQLException = AdapterUtil.toSQLException(resourceException);
                        break block6;
                    }
                    Tr.warning((TraceComponent)tc, (String)"DSA_INTERNAL_ERR_WARNING", (Object)new Object[]{"An unexpected error occurred sending a connectionClosed event" + System.getProperty("line.separator"), resourceException});
                }
            } else if (this.cmConfigData != null) {
                ((com.ibm.ws.j2c.ConnectionManager)this.cm).inactiveConnectionClosed((Object)this);
            }
        }
        this.connImpl = null;
        this.childWrappers = null;
        this.managedConn = null;
        this.managedConnKey = null;
        this.cmConfigData = null;
        this.connRequestInfo = null;
        this.subject = null;
        this.mcf = null;
        this.cm = null;
        this.pmi = null;
        this.helper = null;
        this.threadID = null;
        return sQLException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws SQLException {
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"commit", (Object)this);
            }
            if (this.managedConn.isMCStale()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MC is stale", (Object)this.managedConn);
                }
                throw new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION"));
            }
            if (this.detectMultithreadedAccess) {
                this.detectMultithreadedAccess();
            }
            if (this.state == 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"commit", (Object)"no-op; state is INACTIVE");
                }
                return;
            }
            try {
                if (this.managedConn.inGlobalTransaction()) {
                    SQLException sQLException = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "Connection.commit"));
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"commit", (Object)sQLException);
                    }
                    throw sQLException;
                }
                if (this.managedConn.getTransactionState() == 1) {
                    if (this.cmConfigData == null || this.cmConfigData.getResolutionControl() == 0) {
                        this.managedConn.processLocalTransactionCommittedEvent(this);
                        break block20;
                    } else {
                        SQLException sQLException = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_SPI_LT", "Connection.commit"));
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"commit", (Object)sQLException);
                        }
                        throw sQLException;
                    }
                }
                this.connImpl.commit();
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.commit", (String)"776", (Object)this);
                SQLException sQLException = AdapterUtil.toSQLException(resourceException);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"commit", (Object)"Exception");
                }
                throw sQLException;
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".commit"), (String)"587", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"commit", (Object)"Exception");
                }
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"commit", (Object)"Exception");
                }
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    CallableStatement createCallableStatementWrapper(CallableStatement callableStatement) throws SQLException {
        WSJdbcCallableStatement wSJdbcCallableStatement = new WSJdbcCallableStatement(callableStatement, this);
        wSJdbcCallableStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcCallableStatement;
    }

    CallableStatement createCallableStatementWrapper(CallableStatement callableStatement, StatementCacheKey statementCacheKey) throws SQLException {
        WSJdbcCallableStatement wSJdbcCallableStatement = new WSJdbcCallableStatement(callableStatement, this, statementCacheKey);
        wSJdbcCallableStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcCallableStatement;
    }

    PreparedStatement createPreparedStatementWrapper(PreparedStatement preparedStatement) throws SQLException {
        WSJdbcPreparedStatement wSJdbcPreparedStatement = new WSJdbcPreparedStatement(preparedStatement, this);
        wSJdbcPreparedStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcPreparedStatement;
    }

    PreparedStatement createPreparedStatementWrapper(PreparedStatement preparedStatement, StatementCacheKey statementCacheKey) throws SQLException {
        WSJdbcPreparedStatement wSJdbcPreparedStatement = new WSJdbcPreparedStatement(preparedStatement, this, statementCacheKey);
        wSJdbcPreparedStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcPreparedStatement;
    }

    ResultSet createResultSetWrapper(ResultSet resultSet, WSJdbcObject wSJdbcObject) {
        return new WSJdbcResultSet(resultSet, wSJdbcObject);
    }

    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public final Statement createStatement(int n, int n2) throws SQLException {
        Statement statement;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStatement", (Object)new Object[]{this, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            statement = this.connImpl.createStatement(n, n2);
            statement = this.createStatementWrapper(statement);
            this.childWrappers.add(statement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.createStatement", (String)"865", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createStatement", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createStatement", (Object)statement);
        }
        return statement;
    }

    Statement createStatementWrapper(Statement statement) throws SQLException {
        return new WSJdbcStatement(statement, this);
    }

    final void detectMultithreadedAccess() {
        Thread thread = Thread.currentThread();
        if (thread != this.threadID) {
            this.mcf.detectedMultithreadedAccess = true;
            StringWriter stringWriter = new StringWriter();
            new Error().printStackTrace(new PrintWriter(stringWriter));
            Tr.warning((TraceComponent)tc, (String)"MULTITHREADED_ACCESS_DETECTED", (Object)new Object[]{this, Integer.toHexString(this.threadID.hashCode()) + ' ' + this.threadID, Integer.toHexString(thread.hashCode()) + ' ' + thread, stringWriter.getBuffer().delete(0, "java.lang.Error".length())});
        }
    }

    public void dissociate() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"dissociate", (Object)this);
        }
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isReserved) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Unreserving handle for dissociation", (Object)this);
                    }
                    this.isReserved = false;
                    break;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"dissociate", (Object)"Already dissociated.");
                }
                return;
            }
            case 2: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"dissociate", (Object)"Exception");
                }
                throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection);
            }
        }
        this.closeChildWrappers();
        this.connRequestInfo = this.managedConn.createConnectionRequestInfo();
        this.subject = this.managedConn.getSubject();
        this.managedConn.dissociateHandle(this);
        this.connImpl = null;
        this.managedConn = null;
        this.state = 1;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"state --> INACTIVE");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"dissociate");
        }
    }

    public void fireConnectionErrorEvent(Exception exception) {
        switch (this.state) {
            case 0: {
                try {
                    this.managedConn.processConnectionErrorOccurredEvent(this, exception);
                }
                catch (NullPointerException nullPointerException) {
                    if (!tc.isEventEnabled()) break;
                    Tr.event((TraceComponent)tc, (String)"Handle CLOSED or INACTIVE. Not sending CONNECTION_ERROR_OCCURRED.", (Object)this);
                }
                break;
            }
            case 1: {
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Handle is INACTIVE. Not sending CONNECTION_ERROR_OCCURRED.", (Object)this);
                    }
                    this.close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.FireConnectionErrorEvent", (String)"965", (Object)this);
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Error closing connection:", (Object)sQLException);
                }
                break;
            }
            case 2: {
                if (!tc.isEventEnabled()) break;
                Tr.event((TraceComponent)tc, (String)"Connection already closed. Not sending CONNECTION_ERROR_OCCURRED.", (Object)this);
            }
        }
    }

    public final boolean getAutoCommit() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        return this.autoCommit;
    }

    public ManagedConnection getManagedConnection(Object object) throws ResourceException {
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection);
        }
        if (object != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection);
        }
        return this.managedConn;
    }

    public final String getCatalog() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.getCatalog();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getCatalog", (String)"917", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    final WSJdbcObject getConnectionWrapper() {
        return this;
    }

    public final DataStoreHelper getHelper() {
        return this.helper;
    }

    final Object getJDBCImplObject() {
        return this.connImpl;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMetaData", (Object)this);
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            this.childWrapper = this.childWrapper == null ? new WSJdbcDatabaseMetaData(this.connImpl.getMetaData(), this) : this.childWrapper;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getMetaData", (String)"922", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)this.childWrapper);
        }
        return (WSJdbcDatabaseMetaData)this.childWrapper;
    }

    TraceComponent getTracer() {
        return tc;
    }

    public final int getTransactionIsolation() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.getTransactionIsolation();
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Map getTypeMap() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.getTypeMap();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getTypeMap", (String)"927", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final SQLWarning getWarnings() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.connImpl.getWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getWarnings", (String)"991", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(500, this);
        this.introspectAll(fFDCLogger);
        fFDCLogger.eoln();
        fFDCLogger.introspect("ConnectionRequestInfo:", this.connRequestInfo);
        fFDCLogger.introspect("ManagedConnectionFactory:", this.mcf);
        fFDCLogger.introspect("ManagedConnection", this.managedConn);
        return fFDCLogger.toStringArray();
    }

    void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
        fFDCLogger.append("Transaction Manager global transaction status is", AdapterUtil.getGlobalTranStatusAsString());
        fFDCLogger.append("Underlying Connection: " + AdapterUtil.toString(this.connImpl), this.connImpl);
        fFDCLogger.append("Key Object:", this.managedConnKey);
        fFDCLogger.append("DataStoreHelper:", this.helper);
        fFDCLogger.append("Connection Manager:", this.cm);
        fFDCLogger.append("Connection Manager Configuration Data:", this.cmConfigData);
        fFDCLogger.append("Handle is reserved? " + this.isReserved);
        fFDCLogger.append("AutoCommit value tracked by handle: " + this.autoCommit);
        fFDCLogger.append("Detection of multithreaded access is:", this.detectMultithreadedAccess ? "ENABLED" : "DISABLED");
        fFDCLogger.append("Thread id:", this.threadID);
    }

    public final boolean isClosed() {
        return this.state == 2;
    }

    public final boolean isReadOnly() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.isReadOnly();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.isReadOnly", (String)"996", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean isReserved() {
        return this.isReserved;
    }

    public final boolean isShareable() throws SQLException {
        return this.isShareable;
    }

    public final String nativeSQL(String string) throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.connImpl.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.nativeSQL", (String)"1079", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallableStatement pmiPrepareCall(String string, int n, int n2) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            CallableStatement callableStatement = this.connImpl.prepareCall(string, n, n2);
            return callableStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string, int n, int n2) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.connImpl.prepareStatement(string, n, n2);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareCall", (Object)new Object[]{this, string, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                CSCacheKey cSCacheKey = CSCacheKey.get(string, n, n2);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(cSCacheKey);
                callableStatement = object == null ? (this.pmi == null ? this.connImpl.prepareCall(string, n, n2) : this.pmiPrepareCall(string, n, n2)) : this.resetStatement((CallableStatement)object);
                callableStatement = this.createCallableStatementWrapper(callableStatement, cSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                callableStatement = this.pmi == null ? this.connImpl.prepareCall(string, n, n2) : this.pmiPrepareCall(string, n, n2);
                callableStatement = this.createCallableStatementWrapper(callableStatement);
            }
            this.childWrappers.add(callableStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareCall", (String)"1523", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareCall", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareCall", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareCall", (Object)callableStatement);
        }
        return callableStatement;
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareStatement", (Object)new Object[]{this, string, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                PSCacheKey pSCacheKey = PSCacheKey.get(string, n, n2);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(pSCacheKey);
                preparedStatement = object == null ? (this.pmi == null ? this.connImpl.prepareStatement(string, n, n2) : this.pmiPrepareStatement(string, n, n2)) : this.resetStatement((PreparedStatement)object);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, pSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                preparedStatement = this.pmi == null ? this.connImpl.prepareStatement(string, n, n2) : this.pmiPrepareStatement(string, n, n2);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement);
            }
            this.childWrappers.add(preparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareStatement", (String)"1584", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareStatement", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepareStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareStatement", (Object)preparedStatement);
        }
        return preparedStatement;
    }

    final void reactivate() throws SQLException {
        if (this.state != 1) {
            return;
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Requesting implicit reactivation.");
        }
        if (!this.supportsImplicitReactivation()) {
            throw new SQLException(AdapterUtil.getNLSMessage("CONNECTION_INACTIVE"));
        }
        try {
            ((com.ibm.ws.j2c.ConnectionManager)this.cm).associateConnection((ManagedConnectionFactory)this.mcf, this.subject, this.connRequestInfo, (Object)this);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.reactivate", (String)"1625", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REASSOCIATION_ERR", (Object)((Object)resourceException));
            throw AdapterUtil.toSQLException(resourceException);
        }
    }

    public void reassociate(ManagedConnection managedConnection, Connection connection, Object object) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reassociate", (Object)new Object[]{this, managedConnection, AdapterUtil.toString(connection)});
        }
        if (this.managedConnKey == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection);
        }
        if (object != this.managedConnKey) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection);
        }
        if (this.isReserved) {
            if (managedConnection != this.managedConn) {
                String string = "Connection handle is reserved for reassociation with a specific ManagedConnection, which does not match the ManagedConnection provided.";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)string, (Object)new Object[]{this, this.managedConn, managedConnection});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reassociate", (Object)"Exception");
                }
                throw AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{string, " See trace for more details."}, null, class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection);
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Handle is reserved, reassociating back to original ManagedConnection.");
            }
            this.isReserved = false;
            this.state = 0;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"state --> ACTIVE");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reassociate");
            }
            return;
        }
        if (this.state != 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("CANNOT_REASSOCIATE", this.getStateString(), null, class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection);
        }
        if (this.childWrapper != null || this.childWrappers != null && this.childWrappers.size() > 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("CHILDREN_STILL_OPEN", null, null, class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection);
        }
        this.managedConn = (WSRdbManagedConnectionImpl)managedConnection;
        this.connImpl = connection;
        this.connRequestInfo = null;
        this.subject = null;
        if (PmiReqMetrics.isPassCorrelatorToDB() && this.managedConn.getStateManager().getState() == 0) {
            this.mcf.getInternalDataStoreHelper().setEwlmCorrelator(CorrelationService.getEwlmCorrelator(), this.connImpl);
        }
        this.state = 0;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"state --> ACTIVE");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reassociate");
        }
    }

    public void reserve(Object object) throws ResourceException {
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection);
        }
        if (object != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection = WSJdbcConnection.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcConnection);
        }
        this.isReserved = true;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Reserving handle", (Object)this);
        }
        this.state = 1;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"state --> INACTIVE");
        }
    }

    final CallableStatement resetStatement(CallableStatement callableStatement) throws SQLException {
        callableStatement.clearParameters();
        return callableStatement;
    }

    final PreparedStatement resetStatement(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.clearParameters();
        return preparedStatement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws SQLException {
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"rollback", (Object)this);
            }
            if (this.managedConn.isMCStale()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MC is stale", (Object)this.managedConn);
                }
                throw new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION"));
            }
            if (this.detectMultithreadedAccess) {
                this.detectMultithreadedAccess();
            }
            if (this.state == 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"no-op; state is INACTIVE");
                }
                return;
            }
            try {
                if (this.managedConn.inGlobalTransaction()) {
                    SQLException sQLException = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "Connection.rollback"));
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"rollback", (Object)sQLException);
                    }
                    throw sQLException;
                }
                if (this.managedConn.getTransactionState() == 1) {
                    if (this.cmConfigData == null || this.cmConfigData.getResolutionControl() == 0) {
                        this.managedConn.processLocalTransactionRolledbackEvent(this);
                        break block20;
                    } else {
                        SQLException sQLException = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_SPI_LT", "Connection.rollback"));
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"rollback", (Object)sQLException);
                        }
                        throw sQLException;
                    }
                }
                this.connImpl.rollback();
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.rollback", (String)"2001", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"Exception");
                }
                throw AdapterUtil.toSQLException(resourceException);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".rollback"), (String)"1860", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"Exception");
                }
                throw WSJdbcUtil.mapException(this, sQLException);
            }
            catch (NullPointerException nullPointerException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"Exception");
                }
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeException) throws SQLException {
        switch (this.state) {
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Connection dissociated on another thread while performing an operation. Closing the Connection handle.");
                }
                this.close();
            }
            case 2: {
                throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Connection"));
            }
        }
        return runtimeException;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setAutoCommit requested by application.");
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getTransactionState() == 0) {
                this.managedConn.setAutoCommit(bl);
                this.autoCommit = bl;
            } else if (this.managedConn.inGlobalTransaction()) {
                if (bl) {
                    throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "setAutoCommit"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"setAutoCommit(false) requested during a global transaction.");
                }
                this.managedConn.setAutoCommit(bl);
                this.autoCommit = bl;
            } else {
                if (bl && (this.cmConfigData == null || this.cmConfigData.getResolutionControl() == 0)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"setAutoCommit(true) requested during local transaction; implicitly committing the transaction.");
                    }
                    this.commit();
                }
                this.managedConn.setAutoCommit(bl);
                this.autoCommit = bl;
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setAutoCommit", (String)"2006", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setCatalog(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setCatalog", (Object)new Object[]{this, string});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.isShareable && this.managedConn.inGlobalTransaction()) {
                throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_SHAREABLE", "setCatalog"));
            }
            this.managedConn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setCatalog", (String)"2011", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setReadOnly(boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setReadOnly", (Object)new Object[]{this, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.isShareable && this.managedConn.inGlobalTransaction()) {
                throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_SHAREABLE", "setReadOnly"));
            }
            this.mcf.getInternalDataStoreHelper().setReadOnly(this.managedConn, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setReadOnly", (String)"2016", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setTransactionIsolation(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setTransactionIsolation requested by application.");
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.inGlobalTransaction()) {
                throw new SQLException(AdapterUtil.getNLSMessage("ISO_TRAN_ERROR"));
            }
            this.managedConn.setTransactionIsolation(n);
            this.currentTransactionIsolation = n;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setTransactionIsolation", (String)"2021", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setTypeMap(Map map) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setTypeMap", (Object)new Object[]{this, map});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.isShareable && this.managedConn.inGlobalTransaction()) {
                throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_SHAREABLE", "setTypeMap"));
            }
            this.managedConn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setTypeMap", (String)"2026", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean supportsImplicitReactivation() {
        return this.mcf.supportsImplicitHandleReactivation();
    }

    public ConnectionRequestInfo getCRI() {
        return this.connRequestInfo;
    }

    public void setHoldability(int n) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"setHoldability(int)", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    public int getHoldability() throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getHoldability()", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"setSavepoint()", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"setSavepoint(String)", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"rollback(java.sql.Savepoint)", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"releaseSavepoint(java.sql.Savepoint)", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"createStatement(int, int, int)", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"prepareStatement(String, int, int, int)", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"prepareCall(String, int, int, int)", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"prepareStatement(String, int)", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"prepareStatement(String, int[])", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"prepareStatement(String, String[])", (class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcConnection.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

