/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.j2c.ConnectionWaitTimeoutException;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.JDBCConnectionSpec;
import com.ibm.websphere.rsadapter.WSCciConnectionSpec;
import com.ibm.websphere.rsadapter.WSDataSource;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.j2c.ConnectionManager;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.runtime.service.EJBContainer;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class WSJdbcDataSource
implements WSDataSource,
Referenceable,
Serializable,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$rsadapter$jdbc$WSJdbcDataSource == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcDataSource = WSJdbcDataSource.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcDataSource), (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static EJBContainer ejbContainer;
    WSManagedConnectionFactoryImpl managedConnFactory;
    private javax.resource.spi.ConnectionManager cm;
    private CMConfigData cmConfigData;
    private int defaultIsolationLevel;
    private Reference reference;
    private transient DataStoreHelper dSHelper;
    private transient InternalDataStoreHelper internalHelper;
    private transient boolean supportIsolvlSwitching;
    private static final ConnectionRequestInfo[] defaultCRIs;
    private static final ConnectionRequestInfo[] defaultCRIsWithSwitch;
    static /* synthetic */ Class class$com$ibm$ws$rsadapter$jdbc$WSJdbcDataSource;
    static /* synthetic */ Class class$com$ibm$websphere$rsadapter$WSCciConnectionSpec;
    static /* synthetic */ Class class$javax$sql$DataSource;

    public WSJdbcDataSource(WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl, javax.resource.spi.ConnectionManager connectionManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{wSManagedConnectionFactoryImpl, connectionManager});
        }
        this.managedConnFactory = wSManagedConnectionFactoryImpl;
        this.cm = connectionManager;
        this.dSHelper = this.managedConnFactory.getDataStoreHelper();
        this.internalHelper = wSManagedConnectionFactoryImpl.getInternalDataStoreHelper();
        this.supportIsolvlSwitching = this.internalHelper.isIsolationLevelSwitchingSupport();
        try {
            if (this.cm instanceof ConnectionManager) {
                this.cmConfigData = ((ConnectionManager)this.cm).getCMConfigData();
                this.defaultIsolationLevel = this.cmConfigData.getIsolationLevel();
                if (this.defaultIsolationLevel == 0) {
                    this.defaultIsolationLevel = this.dSHelper.getIsolationLevel(null);
                }
            } else {
                this.defaultIsolationLevel = this.dSHelper.getIsolationLevel(null);
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.<init>", (String)"100", (Object)this);
            String string = System.getProperty("line.separator");
            Tr.warning((TraceComponent)tc, (String)"DSA_ERROR", (Object)new Object[]{"Unable to determine the WebSphere default isolation level from the DataStoreHelper" + string + "Defaulting to READ COMMITTED." + string + this.dSHelper + string + AdapterUtil.stackTraceToString(resourceException)});
            this.defaultIsolationLevel = 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public Connection getConnection() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getConnection");
        }
        int n = this.cmConfigData != null && this.cmConfigData.isCMP1_x() ? this.getIsolationLevelFromContainer() : this.defaultIsolationLevel;
        return this.getConnection(this.supportIsolvlSwitching ? defaultCRIsWithSwitch[n] : defaultCRIs[n]).initialize(this.cm);
    }

    private WSJdbcConnection getConnection(ConnectionRequestInfo connectionRequestInfo) throws SQLException {
        WSJdbcConnection wSJdbcConnection;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object)new Object[]{this, AdapterUtil.toString(connectionRequestInfo)});
        }
        try {
            wSJdbcConnection = (WSJdbcConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.managedConnFactory, connectionRequestInfo);
        }
        catch (ConnectionWaitTimeoutException connectionWaitTimeoutException) {
            FFDCFilter.processException((Throwable)connectionWaitTimeoutException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.getConnection", (String)"294", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received ConnectionWaitTimeoutException from ConnectionManager. Converting to SQLException subclass. Original exception follows.", (Object)((Object)connectionWaitTimeoutException));
            }
            com.ibm.websphere.ce.cm.ConnectionWaitTimeoutException connectionWaitTimeoutException2 = new com.ibm.websphere.ce.cm.ConnectionWaitTimeoutException(AdapterUtil.toErrorMessage(connectionWaitTimeoutException));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)connectionWaitTimeoutException2);
            }
            throw connectionWaitTimeoutException2;
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.getConnection", (String)"299", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)"Exception");
            }
            throw AdapterUtil.toSQLException(resourceException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)wSJdbcConnection);
        }
        return wSJdbcConnection;
    }

    public Connection getConnection(JDBCConnectionSpec jDBCConnectionSpec) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getConnection", (Object)jDBCConnectionSpec);
        }
        int n = jDBCConnectionSpec.getTransactionIsolation();
        WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl = new WSConnectionRequestInfoImpl(jDBCConnectionSpec.getUserName(), jDBCConnectionSpec.getPassword(), n == 0 ? this.defaultIsolationLevel : n, jDBCConnectionSpec.getCatalog(), jDBCConnectionSpec.isReadOnly(), jDBCConnectionSpec.getTypeMap(), true, this.supportIsolvlSwitching);
        return this.getConnection(wSConnectionRequestInfoImpl).initialize(this.cm);
    }

    public final Connection getConnection(String string, String string2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getConnection", (Object)new Object[]{string, string2 == null ? string2 : "******"});
        }
        int n = this.cmConfigData != null && this.cmConfigData.isCMP1_x() ? this.getIsolationLevelFromContainer() : this.defaultIsolationLevel;
        WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl = new WSConnectionRequestInfoImpl(string, string2, n, this.supportIsolvlSwitching);
        return this.getConnection(wSConnectionRequestInfoImpl).initialize(this.cm);
    }

    public Connection getConnection(WSCciConnectionSpec wSCciConnectionSpec) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getConnection(" + (class$com$ibm$websphere$rsadapter$WSCciConnectionSpec == null ? (class$com$ibm$websphere$rsadapter$WSCciConnectionSpec = WSJdbcDataSource.class$("com.ibm.websphere.rsadapter.WSCciConnectionSpec")) : class$com$ibm$websphere$rsadapter$WSCciConnectionSpec).getName() + ")", (class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = WSJdbcDataSource.class$("javax.sql.DataSource")) : class$javax$sql$DataSource).getName()}));
    }

    public final DataStoreHelper getDataStoreHelper() {
        return this.dSHelper;
    }

    public final InternalDataStoreHelper getInternalDataStoreHelper() {
        return this.internalHelper;
    }

    private final int getIsolationLevelFromContainer() throws SQLException {
        try {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"CMP1.x bean. Getting isolation level from Container.");
            }
            if (ejbContainer == null) {
                ejbContainer = (EJBContainer)new InitialContext().lookup("services:websphere/EJBContainer");
            }
            return ejbContainer.getIsolationLevel(this.defaultIsolationLevel);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.getConnection", (String)"213", (Object)this);
            throw AdapterUtil.toSQLException(namingException);
        }
    }

    public final int getLoginTimeout() throws SQLException {
        try {
            return this.managedConnFactory.getLoginTimeout();
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.getLoginTimeout", (String)"274", (Object)this);
            throw AdapterUtil.toSQLException(resourceException);
        }
    }

    public final PrintWriter getLogWriter() throws SQLException {
        try {
            return this.managedConnFactory.getLogWriter();
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.getLogWriter", (String)"288", (Object)this);
            throw AdapterUtil.toSQLException(resourceException);
        }
    }

    public final Reference getReference() {
        return this.reference;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(this);
        fFDCLogger.append("Connection Manager:", this.cm);
        fFDCLogger.append("Connection Manager Configuration Data:", this.cmConfigData);
        fFDCLogger.append("Isolation Level:", AdapterUtil.getIsolationLevelString(this.defaultIsolationLevel));
        fFDCLogger.append("Reference:", this.reference);
        fFDCLogger.introspect("ManagedConnectionFactory:", this.managedConnFactory);
        return fFDCLogger.toStringArray();
    }

    public final void setLoginTimeout(int n) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("LOGIN_TIMEOUT_UNSETTABLE"));
    }

    public final void setLogWriter(PrintWriter printWriter) throws SQLException {
        try {
            this.managedConnFactory.setLogWriter(printWriter);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.setLogWriter", (String)"354", (Object)this);
            throw AdapterUtil.toSQLException(resourceException);
        }
    }

    public final void setReference(Reference reference) {
        this.reference = reference;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Referenceable Object set to:", (Object)reference);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating default, reusable ConnectionRequestInfo instances.");
        }
        defaultCRIs = new WSConnectionRequestInfoImpl[9];
        WSJdbcDataSource.defaultCRIs[0] = new WSConnectionRequestInfoImpl(0, true);
        WSJdbcDataSource.defaultCRIs[1] = new WSConnectionRequestInfoImpl(1, true);
        WSJdbcDataSource.defaultCRIs[2] = new WSConnectionRequestInfoImpl(2, true);
        WSJdbcDataSource.defaultCRIs[4] = new WSConnectionRequestInfoImpl(4, true);
        WSJdbcDataSource.defaultCRIs[8] = new WSConnectionRequestInfoImpl(8, true);
        defaultCRIsWithSwitch = new WSConnectionRequestInfoImpl[9];
        WSJdbcDataSource.defaultCRIsWithSwitch[0] = new WSConnectionRequestInfoImpl(0, true, true);
        WSJdbcDataSource.defaultCRIsWithSwitch[1] = new WSConnectionRequestInfoImpl(1, true, true);
        WSJdbcDataSource.defaultCRIsWithSwitch[2] = new WSConnectionRequestInfoImpl(2, true, true);
        WSJdbcDataSource.defaultCRIsWithSwitch[4] = new WSConnectionRequestInfoImpl(4, true, true);
        WSJdbcDataSource.defaultCRIsWithSwitch[8] = new WSConnectionRequestInfoImpl(8, true, true);
    }
}

