/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;

public class WSJdbcStatement
extends WSJdbcObject
implements Statement {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$rsadapter$jdbc$WSJdbcStatement == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcStatement = WSJdbcStatement.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcStatement")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcStatement), (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    public static final String JDBC = "JDBC";
    Statement stmtImpl;
    int currentFetchSize;
    int requestedFetchSize;
    boolean haveStatementPropertiesChanged;
    boolean hasBatchParameters;
    static /* synthetic */ Class class$com$ibm$ws$rsadapter$jdbc$WSJdbcStatement;
    static /* synthetic */ Class class$java$sql$Statement;

    WSJdbcStatement() {
    }

    WSJdbcStatement(Statement statement, WSJdbcConnection wSJdbcConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{AdapterUtil.toString(statement), wSJdbcConnection});
        }
        this.stmtImpl = statement;
        this.parentWrapper = wSJdbcConnection;
        this.pmi = wSJdbcConnection.pmi;
        this.childWrappers = new ArrayList(1);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public void addBatch(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addBatch", (Object)new Object[]{this, string});
        }
        try {
            this.stmtImpl.addBatch(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.addBatch", (String)"70", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void cancel() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cancel", (Object)this);
        }
        try {
            this.stmtImpl.cancel();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.cancel", (String)"94", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cancel", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cancel", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancel");
        }
    }

    public void clearBatch() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clearBatch", (Object)this);
        }
        try {
            this.stmtImpl.clearBatch();
            this.hasBatchParameters = false;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.clearBatch", (String)"116", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.stmtImpl.clearWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.clearWarnings", (String)"136", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    final void closeResultSets() {
        try {
            ((WSJdbcObject)this.childWrappers.get(0)).close();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.closeResultSets", (String)"277", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"ERR_CLOSING_OBJECT", (Object)new Object[]{this.childWrappers.get(0), sQLException});
        }
    }

    SQLException closeWrapper() {
        block4: {
            try {
                this.parentWrapper.childWrappers.remove(this);
            }
            catch (RuntimeException runtimeException) {
                if (this.parentWrapper.state == 2) break block4;
                throw runtimeException;
            }
        }
        try {
            this.stmtImpl.close();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.closeWrapper", (String)"314", (Object)this);
            this.stmtImpl = null;
            return WSJdbcUtil.mapException(this, sQLException);
        }
        this.stmtImpl = null;
        return null;
    }

    ResultSet createResultSetWrapper(ResultSet resultSet) {
        return new WSJdbcResultSet(resultSet, this);
    }

    void enforceStatementProperties() throws SQLException {
        if (this.requestedFetchSize != this.currentFetchSize) {
            this.stmtImpl.setFetchSize(this.requestedFetchSize);
            this.currentFetchSize = this.requestedFetchSize;
        }
    }

    public boolean execute(String string) throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"execute", (Object)new Object[]{this, string});
        }
        try {
            this.parentWrapper.beginTransactionIfNecessary();
            if (!this.childWrappers.isEmpty()) {
                this.closeResultSets();
            }
            this.enforceStatementProperties();
            bl = this.pmi == null && !PmiReqMetrics.isEnabled() ? this.stmtImpl.execute(string) : this.pmiExecute(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.execute", (String)"296", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"execute", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"execute", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"execute", (Object)(bl ? "QUERY" : "UPDATE"));
        }
        return bl;
    }

    public int[] executeBatch() throws SQLException {
        int[] nArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"executeBatch", (Object)this);
        }
        try {
            this.parentWrapper.beginTransactionIfNecessary();
            if (!this.childWrappers.isEmpty()) {
                this.closeResultSets();
            }
            this.enforceStatementProperties();
            nArray = this.pmi == null && !PmiReqMetrics.isEnabled() ? this.stmtImpl.executeBatch() : this.pmiExecuteBatch();
            this.hasBatchParameters = false;
        }
        catch (BatchUpdateException batchUpdateException) {
            FFDCFilter.processException((Throwable)batchUpdateException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.executeBatch", (String)"357", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Check for Connection Error", (Object)new Object[]{AdapterUtil.getStackTraceWithState(batchUpdateException)});
            }
            try {
                WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.parentWrapper;
                if (wSJdbcConnection.helper.isConnectionError((SQLException)batchUpdateException)) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Encountered a Stale Connection: ", (Object)wSJdbcConnection);
                    }
                    wSJdbcConnection.fireConnectionErrorEvent(batchUpdateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
                }
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
            }
            throw batchUpdateException;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.executeBatch", (String)"384", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(i).append(' ');
            }
            Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)new String(stringBuffer));
        }
        return nArray;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        ResultSet resultSet;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"executeQuery", (Object)new Object[]{this, string});
        }
        try {
            this.parentWrapper.beginTransactionIfNecessary();
            if (!this.childWrappers.isEmpty()) {
                this.closeResultSets();
            }
            this.enforceStatementProperties();
            resultSet = this.createResultSetWrapper(this.pmi == null && !PmiReqMetrics.isEnabled() ? this.stmtImpl.executeQuery(string) : this.pmiExecuteQuery(string));
            this.childWrappers.add(resultSet);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.executeQuery", (String)"459", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeQuery", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeQuery", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"executeQuery", (Object)resultSet);
        }
        return resultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"executeUpdate", (Object)new Object[]{this, string});
        }
        try {
            this.parentWrapper.beginTransactionIfNecessary();
            if (!this.childWrappers.isEmpty()) {
                this.closeResultSets();
            }
            this.enforceStatementProperties();
            n = this.pmi == null && !PmiReqMetrics.isEnabled() ? this.stmtImpl.executeUpdate(string) : this.pmiExecuteUpdate(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.executeUpdate", (String)"522", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeUpdate", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeUpdate", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"executeUpdate", (Object)new Integer(n));
        }
        return n;
    }

    public final Connection getConnection() throws SQLException {
        Connection connection = (Connection)((Object)this.parentWrapper);
        if (this.state == 2 || connection == null) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Statement"));
        }
        return connection;
    }

    final WSJdbcObject getConnectionWrapper() {
        return this.parentWrapper;
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.stmtImpl.getFetchDirection();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getFetchDirection", (String)"551", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final int getFetchSize() throws SQLException {
        if (this.state == 2) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Statement"));
        }
        return this.requestedFetchSize;
    }

    final Object getJDBCImplObject() {
        return this.stmtImpl;
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            return this.stmtImpl.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getMaxFieldSize", (String)"591", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            return this.stmtImpl.getMaxRows();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getMaxRows", (String)"611", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean getMoreResults() throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMoreResults", (Object)this);
        }
        try {
            if (!this.childWrappers.isEmpty()) {
                this.closeResultSets();
            }
            bl = this.stmtImpl.getMoreResults();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getMoreResults", (String)"655", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMoreResults", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMoreResults", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMoreResults", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    public int getQueryTimeout() throws SQLException {
        try {
            return this.stmtImpl.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getQueryTimeout", (String)"675", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSet resultSet;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResultSet", (Object)this);
        }
        try {
            ResultSet resultSet2 = this.stmtImpl.getResultSet();
            if (resultSet2 == null) {
                resultSet = null;
            } else {
                resultSet = this.createResultSetWrapper(resultSet2);
                this.childWrappers.add(resultSet);
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getResultSet", (String)"717", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResultSet", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResultSet", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResultSet", (Object)resultSet);
        }
        return resultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.stmtImpl.getResultSetConcurrency();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getResultSetConcurrency", (String)"737", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            return this.stmtImpl.getResultSetType();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getResultSetType", (String)"757", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    TraceComponent getTracer() {
        return tc;
    }

    public int getUpdateCount() throws SQLException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUpdateCount", (Object)this);
        }
        try {
            n = this.stmtImpl.getUpdateCount();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getUpdateCount", (String)"800", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUpdateCount", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUpdateCount", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUpdateCount", (Object)new Integer(n));
        }
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.stmtImpl.getWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.getWarnings", (String)"820", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
        fFDCLogger.append("Underlying Statement: " + AdapterUtil.toString(this.stmtImpl), this.stmtImpl);
        fFDCLogger.append("Statement properties have changed? " + this.haveStatementPropertiesChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pmiExecute(String string) throws SQLException {
        boolean bl;
        block6: {
            try {
                if (PmiReqMetrics.isEnabled()) {
                    PmiReqMetrics.updateBegin((String)JDBC, (String)string);
                }
                if (this.pmi != null) {
                    this.pmi.jdbcOperationStarted();
                }
                bl = this.stmtImpl.execute(string);
                Object var4_3 = null;
                if (this.pmi == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_4 = null;
                    if (this.pmi != null) {
                        this.pmi.jdbcOperationCompleted();
                    }
                    if (!PmiReqMetrics.isEnabled()) break block7;
                    PmiReqMetrics.updateEnd();
                }
                throw throwable;
            }
            this.pmi.jdbcOperationCompleted();
        }
        if (PmiReqMetrics.isEnabled()) {
            PmiReqMetrics.updateEnd();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] pmiExecuteBatch() throws SQLException {
        int[] nArray;
        block6: {
            try {
                if (PmiReqMetrics.isEnabled()) {
                    PmiReqMetrics.updateBegin((String)JDBC, (String)"executeBatch");
                }
                if (this.pmi != null) {
                    this.pmi.jdbcOperationStarted();
                }
                nArray = this.stmtImpl.executeBatch();
                Object var3_2 = null;
                if (this.pmi == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var3_3 = null;
                    if (this.pmi != null) {
                        this.pmi.jdbcOperationCompleted();
                    }
                    if (!PmiReqMetrics.isEnabled()) break block7;
                    PmiReqMetrics.updateEnd();
                }
                throw throwable;
            }
            this.pmi.jdbcOperationCompleted();
        }
        if (PmiReqMetrics.isEnabled()) {
            PmiReqMetrics.updateEnd();
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet pmiExecuteQuery(String string) throws SQLException {
        ResultSet resultSet;
        block6: {
            try {
                if (PmiReqMetrics.isEnabled()) {
                    PmiReqMetrics.updateBegin((String)JDBC, (String)string);
                }
                if (this.pmi != null) {
                    this.pmi.jdbcOperationStarted();
                }
                resultSet = this.stmtImpl.executeQuery(string);
                Object var4_3 = null;
                if (this.pmi == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_4 = null;
                    if (this.pmi != null) {
                        this.pmi.jdbcOperationCompleted();
                    }
                    if (!PmiReqMetrics.isEnabled()) break block7;
                    PmiReqMetrics.updateEnd();
                }
                throw throwable;
            }
            this.pmi.jdbcOperationCompleted();
        }
        if (PmiReqMetrics.isEnabled()) {
            PmiReqMetrics.updateEnd();
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pmiExecuteUpdate(String string) throws SQLException {
        int n;
        block6: {
            try {
                if (PmiReqMetrics.isEnabled()) {
                    PmiReqMetrics.updateBegin((String)JDBC, (String)string);
                }
                if (this.pmi != null) {
                    this.pmi.jdbcOperationStarted();
                }
                n = this.stmtImpl.executeUpdate(string);
                Object var4_3 = null;
                if (this.pmi == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_4 = null;
                    if (this.pmi != null) {
                        this.pmi.jdbcOperationCompleted();
                    }
                    if (!PmiReqMetrics.isEnabled()) break block7;
                    PmiReqMetrics.updateEnd();
                }
                throw throwable;
            }
            this.pmi.jdbcOperationCompleted();
        }
        if (PmiReqMetrics.isEnabled()) {
            PmiReqMetrics.updateEnd();
        }
        return n;
    }

    final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeException) throws SQLException {
        if (this.state == 2) {
            throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Statement"));
        }
        return runtimeException;
    }

    public void setCursorName(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setCursorName", (Object)new Object[]{this, string});
        }
        try {
            this.stmtImpl.setCursorName(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setCursorName", (String)"840", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setEscapeProcessing", (Object)new Object[]{this, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        try {
            this.stmtImpl.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setEscapeProcessing", (String)"860", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setFetchDirection", (Object)new Object[]{this, AdapterUtil.getFetchDirectionString(n)});
        }
        try {
            this.stmtImpl.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setFetchDirection", (String)"880", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public final void setFetchSize(int n) throws SQLException {
        if (this.state == 2 || n < 0) {
            if (this.state == 2) {
                throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Statement"));
            }
            if (n < 0) {
                throw new SQLException(AdapterUtil.getNLSMessage("NO_NEGATIVE_FETCH_SIZES"));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("requested fetchSize --> " + n), (Object)this);
        }
        this.requestedFetchSize = n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setMaxFieldSize", (Object)new Object[]{this, new Integer(n)});
        }
        try {
            this.stmtImpl.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setMaxFieldSize", (String)"920", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public void setMaxRows(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setMaxRows", (Object)new Object[]{this, new Integer(n)});
        }
        try {
            this.stmtImpl.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setMaxRows", (String)"940", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setQueryTimeout", (Object)new Object[]{this, new Integer(n)});
        }
        try {
            this.stmtImpl.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcStatement.setQueryTimeout", (String)"960", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        this.haveStatementPropertiesChanged = true;
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getMoreResults(int)", (class$java$sql$Statement == null ? (class$java$sql$Statement = WSJdbcStatement.class$("java.sql.Statement")) : class$java$sql$Statement).getName()}));
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getGeneratedKeys()", (class$java$sql$Statement == null ? (class$java$sql$Statement = WSJdbcStatement.class$("java.sql.Statement")) : class$java$sql$Statement).getName()}));
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"executeUpdate(String, int)", (class$java$sql$Statement == null ? (class$java$sql$Statement = WSJdbcStatement.class$("java.sql.Statement")) : class$java$sql$Statement).getName()}));
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"executeUpdate(String, int[])", (class$java$sql$Statement == null ? (class$java$sql$Statement = WSJdbcStatement.class$("java.sql.Statement")) : class$java$sql$Statement).getName()}));
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"executeUpdate(String, String[])", (class$java$sql$Statement == null ? (class$java$sql$Statement = WSJdbcStatement.class$("java.sql.Statement")) : class$java$sql$Statement).getName()}));
    }

    public boolean execute(String string, int n) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"execute(String, int)", (class$java$sql$Statement == null ? (class$java$sql$Statement = WSJdbcStatement.class$("java.sql.Statement")) : class$java$sql$Statement).getName()}));
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"execute(String, int[])", (class$java$sql$Statement == null ? (class$java$sql$Statement = WSJdbcStatement.class$("java.sql.Statement")) : class$java$sql$Statement).getName()}));
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"execute(String, String[])", (class$java$sql$Statement == null ? (class$java$sql$Statement = WSJdbcStatement.class$("java.sql.Statement")) : class$java$sql$Statement).getName()}));
    }

    public int getResultSetHoldability() throws SQLException {
        throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"getResultSetHoldability()", (class$java$sql$Statement == null ? (class$java$sql$Statement = WSJdbcStatement.class$("java.sql.Statement")) : class$java$sql$Statement).getName()}));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

