/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.websphere.ce.cm.PortableSQLException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;

public class WSJdbcUtil {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil = WSJdbcUtil.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcUtil")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil), (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    public static final int DATA_SOURCE = 0;
    public static final int CONNECTION = 1;
    public static final int STATEMENT = 2;
    public static final int PREPARED_STATEMENT = 3;
    public static final int CALLABLE_STATEMENT = 4;
    public static final int RESULT_SET = 5;
    public static final int DATABASE_META_DATA = 6;
    public static final int RESULT_SET_META_DATA = 7;
    private static final HashSet[] forbiddenMethods = new HashSet[8];
    private static final HashSet trustedMethods = new HashSet();
    static /* synthetic */ Class class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil;
    static /* synthetic */ Class class$javax$sql$PooledConnection;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$javax$sql$XADataSource;
    static /* synthetic */ Class class$javax$sql$ConnectionPoolDataSource;

    public static Object call(Class clazz, Object object, String string, Object[] objectArray, Class[] classArray) throws SQLException {
        WSJdbcObject wSJdbcObject;
        WSJdbcConnection wSJdbcConnection;
        WSJdbcConnection wSJdbcConnection2 = wSJdbcConnection = object instanceof WSJdbcConnection ? (WSJdbcConnection)object : null;
        if (clazz != null) {
            if (wSJdbcConnection != null) {
                if ((class$javax$sql$PooledConnection == null ? (class$javax$sql$PooledConnection = WSJdbcUtil.class$("javax.sql.PooledConnection")) : class$javax$sql$PooledConnection).isAssignableFrom(clazz)) {
                    if (wSJdbcConnection.state == 1) {
                        wSJdbcConnection.reactivate();
                    }
                    try {
                        return wSJdbcConnection.managedConn.call(string, objectArray, classArray, wSJdbcConnection);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw wSJdbcConnection.runtimeXIfNotClosed(nullPointerException);
                    }
                }
                if (!(class$java$sql$Connection == null ? (class$java$sql$Connection = WSJdbcUtil.class$("java.sql.Connection")) : class$java$sql$Connection).isAssignableFrom(clazz)) {
                    throw new SQLException(AdapterUtil.getNLSMessage("NO_WRAPPED_OBJECT", new Object[]{object.getClass(), clazz}));
                }
            } else if (!(object instanceof DataSource && ((class$javax$sql$XADataSource == null ? (class$javax$sql$XADataSource = WSJdbcUtil.class$("javax.sql.XADataSource")) : class$javax$sql$XADataSource).isAssignableFrom(clazz) || (class$javax$sql$ConnectionPoolDataSource == null ? (class$javax$sql$ConnectionPoolDataSource = WSJdbcUtil.class$("javax.sql.ConnectionPoolDataSource")) : class$javax$sql$ConnectionPoolDataSource).isAssignableFrom(clazz)) || clazz.isAssignableFrom(object.getClass()))) {
                throw new SQLException(AdapterUtil.getNLSMessage("NO_WRAPPED_OBJECT", new Object[]{object.getClass(), clazz}));
            }
        }
        WSJdbcObject wSJdbcObject2 = wSJdbcObject = object instanceof WSJdbcObject ? (WSJdbcObject)object : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Invoking non-JDBC method, " + string + ", on " + object), (Object)objectArray);
        }
        if (object instanceof WSJdbcDataSource) {
            return ((WSJdbcDataSource)object).managedConnFactory.call(string, objectArray, classArray);
        }
        if (wSJdbcObject == null) {
            throw new SQLException(AdapterUtil.getNLSMessage("NOT_A_JDBC_OBJECT"));
        }
        if (wSJdbcObject.state == 1) {
            ((WSJdbcConnection)wSJdbcObject).reactivate();
        }
        try {
            Object object2 = wSJdbcObject.getJDBCImplObject();
            return WSJdbcUtil.call(object2, string, objectArray, classArray, wSJdbcObject, null);
        }
        catch (NullPointerException nullPointerException) {
            throw wSJdbcObject.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public static final Object call(Object object, String string, Object[] objectArray, Class[] classArray, DataStoreHelper dataStoreHelper) throws SQLException {
        return WSJdbcUtil.call(object, string, objectArray, classArray, null, dataStoreHelper);
    }

    public static final Object call(Object object, String string, Object[] objectArray, Class[] classArray, WSJdbcObject wSJdbcObject) throws SQLException {
        return WSJdbcUtil.call(object, string, objectArray, classArray, wSJdbcObject, null);
    }

    private static Object call(Object object, String string, Object[] objectArray, Class[] classArray, WSJdbcObject wSJdbcObject, DataStoreHelper dataStoreHelper) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"call - JDBC Object is", (Object)AdapterUtil.toString(object));
        }
        if (object instanceof DataSource || object instanceof ConnectionPoolDataSource || object instanceof XADataSource) {
            if (WSJdbcUtil.getForbiddenMethods(0).contains(string)) {
                throw new SQLException(AdapterUtil.getNLSMessage("CALL_NOT_ALLOWED"));
            }
            if (string.startsWith("set") && classArray.length == 1 && DSConfigurationHelper.isRepresentableAsString(classArray[0])) {
                throw new SQLException(AdapterUtil.getNLSMessage("CALL_NOT_ALLOWED"));
            }
        } else if (object instanceof Connection || object instanceof PooledConnection) {
            if (WSJdbcUtil.getForbiddenMethods(1).contains(string)) {
                throw new SQLException(AdapterUtil.getNLSMessage("CALL_NOT_ALLOWED"));
            }
        } else if (object instanceof Statement) {
            if (WSJdbcUtil.getForbiddenMethods(2).contains(string)) {
                throw new SQLException(AdapterUtil.getNLSMessage("CALL_NOT_ALLOWED"));
            }
        } else if (object instanceof ResultSet) {
            if (WSJdbcUtil.getForbiddenMethods(5).contains(string)) {
                throw new SQLException(AdapterUtil.getNLSMessage("CALL_NOT_ALLOWED"));
            }
        } else if (object instanceof DatabaseMetaData) {
            if (WSJdbcUtil.getForbiddenMethods(6).contains(string)) {
                throw new SQLException(AdapterUtil.getNLSMessage("CALL_NOT_ALLOWED"));
            }
        } else if (object instanceof ResultSetMetaData) {
            if (WSJdbcUtil.getForbiddenMethods(7).contains(string)) {
                throw new SQLException(AdapterUtil.getNLSMessage("CALL_NOT_ALLOWED"));
            }
        } else {
            if (object == null) {
                throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Object"));
            }
            throw new SQLException(AdapterUtil.getNLSMessage("NOT_A_JDBC_OBJECT"));
        }
        try {
            Object object2 = object.getClass().getMethod(string, classArray).invoke(object, objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"call - Result is", (Object)object2);
            }
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcUtil.call", (String)"369", (Object)wSJdbcObject);
            Throwable throwable = invocationTargetException.getTargetException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception invoking non-JDBC method: ", (Object)throwable);
            }
            if (throwable instanceof SQLException) {
                if (wSJdbcObject == null) {
                    throw dataStoreHelper.mapException((SQLException)throwable);
                }
                throw WSJdbcUtil.mapException(wSJdbcObject, (SQLException)throwable);
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw AdapterUtil.toSQLException(throwable);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcUtil.call", (String)"397", (Object)wSJdbcObject);
            throw runtimeException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcUtil.call", (String)"404", (Object)wSJdbcObject);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception invoking non-JDBC method: ", (Object)exception);
            }
            throw AdapterUtil.toSQLException(exception);
        }
    }

    private static HashSet getForbiddenMethods(int n) {
        if (forbiddenMethods[n] == null) {
            HashSet<String> hashSet = null;
            switch (n) {
                case 0: {
                    hashSet = new HashSet<String>(Arrays.asList("clone", "getConnection", "getLoginTimeout", "getLogWriter", "getPassword", "setLogWriter"));
                    break;
                }
                case 1: {
                    hashSet = new HashSet<String>(Arrays.asList("clone", "close", "commit", "createStatement", "getAutoCommit", "getCatalog", "getConnection", "getMetaData", "getTransactionIsolation", "getTypeMap", "getXAResource", "isClosed", "isReadOnly", "prepareCall", "prepareSQLJCall", "prepareSQLJStatement", "prepareStatement", "rollback", "scrubConnection", "setAutoCommit", "setCatalog", "setHoldability", "setReadOnly", "setTransactionIsolation", "setTypeMap"));
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    hashSet = new HashSet<String>(Arrays.asList("addBatch", "cancel", "clone", "close", "execute", "executeBatch", "executeQuery", "executeUpdate", "getConnection", "getFetchSize", "getMetaData", "getMoreResults", "getResultSet", "getSingletonResultSet", "setCursorName", "setEscapeProcessing", "setFetchDirection", "setFetchSize", "setMaxFieldSize", "setMaxRows", "setQueryTimeout"));
                    break;
                }
                case 5: {
                    hashSet = new HashSet<String>(Arrays.asList("cancelRowUpdates", "clone", "close", "deleteRow", "getStatement", "insertRow", "refreshRow"));
                    break;
                }
                case 6: {
                    hashSet = new HashSet<String>(Arrays.asList("clone", "getConnection"));
                    break;
                }
                case 7: {
                    hashSet = new HashSet<String>(Arrays.asList("clone"));
                }
            }
            WSJdbcUtil.forbiddenMethods[n] = hashSet;
        }
        return forbiddenMethods[n];
    }

    public static SQLException handleStaleStatement(WSJdbcObject wSJdbcObject, SQLException sQLException) {
        block7: {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Encountered a Stale Statement: " + wSJdbcObject));
            }
            try {
                WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl;
                block6: {
                    WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)wSJdbcObject.getConnectionWrapper();
                    wSRdbManagedConnectionImpl = wSJdbcConnection.managedConn;
                    try {
                        wSJdbcConnection.close();
                    }
                    catch (SQLException sQLException2) {
                        FFDCFilter.processException((Throwable)sQLException2, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcUtil.handleStaleStatement", (String)"558", (Object)wSJdbcObject);
                        if (!tc.isDebugEnabled()) break block6;
                        Tr.debug((TraceComponent)tc, (String)"Error closing the connection", (Object)sQLException2);
                    }
                }
                wSRdbManagedConnectionImpl.clearStatementCache();
            }
            catch (NullPointerException nullPointerException) {
                if (wSJdbcObject.state == 2) break block7;
                throw nullPointerException;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"remapping StaleStatementException to StaleConnectionException");
        }
        return new StaleConnectionException(sQLException.getNextException());
    }

    public static Object jdbcPass(Object object, Class clazz, String string, Object[] objectArray, Class[] classArray, int[] nArray) throws SQLException {
        Object t;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"jdbcPass", (Object)AdapterUtil.populateArrayForTrace(new Object[]{object == null ? "static" : object, clazz, string, objectArray, classArray, nArray}));
        }
        if (!trustedMethods.contains(clazz.getName() + '.' + string)) {
            SQLException sQLException = new SQLException(AdapterUtil.getNLSMessage("UNTRUSTED_METHOD", new Object[]{string, clazz.getName()}));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"jdbcPass", (Object)sQLException);
            }
            throw sQLException;
        }
        int n = objectArray == null ? 0 : objectArray.length;
        Object[] objectArray2 = new Object[n];
        try {
            block9: for (int i = 0; i < n; ++i) {
                switch (nArray[i]) {
                    case -1: {
                        objectArray2[i] = objectArray[i];
                        continue block9;
                    }
                    case 0: {
                        objectArray2[i] = ((WSJdbcDataSource)objectArray[i]).managedConnFactory.getUnderlyingDataSource(29497789L);
                        if (!tc.isDebugEnabled()) continue block9;
                        Tr.debug((TraceComponent)tc, (String)("Parameter #" + (i + 1)), (Object)new Object[]{objectArray[i], "-->", AdapterUtil.toString(objectArray2[i])});
                        continue block9;
                    }
                    case 1: {
                        if (((WSJdbcConnection)objectArray[i]).state == 1) {
                            ((WSJdbcConnection)objectArray[i]).reactivate();
                        }
                    }
                    default: {
                        objectArray2[i] = ((WSJdbcObject)objectArray[i]).getJDBCImplObject();
                        if (!tc.isDebugEnabled()) continue block9;
                        Tr.debug((TraceComponent)tc, (String)("Parameter #" + (i + 1)), (Object)new Object[]{objectArray[i], "-->", AdapterUtil.toString(objectArray2[i])});
                    }
                }
            }
            t = "<init>".equals(string) ? clazz.getConstructor(classArray).newInstance(objectArray2) : clazz.getMethod(string, classArray).invoke(object, objectArray2);
        }
        catch (RuntimeException runtimeException) {
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] == null || !(objectArray[i] instanceof WSJdbcObject) || ((WSJdbcObject)objectArray[i]).getState() != 2) continue;
                ObjectClosedException objectClosedException = new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Parameter " + (i + 1)));
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"jdbcPass", (Object)objectClosedException);
                }
                throw objectClosedException;
            }
            FFDCFilter.processException((Throwable)runtimeException, (String)((class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil = WSJdbcUtil.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcUtil")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil).getName() + "jdbcPass"), (String)"717");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"jdbcPass", (Object)runtimeException);
            }
            throw runtimeException;
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException((Throwable)invocationTargetException.getTargetException(), (String)((class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil = WSJdbcUtil.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcUtil")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil).getName() + ".jdbcPass"), (String)"784");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"jdbcPass", (Object)invocationTargetException.getTargetException());
            }
            throw AdapterUtil.toSQLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)((class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil = WSJdbcUtil.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcUtil")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil).getName() + ".jdbcPass"), (String)"787");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"jdbcPass", (Object)exception);
            }
            throw AdapterUtil.toSQLException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"jdbcPass", t);
        }
        return t;
    }

    public static SQLException mapException(WSJdbcObject wSJdbcObject, SQLException sQLException) {
        block8: {
            if (wSJdbcObject == null || sQLException instanceof PortableSQLException) {
                return sQLException;
            }
            try {
                WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)wSJdbcObject.getConnectionWrapper();
                sQLException = wSJdbcConnection.helper.mapException(sQLException);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"mapException", (Object)new Object[]{AdapterUtil.getStackTraceWithState(sQLException)});
                }
                if (sQLException instanceof StaleStatementException) {
                    sQLException = WSJdbcUtil.handleStaleStatement(wSJdbcObject, sQLException);
                } else if (sQLException instanceof StaleConnectionException) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Encountered a Stale Connection: ", (Object)wSJdbcConnection);
                    }
                    wSJdbcConnection.fireConnectionErrorEvent(sQLException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (wSJdbcObject.state == 2) break block8;
                throw nullPointerException;
            }
        }
        return sQLException;
    }

    public static SQLException mapXWithAdapter(WSJdbcObject wSJdbcObject, SQLException sQLException) {
        block7: {
            if (wSJdbcObject == null || sQLException instanceof PortableSQLException) {
                return sQLException;
            }
            try {
                WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)wSJdbcObject.getConnectionWrapper();
                DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("GENERAL_EXCEPTION", sQLException, sQLException, class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil == null ? (class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil = WSJdbcUtil.class$("com.ibm.ws.rsadapter.jdbc.WSJdbcUtil")) : class$com$ibm$ws$rsadapter$jdbc$WSJdbcUtil);
                dataStoreAdapterException = wSJdbcConnection.mcf.getInternalDataStoreHelper().mapException(dataStoreAdapterException);
                sQLException = (SQLException)dataStoreAdapterException.getLinkedException();
                if (sQLException instanceof StaleStatementException) {
                    sQLException = WSJdbcUtil.handleStaleStatement(wSJdbcObject, sQLException);
                } else if (dataStoreAdapterException.isConnectionError()) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Encountered a Stale Connection: ", (Object)wSJdbcConnection);
                    }
                    wSJdbcConnection.fireConnectionErrorEvent(sQLException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (wSJdbcObject.state == 2) break block7;
                throw nullPointerException;
            }
        }
        return sQLException;
    }

    public static final Object getNativeConnection(WSJdbcConnection wSJdbcConnection) {
        return wSJdbcConnection.connImpl;
    }

    public static final void enlistIfNecessary(WSJdbcConnection wSJdbcConnection) throws SQLException {
        wSJdbcConnection.beginTransactionIfNecessary();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        trustedMethods.add("com.ibm.ws.rsadapter.jdbc.JDBCPassTester.<init>");
        trustedMethods.add("com.ibm.ws.rsadapter.jdbc.JDBCPassTester.doStuff");
        trustedMethods.add("oracle.sql.ARRAY.<init>");
        trustedMethods.add("oracle.sql.BLOB.createTemporary");
        trustedMethods.add("oracle.sql.CLOB.createTemporary");
        trustedMethods.add("oracle.xdb.XMLType.createXML");
        trustedMethods.add("oracle.sql.ArrayDescriptor.createDescriptor");
        trustedMethods.add("oracle.xml.sql.query.OracleXMLQuery.<init>");
        trustedMethods.add("oracle.sql.StructDescriptor.createDescriptor");
    }
}

