/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import java.text.DecimalFormat;

public class CacheMap {
    private final int maxEntries;
    private int numEntries;
    private final int numBuckets;
    private static final int maxBucketSize = 5;
    private int numDiscards;
    private final Object[][] values;
    private final Cacheable[][] keys;
    private final int[] bucketSizes;
    private final int[] previous;
    private final int[] next;
    private final int BEFORE_LRU;
    private final int AFTER_MRU;

    public CacheMap(int n) {
        this.maxEntries = n;
        this.BEFORE_LRU = this.numBuckets = (this.maxEntries * 4 + 1) / 3;
        this.AFTER_MRU = this.numBuckets + 1;
        int n2 = this.numBuckets + 2;
        this.previous = new int[n2];
        this.next = new int[n2];
        this.values = new Object[this.numBuckets][5];
        this.keys = new Cacheable[this.numBuckets][5];
        this.bucketSizes = new int[this.numBuckets];
        for (int i = 0; i < this.numBuckets; ++i) {
            this.next[i] = this.previous[i] = this.BEFORE_LRU;
        }
        this.next[this.BEFORE_LRU] = this.AFTER_MRU;
        this.previous[this.AFTER_MRU] = this.BEFORE_LRU;
    }

    public final Object add(Cacheable cacheable, Object object) {
        int n;
        int n2;
        int n3 = n2 = (cacheable.hashCode() & Integer.MAX_VALUE) % this.numBuckets;
        int n4 = this.bucketSizes[n3];
        this.bucketSizes[n3] = n4 + 1;
        int n5 = n4;
        Object object2 = n5 == 5 ? this.discardFromBucket(n2, --n5) : null;
        this.values[n2][n5] = object;
        this.keys[n2][n5] = cacheable;
        int n6 = this.next[n2];
        if (n6 != this.BEFORE_LRU) {
            this.previous[n6] = n = this.previous[n2];
            this.next[n] = n6;
        }
        n = this.previous[this.AFTER_MRU];
        this.previous[this.AFTER_MRU] = this.next[n] = n2;
        this.next[n2] = this.AFTER_MRU;
        this.previous[n2] = n;
        return ++this.numEntries > this.maxEntries ? this.removeLRU() : object2;
    }

    private Object discardFromBucket(int n, int n2) {
        ++this.numDiscards;
        int n3 = n;
        this.bucketSizes[n3] = this.bucketSizes[n3] - 1;
        --this.numEntries;
        this.keys[n][n2].cache();
        return this.values[n][n2];
    }

    public String display() {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat("'  '000");
        stringBuffer.append('\n').append(this).append("\nNumber of entries:   ").append(this.numEntries).append("\nMaximum entries:     ").append(this.maxEntries).append("\nNumber of buckets:   ").append(this.numBuckets).append("\nMaximum bucket size: ").append(5).append("\nNumber of discards:  ").append(this.numDiscards);
        stringBuffer.append("\n\nBUCKET SIZE PREV NEXT\n");
        for (int i = 0; i < this.numBuckets; ++i) {
            stringBuffer.append(decimalFormat.format(i));
            stringBuffer.append(decimalFormat.format(this.bucketSizes[i]));
            stringBuffer.append(decimalFormat.format(this.previous[i]));
            stringBuffer.append(decimalFormat.format(this.next[i]));
            stringBuffer.append('\n');
            for (int j = 0; j < this.bucketSizes[i]; ++j) {
                stringBuffer.append("                      ").append(Integer.toHexString(this.values[i][j].hashCode())).append(' ').append(this.keys[i][j]).append('\n');
            }
        }
        stringBuffer.append(decimalFormat.format(this.BEFORE_LRU)).append("  LRU     ").append(decimalFormat.format(this.next[this.BEFORE_LRU])).append('\n');
        stringBuffer.append(decimalFormat.format(this.AFTER_MRU)).append("  MRU").append(decimalFormat.format(this.previous[this.AFTER_MRU])).append('\n');
        return new String(stringBuffer);
    }

    public final Object remove(Cacheable cacheable) {
        int n = (cacheable.hashCode() & Integer.MAX_VALUE) % this.numBuckets;
        Cacheable[] cacheableArray = this.keys[n];
        int n2 = this.bucketSizes[n];
        for (int i = n2 - 1; i >= 0; --i) {
            if (!cacheableArray[i].equals(cacheable)) continue;
            if ((this.bucketSizes[n] = --n2) == 0) {
                int n3 = this.next[n];
                int n4 = this.previous[n3] = this.previous[n];
                this.next[n4] = n3;
                this.next[n] = this.previous[n] = this.BEFORE_LRU;
            }
            --this.numEntries;
            cacheableArray[i].cache();
            cacheableArray[i] = cacheableArray[n2];
            cacheableArray[n2] = null;
            Object[] objectArray = this.values[n];
            Object object = objectArray[i];
            objectArray[i] = objectArray[n2];
            objectArray[n2] = null;
            return object;
        }
        return null;
    }

    public final Object[] removeAll() {
        Object[] objectArray = new Object[this.numEntries];
        this.numEntries = 0;
        int n = this.numBuckets;
        int n2 = 0;
        while (n > 0) {
            int n3 = this.bucketSizes[--n];
            while (n3 > 0) {
                Object[] objectArray2 = this.values[n];
                Cacheable[] cacheableArray = this.keys[n];
                cacheableArray[--n3].cache();
                cacheableArray[n3] = null;
                objectArray[n2++] = objectArray2[n3];
                objectArray2[n3] = null;
            }
            this.bucketSizes[n] = 0;
        }
        for (n = 0; n <= this.AFTER_MRU; ++n) {
            this.next[n] = this.previous[n] = this.BEFORE_LRU;
        }
        return objectArray;
    }

    private final Object removeLRU() {
        int n = this.next[this.BEFORE_LRU];
        Object[] objectArray = this.values[n];
        Cacheable[] cacheableArray = this.keys[n];
        int n2 = n;
        int n3 = this.bucketSizes[n2] - 1;
        this.bucketSizes[n2] = n3;
        int n4 = n3;
        --this.numEntries;
        int n5 = (this.numDiscards++ & Integer.MAX_VALUE) % (n4 + 1);
        Object object = objectArray[n5];
        cacheableArray[n5].cache();
        if (n4 == 0) {
            int n6 = this.next[n];
            int n7 = this.previous[n6] = this.previous[n];
            this.next[n7] = n6;
            this.next[n] = this.BEFORE_LRU;
            objectArray[0] = null;
            cacheableArray[0] = null;
        } else {
            objectArray[n5] = objectArray[n4];
            objectArray[n4] = null;
            cacheableArray[n5] = cacheableArray[n4];
            cacheableArray[n4] = null;
        }
        return object;
    }

    public final int size() {
        return this.numEntries;
    }

    public static interface Cacheable {
        public void cache();
    }
}

