/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.db2.jcc.SQLJPackage;
import com.ibm.db2.jcc.SQLJSection;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;

public class DB2SQLJCSCacheKey
extends StatementCacheKey {
    public static final int DB2_SQLJ_CALLABLE_STATEMENT = 4;
    private static final int maxStmtKeys = 120;
    private static int numStmtKeys;
    private static final DB2SQLJCSCacheKey[] stmtKeyList;

    public DB2SQLJCSCacheKey(String string, int n, int n2, int n3, SQLJSection sQLJSection) {
        this.type = n;
        this.concurrency = n2;
        this.holdability = n3;
        SQLJPackage sQLJPackage = sQLJSection.getPackage();
        this.consistencyToken = DB2SQLJCSCacheKey.toLong(sQLJPackage.getConsistencyToken());
        this.sql = string;
        this.sectionNumber = sQLJSection.getSectionNumber();
        this.packageName = sQLJPackage.getPackageName();
        this.hCode = this.sql.hashCode() + this.sectionNumber + this.packageName.hashCode();
        this.statementType = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cache() {
        DB2SQLJCSCacheKey[] dB2SQLJCSCacheKeyArray = stmtKeyList;
        synchronized (stmtKeyList) {
            if (numStmtKeys < 120) {
                DB2SQLJCSCacheKey.stmtKeyList[DB2SQLJCSCacheKey.numStmtKeys++] = this;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final boolean equals(Object object) {
        try {
            StatementCacheKey statementCacheKey = (StatementCacheKey)object;
            return !(this.sql != statementCacheKey.sql && !this.sql.equals(statementCacheKey.sql) || this.statementType != statementCacheKey.statementType || this.holdability != statementCacheKey.holdability || this.type != statementCacheKey.type || this.concurrency != statementCacheKey.concurrency || this.consistencyToken != statementCacheKey.consistencyToken || this.sectionNumber != statementCacheKey.sectionNumber || this.packageName != statementCacheKey.packageName && !this.packageName.equals(statementCacheKey.packageName));
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DB2SQLJCSCacheKey get(String string, int n, int n2, int n3, SQLJSection sQLJSection) {
        DB2SQLJCSCacheKey[] dB2SQLJCSCacheKeyArray = stmtKeyList;
        synchronized (stmtKeyList) {
            DB2SQLJCSCacheKey dB2SQLJCSCacheKey = numStmtKeys > 0 ? stmtKeyList[--numStmtKeys] : null;
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return dB2SQLJCSCacheKey == null ? new DB2SQLJCSCacheKey(string, n, n2, n3, sQLJSection) : dB2SQLJCSCacheKey.recycle(string, n, n2, n3, sQLJSection);
        }
    }

    private final DB2SQLJCSCacheKey recycle(String string, int n, int n2, int n3, SQLJSection sQLJSection) {
        this.type = n;
        this.concurrency = n2;
        this.holdability = n3;
        SQLJPackage sQLJPackage = sQLJSection.getPackage();
        this.consistencyToken = DB2SQLJCSCacheKey.toLong(sQLJPackage.getConsistencyToken());
        this.sql = string;
        this.sectionNumber = sQLJSection.getSectionNumber();
        this.packageName = sQLJPackage.getPackageName();
        this.hCode = this.sql.hashCode() + this.sectionNumber + this.packageName.hashCode();
        return this;
    }

    private static final long toLong(byte[] byArray) {
        long l = 0L;
        int n = byArray.length;
        while (n > 0) {
            l |= ((long)byArray[--n] & 0xFFL) << (n << 3);
        }
        return l;
    }

    public String toString() {
        return "DB2 SQLJ CSTMT: " + this.sql + ' ' + this.type + ' ' + this.concurrency + ' ' + this.holdability + ' ' + this.sectionNumber + ' ' + this.packageName + " 0x" + Long.toHexString(this.consistencyToken);
    }

    static {
        stmtKeyList = new DB2SQLJCSCacheKey[120];
    }
}

