/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.db2.jcc.SQLJPackage;
import com.ibm.db2.jcc.SQLJSection;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;

public class DB2SQLJPSCacheKey
extends StatementCacheKey {
    public static final int DB2_SQLJ_PREPARED_STATEMENT = 3;
    private static final int maxStmtKeys = 120;
    private static int numStmtKeys;
    private static final DB2SQLJPSCacheKey[] stmtKeyList;

    public DB2SQLJPSCacheKey(String string, int n, int n2, int n3, SQLJSection sQLJSection) {
        this.type = n;
        this.concurrency = n2;
        this.holdability = n3;
        SQLJPackage sQLJPackage = sQLJSection.getPackage();
        this.consistencyToken = DB2SQLJPSCacheKey.toLong(sQLJPackage.getConsistencyToken());
        this.sql = string;
        this.sectionNumber = sQLJSection.getSectionNumber();
        this.packageName = sQLJPackage.getPackageName();
        this.hCode = this.sql.hashCode() + this.sectionNumber + this.packageName.hashCode();
        this.statementType = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cache() {
        DB2SQLJPSCacheKey[] dB2SQLJPSCacheKeyArray = stmtKeyList;
        synchronized (stmtKeyList) {
            if (numStmtKeys < 120) {
                DB2SQLJPSCacheKey.stmtKeyList[DB2SQLJPSCacheKey.numStmtKeys++] = this;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final boolean equals(Object object) {
        try {
            StatementCacheKey statementCacheKey = (StatementCacheKey)object;
            return !(this.sql != statementCacheKey.sql && !this.sql.equals(statementCacheKey.sql) || this.statementType != statementCacheKey.statementType || this.holdability != statementCacheKey.holdability || this.type != statementCacheKey.type || this.concurrency != statementCacheKey.concurrency || this.consistencyToken != statementCacheKey.consistencyToken || this.sectionNumber != statementCacheKey.sectionNumber || this.packageName != statementCacheKey.packageName && !this.packageName.equals(statementCacheKey.packageName));
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DB2SQLJPSCacheKey get(String string, int n, int n2, int n3, SQLJSection sQLJSection) {
        DB2SQLJPSCacheKey[] dB2SQLJPSCacheKeyArray = stmtKeyList;
        synchronized (stmtKeyList) {
            DB2SQLJPSCacheKey dB2SQLJPSCacheKey = numStmtKeys > 0 ? stmtKeyList[--numStmtKeys] : null;
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return dB2SQLJPSCacheKey == null ? new DB2SQLJPSCacheKey(string, n, n2, n3, sQLJSection) : dB2SQLJPSCacheKey.recycle(string, n, n2, n3, sQLJSection);
        }
    }

    private final DB2SQLJPSCacheKey recycle(String string, int n, int n2, int n3, SQLJSection sQLJSection) {
        this.type = n;
        this.concurrency = n2;
        this.holdability = n3;
        SQLJPackage sQLJPackage = sQLJSection.getPackage();
        this.consistencyToken = DB2SQLJPSCacheKey.toLong(sQLJPackage.getConsistencyToken());
        this.sql = string;
        this.sectionNumber = sQLJSection.getSectionNumber();
        this.packageName = sQLJPackage.getPackageName();
        this.hCode = this.sql.hashCode() + this.sectionNumber + this.packageName.hashCode();
        return this;
    }

    private static final long toLong(byte[] byArray) {
        long l = 0L;
        int n = byArray.length;
        while (n > 0) {
            l |= ((long)byArray[--n] & 0xFFL) << (n << 3);
        }
        return l;
    }

    public String toString() {
        return "DB2 SQLJ PSTMT: " + this.sql + ' ' + this.type + ' ' + this.concurrency + ' ' + this.holdability + ' ' + this.sectionNumber + ' ' + this.packageName + " 0x" + Long.toHexString(this.consistencyToken);
    }

    static {
        stmtKeyList = new DB2SQLJPSCacheKey[120];
    }
}

