/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.db2.jcc.DB2Connection;
import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJccConnection;
import com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;
import sqlj.runtime.ref.DefaultContext;

public class InternalDB2UniversalDataStoreHelper
extends InternalDB2DataStoreHelper {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$rsadapter$spi$InternalDB2UniversalDataStoreHelper == null ? (class$com$ibm$ws$rsadapter$spi$InternalDB2UniversalDataStoreHelper = InternalDB2UniversalDataStoreHelper.class$("com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper")) : class$com$ibm$ws$rsadapter$spi$InternalDB2UniversalDataStoreHelper), (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private transient PrintWriter db2Pw;
    private transient String traceFile;
    private static final int DEFAULTTRACELEVEL = 49;
    private transient int configuredTraceLevel = 49;
    protected static final TraceComponent db2Tc = Tr.register((String)"com.ibm.ws.db2.logwriter", (String)"WAS.database", null);
    static /* synthetic */ Class class$com$ibm$ws$rsadapter$spi$InternalDB2UniversalDataStoreHelper;

    public void setProperties(Properties properties) throws ResourceException {
        String string;
        this.isRRSTransaction = false;
        this.threadIdentitySupport = "NOTALLOWED";
        this.threadSecurity = false;
        if (this.localZOS && ((DB2UniversalDataStoreHelper)this.externalHelper).getDriverType() == 2) {
            string = properties.getProperty("dataSourceClass");
            if (string.equals("com.ibm.db2.jcc.DB2XADataSource")) {
                throw new ResourceException("DB2 does not support driver type 2  with DB2XADataSource under DB2 for z/OS");
            }
            if (string.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource")) {
                this.isRRSTransaction = true;
                this.threadIdentitySupport = "ALLOWED";
                this.threadSecurity = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The DB2 Universal JDBC driver runs in a RRS environment");
                }
            }
        }
        if (properties != null) {
            string = properties.getProperty("traceLevel");
            if (string != null && !string.equals("")) {
                this.configuredTraceLevel = Integer.parseInt(string);
                if (db2Tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)db2Tc, (String)"traceLevel is set to ", (Object)new Integer(this.configuredTraceLevel));
                }
            } else if (db2Tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)db2Tc, (String)"traceLevel is not set, using WAS default: TRACE_CONNECTION_CALLS | TRACE_DRIVER_CONFIGURATION | TRACE_CONNECTS");
            }
            this.traceFile = properties.getProperty("traceFile");
        }
        if (this.traceFile != null && !this.traceFile.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"DB2 JDBC trace was configured to go to a file, Thus no integration with WAS trace.  File name is: ", (Object)this.traceFile);
            }
            try {
                this.db2Pw = new PrintWriter(new FileOutputStream(this.traceFile), true);
            }
            catch (IOException iOException) {
                Tr.error((TraceComponent)tc, (String)"DB2_FILE_OUTSTREAM_ERROR", (Object)this.traceFile);
            }
        } else {
            this.db2Pw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
        }
    }

    public void closeDefaultContext(DefaultContext defaultContext) throws ResourceException {
        try {
            defaultContext.close();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".closeDefaultContext"), (String)"43", (Object)this);
            throw new DataStoreAdapterException("DSA_ERROR", sQLException, this.getClass());
        }
    }

    public String getCorrelator(Connection connection) throws SQLException {
        try {
            return ((DB2Connection)connection).getDB2Correlator();
        }
        catch (NullPointerException nullPointerException) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"getDB2Correlator()", nullPointerException, "method not supported on DB2 driver being used"});
            return null;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"getDB2Correlator()", noSuchMethodError, "method not supported on DB2 driver being used"});
            return null;
        }
    }

    public void setEwlmCorrelator(byte[] byArray, Connection connection) throws ResourceException {
        try {
            if (byArray != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"setEwlmCorrelator: ", (Object)byArray);
                }
                ((DB2Connection)connection).setDB2eWLMCorrelator(byArray);
            }
        }
        catch (SQLException sQLException) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"setDB2eWLMCorrelator()", sQLException, "method not supported on DB2 driver being used"});
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"setDB2eWLMCorrelator()", noSuchMethodError, "method not supported on DB2 driver being used"});
        }
        catch (NullPointerException nullPointerException) {
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"setDB2eWLMCorrelator()", nullPointerException, "method not supported on DB2 driver being used"});
        }
    }

    public Reassociateable createJDBCConnectionWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        return new WSJccConnection(wSRdbManagedConnectionImpl, wSRdbManagedConnectionImpl.sqlConn, WSRdbManagedConnectionImpl.key, wSRdbManagedConnectionImpl.threadID);
    }

    public void disableJdbcTraceIfnecessary(Connection connection) throws SQLException {
        if (db2Tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)db2Tc, (String)"disabling DB2 jdbc logging on connection", (Object)connection);
        }
        ((DB2Connection)connection).setJCCLogWriter(null);
    }

    public boolean enableJdbcTraceIfnecessary(Connection connection) throws SQLException {
        if (db2Tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)db2Tc, (String)"enabling DB2 jdbc logging on  connection", (Object)connection);
            ((DB2Connection)connection).setJCCLogWriter(this.db2Pw, this.configuredTraceLevel);
            return true;
        }
        return false;
    }

    public void setupInitialJDBCTraceIfNecessary(PrintWriter printWriter, WSRdbDataSource wSRdbDataSource) throws ResourceException {
        if (db2Tc.isDebugEnabled() && printWriter != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"user supplied own printWriter, will use provided one", (Object)printWriter);
            }
            this.db2Pw = printWriter;
        }
    }

    public boolean resetConnection(Connection connection) throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetConnection:", (Object)connection);
        }
        try {
            ((DB2Connection)connection).resetDB2Connection();
            bl = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            bl = false;
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"resetConnection()", noSuchMethodError, "method not supported on DB2 driver being used"});
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
            Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object)new Object[]{"resetConnection()", nullPointerException, "method not supported on DB2 driver being used"});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetConnection: ", (Object)new Boolean(bl));
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

