/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;
import oracle.jdbc.driver.OracleLog;

public class InternalOracleDataStoreHelper
extends InternalGenericDataStoreHelper {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$rsadapter$spi$InternalOracleDataStoreHelper == null ? (class$com$ibm$ws$rsadapter$spi$InternalOracleDataStoreHelper = InternalOracleDataStoreHelper.class$("com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper")) : class$com$ibm$ws$rsadapter$spi$InternalOracleDataStoreHelper), (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final TraceComponent oraTc = Tr.register((String)"com.ibm.ws.oracle.logwriter", (String)"WAS.database", null);
    private transient PrintWriter oraPw;
    private boolean traceEnabled = false;
    private transient int printMask;
    private transient int moduleMask;
    private transient int categoryMask;
    static /* synthetic */ Class class$com$ibm$ws$rsadapter$spi$InternalOracleDataStoreHelper;
    static /* synthetic */ Class class$java$sql$Connection;

    public void setProperties(Properties properties) {
        if (properties != null) {
            String string = properties.getProperty("oraclelogPrintMask");
            String string2 = properties.getProperty("oraclelogModuleMask");
            String string3 = properties.getProperty("oraclelogCategoryMask");
            if (string != null && !string.equals("")) {
                this.printMask = Integer.parseInt(string);
            } else {
                if (oraTc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)oraTc, (String)"DSConfigurationHelper.ORACLELOG_PRINT_MASK is not set, using default: 62 ([OracleLog.FIELD_OBJECT :32 for 9i]/[OracleLog.FIELD_CONN :32 for 817] | OracleLog.FIELD_CATEGORY :16 | OracleLog.FIELD_SUBMOD : 8 | OracleLog.FIELD_MODULE : 4 | OracleLog.FIELD_TIME : 2)");
                }
                this.printMask = 62;
            }
            if (string2 != null && !string2.equals("")) {
                this.moduleMask = Integer.parseInt(string2);
            } else {
                if (oraTc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)oraTc, (String)"DSConfigurationHelper.ORACLELOG_MODULE_MASK is not set, using default: 1  (OracleLog.MODULE_DRIVER : 1 )");
                }
                this.moduleMask = 1;
            }
            if (string3 != null && !string3.equals("")) {
                this.categoryMask = Integer.parseInt(string3);
            } else {
                if (oraTc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)oraTc, (String)"DSConfigurationHelper.ORACLELOG_CATEGORY_MASK is not set, using default: 47 (OracleLog.USER_OPER : 1 | OracleLog.PROG_ERROR : 2 | OracleLog.ERROR : 4 | OracleLog.WARNING : 8 | OracleLog.DEBUG1 : 32)");
                }
                this.categoryMask = 47;
            }
            OracleLog.config((int)this.printMask, (int)this.moduleMask, (int)this.categoryMask);
        }
    }

    public void setupInitialJDBCTraceIfNecessary(PrintWriter printWriter, WSRdbDataSource wSRdbDataSource) throws ResourceException {
        if (oraTc.isDebugEnabled()) {
            if (printWriter != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"user supplied own printWriter, will use provided one", (Object)printWriter);
                }
                this.oraPw = printWriter;
            } else if (this.oraPw == null) {
                this.oraPw = new PrintWriter((Writer)new TraceWriter(oraTc), true);
            }
            Tr.info((TraceComponent)tc, (String)"ORACLE_TRACE_INFORMATION");
            Tr.debug((TraceComponent)oraTc, (String)"using the following values for {PrintMask, ModuleMask, CategoryMask}", (Object)new Object[]{new Integer(this.printMask), new Integer(this.moduleMask), new Integer(this.categoryMask)});
            OracleLog.setLogWriter((PrintWriter)this.oraPw);
            this.traceEnabled = true;
        }
    }

    public void disableJdbcTraceIfnecessary(Connection connection) throws SQLException {
        if (!oraTc.isDebugEnabled() && this.traceEnabled) {
            Tr.debug((TraceComponent)oraTc, (String)"disabling oracle jdbc logging");
            OracleLog.setLogWriter(null);
            this.traceEnabled = false;
        }
    }

    public boolean enableJdbcTraceIfnecessary(Connection connection) throws SQLException {
        if (oraTc.isDebugEnabled() && !this.traceEnabled) {
            Tr.debug((TraceComponent)oraTc, (String)"enabling oracle jdbc logging");
            OracleLog.setLogWriter((PrintWriter)this.oraPw);
            this.traceEnabled = true;
            return true;
        }
        return false;
    }

    public void setReadOnly(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setReadOnly", (Object)new Object[]{this, wSRdbManagedConnectionImpl, new Boolean(bl)});
        }
        if (bl) {
            throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"setReadOnly", (class$java$sql$Connection == null ? (class$java$sql$Connection = InternalOracleDataStoreHelper.class$("java.sql.Connection")) : class$java$sql$Connection).getName()}));
        }
        Tr.info((TraceComponent)tc, (String)"ORA_READONLY");
    }

    public void psSetBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        int n2;
        int n3 = n2 = byArray == null ? 0 : byArray.length;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("psSetBytes - byteArray length: " + n2));
        }
        if (byArray != null && n2 > 2000) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ORACLE setBytes byte array length > 2000 workaround.");
            }
            preparedStatement.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), n2);
        } else {
            preparedStatement.setBytes(n, byArray);
        }
    }

    public void psSetString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        int n2;
        int n3 = n2 = string == null ? 0 : string.getBytes().length;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("string length: " + n2));
        }
        if (n2 > 4000) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Oracle setString length > 4000 bytes workaround.");
            }
            preparedStatement.setCharacterStream(n, (Reader)new StringReader(string), string.length());
        } else {
            preparedStatement.setString(n, string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

