/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.rsadapter.CloudscapeNetworkServerDataStoreHelper;
import com.ibm.websphere.rsadapter.ConnectJDBCDataStoreHelper;
import com.ibm.websphere.rsadapter.DB2390DataStoreHelper;
import com.ibm.websphere.rsadapter.DB2390LocalDataStoreHelper;
import com.ibm.websphere.rsadapter.DB2DataStoreHelper;
import com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper;
import com.ibm.websphere.rsadapter.DataDirectDataStoreHelper;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.OracleDataStoreHelper;
import com.ibm.websphere.rsadapter.SequeLinkDataStoreHelper;
import com.ibm.websphere.rsadapter.WSConnectJDBCDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.InternalCloudscapeNetworkServerDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.security.util.AccessController;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;

public class WSRdbDataSource
implements Serializable,
FFDCSelfIntrospectable {
    private Properties dataSourceProperties = null;
    transient Object dataSource;
    private boolean jtaEnabled = false;
    private boolean wasUsedToGetAConnection;
    private String currentSQLID = null;
    transient DataStoreHelper dataStoreHelper = null;
    private final String dataSourceImplClass;
    private String dataSourceName = null;
    private String productName;
    private static final Class currClass = class$com$ibm$ws$rsadapter$spi$WSRdbDataSource == null ? (class$com$ibm$ws$rsadapter$spi$WSRdbDataSource = WSRdbDataSource.class$("com.ibm.ws.rsadapter.spi.WSRdbDataSource")) : class$com$ibm$ws$rsadapter$spi$WSRdbDataSource;
    private static final TraceComponent tc = Tr.register((Class)currClass, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final HashMap helperMap = new HashMap(16);
    private WSManagedConnectionFactoryImpl mcf = null;
    static /* synthetic */ Class class$com$ibm$ws$rsadapter$spi$WSRdbDataSource;
    static /* synthetic */ Class class$java$lang$String;

    public WSRdbDataSource(Properties properties, WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl) throws ResourceException {
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.mcf = wSManagedConnectionFactoryImpl;
        this.dataSourceProperties = properties;
        Properties properties2 = (Properties)properties.clone();
        Properties properties3 = new Properties();
        this.dataSourceImplClass = (String)properties2.remove("dataSourceClass");
        if (this.dataSourceImplClass == null) {
            throw new DataStoreAdapterException("DSIMPLCLASS_NULL", "DataSource implementation class is null.  Could not create DataSource", currClass);
        }
        String string3 = (String)properties2.remove("informixLockModeWait");
        if (string3 != null) {
            properties3.setProperty("informixLockModeWait", string3);
        }
        if ((string2 = (String)properties2.remove("informixAllowNewLine")) != null) {
            properties3.setProperty("informixAllowNewLine", string2);
        }
        if ((string = (String)properties2.remove("databaseType")) != null) {
            properties3.setProperty("databaseType", string);
            wSManagedConnectionFactoryImpl.setDatabaseType(string);
        }
        String string4 = (String)properties2.remove("dataStoreHelperClass");
        String string5 = (String)properties2.remove("statementCacheSize");
        Object object = properties2.remove("enableMultithreadedAccessDetection");
        wSManagedConnectionFactoryImpl.detectMultithreadedAccess = object != null && new Boolean((String)object) != false;
        object = properties2.remove("enableSQLJ");
        String string6 = (String)properties2.remove("oraclelogPrintMask");
        if (string6 != null) {
            properties3.setProperty("oraclelogPrintMask", string6);
        }
        if ((string6 = (String)properties2.remove("oraclelogModuleMask")) != null) {
            properties3.setProperty("oraclelogModuleMask", string6);
        }
        if ((string6 = (String)properties2.remove("oraclelogCategoryMask")) != null) {
            properties3.setProperty("oraclelogCategoryMask", string6);
        }
        if ((string6 = properties2.getProperty("traceLevel")) != null) {
            properties3.setProperty("traceLevel", string6);
        }
        boolean bl = wSManagedConnectionFactoryImpl.transactionBranchesLooselyCoupled = (object = properties2.remove("transactionBranchesLooselyCoupled")) != null && new Boolean((String)object) != false;
        if (wSManagedConnectionFactoryImpl.transactionBranchesLooselyCoupled) {
            Tr.warning((TraceComponent)tc, (String)"ORACLE_PATCH_WARNING");
        }
        wSManagedConnectionFactoryImpl.resetConnectionByDB2 = (object = properties2.remove("resetConnectionByDB2")) != null && Boolean.getBoolean((String)object);
        String string7 = properties2.getProperty("traceFile");
        if (string7 != null) {
            properties3.setProperty("traceFile", string7);
        }
        wSManagedConnectionFactoryImpl.preTestSQLString = (String)properties2.remove("preTestSQLString");
        String string8 = properties2.getProperty("driverType");
        if (string8 != null) {
            properties3.setProperty("driverType", string8);
        }
        if (string4 == null) {
            string4 = DSConfigurationHelper.getDataStoreHelperClassName(this.dataSourceImplClass, string8);
        }
        properties3.setProperty("dataSourceClass", this.dataSourceImplClass);
        this.dataStoreHelper = DSConfigurationHelper.createDataStoreHelper(string4, properties3);
        int n = this.dataStoreHelper.getMetaData().getHelperType();
        if (string5 != null) {
            wSManagedConnectionFactoryImpl.setStatementCacheSize(Integer.parseInt(string5));
        }
        wSManagedConnectionFactoryImpl.internalHelper = this.createInternalDataStoreHelper(string4);
        wSManagedConnectionFactoryImpl.internalHelper.setExternalHelper(this.dataStoreHelper);
        wSManagedConnectionFactoryImpl.internalHelper.setProperties(properties3);
        String string9 = null;
        if (properties2.containsKey("currentSQLID")) {
            string9 = properties2.getProperty("currentSQLID");
        }
        if (string9 != null && string9.trim().length() > 0) {
            PropertyDescriptor[] propertyDescriptorArray = null;
            try {
                final Class<?> clazz = Class.forName(this.dataSourceImplClass);
                propertyDescriptorArray = (PropertyDescriptor[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
                    }
                });
                boolean bl2 = false;
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    if (!propertyDescriptorArray[i].getName().equals("currentSQLID")) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Setting currentSQLID on DataSource to: " + string9));
                    }
                    this.currentSQLID = string9;
                    properties2.remove("currentSQLID");
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"currentSQLID will be passed to physical DS");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)this.getClass().getName(), (String)"420", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"<init> with exception: ", (Object)classNotFoundException);
                }
                throw AdapterUtil.createDataStoreAdapterException("DS_CLASS_NOT_FOUND", this.dataSourceImplClass, classNotFoundException, class$com$ibm$ws$rsadapter$spi$WSRdbDataSource == null ? (class$com$ibm$ws$rsadapter$spi$WSRdbDataSource = WSRdbDataSource.class$("com.ibm.ws.rsadapter.spi.WSRdbDataSource")) : class$com$ibm$ws$rsadapter$spi$WSRdbDataSource);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"<init> with exception:", (Object)exception);
                }
                throw (ResourceException)((Object)exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("\nDatabase type:                          " + string + "\nDataSource class:                       " + this.dataSourceImplClass + "\nDataStoreHelper class:                  " + string4 + "\nInternalDataStoreHelper class:          " + wSManagedConnectionFactoryImpl.internalHelper + "\nMultithreaded access detection enabled? " + wSManagedConnectionFactoryImpl.detectMultithreadedAccess));
        }
        properties2 = wSManagedConnectionFactoryImpl.internalHelper.validateConfiguration(properties2);
        this.createNewDataSource(properties2);
        wSManagedConnectionFactoryImpl.internalHelper.setupInitialJDBCTraceIfNecessary(this.dataStoreHelper.getPrintWriter(), this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    private InternalDataStoreHelper createInternalDataStoreHelper(String string) throws ResourceException {
        Object object = helperMap.get(string);
        try {
            block19: {
                if (object == null) {
                    object = helperMap.get(this.dataSourceImplClass);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"searching on the dataSourceImplClass returned: ", object);
                    }
                    if (object == null) {
                        int n = this.dataStoreHelper.getMetaData().getHelperType();
                        switch (n) {
                            case 1: 
                            case 3: 
                            case 15: {
                                return new InternalDB2DataStoreHelper();
                            }
                            case 4: {
                                return new InternalDB2UniversalDataStoreHelper();
                            }
                            case 0: 
                            case 5: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 14: {
                                return new InternalGenericDataStoreHelper();
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                return new InternalDataDirectDataStoreHelper();
                            }
                            case 13: {
                                return new InternalOracleDataStoreHelper();
                            }
                            case 16: {
                                return new InternalCloudscapeNetworkServerDataStoreHelper();
                            }
                            case -1: {
                                return this.getInternalHelperBasedOnInstance();
                            }
                            case 2: {
                                break;
                            }
                            default: {
                                return new InternalGenericDataStoreHelper();
                            }
                        }
                    }
                }
                if (object.equals("com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper")) {
                    try {
                        Class<?> clazz = Class.forName("com.ibm.db2.jcc.SQLJConnection");
                        object = "com.ibm.ws.rsadapter.spi.InternalDB2V8DataStoreHelper";
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"SQLJConnection is implemented by DB2, change to InternalDB2V8DataStoreHelper  ", object);
                        }
                        clazz = null;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!tc.isDebugEnabled()) break block19;
                        Tr.debug((TraceComponent)tc, (String)"SQLJConnection is not implemented by DB2");
                    }
                }
            }
            return (InternalDataStoreHelper)DSConfigurationHelper.loadClass((String)object).newInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".createInternalDataStoreHelper"), (String)"276", (Object)this);
            throw AdapterUtil.createDataStoreAdapterException("DSA_INTERNAL_ERROR", new Object[]{"Unable to locate Internal Data Store Helper for " + string, ".  Exception is: ", exception}, exception, this.getClass());
        }
    }

    private final InternalDataStoreHelper getInternalHelperBasedOnInstance() {
        if (this.dataStoreHelper instanceof DB2390LocalDataStoreHelper) {
            return new InternalDB2DataStoreHelper();
        }
        if (this.dataStoreHelper instanceof WSConnectJDBCDataStoreHelper) {
            return new InternalDataDirectDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof DB2UniversalDataStoreHelper) {
            return new InternalDB2UniversalDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof DB2390DataStoreHelper) {
            return new InternalDB2DataStoreHelper();
        }
        if (this.dataStoreHelper instanceof ConnectJDBCDataStoreHelper) {
            return new InternalDataDirectDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof CloudscapeNetworkServerDataStoreHelper) {
            return new InternalCloudscapeNetworkServerDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof SequeLinkDataStoreHelper) {
            return new InternalDataDirectDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof DB2DataStoreHelper) {
            return new InternalDB2DataStoreHelper();
        }
        if (this.dataStoreHelper instanceof OracleDataStoreHelper) {
            return new InternalOracleDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof DataDirectDataStoreHelper) {
            return new InternalDataDirectDataStoreHelper();
        }
        return new InternalGenericDataStoreHelper();
    }

    public final PooledConnection getPooledConnection(String string, String string2) throws ResourceException {
        return DSConfigurationHelper.getPooledConnection(this.dataSource, string, string2, this.jtaEnabled);
    }

    public Connection getConnection(PooledConnection pooledConnection) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object)AdapterUtil.toString(pooledConnection));
        }
        Statement statement = null;
        try {
            Object object;
            Connection connection = pooledConnection.getConnection();
            this.dataStoreHelper.doConnectionSetup(connection);
            if (!this.wasUsedToGetAConnection) {
                this.wasUsedToGetAConnection = true;
                object = connection.getMetaData();
                String string = object.getDatabaseProductName();
                this.mcf.internalHelper.setDatabaseProductName(string);
                Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_NAME", (Object)string);
                Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_VERSION", (Object)object.getDatabaseProductVersion());
                Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_NAME", (Object)object.getDriverName());
                Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_VERSION", (Object)object.getDriverVersion());
                if (connection.getClass().getName().indexOf("com.microsoft") >= 0) {
                    Tr.info((TraceComponent)tc, (String)"CONFIG_WARN", (Object)"Support for the SequeLink JDBC driver is deprecated and will be removed in a future WAS release. Please use the Connect JDBC driver instead.");
                }
                if ("SequeLink".equals(object.getDriverName())) {
                    Tr.info((TraceComponent)tc, (String)"CONFIG_WARN", (Object)"Support for the MS SQL Server 2000 JDBC driver is deprecated and will be removed in a future WAS release. Please use the Connect JDBC driver instead.");
                }
            }
            if (this.currentSQLID != null && !this.currentSQLID.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Setting currentSQLID (auth_id/SQLID): " + connection.getMetaData().getUserName() + "/" + this.currentSQLID));
                }
                statement = connection.createStatement();
                object = "set current sqlid = '" + this.currentSQLID + "'";
                statement.executeUpdate((String)object);
                statement.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)AdapterUtil.toString(connection));
            }
            return connection;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbDataSource.getConnection", (String)"260", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConnection - throwing exception");
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
            throw this.translateSQLException(sQLException);
        }
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        try {
            if (this.jtaEnabled) {
                return ((XADataSource)this.dataSource).getLogWriter();
            }
            return ((ConnectionPoolDataSource)this.dataSource).getLogWriter();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbDataSource.getLogWriter", (String)"293", (Object)this);
            throw this.translateSQLException(sQLException);
        }
    }

    public final int getLoginTimeout() throws ResourceException {
        try {
            if (this.jtaEnabled) {
                return ((XADataSource)this.dataSource).getLoginTimeout();
            }
            return ((ConnectionPoolDataSource)this.dataSource).getLoginTimeout();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbDataSource.getLoginTimeout", (String)"323", (Object)this);
            throw this.translateSQLException(sQLException);
        }
    }

    public final Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(100, this);
        fFDCLogger.append("DataSource Implementation Class Name:", this.dataSourceImplClass);
        fFDCLogger.append("DataSource Name:", this.dataSourceName);
        fFDCLogger.append("DataStoreHelper:", this.dataStoreHelper);
        fFDCLogger.append("DataSource properties:", AdapterUtil.hidePassword(this.dataSourceProperties));
        fFDCLogger.append(this.jtaEnabled ? "TWO PHASE ENABLED" : "ONE PHASE ENABLED");
        fFDCLogger.append("Underlying DataSource Object: " + AdapterUtil.toString(this.dataSource), this.dataSource);
        return fFDCLogger.toStringArray();
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setting the logWriter to:", (Object)printWriter);
        }
        try {
            if (this.jtaEnabled) {
                ((XADataSource)this.dataSource).setLogWriter(printWriter);
            } else {
                ((ConnectionPoolDataSource)this.dataSource).setLogWriter(printWriter);
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbDataSource.setLogWriter", (String)"367", (Object)this);
            throw this.translateSQLException(sQLException);
        }
    }

    public final void setLoginTimeout(int n) throws ResourceException {
        try {
            if (this.jtaEnabled) {
                ((XADataSource)this.dataSource).setLoginTimeout(n);
            } else {
                ((ConnectionPoolDataSource)this.dataSource).setLoginTimeout(n);
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbDataSource.setLoginTimeout", (String)"396", (Object)this);
            throw this.translateSQLException(sQLException);
        }
    }

    public final boolean isJTAEnabled() {
        return this.jtaEnabled;
    }

    public final Object call(String string, Object[] objectArray, Class[] classArray) throws SQLException {
        return WSJdbcUtil.call(this.dataSource, string, objectArray, classArray, this.dataStoreHelper);
    }

    private final DataStoreAdapterException translateSQLException(SQLException sQLException) {
        DataStoreAdapterException dataStoreAdapterException = new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
        return this.mcf.getInternalDataStoreHelper().mapException(dataStoreAdapterException);
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    private void createNewDataSource(final Properties properties) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createNewDataSource", (Object)this.dataSourceImplClass);
        }
        try {
            this.dataSource = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object object = DSConfigurationHelper.createDataSource(WSRdbDataSource.this.dataSourceImplClass);
                    DSConfigurationHelper.setDataSourceProperties(object, properties);
                    return object;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.rsadapter.spi.WSRdbDataSource.WSRdbDataSource", (String)"532", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createNewDataSource", (Object)privilegedActionException.getException());
            }
            throw (ResourceException)((Object)privilegedActionException.getException());
        }
        this.jtaEnabled = DSConfigurationHelper.is2PhaseEnabled(properties, this.dataSource);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createNewDataSource", (Object)this.dataSource);
        }
    }

    public void setUserName(String string) {
        String string2 = "setUser";
        Method method = null;
        try {
            method = this.dataSource.getClass().getMethod(string2, class$java$lang$String == null ? (class$java$lang$String = WSRdbDataSource.class$("java.lang.String")) : class$java$lang$String);
            method.invoke(this.dataSource, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_NOT_FOUND", (Object)new Object[]{this.dataSource.getClass().getName(), "user"});
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_SET_ERROR", (Object)new Object[]{this.dataSource.getClass().getName(), "user", illegalAccessException});
        }
        catch (InvocationTargetException invocationTargetException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_SET_ERROR", (Object)new Object[]{this.dataSource.getClass().getName(), "user", invocationTargetException});
        }
        this.dataSourceProperties.setProperty("user", string);
    }

    public void setPassword(String string) {
        String string2 = "setPassword";
        Method method = null;
        try {
            method = this.dataSource.getClass().getMethod(string2, class$java$lang$String == null ? (class$java$lang$String = WSRdbDataSource.class$("java.lang.String")) : class$java$lang$String);
            method.invoke(this.dataSource, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_NOT_FOUND", (Object)new Object[]{this.dataSource.getClass().getName(), "password"});
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_SET_ERROR", (Object)new Object[]{this.dataSource.getClass().getName(), "password", illegalAccessException});
        }
        catch (InvocationTargetException invocationTargetException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_SET_ERROR", (Object)new Object[]{this.dataSource.getClass().getName(), "password", invocationTargetException});
        }
        this.dataSourceProperties.setProperty("password", string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        helperMap.put("com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DB2DataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DB2390DataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DB2390LocalDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DataDirectDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.CloudscapeNetworkServerDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalCloudscapeNetworkServerDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.OracleDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.ConnectJDBCDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.SequeLinkDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.WSConnectJDBCDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.DB2StdXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.UDBXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400ToolboxDataStoreHelper");
        helperMap.put("com.ibm.as400.access.AS400JDBCXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400ToolboxDataStoreHelper");
    }
}

